/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import org.eclipse.aperi.San.gui.PerfAlertEditor;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.SwitchAlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.SwitchAlertSelector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.xmsg.MessageLog;

public class SwitchAlertEditor
extends PerfAlertEditor {
    private SwitchAlertSelector switchSelector;
    private SwitchAlertCreateOrEdit saCOE;

    public SwitchAlertEditor(SwitchAlertCreateOrEdit switchAlertCreateOrEdit) {
        this.saCOE = switchAlertCreateOrEdit;
    }

    public SwitchAlertEditor(SwitchAlertCreateOrEdit switchAlertCreateOrEdit, AlertHeader alertHeader) {
        super(alertHeader);
        this.saCOE = switchAlertCreateOrEdit;
    }

    protected void initAlert() {
        super.initAlert();
        this.alert.aldProductID = 0;
        this.alert.aldType = (short)31;
        this.alert.aldCondition = (short)107;
        this.alert.aldThresholdType = (byte)4;
    }

    protected void initConditions() {
        this.oldConditions = new IntToString[10];
        this.oldConditions[0] = new IntToString(107, MessageLog.getMessageNoID("ALR1261W"));
        this.oldConditions[1] = new IntToString(95, Util.getString("FabricSwAlert_SwitchStateChange"));
        this.oldConditions[2] = new IntToString(96, Util.getString("FabricSwAlert_SwitchPropertyChange"));
        this.oldConditions[3] = new IntToString(124, Util.getString("FabricAlert_Switch_Status_Change_Offline"));
        this.oldConditions[4] = new IntToString(125, Util.getString("FabricAlert_Switch_Status_Change_Online"));
        this.oldConditions[5] = new IntToString(126, Util.getString("FabricAlert_Switch_Version_Change"));
        this.oldConditions[6] = new IntToString(127, Util.getString("FabricAlert_Switch_Port_Change"));
        this.oldConditions[7] = new IntToString(128, Util.getString("FabricAlert_Switch_Blade_change"));
        this.oldConditions[8] = new IntToString(129, Util.getString("FabricAlert_Switch_Blade_change_Offline"));
        this.oldConditions[9] = new IntToString(130, Util.getString("FabricAlert_Switch_Blade_change_Online"));
    }

    protected void switchCard(int n) {
        switch (n) {
            case 95: 
            case 96: 
            case 107: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                this.cardLayout.show(this.valuePanel, "oldValuePanel");
                this.updateSwitchList(false);
                this.createHeaderPanel.setEnabledCheckbox(true);
            }
        }
        this.oldAlertType = n;
    }

    protected void getConditionData() {
        short s = this.getConditionValue();
        switch (s) {
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 107: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                super.getConditionData();
                this.alert.aldType = (short)31;
            }
        }
    }

    public void setSelector(SwitchAlertSelector switchAlertSelector) {
        this.switchSelector = switchAlertSelector;
    }

    private void updateSwitchList(boolean bl) {
        this.switchSelector.setDoSwitchPerfAlert(bl);
        this.switchSelector.resetSelector();
    }

    public AlertHeader getAlertHeader() {
        return this.alertHeader;
    }

    protected void conditionChange() {
        super.conditionChange();
        short s = this.getConditionValue();
        if (s == 107) {
            this.saCOE.tabbedPane.setEnabledAt(1, false);
        } else {
            this.saCOE.tabbedPane.setEnabledAt(1, true);
        }
    }
}

