/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupData
implements ReportingObjectBuilder {
    public static final int GROUP_SEPARATION = 12;
    private boolean isLodestoneCluster = false;
    private boolean isDiskArray = false;

    public Component build(Object object) {
        RespVolGroup respVolGroup = (RespVolGroup)object;
        if (respVolGroup.rvgComputerOsType == 21) {
            this.isLodestoneCluster = true;
        }
        if (Constants.isDiskArray(respVolGroup.rvgComputerOsType)) {
            this.isDiskArray = true;
        }
        JPanel jPanel = GuiUtil.getPanel();
        String string = respVolGroup.vgType == 2 || respVolGroup.vgType == 4 || respVolGroup.vgType == 5 ? "SAG0060I" : (respVolGroup.vgType == 3 || respVolGroup.vgType == 6 ? (this.isLodestoneCluster ? "SAG0063I" : "SAG0062I") : (respVolGroup.vgType == 1 ? "SAG0061I" : "STG6210L"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.top = 30;
        gridBagConstraints.insets.bottom = 20;
        VolGroupData.addItem(jPanel, gridBagConstraints, string, respVolGroup.vgName);
        gridBagConstraints.insets.top = 0;
        if (respVolGroup.vgType == 2 || respVolGroup.vgType == 4 || respVolGroup.vgType == 5 || respVolGroup.vgType == 3 || respVolGroup.vgType == 6) {
            String string2;
            String string3;
            gridBagConstraints.insets.bottom = 12;
            string = this.isLodestoneCluster ? "STG4500L" : "SAG0001L";
            VolGroupData.addItem(jPanel, gridBagConstraints, string, respVolGroup.rvgComputerName);
            gridBagConstraints.insets.bottom = 0;
            if (respVolGroup.vgType == 2 || respVolGroup.vgType == 4 || respVolGroup.vgType == 5) {
                if (respVolGroup.vgType == 4 || respVolGroup.vgType == 5) {
                    VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0093L", respVolGroup.getArraySitesforDisplay());
                    VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0101L", respVolGroup.vgRank);
                    VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0099L", respVolGroup.getConfigsforDisplay());
                } else {
                    VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0027L", respVolGroup.vgDiskGroup);
                    VolGroupData.addItem(jPanel, gridBagConstraints, "STG6105L", respVolGroup.vgLSS);
                    VolGroupData.addItem(jPanel, gridBagConstraints, "STG1132L", respVolGroup.getConfig());
                }
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0038L", respVolGroup.getTrackFormat());
            } else if (respVolGroup.vgType == 6) {
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0099L", respVolGroup.getConfigsforDisplay());
            }
            if (respVolGroup.vgType == 3 && respVolGroup.vgConfig != 11) {
                VolGroupData.addItem(jPanel, gridBagConstraints, "STG1132L", respVolGroup.getConfig());
            }
            gridBagConstraints.insets.bottom = 12;
            String string4 = null;
            string4 = this.isDiskArray ? respVolGroup.getOperationalStatus(respVolGroup.vgOperationalStatus) : respVolGroup.getStatus();
            VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0042L", string4);
            if (this.isLodestoneCluster) {
                gridBagConstraints.insets.bottom = 12;
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0064L", Util.formatPrefBytes(respVolGroup.vgExtentSize * 1024 * 1024));
                String string5 = Util.formatPrefBytes(respVolGroup.vgTotalSpace * 512L);
                String string6 = Util.formatPrefBytes(respVolGroup.vgFreeSpace * 512L);
                string3 = Util.formatPrefBytes(respVolGroup.vgSurfacedLunCap * 512L);
                string2 = Util.formatPrefBytes(respVolGroup.vgUnSurfacedLunCap * 512L);
                gridBagConstraints.insets.bottom = 0;
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0073L", string5);
                gridBagConstraints.insets.bottom = 12;
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0074L", string6);
            } else {
                String string7 = Util.formatPrefBytes(respVolGroup.vgTotalSpace << 9);
                String string8 = Util.formatPrefBytes(respVolGroup.vgFreeSpace << 9);
                string3 = Util.formatPrefBytes(respVolGroup.vgSurfacedLunCap << 9);
                string2 = Util.formatPrefBytes(respVolGroup.vgUnSurfacedLunCap << 9);
                gridBagConstraints.insets.bottom = 0;
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0037L", string7);
                gridBagConstraints.insets.bottom = 12;
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0041L", string8);
            }
            gridBagConstraints.insets.bottom = 0;
            VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0008L", Integer.toString(respVolGroup.vgDisks));
            VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0009L", Integer.toString(respVolGroup.vgVolumes));
            VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0039L", string3);
            VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0040L", string2);
            if (respVolGroup.vgType == 4 || respVolGroup.vgType == 5) {
                long l = respVolGroup.vgTotalSpace - respVolGroup.vgFreeSpace - respVolGroup.vgSurfacedLunCap - respVolGroup.vgUnSurfacedLunCap;
                String string9 = Util.formatPrefBytes(l << 9);
                VolGroupData.addItem(jPanel, gridBagConstraints, "SAG0102L", string9);
            }
        } else {
            gridBagConstraints.insets.bottom = 12;
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG1102L", respVolGroup.rvgComputerName);
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG1132L", respVolGroup.getType());
            gridBagConstraints.insets.bottom = 0;
            String string10 = Integer.toString(respVolGroup.vgDisks);
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG6057L", string10);
            gridBagConstraints.insets.bottom = 12;
            string10 = Integer.toString(respVolGroup.vgVolumes);
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG6202L", string10);
            gridBagConstraints.insets.bottom = 0;
            string10 = Util.formatPrefBytes(respVolGroup.vgTotalSpace << 9);
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG1162L", string10);
            gridBagConstraints.insets.bottom = 12;
            string10 = Util.formatPrefBytes(respVolGroup.vgFreeSpace << 9);
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG1184L", string10);
            gridBagConstraints.insets.bottom = 0;
            string10 = DateFormat.getDateTimeInstance().format(new Date(respVolGroup.vgDiscoveredTime));
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG1134L", string10);
            string10 = DateFormat.getDateTimeInstance().format(new Date(respVolGroup.vgProbeTime));
            VolGroupData.addItem(jPanel, gridBagConstraints, "STG1119L", string10);
        }
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    public static void addItem(Container container, GridBagConstraints gridBagConstraints, String string, String string2) {
        String string3 = MessageLog.getMessageNoID(string);
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridwidth = 1;
        container.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(string2);
        jLabel.setFont(BaseTree.plainFont);
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridwidth = 0;
        int n = gridBagConstraints.insets.left;
        gridBagConstraints.insets.left = 24;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = n;
    }
}

