/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.TimestampWidget;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.TStorm.gui.rptfilter.WidgetListener;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DateBetweenEditor
implements ValueEditor,
WidgetListener,
ChangeListener {
    private ColumnFilter filter;
    private ValueEditorDialog dialog;
    private TimestampWidget leftWidget;
    private TimestampWidget rightWidget;
    private JComponent panel;
    private JLabel[] labels;

    private Component makeLabeledPanel(Component component, int n, String string) {
        int n2 = n < 2 ? 3 : 0;
        BorderLayout borderLayout = new BorderLayout(0, n2);
        JPanel jPanel = new JPanel(borderLayout);
        String string2 = MessageLog.getMessageNoID(string);
        JLabel jLabel = new JLabel(string2);
        Font font = jLabel.getFont().deriveFont(1);
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        jPanel.add((Component)jLabel, "North");
        jPanel.add(Box.createHorizontalStrut(15), "West");
        jPanel.add(component, "Center");
        this.labels[n] = jLabel;
        return jPanel;
    }

    private void enableAppropriateLabels() {
        boolean bl = this.leftWidget.scale == 0;
        this.labels[0].setEnabled(!bl);
        this.labels[1].setEnabled(!bl);
        this.labels[2].setEnabled(bl);
        this.labels[3].setEnabled(bl);
    }

    public DateBetweenEditor(ColumnFilter columnFilter, ValueEditorDialog valueEditorDialog) {
        int n;
        this.filter = columnFilter;
        this.dialog = valueEditorDialog;
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        ColumnFilterValue columnFilterValue2 = columnFilterValue != null ? columnFilterValue.fvNext : null;
        this.labels = new JLabel[4];
        this.leftWidget = DateEditor.makeTimestampWidget(this.filter, columnFilterValue, this);
        this.rightWidget = DateEditor.makeTimestampWidget(this.filter, columnFilterValue2, this);
        Component component = this.leftWidget.makeAbsolutePanel();
        component = this.makeLabeledPanel(component, 0, "STG3271L");
        Component component2 = this.rightWidget.makeAbsolutePanel();
        component2 = this.makeLabeledPanel(component2, 1, "STG3272L");
        Component component3 = this.leftWidget.makeRelativePanel();
        component3 = this.makeLabeledPanel(component3, 2, "STG3271L");
        Component component4 = this.rightWidget.makeRelativePanel();
        component4 = this.makeLabeledPanel(component4, 3, "STG3272L");
        this.enableAppropriateLabels();
        this.leftWidget.enableAppropriateControls();
        this.rightWidget.enableAppropriateControls();
        int n2 = 0;
        while (n2 < this.rightWidget.buttons.length) {
            this.leftWidget.buttons[n2].removeChangeListener(this.leftWidget);
            this.leftWidget.buttons[n2].addChangeListener(this);
            ++n2;
        }
        this.rightWidget.buttons = this.leftWidget.buttons;
        this.panel = new JPanel(new GridBagLayout());
        String string = MessageLog.getMessageNoID("STG3063L");
        this.panel.setBorder(GuiUtil.getBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        int n3 = 25;
        gridBagConstraints.insets.left = n = 5;
        this.panel.add((Component)this.leftWidget.buttons[1], gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.panel.add(Box.createHorizontalStrut(1), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = n3;
        gridBagConstraints.insets.bottom = 17;
        gridBagConstraints.fill = 1;
        this.panel.add(component, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = n;
        this.panel.add(component2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 0;
        this.panel.add((Component)this.leftWidget.buttons[0], gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.panel.add(Box.createHorizontalStrut(1), gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = n3;
        gridBagConstraints.insets.bottom = 15;
        this.panel.add(component3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = n;
        this.panel.add(component4, gridBagConstraints);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void getData() throws GeneralException {
        ColumnFilterValue columnFilterValue = DateEditor.makeValue(this.leftWidget, this.filter);
        ColumnFilterValue columnFilterValue2 = DateEditor.makeValue(this.rightWidget, this.filter);
        Comparable comparable = (Comparable)columnFilterValue.fvValue;
        Comparable comparable2 = (Comparable)columnFilterValue2.fvValue;
        if (comparable.compareTo(comparable2) > 0 && DurationBetweenEditor.userConfirmsValueSwap(this)) {
            this.filter.clfValueList = columnFilterValue2;
            columnFilterValue2.fvNext = columnFilterValue;
        } else {
            this.filter.clfValueList = columnFilterValue;
            columnFilterValue.fvNext = columnFilterValue2;
        }
    }

    public void setFocus() {
        this.leftWidget.setFocus();
    }

    public void valueChanged(int n) {
        if (n != 0) {
            this.dialog.setOKEnabled(!this.leftWidget.isIncomplete() && !this.rightWidget.isIncomplete());
        }
    }

    public void notifyEnterStruck() {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.leftWidget.stateChanged(changeEvent);
        this.rightWidget.stateChanged(changeEvent);
        this.enableAppropriateLabels();
    }
}

