/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DbGenerateClasses {
    private static Connection connect(String string, String string2, String string3) throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    private static Connection connect(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        Class.forName(string);
        Connection connection = DbGenerateClasses.connect(string2, string3, string4);
        return connection;
    }

    private static void printHeader(PrintWriter printWriter, String string) {
        printWriter.println("/********************************************************* {COPYRIGHT-TOP} ***");
        printWriter.println("* Aperi Storage Manager");
        printWriter.println("* (C) Copyright IBM Corp. 2005, 2006");
        printWriter.println("* All rights reserved. This program and the accompanying materials");
        printWriter.println("* are made available under the terms of the Eclipse Public License v1.0");
        printWriter.println("* which accompanies this distribution, and is available at");
        printWriter.println("* http://www.eclipse.org/legal/epl-v10.html");
        printWriter.println("********************************************************** {COPYRIGHT-END} **/");
    }

    public static String columnNameToMemberName(String string) {
        char[] cArray = string.toLowerCase().toCharArray();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            if (n != 0 && cArray[n] != '_') {
                stringBuffer.append(cArray[n]);
            } else {
                if (cArray[n] == '_') {
                    ++n;
                }
                stringBuffer.append(Character.toUpperCase(cArray[n]));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String sqlTypeToJavaTypeString(short s) {
        String string = new String();
        switch (s) {
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case -6: {
                string = "byte";
                break;
            }
            case -5: {
                string = "long";
                break;
            }
            case 4: {
                string = "int";
                break;
            }
            case 5: {
                string = "short";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = "String";
                break;
            }
            case 6: 
            case 8: {
                string = "double";
                break;
            }
            case 7: {
                string = "float";
                break;
            }
            case 2: 
            case 3: {
                string = "double";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case -7: {
                string = "boolean";
                break;
            }
            case 1111: {
                string = "Object";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "byte[]";
                break;
            }
            default: {
                string = "Object";
            }
        }
        return string;
    }

    private static String sqlTypeToJavaTypeCapString(short s) {
        String string = new String();
        switch (s) {
            case -6: {
                string = "Byte";
                break;
            }
            case -5: {
                string = "Long";
                break;
            }
            case 4: {
                string = "Int";
                break;
            }
            case 5: {
                string = "Short";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = "String";
                break;
            }
            case 6: 
            case 8: {
                string = "Double";
                break;
            }
            case 7: {
                string = "Float";
                break;
            }
            case 2: 
            case 3: {
                string = "Double";
                break;
            }
            case 91: {
                string = "Date";
                break;
            }
            case -7: {
                string = "Boolean";
                break;
            }
            case 1111: {
                string = "Object";
                break;
            }
            case 93: {
                string = "Timestamp";
                break;
            }
            case 92: {
                string = "Time";
                break;
            }
            case 2005: {
                string = "Clob";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "Bytes";
                break;
            }
            default: {
                string = "Object";
            }
        }
        return string;
    }

    private static String sqlTypeToSqlTypeString(short s) {
        String string = new String();
        switch (s) {
            case -6: {
                string = "TINYINT";
                break;
            }
            case -5: {
                string = "BIGINT";
                break;
            }
            case 4: {
                string = "INTEGER";
                break;
            }
            case 5: {
                string = "SMALLINT";
                break;
            }
            case 1: {
                string = "CHAR";
                break;
            }
            case 12: {
                string = "VARCHAR";
                break;
            }
            case -1: {
                string = "LONGVARCHAR";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case 8: {
                string = "DOUBLE";
                break;
            }
            case 6: {
                string = "FLOAT";
                break;
            }
            case 7: {
                string = "REAL";
                break;
            }
            case 2: {
                string = "NUMERIC";
                break;
            }
            case 3: {
                string = "DECIMAL";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case -7: {
                string = "BIT";
                break;
            }
            case 1111: {
                string = "OTHER";
                break;
            }
            case 93: {
                string = "TIMESTAMP";
                break;
            }
            case 92: {
                string = "TIME";
                break;
            }
            case -2: {
                string = "BINARY";
                break;
            }
            case -3: {
                string = "VARBINARY";
                break;
            }
            case -4: {
                string = "LONGVARBINARY";
            }
        }
        return string;
    }

    private static String trimTypeString(String string) {
        if (string.indexOf(".") >= 0) {
            String[] stringArray = string.split("\\.");
            return stringArray[stringArray.length - 1];
        }
        return string;
    }

    private static String invalidValueString(short s) {
        switch (s) {
            case 2005: {
                return "DBConstants.INVALID_CLOB_VALUE";
            }
            case -6: 
            case 5: {
                return "DBConstants.INVALID_SHORT_VALUE";
            }
            case -1: 
            case 1: 
            case 12: {
                return "DBConstants.INVALID_STRING_VALUE";
            }
            case -5: {
                return "DBConstants.INVALID_LONG_VALUE";
            }
            case 91: {
                return "DBConstants.INVALID_DATE_VALUE";
            }
            case 92: {
                return "DBConstants.INVALID_TIME_VALUE";
            }
            case 1111: {
                return "DBConstants.INVALID_STRING_VALUE";
            }
            case -4: 
            case -3: 
            case -2: {
                return "DBConstants.INVALID_BYTE_ARRAY_VALUE";
            }
            case 4: {
                return "DBConstants.INVALID_INT_VALUE";
            }
            case 6: 
            case 7: {
                return "DBConstants.INVALID_FLOAT_VALUE";
            }
            case 2: 
            case 3: 
            case 8: {
                return "DBConstants.INVALID_DOUBLE_VALUE";
            }
            case 93: {
                return "DBConstants.INVALID_TIMESTAMP_VALUE";
            }
        }
        return "null";
    }

    private static String buildSetStatement(String string, String string2, short s) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = DbGenerateClasses.sqlTypeToJavaTypeString(s);
        stringBuffer.append("\tpublic void set");
        stringBuffer.append(string);
        stringBuffer.append("( ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(") { this.");
        stringBuffer.append(string2);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(";}");
        return stringBuffer.toString();
    }

    private static boolean basicDataType(short s) {
        switch (s) {
            case -6: 
            case 5: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return false;
            }
            case -5: {
                return true;
            }
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return false;
            }
            case 4: {
                return true;
            }
            case 6: 
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static String buildClearStatement(String string, short s) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        switch (s) {
            case -6: 
            case 5: {
                stringBuffer.append("DBConstants.INVALID_SHORT_VALUE");
                break;
            }
            case 2005: {
                stringBuffer.append("DBConstants.INVALID_CLOB_VALUE");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                stringBuffer.append("DBConstants.INVALID_STRING_VALUE");
                break;
            }
            case -5: {
                stringBuffer.append("DBConstants.INVALID_LONG_VALUE");
                break;
            }
            case 1111: {
                stringBuffer.append("DBConstants.INVALID_STRING_VALUE");
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                stringBuffer.append("DBConstants.INVALID_BYTE_ARRAY_VALUE");
                break;
            }
            case 4: {
                stringBuffer.append("DBConstants.INVALID_INT_VALUE");
                break;
            }
            case 6: 
            case 7: {
                stringBuffer.append("DBConstants.INVALID_FLOAT_VALUE");
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                stringBuffer.append("DBConstants.INVALID_DOUBLE_VALUE");
                break;
            }
            case 93: {
                stringBuffer.append("DBConstants.INVALID_TIMESTAMP_VALUE");
                break;
            }
            case 92: {
                stringBuffer.append("DBConstants.INVALID_TIME_VALUE");
                break;
            }
            case 91: {
                stringBuffer.append("DBConstants.INVALID_DATE_VALUE");
                break;
            }
            default: {
                stringBuffer.append("null");
            }
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    private static String convertToString(String string, short s) {
        switch (s) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "String.valueOf(this." + string + ")";
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2005: {
                return "this." + string;
            }
            case -4: 
            case -3: 
            case -2: {
                return "(new String(this." + string + "))";
            }
        }
        return "null";
    }

    public static void main(String[] stringArray) {
        Properties properties = System.getProperties();
        if (stringArray.length < 1) {
            System.out.println("Usage: ");
            System.out.println("Select tables: java DBGenerateClasses <path-config-file> <table1> ... <tableN>");
            System.out.println("All tables: java DBGenerateClasses <path-config-file>");
            System.exit(1);
        }
        String string = stringArray[0];
        Connection connection = null;
        String string2 = new String("public static String getTablename() { \n\t return TABLE_NM; }\n");
        StringBuffer stringBuffer = new StringBuffer("public void clear () {\n");
        String string3 = new String();
        if (string == null) {
            System.err.println("ERROR: You must enter config file name on command line");
            System.err.println("Usage: java -DConfigFileName=<config file name> <table1> .. <tableN>");
            System.exit(1);
        }
        try {
            properties.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println("ERROR: load of " + string + " failed: " + iOException.getMessage());
            System.exit(2);
        }
        String string4 = properties.getProperty("Driver");
        String string5 = properties.getProperty("DbUrl");
        String string6 = properties.getProperty("User");
        String string7 = properties.getProperty("Password");
        String string8 = properties.getProperty("Schema");
        String string9 = properties.getProperty("Root");
        String string10 = properties.getProperty("NormalFields");
        String string11 = properties.getProperty("NormalTables");
        String string12 = properties.getProperty("LegacyTables");
        try {
            connection = DbGenerateClasses.connect(string4, string5, string6, string7);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ERROR: Driver couldn't be loaded for: " + string4);
            System.err.println("Error message is: " + classNotFoundException.getMessage());
            System.exit(3);
        }
        catch (SQLException sQLException) {
            System.err.println("ERROR: connect failed: " + sQLException.getMessage());
            System.err.println("Check your configuration file: " + string);
            System.exit(3);
        }
        try {
            int n;
            Cloneable cloneable;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray2 = null;
            if (stringArray.length > 1) {
                stringArray2 = new String[stringArray.length - 1];
                int n2 = 0;
                while (n2 < stringArray.length - 1) {
                    stringArray2[n2] = new String(stringArray[n2 + 1]);
                    ++n2;
                }
            } else {
                ResultSet resultSet = databaseMetaData.getTables(null, string8, null, null);
                cloneable = new Vector<String>();
                while (resultSet.next()) {
                    ((Vector)cloneable).add(resultSet.getString("TABLE_NAME"));
                }
                n = ((Vector)cloneable).size();
                stringArray2 = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    stringArray2[n3] = (String)((Vector)cloneable).elementAt(n3);
                    ++n3;
                }
            }
            String[] stringArray3 = string10.split(" ");
            cloneable = new Hashtable();
            n = 0;
            while (n < stringArray3.length) {
                ((Hashtable)cloneable).put(stringArray3[n], stringArray3[n]);
                ++n;
            }
            String[] stringArray4 = string11.split(" ");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n4 = 0;
            while (n4 < stringArray4.length) {
                hashtable.put(stringArray4[n4], stringArray4[n4]);
                ++n4;
            }
            String[] stringArray5 = string12.split(" ");
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            int n5 = 0;
            while (n5 < stringArray5.length) {
                hashtable2.put(stringArray5[n5], stringArray5[n5]);
                ++n5;
            }
            n5 = 0;
            while (n5 < stringArray2.length) {
                short s;
                String string13;
                String string14;
                String string15;
                Object object;
                short s2;
                Object object2;
                String string16;
                String string17;
                System.out.println("Processing Table Name: " + stringArray2[n5]);
                String string18 = null;
                String string19 = null;
                String string20 = null;
                stringBuffer = null;
                String string21 = null;
                string18 = new String("");
                string19 = new String("");
                string20 = new String("");
                string21 = new String("");
                String string22 = new String("public String toString () {\n\tStringBuffer output = new StringBuffer();\n");
                stringBuffer = new StringBuffer("\tpublic void clear () {\n");
                String string23 = new String("static {\n\tm_colList = new Hashtable();\n\tColumnInfo colInfo;\n");
                String string24 = string17 = DbGenerateClasses.columnNameToMemberName(stringArray2[n5]);
                string17 = String.valueOf(string17) + "Table";
                String string25 = String.valueOf(string17) + ".java";
                String string26 = "";
                System.out.println("Writing table class: " + string25);
                File file = new File(String.valueOf(string9) + "\\tables\\" + string25);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                DbGenerateClasses.printHeader(printWriter, string17);
                printWriter.println("package org.eclipse.aperi.infrastructure.database.tables;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBTable;");
                printWriter.println("import java.sql.Types;");
                printWriter.println("import java.util.Hashtable;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.ColumnInfo;\n");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBConstants;\n");
                printWriter.println("public abstract class " + string17 + " extends DBTable {");
                printWriter.println("//constant for database table name");
                String string27 = stringArray2[n5].toUpperCase();
                printWriter.println("\tprotected static final String TABLE_NM = \"" + string27 + "\";");
                printWriter.println("\tprivate static Hashtable m_colList;");
                printWriter.println("//member variables for columns");
                ResultSet resultSet = databaseMetaData.getColumns(null, string8, string27, null);
                Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                Vector<String> vector = new Vector<String>();
                while (resultSet.next()) {
                    String string28 = resultSet.getString("COLUMN_NAME");
                    string16 = DbGenerateClasses.columnNameToMemberName(string28);
                    short s3 = resultSet.getShort("DATA_TYPE");
                    if (!resultSet.getString("TABLE_NAME").equals(string27)) continue;
                    printWriter.print("\tprotected ");
                    string23 = String.valueOf(string23) + "\tcolInfo = new ColumnInfo();\n";
                    string23 = String.valueOf(string23) + "\tcolInfo.setTableName(TABLE_NM);\n";
                    string23 = String.valueOf(string23) + "\tcolInfo.setName(" + string28 + ");\n";
                    string22 = String.valueOf(string22) + "\toutput.append(" + string28 + "+\":\\t\\t\");\n";
                    string22 = String.valueOf(string22) + "\toutput.append(get" + string16 + "());\n";
                    string22 = String.valueOf(string22) + "\toutput.append(\"\\n\");\n";
                    string3 = DbGenerateClasses.sqlTypeToJavaTypeString(s3);
                    String string29 = DbGenerateClasses.sqlTypeToSqlTypeString(s3);
                    string26 = "m_" + string16;
                    vector.add(string28);
                    hashtable3.put(string28, String.valueOf(s3));
                    printWriter.println(String.valueOf(string3) + " " + string26 + ";");
                    string21 = String.valueOf(string21) + "\tpublic static final String " + string28 + " = \"" + string28 + "\";\n";
                    string18 = String.valueOf(string18) + "\tpublic " + string3 + " get" + string16;
                    string18 = String.valueOf(string18) + "() {return " + string26 + ";}\n";
                    string23 = String.valueOf(string23) + "\tcolInfo.setDataType(Types." + string29 + ");\n";
                    string23 = String.valueOf(string23) + "\tm_colList.put(" + string28 + ", colInfo);\n";
                    stringBuffer.append("\t\t").append(DbGenerateClasses.buildClearStatement(string26, s3));
                    string19 = String.valueOf(string19) + DbGenerateClasses.buildSetStatement(string16, string26, s3) + "\n";
                }
                string20 = "public " + string17 + " ( ) {}\n";
                string23 = String.valueOf(string23) + " \n}";
                string22 = String.valueOf(string22) + "\n\treturn output.toString();\n}\n";
                stringBuffer.append("\n\t}\n");
                printWriter.println("\t//Public Column Names");
                printWriter.println(string21);
                printWriter.println("\t//Static Initializer");
                printWriter.println(string23);
                printWriter.println("\t//Constructor");
                printWriter.println(string20);
                printWriter.println("\t//Selectors");
                printWriter.println(string18);
                printWriter.println("\t//Set Methods");
                printWriter.println(string19);
                printWriter.println("\t//ToString method");
                printWriter.println(string22);
                printWriter.println("\t//clear method");
                printWriter.println(stringBuffer.toString());
                printWriter.println("\t//getTablename method");
                printWriter.println(string2);
                printWriter.println("public static ColumnInfo getColumnInfo (String colName) { return (ColumnInfo) m_colList.get(colName); }");
                printWriter.println("public static Hashtable getColumns () { return (Hashtable)m_colList.clone(); }");
                printWriter.println("} // class " + string17);
                printWriter.close();
                resultSet.close();
                int n6 = 1;
                if (hashtable2.get(stringArray2[n5]) == null) {
                    n6 = stringArray2[n5].indexOf(95, 2);
                }
                string16 = stringArray2[n5].substring(n6 + 1);
                String string30 = DbGenerateClasses.columnNameToMemberName(string16);
                String string31 = string17;
                string17 = string24;
                string25 = String.valueOf(string30) + ".java";
                System.out.println("Writing object class: " + string25);
                file = new File(String.valueOf(string9) + "\\objects\\" + string25);
                fileOutputStream = new FileOutputStream(file);
                printWriter = new PrintWriter(fileOutputStream);
                DbGenerateClasses.printHeader(printWriter, string30);
                printWriter.println("package org.eclipse.aperi.infrastructure.database.objects;\n");
                printWriter.println("import java.sql.Timestamp;");
                printWriter.println("import java.sql.Statement;");
                printWriter.println("import java.sql.Date;");
                printWriter.println("import java.sql.Time;");
                printWriter.println("import java.sql.Clob;");
                printWriter.println("import java.sql.SQLException;");
                printWriter.println("import java.util.Hashtable;");
                printWriter.println("import java.util.Vector;\n");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.ColumnInfo;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBConnection;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBConstants;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBCursor;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBResultSet;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBTable;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.Normalizer;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.tables." + string31 + ";\n");
                printWriter.println("public class " + string30 + " extends " + string17 + "Table {\n");
                int n7 = 0;
                while (n7 < vector.size()) {
                    object2 = (String)vector.elementAt(n7);
                    s2 = Short.parseShort((String)hashtable3.get(object2));
                    if (((Hashtable)cloneable).get(object2) != null && hashtable.get(stringArray2[n5]) == null && s2 == 5) {
                        object = DbGenerateClasses.columnNameToMemberName((String)object2);
                        string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s2));
                        string26 = "m_" + (String)object;
                        printWriter.println("\tprivate String " + string26 + "_str;");
                    }
                    if (n7 == vector.size() - 1) {
                        printWriter.println("");
                    }
                    ++n7;
                }
                n7 = 0;
                while (n7 < vector.size()) {
                    object2 = (String)vector.elementAt(n7);
                    s2 = Short.parseShort((String)hashtable3.get(object2));
                    if (((Hashtable)cloneable).get(object2) != null && hashtable.get(stringArray2[n5]) == null && s2 == 5) {
                        object = DbGenerateClasses.columnNameToMemberName((String)object2);
                        string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s2));
                        string26 = "m_" + (String)object;
                        string15 = ((String)object).substring(0, ((String)object).length() - 2);
                        printWriter.print("\tpublic void set" + string15 + "(String el) { ");
                        printWriter.print("this." + string26 + "_str = el; }\n\n");
                        printWriter.print("\tpublic String get" + string15 + "() { ");
                        printWriter.print("return this." + string26 + "_str; }\n\n");
                        if (n7 == vector.size() - 1) {
                            printWriter.println("");
                        }
                    }
                    ++n7;
                }
                printWriter.println("\tpublic static class " + string30 + "Cursor extends DBCursor {\n");
                printWriter.println("\t\tprivate " + string30 + " element = new " + string30 + "();");
                printWriter.println("\t\tprivate DBConnection con;\n");
                n7 = 0;
                int n8 = 0;
                while (n8 < vector.size()) {
                    String string32 = (String)vector.elementAt(n8);
                    object = DbGenerateClasses.columnNameToMemberName(string32);
                    short s4 = Short.parseShort((String)hashtable3.get(string32));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s4));
                    string26 = "m_" + (String)object;
                    if (((Hashtable)cloneable).get(string32) != null && hashtable.get(stringArray2[n5]) == null && s4 == 5) {
                        if (n7 == 0) {
                            printWriter.println("\t\tprivate static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {\n\n");
                            printWriter.print("\t\t\tif (htWhereClause == null) return null;\n\n");
                            n7 = 1;
                        }
                        printWriter.print("\t\t\tif (htWhereClause.get(getColumnInfo(" + string31 + "." + string32 + ")) != null)\n");
                        printWriter.print("\t\t\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string32 + "), String.valueOf(Normalizer." + ((String)object).substring(0, ((String)object).length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htWhereClause.get(getColumnInfo(" + string31 + "." + string32 + ")))));\n\n");
                    }
                    ++n8;
                }
                if (n7 != 0) {
                    printWriter.println("\t\t\treturn htWhereClause;\n\t\t}\n");
                }
                printWriter.println("\t\tpublic " + string30 + "Cursor (DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {\n");
                if (n7 != 0) {
                    printWriter.println("\t\t\tsuper(TABLE_NM, con, normalize(con, htWhereClause), columns);\n");
                } else {
                    printWriter.println("\t\t\tsuper(TABLE_NM, con, htWhereClause, columns);\n");
                }
                printWriter.println("\t\t\tthis.con = con;\n");
                printWriter.println("\t\t}\n");
                printWriter.println("\t\tpublic " + string30 + " getObject() throws SQLException {\n");
                printWriter.println("\t\t\t" + string30 + " el = null;\n");
                printWriter.println("\t\t\tif (DBrs != null) {");
                printWriter.println("\t\t\t\tel = new " + string30 + "();");
                printWriter.println("\t\t\t\tel.setFields(con, DBrs);");
                printWriter.println("\t\t\t}\n");
                printWriter.println("\t\t\treturn el;");
                printWriter.println("\t\t}\n");
                printWriter.println("\t\tpublic " + string30 + " getAttributes() throws SQLException {\n");
                printWriter.println("\t\t\tif (DBrs != null) {");
                printWriter.println("\t\t\t\telement.setFields(con, DBrs);");
                printWriter.println("\t\t\t\treturn element;");
                printWriter.println("\t\t\t}\n");
                printWriter.println("\t\t\telse return null;");
                printWriter.println("\t\t}\n");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static " + string30 + "Cursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns)" + " throws SQLException{\n");
                printWriter.println("\t\treturn new " + string30 + "Cursor(con, htWhereClause, columns);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic " + string30 + "() { clear(); }\n");
                printWriter.print("\tpublic " + string30 + "(");
                n8 = 0;
                while (n8 < vector.size()) {
                    String string33 = (String)vector.elementAt(n8);
                    object = DbGenerateClasses.columnNameToMemberName(string33);
                    short s5 = Short.parseShort((String)hashtable3.get(string33));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s5));
                    string26 = "m_" + (String)object;
                    printWriter.print("\t\t" + string3 + " " + (String)object);
                    if (n8 == vector.size() - 1) {
                        printWriter.println(")");
                    } else {
                        printWriter.println(",");
                    }
                    ++n8;
                }
                printWriter.println("\t{");
                printWriter.println("\t\tthis.clear();\n");
                n8 = 0;
                while (n8 < vector.size()) {
                    String string34 = (String)vector.elementAt(n8);
                    object = DbGenerateClasses.columnNameToMemberName(string34);
                    short s6 = Short.parseShort((String)hashtable3.get(string34));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s6));
                    string26 = "m_" + (String)object;
                    printWriter.print("\t\tthis." + string26 + " = " + (String)object);
                    printWriter.println(";");
                    ++n8;
                }
                printWriter.println("\t}\n");
                resultSet = databaseMetaData.getPrimaryKeys(null, string8, string27);
                object2 = new Hashtable();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                object = new Vector();
                while (resultSet.next()) {
                    string15 = resultSet.getString("COLUMN_NAME");
                    string14 = DbGenerateClasses.columnNameToMemberName(string15);
                    string26 = "m_" + string14;
                    ((Hashtable)object2).put(string15, string26);
                    ((Vector)object).add(string15);
                    System.out.println("Primary key:" + string15);
                }
                resultSet.close();
                if (((Vector)object).size() == 0) {
                    System.out.println("No primary keys for " + string27);
                }
                printWriter.println("\tprivate void setNonKeyValues(Hashtable htColsAndValues) {\n");
                int n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    s = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s));
                    string26 = "m_" + string13;
                    if (((Hashtable)object2).get(string14) != null) {
                        hashtable4.put(string14, String.valueOf(s));
                    } else {
                        printWriter.println("\t\tif (" + string26 + " != " + DbGenerateClasses.invalidValueString(s) + ") {");
                        printWriter.println("\t\t\thtColsAndValues.put(" + string30 + ".getColumnInfo(" + string31 + "." + string14 + ")," + DbGenerateClasses.convertToString(string26, s) + ");}\n");
                    }
                    ++n9;
                }
                printWriter.println("\t}\n");
                printWriter.println("\tpublic boolean insert(DBConnection con) throws SQLException {\n");
                printWriter.println("\t\thtColsAndValues.clear();\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    s = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s == 5) {
                        printWriter.print("\t\tif (this." + string26 + "_str != null) this." + string26 + " = Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("this." + string26 + "_str);\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    string13 = (String)((Hashtable)object2).get(string14);
                    String string35 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (this." + string13 + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(string35)) + "){");
                    printWriter.println("\t\t\tthrow new SQLException(\"ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtColsAndValues.put(getColumnInfo(" + string31 + "." + string14 + ")," + DbGenerateClasses.convertToString(string13, (short)Integer.parseInt(string35)) + ");");
                    ++n9;
                }
                printWriter.println("\t\tthis.setNonKeyValues(htColsAndValues);\n");
                printWriter.println("\t\treturn DBQueryAssistant.performInsert(TABLE_NM, con, htColsAndValues);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic boolean insert(DBConnection con, Hashtable htinput) throws SQLException {\n");
                printWriter.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s7 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s7));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s7 == 5) {
                        printWriter.print("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtinput.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htinput.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    String cfr_ignored_0 = (String)((Hashtable)object2).get(string14);
                    String cfr_ignored_1 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) == null) {");
                    printWriter.println("\t\t\tthrow new SQLException(\" ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    ++n9;
                }
                printWriter.println("\t\treturn DBQueryAssistant.performInsert(TABLE_NM, con, htinput);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic int update(DBConnection con) throws SQLException {\n");
                printWriter.println("\t\thtColsAndValues.clear();\n");
                printWriter.println("\t\thtWhereClause.clear();\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s8 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s8));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s8 == 5) {
                        printWriter.print("\t\tif (this." + string26 + "_str != null) this." + string26 + " = Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("this." + string26 + "_str);\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    string13 = (String)((Hashtable)object2).get(string14);
                    String string36 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (this." + string13 + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(string36)) + "){");
                    printWriter.println("\t\t\tthrow new SQLException(\"ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + ")," + DbGenerateClasses.convertToString(string13, (short)Integer.parseInt(string36)) + ");");
                    ++n9;
                }
                printWriter.println("\t\tthis.setNonKeyValues(htColsAndValues);\n");
                printWriter.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                printWriter.println("\t\treturn DBQueryAssistant.performUpdate(TABLE_NM, con, htColsAndValues, htWhereClause);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic int update(DBConnection con, Hashtable htinput) throws SQLException {\n");
                printWriter.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");");
                printWriter.println("\t\thtWhereClause.clear();\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s9 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s9));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s9 == 5) {
                        printWriter.print("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtinput.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htinput.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    String cfr_ignored_2 = (String)((Hashtable)object2).get(string14);
                    String cfr_ignored_3 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) == null) {");
                    printWriter.println("\t\t\tthrow new SQLException(\" ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + ")," + "htinput.get(getColumnInfo(" + string31 + "." + string14 + ")));\n");
                    ++n9;
                }
                printWriter.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                printWriter.println("\t\treturn DBQueryAssistant.performUpdate(TABLE_NM, con, htinput, htWhereClause);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic int delete(DBConnection con) throws SQLException {\n");
                printWriter.println("\t\thtWhereClause.clear();\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s10 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s10));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s10 == 5) {
                        printWriter.print("\t\tif (this." + string26 + "_str != null) this." + string26 + " = Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("this." + string26 + "_str);\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    string13 = (String)((Hashtable)object2).get(string14);
                    String string37 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (this." + string13 + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(string37)) + "){");
                    printWriter.println("\t\t\tthrow new SQLException(\"ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + ")," + DbGenerateClasses.convertToString(string13, (short)Integer.parseInt(string37)) + ");");
                    ++n9;
                }
                printWriter.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                printWriter.println("\t\treturn DBQueryAssistant.performDelete(TABLE_NM, con, htWhereClause);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic int delete(DBConnection con, Hashtable htinput) throws SQLException {\n");
                printWriter.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");");
                printWriter.println("\t\thtWhereClause.clear();\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s11 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s11));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s11 == 5) {
                        printWriter.print("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtinput.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htinput.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    String cfr_ignored_4 = (String)((Hashtable)object2).get(string14);
                    String cfr_ignored_5 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) == null) {");
                    printWriter.println("\t\t\tthrow new SQLException(\" ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + ")," + "htinput.get(getColumnInfo(" + string31 + "." + string14 + ")));");
                    ++n9;
                }
                printWriter.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                printWriter.println("\t\treturn DBQueryAssistant.performDelete(TABLE_NM, con, htWhereClause);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic boolean retrieve(DBConnection con) throws SQLException {\n");
                printWriter.println("\t\thtWhereClause.clear();\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s12 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s12));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s12 == 5) {
                        printWriter.print("\t\tif (this." + string26 + "_str != null) this." + string26 + " = Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("this." + string26 + "_str);\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    string13 = (String)((Hashtable)object2).get(string14);
                    String string38 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (this." + string13 + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(string38)) + "){");
                    printWriter.println("\t\t\tthrow new SQLException(\"ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + ")," + DbGenerateClasses.convertToString(string13, (short)Integer.parseInt(string38)) + ");");
                    ++n9;
                }
                printWriter.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                printWriter.println("\t\tDBResultSet DBrs = null;");
                printWriter.println("\t\tboolean res = false;");
                printWriter.println("\t\ttry {");
                printWriter.println("\t\t\tDBrs = DBQueryAssistant.performRetrieve(TABLE_NM, con, htWhereClause, null);");
                printWriter.println("\t\t\tif (DBrs.next()) { setFields(con, DBrs); res = true; }");
                printWriter.println("\t\t}");
                printWriter.println("\t\tfinally {");
                printWriter.println("\t\t\tif (DBrs != null) { DBrs.getStatement().close(); }");
                printWriter.println("\t\t}");
                printWriter.println("\t\treturn res;");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static " + string30 + " retrieve(DBConnection con, Hashtable htinput) throws SQLException {\n");
                printWriter.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");");
                printWriter.println("\t\tHashtable htWhereClause = new Hashtable();");
                printWriter.println("\t\t" + string30 + " el = null;");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s13 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s13));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s13 == 5) {
                        printWriter.print("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtinput.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htinput.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    string14 = (String)((Vector)object).elementAt(n9);
                    String cfr_ignored_6 = (String)((Hashtable)object2).get(string14);
                    String cfr_ignored_7 = (String)hashtable4.get(string14);
                    printWriter.println("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) == null) {");
                    printWriter.println("\t\t\tthrow new SQLException(\" ERROR: key " + string14 + " not found\");");
                    printWriter.println("\t\t}\n");
                    printWriter.println("\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + ")," + "htinput.get(getColumnInfo(" + string31 + "." + string14 + ")));");
                    ++n9;
                }
                printWriter.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                printWriter.println("\t\tDBResultSet DBrs = null;");
                printWriter.println("\t\ttry {");
                printWriter.println("\t\t\tDBrs = DBQueryAssistant.performRetrieve(TABLE_NM, con, htWhereClause, null);");
                printWriter.println("\t\t\tif (DBrs.next()) { el = new " + string30 + "(); el.setFields(con, DBrs); }");
                printWriter.println("\t\t}");
                printWriter.println("\t\tfinally {");
                printWriter.println("\t\t\tif (DBrs != null) { DBrs.getStatement().close(); }");
                printWriter.println("\t\t}");
                printWriter.println("\t\treturn el;");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {\n");
                printWriter.println("\t\tif (con == null || htinput == null || htWhereClause == null) throw new SQLException(\"ERROR invalid input\");");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s14 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s14));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s14 == 5) {
                        printWriter.print("\t\tif (htinput.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtinput.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htinput.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s15 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s15));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s15 == 5) {
                        printWriter.print("\t\tif (htWhereClause.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htWhereClause.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                printWriter.println("\t\treturn DBQueryAssistant.performUpdate(TABLE_NM, con, htinput, htWhereClause);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {\n");
                printWriter.println("\t\tif (con == null || htWhereClause == null) throw new SQLException(\"ERROR invalid input\");");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s16 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(s16));
                    string26 = "m_" + string13;
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s16 == 5) {
                        printWriter.print("\t\tif (htWhereClause.get(getColumnInfo(" + string31 + "." + string14 + ")) != null)\n");
                        printWriter.print("\t\t\thtWhereClause.put(getColumnInfo(" + string31 + "." + string14 + "), String.valueOf(Normalizer." + string13.substring(0, string13.length() - 2) + "GetID(con, ");
                        printWriter.print("(String)htWhereClause.get(getColumnInfo(" + string31 + "." + string14 + ")))));\n\n");
                    }
                    ++n9;
                }
                printWriter.println("\t\treturn DBQueryAssistant.performDelete(TABLE_NM, con, htWhereClause);");
                printWriter.println("\t}\n");
                printWriter.println("\tprotected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {\n");
                n9 = 0;
                while (n9 < vector.size()) {
                    string14 = (String)vector.elementAt(n9);
                    string13 = DbGenerateClasses.columnNameToMemberName(string14);
                    short s17 = Short.parseShort((String)hashtable3.get(string14));
                    string3 = DbGenerateClasses.sqlTypeToJavaTypeCapString(s17);
                    string26 = "m_" + string13;
                    printWriter.println("\t\tthis.set" + string13 + "(DBrs.get" + string3 + "(" + string31 + "." + string14 + "));");
                    if (((Hashtable)cloneable).get(string14) != null && hashtable.get(stringArray2[n5]) == null && s17 == 5) {
                        printWriter.println("\t\tthis.set" + string13.substring(0, string13.length() - 2) + "(Normalizer." + string13.substring(0, string13.length() - 2) + "GetName(con, this." + string26 + "));");
                    }
                    if (n9 == vector.size() - 1) {
                        printWriter.println("\t}\n");
                    }
                    ++n9;
                }
                printWriter.println("}\n");
                printWriter.close();
                string25 = "Sql" + string30 + ".java";
                System.out.println("Writing sql class: " + string25);
                file = new File(String.valueOf(string9) + "\\sql\\" + string25);
                fileOutputStream = new FileOutputStream(file);
                printWriter = new PrintWriter(fileOutputStream);
                DbGenerateClasses.printHeader(printWriter, "Sql" + string30);
                printWriter.println("package org.eclipse.aperi.infrastructure.database.sql;\n");
                printWriter.println("import java.sql.SQLException;\n");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.ComplexQuery;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBResultSet;");
                printWriter.println("import org.eclipse.aperi.infrastructure.database.DBConnection;\n");
                printWriter.println("import java.util.Hashtable;\n");
                printWriter.println("public class Sql" + string30 + " {\n");
                printWriter.println("//This is a auto-generated comment: please do not touch");
                printWriter.println("//Please add your query to sqlArray and index it with a integer public variable");
                printWriter.println("//An example is shown below:");
                printWriter.println("//\tpublic static int maxSizeQuery = 0;");
                printWriter.println("//\tpublic static int minSizeQuery = 1;");
                printWriter.println("//\tprivate static String sqlArray[] = { \"SELECT MAX(CAPACITY) FROM STORAGE_VOLUME\",\n//\t\t\"SELECT MIN(CAPACITY) FROM STORAGE_VOLUME\" };");
                printWriter.println("//Please do NOT modify a checked-in query as someone else may use it -- create a new one\n\n");
                printWriter.println("\tprivate static String sqlArray[] = {}; \n");
                printWriter.println("\tpublic static int sqlUpdate(DBConnection con, int sqlIndex, Hashtable params) throws SQLException {");
                printWriter.println("\t\treturn ComplexQuery.sqlUpdate(con, sqlArray[sqlIndex], params);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static DBResultSet sqlQuery(DBConnection con, int sqlIndex, Hashtable params) throws SQLException {");
                printWriter.println("\t\treturn ComplexQuery.sqlQuery(con, sqlArray[sqlIndex], params);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static int sqlUpdate(DBConnection con, int sqlIndex, String concat, Hashtable params) throws SQLException {");
                printWriter.println("\t\treturn ComplexQuery.sqlUpdate(con, sqlArray[sqlIndex] + concat, params);");
                printWriter.println("\t}\n");
                printWriter.println("\tpublic static DBResultSet sqlQuery(DBConnection con, int sqlIndex, String concat, Hashtable params) throws SQLException {");
                printWriter.println("\t\treturn ComplexQuery.sqlQuery(con, sqlArray[sqlIndex] + concat, params);");
                printWriter.println("\t}\n");
                printWriter.println("}\n");
                printWriter.close();
                System.out.println("\n");
                ++n5;
            }
            connection.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR: exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

