/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.io.Serializable;
import org.eclipse.aperi.common.api.Distinguishable;

public class SRMVersion
implements Cloneable,
Comparable,
Serializable,
Distinguishable {
    private static final String version = "5.0.0";
    private static final String equiv = "5.0.0";
    private static final String incomp = "4.9.9";
    private static final String[] features = new String[0];
    private String strSerVersion;
    private String strSerEquiv;
    private String strSerIncomp;
    private String[] astrSerFeatures;
    static final long serialVersionUID = -470009297440056011L;

    public SRMVersion() {
        this.strSerVersion = "5.0.0";
        this.strSerEquiv = this.getLocalEquivalenceLevel();
        this.strSerIncomp = this.getLocalIncompatibilityLevel();
        this.astrSerFeatures = this.getLocalFeatureList();
    }

    public SRMVersion(SRMVersion sRMVersion) {
        this.strSerVersion = sRMVersion.strSerVersion;
        this.strSerEquiv = sRMVersion.strSerEquiv;
        this.strSerIncomp = sRMVersion.strSerIncomp;
        this.astrSerFeatures = new String[sRMVersion.astrSerFeatures.length];
        int n = this.astrSerFeatures.length - 1;
        while (n >= 0) {
            this.astrSerFeatures[n] = sRMVersion.astrSerFeatures[n];
            --n;
        }
    }

    public final String getVersion() {
        return this.strSerVersion;
    }

    public String getCheckableVersion() {
        return SRMVersion.getCheckableVersion(this.strSerVersion);
    }

    public String getEquivalenceLevel() {
        return this.strSerEquiv;
    }

    public String getIncompatibilityLevel() {
        return this.strSerIncomp;
    }

    public String[] getFeatureList() {
        return this.astrSerFeatures;
    }

    public static final String getLocalVersion() {
        return "5.0.0";
    }

    public String getLocalEquivalenceLevel() {
        return "5.0.0";
    }

    public String getLocalIncompatibilityLevel() {
        return incomp;
    }

    public String[] getLocalFeatureList() {
        return features;
    }

    public boolean isCompatible() {
        SRMVersion sRMVersion = null;
        try {
            sRMVersion = (SRMVersion)this.getClass().newInstance();
        }
        catch (Exception exception) {}
        return this.isCompatible(sRMVersion);
    }

    protected boolean isCompatible(SRMVersion sRMVersion) {
        String string = SRMVersion.getCheckableVersion(this.strSerVersion);
        String string2 = SRMVersion.getCheckableVersion(sRMVersion.getVersion());
        String string3 = SRMVersion.getCheckableVersion(this.strSerEquiv);
        String string4 = SRMVersion.getCheckableVersion(sRMVersion.getIncompatibilityLevel());
        return SRMVersion.compareVersionStrings(string, string2) == 0 || SRMVersion.compareVersionStrings(string, string2) < 0 && SRMVersion.compareVersionStrings(string, string4) > 0 || SRMVersion.compareVersionStrings(string, string2) > 0 && SRMVersion.compareVersionStrings(string3, string2) <= 0;
    }

    public static int compareVersionStrings(String string, String string2) {
        long l;
        long l2 = SRMVersion.convertVersion(string);
        return l2 == (l = SRMVersion.convertVersion(string2)) ? 0 : (l2 < l ? -1 : 1);
    }

    public boolean isFeatureSupported(String string) {
        int n = this.astrSerFeatures.length - 1;
        while (n >= 0) {
            if (string.equalsIgnoreCase(this.astrSerFeatures[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    public boolean isFeatureSupportedLocally(String string) {
        String[] stringArray = this.getLocalFeatureList();
        int n = stringArray.length - 1;
        while (n >= 0) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof SRMVersion) {
            return this.strSerVersion.equals(((SRMVersion)object).strSerVersion);
        }
        return false;
    }

    public int compareTo(Object object) {
        return SRMVersion.compareVersionStrings(this.strSerVersion, ((SRMVersion)object).strSerVersion);
    }

    public boolean isIdentical(Object object) {
        boolean bl = false;
        if (object instanceof SRMVersion && ((SRMVersion)object).strSerVersion.equals(this.strSerVersion) && ((SRMVersion)object).strSerEquiv.equals(this.strSerEquiv) && ((SRMVersion)object).strSerIncomp.equals(this.strSerIncomp) && ((SRMVersion)object).astrSerFeatures.length == this.astrSerFeatures.length) {
            bl = true;
            int n = this.astrSerFeatures.length - 1;
            while (n >= 0) {
                if (!((SRMVersion)object).astrSerFeatures[n].equals(this.astrSerFeatures[n])) {
                    bl = false;
                    break;
                }
                --n;
            }
        }
        return bl;
    }

    public String toString() {
        return "SRMVersion@" + Integer.toHexString(this.hashCode()) + " (ver=" + this.strSerVersion + ", equ=" + this.strSerEquiv + ", inc=" + this.strSerIncomp + ")";
    }

    public Object clone() {
        SRMVersion sRMVersion = null;
        try {
            sRMVersion = (SRMVersion)super.clone();
            sRMVersion.astrSerFeatures = new String[this.astrSerFeatures.length];
            int n = this.astrSerFeatures.length - 1;
            while (n >= 0) {
                sRMVersion.astrSerFeatures[n] = this.astrSerFeatures[n];
                --n;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return sRMVersion;
    }

    private static String getCheckableVersion(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < 3) {
            if ((n = string.indexOf(46, n + 1)) == -1) break;
            ++n2;
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private static long convertVersion(String string) {
        long l = 0L;
        int n = 0;
        while (n < 4) {
            String string2;
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            }
            l *= 65536L;
            if (string2.length() > 0) {
                try {
                    l += (long)Short.parseShort(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
        return l;
    }
}

