/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.JobLogDeletionHandler;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.control.TokenHeartbeat;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.IControlEngine;
import org.eclipse.aperi.control.interfaces.InvalidTokenException;
import org.eclipse.aperi.control.interfaces.JobInProgressException;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class ControlEngine
implements IControlEngine {
    private static ControlEngine instance;
    private Integer tokenTimeout = null;
    private ArrayList<Token> validTokens = new ArrayList();
    private Token internalToken = null;
    public Hashtable tokenTable = new Hashtable();
    private Hashtable subJobStatus = new Hashtable();
    private Hashtable jobsBelongingToTokens = new Hashtable();
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        instance = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.ControlEngine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public static synchronized ControlEngine getInstance() {
        if (instance == null) {
            instance = new ControlEngine();
        }
        return instance;
    }

    private ControlEngine() {
        String string = "ControlEngine";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        this.internalToken = new Token("internalToken", "XX", -1, "ControlEngine", 2, "");
        this.validTokens.add(this.internalToken);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public synchronized String startJob(Token token, String string, boolean bl, boolean bl2) throws Exception {
        ArrayList<JobInfo> arrayList;
        JobInfo jobInfo;
        ILogger iLogger;
        String string2;
        String string3;
        String string4;
        block14: {
            TokenHeartbeat tokenHeartbeat;
            block13: {
                string4 = "startJob";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string4);
                }
                this.checkToken(token);
                tokenHeartbeat = this.startTokenHeartbeat(token);
                string3 = new Integer(ServiceUtils.getJobIdentifier(bl2, 7)).toString();
                string2 = new Integer(ServiceUtils.getJobIdentifier(bl2, 2)).toString();
                iLogger = null;
                if (bl2) {
                    try {
                        Class<?> clazz;
                        iLogger = LogManagerFactory.getJobLogger("control", string3, string2);
                        try {
                            clazz = Class.forName("org.eclipse.aperi.disk.resources.DMJobMessages");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        iLogger.setMessageFile(clazz.getName());
                    }
                    catch (Exception exception) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block13;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
                    }
                }
            }
            jobInfo = new JobInfo(string3, string2, bl);
            jobInfo.setJobStatus(2);
            jobInfo.setToken(token);
            jobInfo.setHeartBeat(tokenHeartbeat);
            jobInfo.setJobLogger(iLogger);
            ServiceUtils.activeJobs.put(string3, jobInfo);
            if (bl2) {
                arrayList = "";
                if (iLogger != null) {
                    arrayList = LogManagerFactory.getLogFileName(iLogger);
                }
                ServiceUtils.createJobRecord(Integer.parseInt(string3), Integer.parseInt(string2), string, (String)((Object)arrayList));
                try {
                    JobLogDeletionHandler.purgeControlLogFiles();
                }
                catch (Exception exception) {
                    if (!this.traceLogger.isLogging()) break block14;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
                    this.traceLogger.text(IRecordType.TYPE_INFORMATION, className, string4, "Error during job log deletion : RUN ID=" + string3 + ", Job ID=" + string2);
                }
            }
        }
        this.subJobStatus.put(string3, new ArrayList());
        token.setJobId(string3);
        arrayList = (ArrayList)this.jobsBelongingToTokens.get(token);
        if (arrayList == null) {
            arrayList = new ArrayList<JobInfo>();
        }
        arrayList.add(jobInfo);
        this.jobsBelongingToTokens.put(token, arrayList);
        if (iLogger != null) {
            iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string4, "ControlService_jobStarted", new String[]{string3, string2, string});
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
        }
        return string3;
    }

    public synchronized int startSubJob(Token token, String string, boolean bl) throws Exception {
        String string2 = "startSubJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        int n = -1;
        String string3 = token.getJobId();
        ArrayList arrayList = (ArrayList)this.subJobStatus.get(string3);
        if (arrayList != null) {
            Object object;
            int n2 = Integer.parseInt(string3);
            String string4 = null;
            ILogger iLogger = null;
            if (n2 >= 0) {
                string4 = new Integer(ServiceUtils.getJobIdentifier(bl, 2)).toString();
                if (bl) {
                    object = "";
                    JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string3);
                    if (jobInfo != null && jobInfo.getJobLogger() != null) {
                        iLogger = jobInfo.getJobLogger();
                        object = LogManagerFactory.getLogFileName(iLogger);
                    }
                    ServiceUtils.createJobRecord(Integer.parseInt(string3), Integer.parseInt(string4), string, (String)object);
                }
            } else {
                string4 = new Integer(ServiceUtils.getJobIdentifier(false, 2)).toString();
            }
            object = new AsyncResult(0, 2);
            ((AsyncResult)object).setJobId(string4);
            n = arrayList.size();
            arrayList.add(n, object);
            if (iLogger != null) {
                iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string2, "ControlService_childJobStarted", new String[]{string4, string});
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return n;
    }

    public synchronized boolean endJob(Token token, int n, int n2, SRMMessage sRMMessage, Exception exception, Object[] objectArray) throws Exception {
        String string = "endJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        boolean bl = false;
        String string2 = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string2);
        if (jobInfo != null) {
            String string3 = jobInfo.getJobId();
            jobInfo.setJobStatus(n2);
            int n3 = Integer.parseInt(string2);
            if (n3 >= 0) {
                ServiceUtils.updateJobRecord(n3, Integer.parseInt(string3), n2, n);
            }
            if (n2 == 2) {
                ServiceUtils.activeJobs.put(string2, jobInfo);
            } else {
                Object object;
                TokenHeartbeat tokenHeartbeat = jobInfo.getHeartBeat();
                this.stopTokenHeartbeat(tokenHeartbeat);
                if (jobInfo.isAsyncJob()) {
                    object = new AsyncResult(n, n2, sRMMessage);
                    ((AsyncResult)object).setJobId(string2);
                    ((AsyncResult)object).setReturnException(exception);
                    ((Result)object).setResults(objectArray);
                    AsyncResult asyncResult = this.getActiveJobResults(string2);
                    if (asyncResult != null) {
                        ((AsyncResult)object).setSubJobResults(asyncResult.getSubJobResults());
                    }
                    ServiceUtils.completedJobResults.put(string2, object);
                }
                ServiceUtils.activeJobs.remove(string2);
                this.subJobStatus.remove(string2);
                object = jobInfo.getJobLogger();
                if (object != null) {
                    object.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "ControlService_jobFinished", new String[]{jobInfo.getDeviceServerRunNumber(), jobInfo.getJobId(), new Integer(jobInfo.getJobStatus()).toString(), new Integer(n).toString()});
                    LogManagerFactory.returnJobLogger(jobInfo.getJobLogger());
                }
                bl = true;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return bl;
    }

    public synchronized boolean endSubJob(Token token, int n, int n2, int n3, SRMMessage sRMMessage, Exception exception, Object[] objectArray) throws Exception {
        String string = "endSubJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        boolean bl = false;
        String string2 = token.getJobId();
        ArrayList arrayList = (ArrayList)this.subJobStatus.get(string2);
        if (arrayList != null && n >= 0) {
            AsyncResult asyncResult;
            ILogger iLogger;
            block11: {
                iLogger = null;
                asyncResult = null;
                try {
                    asyncResult = (AsyncResult)arrayList.get(n);
                }
                catch (Exception exception2) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception2);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception2);
                }
            }
            if (asyncResult != null) {
                String string3;
                block12: {
                    Object object;
                    string3 = asyncResult.getJobId();
                    int n4 = Integer.parseInt(string3);
                    if (n4 >= 0) {
                        ServiceUtils.updateJobRecord(Integer.parseInt(string2), n4, n3, n2);
                        object = (JobInfo)ServiceUtils.activeJobs.get(string2);
                        if (object != null) {
                            iLogger = ((JobInfo)object).getJobLogger();
                        }
                    }
                    object = new AsyncResult(n2, n3, sRMMessage);
                    ((AsyncResult)object).setJobId(string3);
                    ((AsyncResult)object).setReturnException(exception);
                    ((Result)object).setResults(objectArray);
                    try {
                        arrayList.set(n, object);
                        bl = true;
                    }
                    catch (Exception exception3) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception3);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block12;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception3);
                    }
                }
                if (iLogger != null) {
                    iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "ControlService_childJobFinished", new String[]{string3, new Integer(n3).toString(), new Integer(n2).toString()});
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return bl;
    }

    public AsyncResult processReturnObj(Token token, Object object) {
        String string = "processReturnObj";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        AsyncResult asyncResult = new AsyncResult(0, 1);
        asyncResult.setJobId(token.getJobId());
        if (object != null) {
            if (object instanceof AsyncResult) {
                asyncResult = new AsyncResult(((AsyncResult)object).getRc(), ((AsyncResult)object).getStatus(), ((AsyncResult)object).getSRMMessage());
                asyncResult.setJobId(token.getJobId());
                asyncResult.setReturnException(((AsyncResult)object).getReturnException());
                asyncResult.setResults(((AsyncResult)object).getResults());
            } else if (object instanceof Result) {
                int n = ((Result)object).getRc();
                int n2 = 1;
                if (n != 0) {
                    n2 = 0;
                }
                asyncResult = new AsyncResult(n, n2, ((Result)object).getSRMMessage());
                asyncResult.setJobId(token.getJobId());
                asyncResult.setResults(((Result)object).getResults());
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                asyncResult.setRc(n);
                if (n != 0) {
                    asyncResult.setStatus(0);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return asyncResult;
    }

    public ILogger getJobLogger(Token token) {
        String string = "getJobLogger";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        ILogger iLogger = null;
        String string2 = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string2);
        if (jobInfo != null) {
            iLogger = jobInfo.getJobLogger();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return iLogger;
    }

    public synchronized void addAsyncThreadToJob(Token token, IController iController) {
        String string;
        JobInfo jobInfo;
        String string2 = "addAsyncThreadToJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        if ((jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string = token.getJobId())) != null) {
            jobInfo.setController(iController);
            ServiceUtils.activeJobs.put(string, jobInfo);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    public boolean isJobActive(String string) {
        String string2 = "isJobActive";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return jobInfo != null;
    }

    public void cancelJob(String string) {
        String string2;
        block6: {
            JobInfo jobInfo;
            string2 = "cancelJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
            }
            if ((jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string)) != null) {
                IController iController = jobInfo.getController();
                if (iController != null) {
                    iController.shutdown();
                }
                try {
                    this.endJob(jobInfo.getToken(), -47, 5, null, null, null);
                }
                catch (Exception exception) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, string2, exception);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    public AsyncResult getJobResults(String string) {
        String string2 = "getJobResults";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        AsyncResult asyncResult = (AsyncResult)ServiceUtils.completedJobResults.get(string);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return asyncResult;
    }

    public AsyncResult getActiveJobResults(String string) {
        String string2 = "getActiveJobResults";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        AsyncResult asyncResult = null;
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(string);
        if (jobInfo != null) {
            asyncResult = new AsyncResult(0, 2);
            asyncResult.setJobId(string);
            ArrayList arrayList = (ArrayList)this.subJobStatus.get(string);
            if (arrayList != null && arrayList.size() > 0) {
                AsyncResult[] asyncResultArray = arrayList.toArray(new AsyncResult[0]);
                asyncResult.setSubJobResults(asyncResultArray);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return asyncResult;
    }

    public int getJobStatus(String string) {
        String string2 = "getJobStatus";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return ServiceUtils.getJobStatus(string).getStatus();
    }

    public AsyncResult waitForJobToComplete(String string) {
        String string2 = "waitForJobToComplete";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string2);
        }
        while (this.isJobActive(string)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return this.getJobResults(string);
    }

    public String[] getJobIds(Token token) {
        String string = "getJobIds";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        String[] stringArray = null;
        ArrayList arrayList = (ArrayList)this.jobsBelongingToTokens.get(token);
        if (arrayList != null) {
            JobInfo[] jobInfoArray = arrayList.toArray(new JobInfo[0]);
            stringArray = new String[jobInfoArray.length];
            int n = 0;
            while (n < jobInfoArray.length) {
                stringArray[n] = new String(jobInfoArray[n].getDeviceServerRunNumber());
                ++n;
            }
        } else {
            stringArray = new String[]{};
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return stringArray;
    }

    public void setTokenForProxyThread(Thread thread, Token token) {
        String string = "setTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        this.tokenTable.put(thread, token);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public Token getTokenForProxyThread(Thread thread) {
        String string = "getTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return (Token)this.tokenTable.get(thread);
    }

    public void removeTokenForProxyThread(Thread thread) {
        String string = "getTokenForProxyThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        this.tokenTable.remove(thread);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public long getTokenUpdateInterval() {
        int n;
        long l;
        String string = "getTokenUpdateInterval";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        if ((l = (long)((n = this.getTokenTimeout()) - 60)) <= (long)(n / 2)) {
            l = n / 2;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return l * 1000L;
    }

    private int getTokenTimeout() {
        String string = "getTokenTimeout";
        if (this.tokenTimeout == null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, className, string);
            }
            try {
                IConfigService iConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                String string2 = iConfigService.getProperty("ZoneTokenTimeout", "user");
                if (string2 != null) {
                    this.tokenTimeout = new Integer(Integer.parseInt(string2));
                } else {
                    iConfigService.setProperty("ZoneTokenTimeout", "user", String.valueOf(300));
                    this.tokenTimeout = new Integer(300);
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, string, exception);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                this.tokenTimeout = new Integer(300);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
            }
        }
        return this.tokenTimeout;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token getDBToken(String var1_1, String var2_2, String var3_3, int var4_4) {
        block11: {
            var5_5 = "getDBToken";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, ControlEngine.className, var5_5);
            }
            var6_6 = null;
            if (var4_4 != 1) break block11;
            var7_7 = null;
            try {
                try {
                    var7_7 = ServiceUtils.getConnection();
                    var8_8 = new Hashtable<ColumnInfo, String>();
                    var8_8.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), var1_1);
                    var8_8.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), var2_2);
                    var9_10 = org.eclipse.aperi.infrastructure.database.objects.Token.retrieve(var7_7, var8_8);
                    if (var9_10 != null) {
                        var6_6 = new Token(var9_10.getResId(), var9_10.getResType(), var9_10.getTokenId(), var3_3, var4_4, var9_10.getUserId(), var9_10.getInitialTstamp().getTime());
                    }
                }
                catch (Exception var8_9) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var5_5, var8_9);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var5_5, var8_9);
                    }
                }
            }
            catch (Throwable var11_11) {
                var10_12 = null;
                if (var7_7 == null) throw var11_11;
                try {
                    var7_7.commit();
                    var7_7.close();
                    throw var11_11;
                }
                catch (Exception var12_14) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var5_5, var12_14);
                    if (this.traceLogger == null) throw var11_11;
                    if (this.traceLogger.isLogging() == false) throw var11_11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var5_5, var12_14);
                }
                throw var11_11;
            }
            {
                var10_13 = null;
                if (var7_7 == null) break block11;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 225->238)] { 
lbl42:
            // 1 sources

            var7_7.commit();
            var7_7.close();
            break block11;
lbl45:
            // 1 sources

            catch (Exception var12_15) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var5_5, var12_15);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var5_5, var12_15);
            }
        }
        if (this.traceLogger == null) return var6_6;
        if (this.traceLogger.isLogging() == false) return var6_6;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, ControlEngine.className, var5_5);
        return var6_6;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token createToken(String var1_1, String var2_2, String var3_3, int var4_4, String var5_5) {
        block20: {
            block21: {
                var6_6 = "createToken";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, ControlEngine.className, var6_6);
                }
                var7_7 = null;
                if (var4_4 != 1) break block21;
                var8_8 = null;
                var9_11 = false;
                var10_12 = -1;
                try {
                    try {
                        var10_12 = AutoIdentifier.getIdentifier(8, 1);
                        var8_8 = ServiceUtils.getConnection();
                        var11_13 = CurrentTime.getTimestamp(var8_8);
                        var12_15 = new org.eclipse.aperi.infrastructure.database.objects.Token();
                        var12_15.setTstamp(var11_13);
                        var12_15.setResId(var1_1);
                        var12_15.setResType(var2_2);
                        var12_15.setTokenId(var10_12);
                        var12_15.setUserId(var5_5);
                        var12_15.setInitialTstamp(var11_13);
                        var12_15.insert(var8_8);
                        var9_11 = true;
                    }
                    catch (Exception var11_14) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var11_14);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var11_14);
                        }
                    }
                }
                catch (Throwable var14_16) {
                    block18: {
                        var13_17 = null;
                        if (var8_8 != null) {
                            try {
                                var8_8.commit();
                                var8_8.close();
                            }
                            catch (Exception var15_19) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var15_19);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block18;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var15_19);
                            }
                        }
                    }
                    if (var9_11) {
                        var7_7 = this.getDBToken(var1_1, var2_2, var3_3, var4_4);
                    }
                    throw var14_16;
                }
                {
                    block19: {
                        var13_18 = null;
                        if (var8_8 != null) {
                            ** try [egrp 2[TRYBLOCK] [3 : 217->230)] { 
lbl49:
                            // 1 sources

                            var8_8.commit();
                            var8_8.close();
                            break block19;
lbl52:
                            // 1 sources

                            catch (Exception var15_20) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var15_20);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var15_20);
                            }
                        }
                    }
                    if (var9_11) {
                        var7_7 = this.getDBToken(var1_1, var2_2, var3_3, var4_4);
                    }
                    break block20;
                }
            }
            try {
                var8_9 = AutoIdentifier.getIdentifier(8, 1);
                var7_7 = new Token(var1_1, var2_2, var8_9, var3_3, var4_4, var5_5);
            }
            catch (Exception var8_10) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var6_6, var8_10);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block20;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var6_6, var8_10);
            }
        }
        if (var7_7 != null) {
            this.validTokens.add(var7_7);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, ControlEngine.className, var6_6);
        }
        return var7_7;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeToken(String var1_1, String var2_2) {
        block10: {
            var3_3 = "removeToken";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, ControlEngine.className, var3_3);
            }
            var4_4 = null;
            try {
                try {
                    var4_4 = ServiceUtils.getConnection();
                    var5_5 = new Hashtable<ColumnInfo, String>();
                    var5_5.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), var1_1);
                    var5_5.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), var2_2);
                    org.eclipse.aperi.infrastructure.database.objects.Token.deletes(var4_4, var5_5);
                }
                catch (Exception var5_6) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var3_3, var5_6);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var3_3, var5_6);
                    }
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                if (var4_4 == null) throw var7_7;
                try {
                    var4_4.commit();
                    var4_4.close();
                    throw var7_7;
                }
                catch (Exception var8_10) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var3_3, var8_10);
                    if (this.traceLogger == null) throw var7_7;
                    if (this.traceLogger.isLogging() == false) throw var7_7;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var3_3, var8_10);
                }
                throw var7_7;
            }
            {
                var6_9 = null;
                if (var4_4 == null) break block10;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 166->179)] { 
lbl38:
            // 1 sources

            var4_4.commit();
            var4_4.close();
            break block10;
lbl41:
            // 1 sources

            catch (Exception var8_11) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var3_3, var8_11);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block10;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var3_3, var8_11);
            }
        }
        if (this.traceLogger == null) return;
        if (this.traceLogger.isLogging() == false) return;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, ControlEngine.className, var3_3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTokenValid(Token var1_1) {
        block12: {
            var2_2 = "isTokenValid";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, ControlEngine.className, var2_2);
            }
            var3_3 = false;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            try {
                try {
                    var6_6 = ServiceUtils.getConnection();
                    var4_4 = CurrentTime.getTimestamp(var6_6);
                    var7_7 = new Hashtable<ColumnInfo, String>();
                    var7_7.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TOKEN_ID"), String.valueOf(var1_1.getTokenId()));
                    var7_7.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), var1_1.getResource());
                    var7_7.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), var1_1.getResourceType());
                    var8_9 = org.eclipse.aperi.infrastructure.database.objects.Token.retrieve(var6_6, var7_7);
                    if (var8_9 != null) {
                        var5_5 = var8_9.getTstamp();
                        var9_10 = var4_4.getTime() + (long)(var4_4.getNanos() / 1000000);
                        if (var9_10 - (var11_11 = var5_5.getTime() + (long)(var5_5.getNanos() / 1000000)) <= (long)(this.getTokenTimeout() * 1000)) {
                            var3_3 = true;
                        }
                    }
                }
                catch (Exception var7_8) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var2_2, var7_8);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var2_2, var7_8);
                    }
                }
            }
            catch (Throwable var14_12) {
                var13_13 = null;
                if (var6_6 == null) throw var14_12;
                try {
                    var6_6.commit();
                    var6_6.close();
                    throw var14_12;
                }
                catch (Exception var15_15) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var2_2, var15_15);
                    if (this.traceLogger == null) throw var14_12;
                    if (this.traceLogger.isLogging() == false) throw var14_12;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var2_2, var15_15);
                }
                throw var14_12;
            }
            {
                var13_14 = null;
                if (var6_6 == null) break block12;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 275->288)] { 
lbl49:
            // 1 sources

            var6_6.commit();
            var6_6.close();
            break block12;
lbl52:
            // 1 sources

            catch (Exception var15_16) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var2_2, var15_16);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block12;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var2_2, var15_16);
            }
        }
        if (this.traceLogger == null) return var3_3;
        if (this.traceLogger.isLogging() == false) return var3_3;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, ControlEngine.className, var2_2);
        return var3_3;
    }

    public void checkToken(Token token) throws InvalidTokenException, JobInProgressException {
        String string = "checkToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
        if (token == null) {
            throw new InvalidTokenException();
        }
        if (!this.validTokens.contains(token)) {
            token.setValid(false);
            throw new InvalidTokenException();
        }
        if (token.getAccessType() == 1) {
            Token token2 = this.getDBToken(token.getResource(), token.getResourceType(), token.getClient(), token.getAccessType());
            if (token2 != null) {
                if (token == null || !token.equals(token2) || !this.isTokenValid(token2)) {
                    token.setValid(false);
                    throw new InvalidTokenException();
                }
            } else {
                token.setValid(false);
                throw new InvalidTokenException();
            }
            String[] stringArray = this.getJobIds(token);
            int n = 0;
            while (n < stringArray.length) {
                if (this.isJobActive(stringArray[n])) {
                    throw new JobInProgressException();
                }
                ++n;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    private TokenHeartbeat startTokenHeartbeat(Token token) {
        String string = "startTokenHeartbeat";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        TokenHeartbeat tokenHeartbeat = null;
        if (token.getAccessType() == 1) {
            if (this.updateTokenTimestamp(token) != 1 && this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "Unable to update Token for SAN " + token.getResource() + " client " + token.getClient());
            }
            long l = this.getTokenUpdateInterval();
            tokenHeartbeat = new TokenHeartbeat(this, token, l);
            tokenHeartbeat.start();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return tokenHeartbeat;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopTokenHeartbeat(TokenHeartbeat tokenHeartbeat) {
        String string;
        block9: {
            string = "stopTokenHeartbeat";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, className, string);
            }
            if (tokenHeartbeat == null) break block9;
            try {
                try {
                    if (tokenHeartbeat != null && !tokenHeartbeat.isDone()) {
                        tokenHeartbeat.shutdown();
                        tokenHeartbeat.join(30000L);
                    }
                }
                catch (Exception exception) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                tokenHeartbeat = null;
                throw throwable;
            }
            {
                Object var4_6 = null;
                tokenHeartbeat = null;
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateTokenTimestamp(Token var1_1) {
        block11: {
            var2_2 = "updateTokenTimestamp";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, ControlEngine.className, var2_2);
            }
            if (var1_1.getAccessType() != 1) {
                return 1;
            }
            var3_3 = null;
            var4_4 = null;
            var5_5 = 0;
            try {
                try {
                    var4_4 = ServiceUtils.getConnection();
                    var3_3 = CurrentTime.getTimestamp(var4_4);
                    var6_6 = new Hashtable<ColumnInfo, String>();
                    var6_6.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TOKEN_ID"), String.valueOf(var1_1.getTokenId()));
                    var6_6.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_ID"), var1_1.getResource());
                    var6_6.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("RES_TYPE"), var1_1.getResourceType());
                    var7_8 = new Hashtable<ColumnInfo, Timestamp>();
                    var7_8.put(org.eclipse.aperi.infrastructure.database.objects.Token.getColumnInfo("TSTAMP"), var3_3);
                    var5_5 = org.eclipse.aperi.infrastructure.database.objects.Token.update(var4_4, var7_8, var6_6);
                }
                catch (Exception var6_7) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var2_2, var6_7);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var2_2, var6_7);
                    }
                }
            }
            catch (Throwable var9_9) {
                var8_10 = null;
                if (var4_4 == null) throw var9_9;
                try {
                    var4_4.commit();
                    var4_4.close();
                    throw var9_9;
                }
                catch (Exception var10_12) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, this, var2_2, var10_12);
                    if (this.traceLogger == null) throw var9_9;
                    if (this.traceLogger.isLogging() == false) throw var9_9;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var2_2, var10_12);
                }
                throw var9_9;
            }
            {
                var8_11 = null;
                if (var4_4 == null) break block11;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 237->250)] { 
lbl47:
            // 1 sources

            var4_4.commit();
            var4_4.close();
            break block11;
lbl50:
            // 1 sources

            catch (Exception var10_13) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, this, var2_2, var10_13);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, ControlEngine.className, var2_2, var10_13);
            }
        }
        if (this.traceLogger == null) return var5_5;
        if (this.traceLogger.isLogging() == false) return var5_5;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, ControlEngine.className, var2_2);
        return var5_5;
    }

    public synchronized void shutdown() {
        String string = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public void removeTokenFromJobs(Token token) {
        this.jobsBelongingToTokens.remove(token);
    }

    public void removeTokenFromValidTokens(Token token) {
        this.validTokens.remove(token);
    }

    public Token getInternalToken() {
        return this.internalToken;
    }
}

