/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class CreateStorageVolumesParameter
extends ConfigurationParameter {
    protected ArrayList storagePools = new ArrayList();
    protected ArrayList storagePoolCIMOPs = new ArrayList();
    protected ArrayList sizes = new ArrayList();
    protected ArrayList volumeNames = new ArrayList();
    protected String cVolumeElementName = "";

    public CreateStorageVolumesParameter(StorageSubsystem storageSubsystem, CIMObjectPath cIMObjectPath) {
        super(storageSubsystem, cIMObjectPath);
    }

    public void addCreateStorageVolumeParameter(StoragePool storagePool, CIMObjectPath cIMObjectPath, long l, String string) {
        boolean bl = true;
        int n = 0;
        int n2 = this.storagePools.size();
        while (n2 > 0) {
            if (storagePool.getInstanceId().compareTo(((StoragePool)this.storagePools.get(--n2)).getInstanceId()) <= 0) {
                n = ++n2;
                bl = false;
                break;
            }
            --n2;
        }
        if (bl) {
            this.storagePools.add(storagePool);
            this.storagePoolCIMOPs.add(cIMObjectPath);
            this.sizes.add(new Long(l));
            this.volumeNames.add(string);
        } else {
            this.storagePools.add(n, storagePool);
            this.storagePoolCIMOPs.add(n, cIMObjectPath);
            this.sizes.add(n, new Long(l));
            this.volumeNames.add(n, string);
        }
    }

    public long[] getSizes() {
        Long[] longArray = new Long[this.sizes.size()];
        longArray = this.sizes.toArray(longArray);
        long[] lArray = new long[longArray.length];
        int n = 0;
        while (n < longArray.length) {
            lArray[n] = longArray[n];
            ++n;
        }
        return lArray;
    }

    public StoragePool[] getStoragePools() {
        StoragePool[] storagePoolArray = new StoragePool[this.storagePools.size()];
        return this.storagePools.toArray(storagePoolArray);
    }

    public CIMObjectPath[] getStoragePoolCIMOPs() {
        CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[this.storagePoolCIMOPs.size()];
        return this.storagePoolCIMOPs.toArray(cIMObjectPathArray);
    }

    public String[] getVolumeNames() {
        String[] stringArray = new String[this.volumeNames.size()];
        return this.volumeNames.toArray(stringArray);
    }

    public String getVolumeElementName() {
        return this.cVolumeElementName;
    }

    public void setVolumeElementName(String string) {
        this.cVolumeElementName = string;
    }

    String prepareToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.prepareToString());
        stringBuffer.append("; Storage Volume Names: {");
        if (this.cVolumeNames != null && this.cVolumeNames.length > 0) {
            int n = 0;
            while (n < this.cVolumeNames.length) {
                stringBuffer.append(this.cVolumeNames[n]);
                if (n < this.cVolumeNames.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        }
        stringBuffer.append("}");
        stringBuffer.append("; Sizes: {");
        stringBuffer.append(OutputHelper.listToCS(this.sizes));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

