/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.disk.SubprofileConstants;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt64;

public class CIMInstanceHelper {
    public static final String SEPARATOR = ",";

    public static final Hashtable changeCIMInstanceToHashtable(CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getAllProperties();
        CIMProperty cIMProperty = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < vector.size()) {
            cIMProperty = (CIMProperty)vector.elementAt(n);
            CIMValue cIMValue = cIMProperty.getValue();
            String string = cIMProperty.getName();
            if (string != null && cIMValue != null) {
                String string2 = cIMValue.toString();
                if ((string2 = string2.replaceAll("\"", "")).length() > 0) {
                    hashtable.put(string.toLowerCase(), string2.startsWith("\t") ? string2.substring(1) : string2);
                }
            }
            ++n;
        }
        return hashtable;
    }

    public static final HashMap changeCIMInstanceToHashMap(CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getAllProperties();
        CIMProperty cIMProperty = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < vector.size()) {
            cIMProperty = (CIMProperty)vector.elementAt(n);
            CIMValue cIMValue = cIMProperty.getValue();
            String string = cIMProperty.getName();
            hashMap.put(string, cIMValue.toString());
            ++n;
        }
        return hashMap;
    }

    public static final Object getCIMProperyValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        return cIMValue.getValue();
    }

    public static final Object getCIMKeyValue(CIMObjectPath cIMObjectPath, String string) {
        CIMProperty cIMProperty = cIMObjectPath.getKey(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        return cIMValue.getValue();
    }

    public static final Object getCIMPropertyValue(CIMArgument[] cIMArgumentArray, String string) {
        int n = 0;
        while (n < cIMArgumentArray.length) {
            CIMArgument cIMArgument = cIMArgumentArray[n];
            if (cIMArgument.getName().equalsIgnoreCase(string)) {
                if (cIMArgument.getValue() == null) {
                    return null;
                }
                if (cIMArgument.getValue().getValue() == null) {
                    return null;
                }
                return cIMArgument.getValue().getValue();
            }
            ++n;
        }
        return null;
    }

    public static final Object getCIMPropertyValue(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            CIMArgument cIMArgument = (CIMArgument)vector.get(n);
            if (cIMArgument.getName().equalsIgnoreCase(string)) {
                if (cIMArgument.getValue() == null) {
                    return null;
                }
                if (cIMArgument.getValue().getValue() == null) {
                    return null;
                }
                return cIMArgument.getValue().getValue();
            }
            ++n;
        }
        return null;
    }

    public static final String convertSubProfile(String string, LogTraceHelper logTraceHelper) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
            List<String> list = Arrays.asList(SubprofileConstants.SHORT_SUBPROFILEKEYS);
            List<String> list2 = Arrays.asList(SubprofileConstants.SUBPROFILEKEYS);
            while (stringTokenizer.hasMoreElements()) {
                string2 = stringTokenizer.nextToken();
                if (list2.contains(string2 = string2.trim())) {
                    stringBuffer.append(list.get(list2.indexOf(string2)) + SEPARATOR);
                    continue;
                }
                if (logTraceHelper == null) continue;
                logTraceHelper.traceWarning("No Mapping found for :" + string2);
            }
        } else if (logTraceHelper != null) {
            logTraceHelper.traceWarning("A NULL subprofile string object was passed to converSubProfile function -- an empty string will be returned, but this may indicate an error.");
        }
        return stringBuffer.toString();
    }

    public static final boolean isSupportedSubprofile(String string, String string2) {
        boolean bl = false;
        if (string2.indexOf(string) >= 0) {
            bl = true;
        }
        return bl;
    }

    public static long getPropertyLongValue(CIMArgument cIMArgument) {
        Object object;
        long l = -1L;
        CIMValue cIMValue = cIMArgument.getValue();
        if (cIMValue != null && (object = cIMValue.getValue()) != null) {
            l = ((UnsignedInt64)object).longValue();
        }
        return l;
    }

    public static Hashtable getAllPropertiesIntoHashTable(CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getAllProperties();
        CIMProperty cIMProperty = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < vector.size()) {
            cIMProperty = (CIMProperty)vector.elementAt(n);
            CIMValue cIMValue = cIMProperty.getValue();
            String string = cIMProperty.getName();
            if (string != null && cIMValue != null) {
                String string2 = cIMValue.toString();
                if ((string2 = string2.replaceAll("\"", "")).length() > 0) {
                    hashtable.put(string.toLowerCase(), string2.startsWith("\t") ? string2.substring(1) : string2);
                }
            }
            ++n;
        }
        return hashtable;
    }
}

