/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.Alertable;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertHistoryNode
extends Alertable {
    protected short productCode;
    protected short objectType;
    protected byte subProduct;
    protected boolean[] productMask;

    public AlertHistoryNode(short s, short s2, byte by, boolean bl) {
        this.setAllowsChildren(bl);
        this.productCode = s;
        this.subProduct = by;
        this.objectType = s2;
        String string = this.allowsChildren ? MessageLog.getMessageNoID("STG1303L") : (this.objectType < 0 ? MessageLog.getMessageNoID("STG0005T") : CreateOrEditDDI.getObjectTypeName(this.objectType));
        this.setUserObject(string);
        AlertManager.register(this.productCode, this.objectType, this.subProduct, this);
    }

    public AlertHistoryNode(short s, String string, byte by, boolean bl) {
        this.setAllowsChildren(bl);
        this.productCode = s;
        this.subProduct = by;
        this.objectType = (short)-1;
        this.setUserObject(MessageLog.getMessageNoID(string));
        AlertManager.register(this.productCode, this.objectType, this.subProduct, this);
    }

    public AlertHistoryNode(short s, short s2, boolean bl) {
        this(s, s2, -1, bl);
    }

    public AlertHistoryNode(short s, String string, boolean bl) {
        this(s, string, -1, bl);
    }

    public AlertHistoryNode(short s) {
        this(s, -1, -1, false);
    }

    public AlertHistoryNode(short s, byte by) {
        this(s, -1, by, false);
    }

    public AlertHistoryNode(short s, short s2) {
        this(s, s2, -1, false);
    }

    public AlertHistoryNode(short s, short s2, byte by) {
        this(s, s2, by, false);
    }

    public AlertHistoryNode(short s, boolean bl) {
        this(s, -1, -1, bl);
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        if (this.allowsChildren) {
            this.selectable = true;
        } else {
            AlertLogDDI alertLogDDI;
            if (this.objectType < 0) {
                alertLogDDI = new AlertLogDDI(this.productCode, this.subProduct, this.productMask);
            } else {
                NameList nameList = new NameList();
                nameList.nlID = -1;
                nameList.nlInfo = this.objectType;
                alertLogDDI = new AlertLogDDI(nameList, this.productCode, this.subProduct, this.productMask);
            }
            ((DataDisplayInfo)alertLogDDI).reDisplay();
        }
    }
}

