/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.Alertable;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AlertableTreeNode
extends Alertable {
    protected int ID;
    public JPopupMenu menu;

    public AlertableTreeNode(int n) {
        this.ID = n;
        if (this.ID > 0) {
            AlertManager.register(this.ID, (Alertable)this);
        }
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.render(defaultTreeCellRenderer, baseTree, bl, bl2, bl3, n, bl4);
        defaultTreeCellRenderer.setFont(BaseTree.plainFont);
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.menu;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.menu = this.getPopupMenu();
        if (this.ID > 0) {
            String string = MessageLog.getMessageNoID("GUI0059L");
            JMenuItem jMenuItem = new JMenuItem(string);
            this.menu.add(jMenuItem);
            jMenuItem.addActionListener(new Listener());
            jMenuItem.setName(string);
        }
        if (mouseEvent != null) {
            this.showPopupMenu(this.menu, mouseEvent);
        }
    }

    protected abstract NameList getNameList();

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            byte by;
            short s;
            Object object;
            NameList nameList = AlertableTreeNode.this.getNameList();
            if (nameList instanceof AlertNameList) {
                object = (AlertNameList)nameList;
                s = ((AlertNameList)object).nlProductID;
                by = ((AlertNameList)object).nlSubProductID;
            } else {
                s = 0;
                by = 0;
            }
            object = new AlertLogDDI(nameList, s, by);
            ((DataDisplayInfo)object).reDisplay();
        }
    }
}

