/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.InbandFabricAgentTreeNode;
import org.eclipse.aperi.gui.admin.OutOfBandAgentDialog;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentTreeNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentTreeLabel
extends BaseTreeNode
implements GuiRequestor,
ActionListener {
    private int currAgent = -1;
    private int agentType = -1;
    JMenuItem addSNMPAgentMenu;

    public AgentTreeLabel(int n) {
        this.agentType = n;
        switch (this.agentType) {
            case 2: {
                this.setUserObject(Util.getString("DATA"));
                break;
            }
            case 6: {
                this.setUserObject(Util.getString("CIMOMS"));
                break;
            }
            case 7: {
                this.setUserObject(Util.getString("OUT_OF_BAND_FABRIC"));
                break;
            }
            case 8: {
                this.setUserObject(Util.getString("INBAND_FABRIC"));
                break;
            }
            default: {
                this.setUserObject("<unknown>");
            }
        }
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            this.getAgents();
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(MessageLog.getMessageNoID("ADG0003L"));
        jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        if (this.agentType == 6) {
            JMenuItem jMenuItem2 = new JMenuItem(Util.getString("CIMOM_CFG_ADD"));
            jMenuItem2.setToolTipText(Util.getString("CIMOM_CFG_ADD_TIP"));
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(AgentTreeLabel.access$0().getFrame(), Util.getString("CIMOM_CFG_ADD_TITLE"), Util.getString("CIMOM_CFG_ADD_TITLE"), 1);
                }
            });
            jPopupMenu.add(jMenuItem2);
        }
        if (this.agentType == 7) {
            this.addSNMPAgentMenu = new JMenuItem(Util.getString("FabricAgent_add"));
            this.addSNMPAgentMenu.addActionListener(this);
            this.addSNMPAgentMenu.setEnabled(this.capabilities.isAperiAdmin());
            jPopupMenu.add(this.addSNMPAgentMenu);
        }
        this.showPopupMenu(jPopupMenu, mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addSNMPAgentMenu) {
            OutOfBandAgentDialog outOfBandAgentDialog = new OutOfBandAgentDialog(guiMain.getFrame(), true);
            outOfBandAgentDialog.setParentNode(this);
            outOfBandAgentDialog.show();
        } else {
            this.getAgents();
        }
    }

    public void refreshAgents() {
        if (this.getChildCount() > 0) {
            this.getAgents();
        }
    }

    private void getAgents() {
        Request request = new Request();
        ServerRequest.guiInfo(request, this.agentType, -2);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        Serializable serializable;
        Object object;
        Object object2;
        this.currAgent = -1;
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo != null && dataDisplayInfo instanceof AgentDDI) {
            this.currAgent = ((AgentTreeNode)dataDisplayInfo.treeNode).computerID;
        }
        DataDisplayInfo dataDisplayInfo2 = DataDisplayInfo.getRoot();
        while (dataDisplayInfo2 != null) {
            object2 = dataDisplayInfo2.getNext();
            if (dataDisplayInfo2 instanceof AgentDDI) {
                dataDisplayInfo2.remove();
            }
            dataDisplayInfo2 = object2;
        }
        this.removeAllChildren();
        object2 = null;
        if (s <= 4) {
            object2 = (NameList)response.responseData;
        }
        while (object2 != null) {
            object = null;
            switch (this.agentType) {
                case 2: {
                    serializable = GuiUtil.getComputer(((NameList)object2).nlID);
                    object = new AgentTreeNode(((GComputer)serializable).gcTSName, ((NameList)object2).nlID, ((NameList)object2).nlState);
                    break;
                }
                case 7: {
                    object = new OutOfBandFabricAgentTreeNode((Object)((NameList)object2).nlName, ((NameList)object2).nlName2, ((NameList)object2).nlState);
                    break;
                }
                case 8: {
                    object = new InbandFabricAgentTreeNode(((NameList)object2).nlName, ((NameList)object2).nlID, ((NameList)object2).nlState);
                }
            }
            this.addSorted((BaseTreeNode)object);
            object2 = ((NameList)object2).nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        if (this.currAgent > -1) {
            object = this.children();
            while (object.hasMoreElements()) {
                serializable = (AgentTreeNode)object.nextElement();
                if (((AgentTreeNode)serializable).computerID != this.currAgent) continue;
                ((AgentTreeNode)serializable).select(null);
                break;
            }
        }
    }

    static /* synthetic */ IGuiMain access$0() {
        return BaseTreeNode.guiMain;
    }
}

