/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.config.service.ServiceConfigTab;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataServerSection
extends ConfigSection
implements ActionListener {
    private MegaTable table = null;
    private DataServerTableModel tableModel = null;
    private ServerStatusResp status = null;
    private ServerStatusResp.Service service = null;
    private JButton link2detail = null;
    private ArrayList datasvrNodePath = null;

    public DataServerSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        Class<?> clazz;
        Class<?> clazz2;
        this.datasvrNodePath = new ArrayList();
        try {
            clazz2 = Class.forName("org.eclipse.aperi.gui.admin.AdminTreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.datasvrNodePath.add(clazz2);
        this.datasvrNodePath.add(MessageLog.getMessageNoID("ADG0100L", null));
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.admin.ServicesTreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.datasvrNodePath.add(clazz);
        this.datasvrNodePath.add(new Integer(1));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_DATASERVER_TITLE_EXPANDED");
        if (this.status == null) {
            this.retrieveServerStatus();
        }
        if (this.status != null && !this.isExpanded() && this.service != null) {
            String string2 = GUIEntityUtil.getDisplayText(String.valueOf(GuiUtil.getComputer((int)this.status.computerID).gcTSName) + GuiUtil.getString("COLON") + Integer.toString(this.status.listenerPort));
            String string3 = "";
            if (this.service.state == 3) {
                string3 = Util.getString("TEXT_STATE_UPGRADING", string2);
            } else if (this.service.state == 1) {
                string3 = Util.getString("TEXT_AGENTSTATE_UP", string2);
            } else if (this.service.state == 3) {
                string3 = Util.getString("TEXT_AGENTSTATE_DOWN", string2);
            }
            string = Util.getString("CONFIG_DATASERVER_TITLE_COLLAPSED", string3);
        }
        return string;
    }

    private void retrieveServerStatus() {
        if (GuiClient.serverStatus() <= 4) {
            this.status = GuiClient.serverStatusResp;
            int n = this.status.services.length;
            int n2 = 0;
            while (n2 < n) {
                this.service = this.status.services[n2];
                if (this.service.requestType == "org.eclipse.aperi.server.svp.ServerSvp") break;
                ++n2;
            }
        }
    }

    public void refresh(boolean bl) {
        if (this.table == null) {
            this.setLayout(new BorderLayout());
            this.table = new MegaTable();
            this.add((Component)this.table, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_DATASERVER_BUTTON_DETAILS"));
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            this.link2detail.addActionListener(this);
            jPanel2.add(this.link2detail);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_DATASERVER_NOTE"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
        }
        if (bl || this.tableModel == null) {
            this.retrieveServerStatus();
            if (this.status != null) {
                this.tableModel = new DataServerTableModel(this.status);
            }
            if (this.tableModel != null) {
                Class<?> clazz;
                Class<?> clazz2;
                this.table.setBaseTableModel(this.tableModel);
                try {
                    clazz2 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                this.table.setCellRenderer(clazz2, new NumberRenderer());
                try {
                    clazz = Class.forName("javax.swing.JLabel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                this.table.setCellRenderer(clazz, new LabelRenderer());
                this.table.setSelectionPolicy(0);
                this.table.updateUI();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2detail) {
            new ConfigUtil().selectNode(this.datasvrNodePath);
        }
    }

    public class DataServerTableModel
    extends BaseTableModel {
        public final String[] COL_NAMES = new String[]{GuiUtil.getString("CONFIG_COMMON_TABLE_COL_SERVER"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_PORT"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_STATE"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_TIME"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_DB")};
        private static final int DS_NAME = 0;
        private static final int DS_PORT = 1;
        private static final int DS_STATE = 2;
        private static final int DS_START_TIME = 3;
        private static final int DS_DATABASE = 4;
        private ServerStatusResp status;

        public DataServerTableModel(ServerStatusResp serverStatusResp) {
            this.status = serverStatusResp;
            this.columnNames = this.COL_NAMES;
            this.rowCount = serverStatusResp != null ? 1 : 0;
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                switch (n2) {
                    case 0: {
                        return GUIEntityUtil.getDisplayText(this.status.serverName);
                    }
                    case 1: {
                        return Integer.toString(this.status.listenerPort);
                    }
                    case 2: {
                        if (((DataServerSection)DataServerSection.this).service.state == 3) {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_SERVER_STATUS_UPGRADE"), ServiceConfigTab.ICON_UPGRADE, 10);
                        }
                        if (((DataServerSection)DataServerSection.this).service.state == 1) {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_SERVER_STATUS_UP"), ServiceConfigTab.ICON_UP, 10);
                        }
                        if (((DataServerSection)DataServerSection.this).service.state == 2) {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_SERVER_STATUS_DOWN"), ServiceConfigTab.ICON_DOWN, 10);
                        }
                    }
                    case 3: {
                        return DateFormat.getDateTimeInstance().format(this.status.startTime);
                    }
                    case 4: {
                        return GUIEntityUtil.getDisplayText(this.status.jdbcURL);
                    }
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }
    }
}

