/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSetCharacteristicsStep;
import org.eclipse.aperi.request.Response;

public class CreateVDiskAddMDiskDialog
extends JDialog
implements ActionListener,
TJCTableMouseInterface {
    public static CreateVDiskAddMDiskDialog addMDiskDialog = null;
    private JLabel titleLabel = null;
    private JLabel mdiskGroupLabel = null;
    private JLabel noDataLabel = null;
    private JTextField mdiskGroupTextField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton helpButton = null;
    private JPanel mdiskTablePanel = null;
    private DefaultListModel mdiskListModel = null;
    private static String svcID = null;
    private static GUIMDiskGroup mdGroup = null;
    private DiskDataAccessor diskAccessor;
    private DiskDataController diskController = null;
    private DiskGuiTable mdiskTable = null;
    private mdiskTableModel tableModel = null;
    private boolean dblClick = false;
    private static CreateVDiskSetCharacteristicsStep addDialogparent = null;
    private Hashtable vdiskData = null;
    private Vector tempList = null;
    private static final String[] COL_NAMES = new String[]{Util.getString("DISK_MDISKID_LABEL"), Util.getString("DISK_NAME_LABEL"), Util.getString("DISK_STATUS_LABEL"), Util.getString(Util.getString("DISK_CAPACITY_LABEL_MB"))};
    private static final int MDISK_ID = 0;
    private static final int MDISK_NAME = 1;
    private static final int MDISK_STATUS = 2;
    private static final int MDISK_CAPACITY = 3;
    private HashMap mdiskMap = new HashMap();
    private String[] mdiskIDs = null;
    private String[] mdiskStatus = new String[]{Util.getString("DISK_MDISK_STATUS_ONLINE"), Util.getString("DISK_MDISK_STATUS_OFFLINE"), Util.getString("DISK_MDISK_STATUS_EXCLUDED"), Util.getString("DISK_MDISK_STATUS_DEGRADED")};
    private GUIMDisk md = null;
    private Vector mdisks = new Vector();
    private static boolean getData = false;
    private static boolean progress = false;

    private CreateVDiskAddMDiskDialog(JDialog jDialog, String string, GUIMDiskGroup gUIMDiskGroup) {
        super(jDialog, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), true);
        this.setName(this.getClass().getName());
        this.diskAccessor = DiskDataAccessor.getInstance();
        svcID = string;
        mdGroup = gUIMDiskGroup;
        this.create();
        this.setResizable(false);
        this.helpButton.addActionListener(Help.getDisplayHelpFromSource());
        Help.setHelpID(this.helpButton, DiskConstants.DISK_ADD_MDISK);
        Help.setHelpID(this.getRootPane(), DiskConstants.DISK_ADD_MDISK);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    public static CreateVDiskAddMDiskDialog getAddMDiskDialogInstance(WizardPage wizardPage, String string, GUIMDiskGroup gUIMDiskGroup) {
        if (addMDiskDialog == null) {
            JDialog jDialog = (JDialog)wizardPage.getParent().getParent().getParent().getParent().getParent();
            addDialogparent = (CreateVDiskSetCharacteristicsStep)wizardPage;
            addMDiskDialog = new CreateVDiskAddMDiskDialog(jDialog, string, gUIMDiskGroup);
        } else {
            svcID = string;
            mdGroup = gUIMDiskGroup;
            getData = false;
        }
        return addMDiskDialog;
    }

    public void create() {
        Class<?> clazz;
        this.setTitle(Util.getString("DISK_VDISK_ADDMDISK_LABEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel();
        String string = mdGroup.getDeviceId();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.mdiskGroupLabel = new JLabel(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdiskGroupTextField = new JTextField(string);
        jPanel.add(this.mdiskGroupLabel);
        jPanel.add(this.mdiskGroupTextField);
        this.mdiskGroupTextField.setText(string);
        this.mdiskGroupTextField.setEditable(false);
        this.mdiskGroupTextField.setSize(new Dimension(string.length(), 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        GuiUtil.setAccessibleLabel(this.mdiskGroupLabel, this.mdiskGroupTextField, "", this.mdiskGroupLabel.getText(), this.mdiskGroupLabel.getText());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VDISK_ADDMDISK_MDISKS"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.add(this.titleLabel);
        jPanel2.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        container.add(jPanel2);
        this.mdiskTablePanel = new JPanel();
        this.mdiskTablePanel.setLayout(new BoxLayout(this.mdiskTablePanel, 0));
        this.mdiskTable = new DiskGuiTable();
        this.mdiskTable.setMouseListener(this);
        this.mdiskTable.setColumnHidden(0, true);
        this.mdiskTable.setRowIcon(10, false);
        this.mdiskTablePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        try {
            clazz = Class.forName("java.math.BigDecimal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mdiskTable.setCellRenderer(clazz, TableCellRenderers.number);
        this.mdiskTablePanel.add(this.mdiskTable);
        this.mdiskTablePanel.setPreferredSize(new Dimension(350, 100));
        container.add(this.mdiskTablePanel);
        this.noDataLabel = new JLabel(Util.getString("DISK_NO_DATA_LABEL"));
        this.noDataLabel.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.okButton = new JButton(Util.getString("DISK_OK_BUTTON"));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(Util.getString("DISK_CANCEL_BUTTON"));
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton(Util.getString("DISK_HELP_BUTTON"));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        jPanel3.add(this.helpButton);
        container.add(jPanel3);
    }

    public void invalidate() {
        super.invalidate();
        if (!getData) {
            if (this.mdiskGroupTextField != null) {
                this.mdiskGroupTextField.setText(mdGroup.getDeviceId());
            }
            this.fillData(svcID);
            getData = true;
        }
    }

    private boolean addMDisksToMDiskGroup() {
        int[] nArray = new int[]{};
        if (this.mdiskTable.isVisible()) {
            nArray = this.mdiskTable.getSelectedRows();
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray.length <= 0 || !this.mdiskTable.isVisible()) {
                String string = Util.getString("DISK_VDISK_ADDMDISK_WARNING");
                JOptionPane.showMessageDialog(this, string, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), 1);
                return true;
            }
            ++n;
        }
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < nArray.length) {
            vector.add(this.mdiskTable.getDataSource().getValueAt(nArray[n2], 0));
            ++n2;
        }
        String[] stringArray = vector.toArray(new String[0]);
        this.diskController = DiskDataController.getInstance();
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        progress = true;
        this.diskController.addMisks(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                GuiUtil.triggerJobChange((short)107);
                if (s <= 4) {
                    int n = (Integer)response.responseData;
                    Response response2 = GuiDeviceJob.getJobStatus(n, true);
                    GuiUtil.triggerJobChange((short)107);
                    if (response2 != null) {
                        AsyncResult asyncResult = (AsyncResult)response2.responseData;
                        if (asyncResult != null && asyncResult.getRc() <= 0) {
                            getData = false;
                            CreateVDiskAddMDiskDialog.this.invalidate();
                            String string = Util.getString("DISK_SUBSYSTEMS_SAVE_CONFIRMATION_LABEL");
                            JOptionPane.showMessageDialog(addMDiskDialog, string, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), 1);
                            addDialogparent.invalidateMDGroups();
                        } else {
                            addDialogparent.invalidateMDGroups();
                            String string = Util.getString("DMSG_DISK_ADD_MDISK_FAILED");
                            JOptionPane.showMessageDialog(addMDiskDialog, string, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), 0);
                        }
                        progress = false;
                        CreateVDiskAddMDiskDialog.this.closeDialog();
                    }
                }
            }
        }, mdGroup.getId(), stringArray);
        return true;
    }

    public void closeDialog() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = null;
        if (actionEvent == null) {
            return;
        }
        object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.okButton)) {
            this.addMDisksToMDiskGroup();
        }
        if (object.equals(this.cancelButton)) {
            this.dispose();
            getData = false;
        }
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showDefaultChart(int n) {
    }

    public void selectionChanged(boolean bl) {
        if (!progress) {
            try {
                int cfr_ignored_0 = this.mdiskTable.getSelectedRows()[0];
            }
            catch (NullPointerException nullPointerException) {
                this.okButton.setEnabled(false);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.okButton.setEnabled(false);
                return;
            }
        }
    }

    public void doubleClick(int n, int n2) {
        this.dblClick = true;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    private DefaultListModel addVectorToModel(Vector vector) {
        DefaultListModel defaultListModel = new DefaultListModel();
        if (vector == null) {
            return defaultListModel;
        }
        int n = 0;
        while (n < vector.size()) {
            defaultListModel.add(n, vector.get(n));
            ++n;
        }
        return defaultListModel;
    }

    private void fillData(String string) {
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.mdisks.removeAllElements();
        this.diskAccessor.getUnmanagedMDisksBySVC(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    CreateVDiskAddMDiskDialog.this.mdiskMap = (HashMap)response.responseData;
                    CreateVDiskAddMDiskDialog.this.mdiskIDs = CreateVDiskAddMDiskDialog.this.mdiskMap.keySet().toArray(new String[0]);
                    if (CreateVDiskAddMDiskDialog.this.mdiskMap != null) {
                        Iterator iterator = CreateVDiskAddMDiskDialog.this.mdiskMap.values().iterator();
                        while (iterator.hasNext()) {
                            CreateVDiskAddMDiskDialog.this.md = (GUIMDisk)iterator.next();
                            CreateVDiskAddMDiskDialog.this.mdisks.add(CreateVDiskAddMDiskDialog.this.md.getName());
                        }
                        if (CreateVDiskAddMDiskDialog.this.mdisks.size() <= 0) {
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setVisible(false);
                            CreateVDiskAddMDiskDialog.this.mdiskTablePanel.add(CreateVDiskAddMDiskDialog.this.noDataLabel);
                        } else {
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setVisible(true);
                            CreateVDiskAddMDiskDialog.this.mdiskTablePanel.remove(CreateVDiskAddMDiskDialog.this.noDataLabel);
                            CreateVDiskAddMDiskDialog.this.tableModel = new mdiskTableModel();
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setFrozenColumns(0);
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setBaseTableModel(CreateVDiskAddMDiskDialog.this.tableModel);
                            CreateVDiskAddMDiskDialog.this.mdiskTable.sortByColumn(0, 1);
                            CreateVDiskAddMDiskDialog.this.okButton.setEnabled(true);
                        }
                    }
                }
                CreateVDiskAddMDiskDialog.this.cancelButton.setEnabled(true);
            }
        }, svcID);
    }

    private class mdiskTableModel
    extends BaseTableModel {
        public mdiskTableModel() {
            this.columnNames = COL_NAMES;
            this.rowCount = CreateVDiskAddMDiskDialog.this.mdiskMap.size();
        }

        public Object getTableDataItem(int n, int n2) {
            this.rowCount = CreateVDiskAddMDiskDialog.this.mdiskMap.size();
            if (this.rowCount <= 0) {
                return null;
            }
            GUIMDisk gUIMDisk = (GUIMDisk)CreateVDiskAddMDiskDialog.this.mdiskMap.get(CreateVDiskAddMDiskDialog.this.mdiskIDs[n]);
            switch (n2) {
                case 0: {
                    return gUIMDisk.getId();
                }
                case 1: {
                    return gUIMDisk.getName();
                }
                case 2: {
                    return CreateVDiskAddMDiskDialog.this.mdiskStatus[gUIMDisk.getState()];
                }
                case 3: {
                    long l = new Long(gUIMDisk.getCapacity());
                    l = GUIEntityUtil.convertStorageCapacity(l, 0, 2);
                    return new BigDecimal(l);
                }
            }
            return "";
        }
    }
}

