/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.BaseZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentReviewStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentZoneActionStep;
import org.eclipse.aperi.request.Response;

public class PortAssignmentWizard
extends Wizard {
    private PortAssignmentSelectHostPortsStep hostStep = null;
    private PortAssignmentSelectSubsystemPortsStep portStep = null;
    private PortAssignmentZoneActionStep zoneStep = null;
    private PortAssignmentReviewStep reviewStep = null;
    private String SS_ID = null;
    private String deviceID = null;
    private GUIVolume selectedVolume = null;
    private DiskDataAccessor diskAccessor = null;
    private Vector mapVector = new Vector();
    private JDialog wizardDialog = null;
    private GUIStorageSubsystem subSystem = null;
    private DiskDataController diskController = null;
    private String[] volumeIDs = null;
    private Vector hostportWWPNs = new Vector();
    private String[] hostNames = null;
    private Integer hosttype = new Integer(-1);
    private String hostTypeDesc = new String();
    private Vector ssportWWPNs = new Vector();
    private Vector unhostportWWPNs = new Vector();
    private Vector unssportWWPNs = new Vector();
    private String[] ssportsArray = null;
    private HashMap portData = null;
    private int WIZARD_FLAGS = 31;

    public PortAssignmentWizard(GUIStorageSubsystem gUIStorageSubsystem, GUIVolume gUIVolume) {
        this.subSystem = gUIStorageSubsystem;
        this.SS_ID = this.subSystem.getId();
        this.selectedVolume = gUIVolume;
        this.deviceID = this.subSystem.getDeviceId();
        this.addWizardListener(this);
        this.portData = new HashMap();
        this.hostStep = new PortAssignmentSelectHostPortsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.hostStep);
        if (this.subSystem.isTargetPortRestrictionSupported() && 4 != this.subSystem.getCapabilityData().getPortsPerView() && this.subSystem.getType() != 4) {
            this.portStep = new PortAssignmentSelectSubsystemPortsStep(this.WIZARD_FLAGS, this.subSystem);
            this.add(this.portStep);
        }
        this.zoneStep = new PortAssignmentZoneActionStep(this.WIZARD_FLAGS, this.SS_ID);
        this.add(this.zoneStep);
        this.reviewStep = new PortAssignmentReviewStep(this.WIZARD_FLAGS);
        this.add(this.reviewStep);
    }

    public GUIVolume getSelectedVolume() {
        return this.selectedVolume;
    }

    public PortAssignmentSelectSubsystemPortsStep getSubsystemPortsStep() {
        return this.portStep;
    }

    public PortAssignmentSelectHostPortsStep getHostPortsStep() {
        return this.hostStep;
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void addData(String string, Object object) {
        this.portData.put(string, object);
    }

    public void removeData(String string) {
        this.portData.remove(string);
    }

    public HashMap getData() {
        return this.portData;
    }

    public void nextBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.hostStep) {
            if (this.hostStep.skipSubsystemStep()) {
                wizardEvent.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                wizardEvent.setNewPage(this.reviewStep);
            }
        }
    }

    public void nextComplete(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextComplete());
        if ((WizardPage)wizardEvent.getNewPage() == this.hostStep) {
            this.hostStep.getSSPortsFromSystem();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.portStep) {
            this.portStep.fillData();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.zoneStep) {
            this.zoneStep.fillData();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.reviewStep) {
            this.reviewStep.fillData();
        }
    }

    public void previousBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).previousBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.reviewStep) {
            if (this.hostStep.skipSubsystemStep()) {
                wizardEvent.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                wizardEvent.setNewPage(this.hostStep);
            }
        }
    }

    public void finished(WizardEvent wizardEvent) {
        super.finished(wizardEvent);
        if (((WizardPage)wizardEvent.getCurrentPage()).equals(this.reviewStep)) {
            String string = Util.getString("DISK_PORT_ASSIGNMENT_WIZARD_FINISHED");
            JOptionPane.showMessageDialog(this, string, Util.getString("DISK_HPA_WIZARD_LABEL", this.deviceID), 1);
            this.closeWizard();
            AssignmentThread assignmentThread = new AssignmentThread(this);
            assignmentThread.run();
        }
    }

    public void canceled(WizardEvent wizardEvent) {
        int n = JOptionPane.showConfirmDialog(this, Util.getString("DISK_PORT_ASSIGNMENT_WIZARD_CANCELED"), Util.getString("DISK_HPA_WIZARD_LABEL", this.deviceID), 0);
        switch (n) {
            case 0: {
                super.canceled(wizardEvent);
                this.closeWizard();
                break;
            }
        }
    }

    private void closeWizard() {
        this.wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        this.wizardDialog.dispose();
    }

    private class AssignmentThread
    extends Thread {
        private PortAssignmentWizard wizard;

        public AssignmentThread(PortAssignmentWizard portAssignmentWizard2) {
            this.wizard = portAssignmentWizard2;
        }

        public void run() {
            this.portsAssign();
        }

        public void portsAssign() {
            PortAssignmentWizard.this.wizardDialog = (JDialog)this.wizard.getParent().getParent().getParent().getParent();
            PortAssignmentWizard.this.diskController = DiskDataController.getInstance();
            PortAssignmentWizard.this.volumeIDs = new String[1];
            ((PortAssignmentWizard)PortAssignmentWizard.this).volumeIDs[0] = PortAssignmentWizard.this.selectedVolume.getId();
            Vector vector = (Vector)PortAssignmentWizard.this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_DATA);
            Vector vector2 = (Vector)PortAssignmentWizard.this.portData.get(PortAssignmentSelectSubsystemPortsStep.SUBSYSTEM_DATA);
            PortAssignmentWizard.this.unhostportWWPNs = (Vector)PortAssignmentWizard.this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_UNASSIGNED_DATA);
            PortAssignmentWizard.this.hosttype = (Integer)PortAssignmentWizard.this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_TYPE_DATA);
            PortAssignmentWizard.this.hostTypeDesc = (String)PortAssignmentWizard.this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_TYPE_DESC_DATA);
            if (PortAssignmentWizard.this.hostTypeDesc != null && PortAssignmentWizard.this.hostTypeDesc.length() == 0) {
                PortAssignmentWizard.this.hostTypeDesc = null;
            }
            String string = new String();
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                try {
                    string = ((GUIPort)vector2.get(n)).getWwpn();
                }
                catch (ClassCastException classCastException) {
                    string = (String)vector2.get(n);
                }
                PortAssignmentWizard.this.ssportWWPNs.add(string);
                ++n;
            }
            if (PortAssignmentWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != PortAssignmentWizard.this.subSystem.getCapabilityData().getPortsPerView()) {
                PortAssignmentWizard.this.ssportsArray = PortAssignmentWizard.this.ssportWWPNs.toArray(new String[0]);
            }
            PortAssignmentWizard.this.hostNames = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                PortAssignmentWizard.this.hostportWWPNs.add(((GUIPort)vector.get(n)).getWwpn());
                ((PortAssignmentWizard)PortAssignmentWizard.this).hostNames[n] = ((GUIPort)vector.get(n)).getHostName();
                ++n;
            }
            HashMap hashMap = (HashMap)PortAssignmentWizard.this.portData.get(PortAssignmentZoneActionStep.ZONE_ACTION_DATA);
            if (hashMap != null) {
                Iterator iterator = hashMap.values().iterator();
                new Vector(hashMap.values());
                while (iterator.hasNext()) {
                    int n2;
                    String[] stringArray;
                    Vector vector3;
                    BaseZoneActionStep.ZoneAction zoneAction = (BaseZoneActionStep.ZoneAction)iterator.next();
                    if (zoneAction.action == 0) {
                        zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                        vector3 = zoneAction.hostPorts;
                        stringArray = new String[vector3.size()];
                        n2 = 0;
                        while (n2 < vector3.size()) {
                            stringArray[n2] = ((GUIPort)vector3.get(n2)).getWwpn();
                            ++n2;
                        }
                        PortAssignmentWizard.this.diskController.createZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, stringArray);
                        continue;
                    }
                    if (zoneAction.action != 1) continue;
                    zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                    vector3 = zoneAction.hostPorts;
                    stringArray = new String[vector3.size()];
                    n2 = 0;
                    while (n2 < vector3.size()) {
                        stringArray[n2] = ((GUIPort)vector3.get(n2)).getWwpn();
                        ++n2;
                    }
                    PortAssignmentWizard.this.diskController.updateZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, stringArray);
                }
            }
            if (PortAssignmentWizard.this.unhostportWWPNs.size() > 0) {
                PortAssignmentWizard.this.diskController.unassignPorts(new GuiRequestor(this){
                    final /* synthetic */ AssignmentThread this$1;
                    {
                        this.this$1 = assignmentThread;
                    }

                    public void handleResponse(short s, Response response) {
                        GuiUtil.triggerJobChange((short)107);
                    }
                }, PortAssignmentWizard.this.volumeIDs, PortAssignmentWizard.this.unhostportWWPNs.toArray(new String[0]), false);
            }
            if (PortAssignmentWizard.this.hostportWWPNs.size() > 0) {
                PortAssignmentWizard.this.diskController.assignPorts(new GuiRequestor(this){
                    final /* synthetic */ AssignmentThread this$1;
                    {
                        this.this$1 = assignmentThread;
                    }

                    public void handleResponse(short s, Response response) {
                        GuiUtil.triggerJobChange((short)107);
                    }
                }, PortAssignmentWizard.this.volumeIDs, PortAssignmentWizard.this.ssportsArray, PortAssignmentWizard.this.hostportWWPNs.toArray(new String[0]), PortAssignmentWizard.this.hosttype, PortAssignmentWizard.this.hostTypeDesc, PortAssignmentWizard.this.hostNames, false);
            }
        }
    }

    public class ZoneRequestor
    implements GuiRequestor {
        String fabricID = null;

        public ZoneRequestor(String string) {
            this.fabricID = string;
        }

        public void handleResponse(short s, Response response) {
            GuiUtil.triggerJobChange((short)108);
            if (s <= 4) {
                int n = (Integer)response.responseData;
                new JobResultThread(n, this.fabricID).start();
            }
        }
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected String fabricID = null;

        public JobResultThread(int n) {
            this.jobID = n;
        }

        public JobResultThread(int n, String string) {
            this.jobID = n;
            this.fabricID = string;
        }

        public void run() {
            AsyncResult[] asyncResultArray;
            Response response = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (this.fabricID != null) {
                GuiUtil.triggerJobChange((short)108);
                boolean bl = false;
                if (response != null && (asyncResultArray = (AsyncResult[])response.responseData) != null && (asyncResultArray.getReturnException() != null || asyncResultArray.getRc() > 0)) {
                    bl = true;
                }
                if (bl) {
                    PortAssignmentWizard.this.diskController.rollbackFabricTransaction(new GuiRequestor(this){
                        final /* synthetic */ JobResultThread this$1;
                        {
                            this.this$1 = jobResultThread;
                        }

                        public void handleResponse(short s, Response response) {
                        }
                    }, this.fabricID);
                } else {
                    PortAssignmentWizard.this.diskController.releaseFabric(new GuiRequestor(this){
                        final /* synthetic */ JobResultThread this$1;
                        {
                            this.this$1 = jobResultThread;
                        }

                        public void handleResponse(short s, Response response) {
                        }
                    }, this.fabricID);
                }
            } else {
                GuiUtil.triggerJobChange((short)107);
            }
            if (response != null) {
                AsyncResult asyncResult = (AsyncResult)response.responseData;
                asyncResultArray = asyncResult.getSubJobResults();
                int n = 0;
                while (asyncResultArray != null && n < asyncResultArray.length) {
                    Exception exception = asyncResultArray[n].getReturnException();
                    if (exception != null) {
                        String string = exception.getMessage();
                        if (exception instanceof SRMRuntimeException) {
                            string = ((SRMRuntimeException)exception).getLocalizedMessage();
                        }
                    }
                    if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                        asyncResultArray[n].getResults();
                    }
                    ++n;
                }
            }
        }
    }
}

