/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.gui.fabric.zone.ZoneConfigurationPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneDDI;
import org.eclipse.aperi.gui.fabric.zone.ZoneDefinitionPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneUIAccessor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.util.FabricUtilConverter;
import org.eclipse.aperi.xmsg.IntlMessageFormat;
import org.eclipse.aperi.xmsg.MessageLog;

public class ZoneCNS
extends DataDisplayInfo
implements GuiRequestor {
    protected int zoneTab;
    protected int runNumber;
    private ZoneDDI zoneDDI = null;
    private String sanLabel;
    private String sanWWN;
    private HashMap[] switchZMems = null;
    private HashMap[] deviceSPMap = null;
    private HashMap[] nodeMemMap = null;
    private HashMap[] deviceMemMap = null;
    private HashMap[] portMap = null;
    private ZoneSet origActiveZS = null;
    private ZoneDefinition origZoneDef = new ZoneDefinition();
    private ZoneDefinition zoneDef = new ZoneDefinition();
    ZoneUIAccessor zoneAccessor = ZoneUIAccessor.getInstance();
    private ZoneDefinition activeZoneDef = new ZoneDefinition();
    private ZoneCapabilities zoneCap = new ZoneCapabilities();
    private String ZONE_CLASS = "Zone";
    private String ZONESET_CLASS = "ZoneSet";
    private String ERROR_CONFIG = "ConfigError";
    private HashMap zoneStatusTracker = new HashMap();
    private HashMap zsStatusTracker = new HashMap();
    public static boolean DEBUG = false;
    private boolean returnToDef = false;
    private int extra = 0;
    private boolean showStatusOnZCPanel = true;
    private Capabilities capabilities = guiMain.getCapabilities();
    Token myOldToken;
    Timer refreshTimer;
    TimerTask refreshTask;
    boolean refreshFailed = false;

    public ZoneCNS(ZoneDDI zoneDDI, String string, String string2) {
        this.sanLabel = string;
        this.sanWWN = string2;
        this.zoneDDI = zoneDDI;
    }

    public void populateZoneDefinition() {
        if (this.showStatusOnZCPanel) {
            this.zoneDDI.mainPanel.setStatusText(Util.getString("FabricZoneNotebook_RefreshStatus"), this.sanWWN);
        }
        if (DEBUG) {
            this.populateDebugZoneDefinition(this.origZoneDef, false);
            this.populateDebugZoneDefinition(this.zoneDef, false);
            this.populateDebugZoneDefinition(this.activeZoneDef, true);
        } else {
            this.enableEditButton(false);
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
            request.userName = GuiUtil.getUserName();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(GuiZoneConstants.POPULATE_ZONEDEF, this.sanWWN);
            request.requestData = hashMap;
            request.flags = (byte)4;
            GuiClient.doRequest(this, request);
            this.populateActiveZoneDefinition();
            this.getSwitchZoneMembers();
            this.getDeviceSPZoneMembers();
            this.getNodeZoneMembers();
            this.getDeviceZoneMembers();
            this.getPortZoneMembers();
        }
    }

    private void populateActiveZoneDefinition() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, this.sanWWN);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void getSwitchZoneMembers() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.ZM_SWITCHES, this.sanWWN);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void getDeviceSPZoneMembers() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.ZM_DEVICESP, this.sanWWN);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void getNodeZoneMembers() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.ZM_NODE, this.sanWWN);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void getDeviceZoneMembers() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.ZM_DEVICE, this.sanWWN);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void getPortZoneMembers() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.ZM_PORT, this.sanWWN);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void populateActiveZoneDefPreSave(ZoneDefinitionPanel zoneDefinitionPanel, int n) {
        final ZoneDefinitionPanel zoneDefinitionPanel2 = zoneDefinitionPanel;
        final int n2 = n;
        this.zoneAccessor.populateFabricZoneDefinition(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    ZoneDefinition zoneDefinition = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_FABRICZONEDEF);
                    if (zoneDefinition == null) {
                        ZoneCNS.this.displayZoneDefCheckErrorMessage(hashMap);
                        ZoneCNS.this.returnToDef = true;
                    } else if (!ZoneCNS.this.isSameZoneDef(zoneDefinition)) {
                        int n = JOptionPane.showConfirmDialog(zoneDefinitionPanel2, GuiUtil.getString("FabricZone_ActiveMsg"), GuiUtil.getString("FabricZone_ActiveTitle"), 0);
                        if (n == 1) {
                            ZoneCNS.this.returnToDef = true;
                        } else {
                            ZoneCNS.this.returnToDef = false;
                        }
                    }
                }
                ZoneCNS.this.saveZoneDefPanel(zoneDefinitionPanel2, n2);
            }
        }, this.sanWWN, n, this.myOldToken);
    }

    public void reserveTokenAndCheckDefinition(ZoneConfigurationPanel zoneConfigurationPanel) {
        final ZoneConfigurationPanel zoneConfigurationPanel2 = zoneConfigurationPanel;
        this.zoneAccessor.reserveToken(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        Object object;
                        int n = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String string = "";
                        String string2 = "";
                        switch (n) {
                            case 4: {
                                string = GuiUtil.getString("FabricZone_TokenError");
                                string2 = GuiUtil.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                object = null;
                                Date date = null;
                                if (hashMap.containsKey(GuiZoneConstants.LOCKED_BY_USER)) {
                                    object = (String)hashMap.get(GuiZoneConstants.LOCKED_BY_USER);
                                }
                                date = (Date)hashMap.get(GuiZoneConstants.LOCKED_MOMENT);
                                String string3 = GuiUtil.formatDateTime(date);
                                if (object != null) {
                                    string = GuiUtil.getString("FMSG_FabricZoneNotebook_pingLockedByWarning", (String)object, string3);
                                    string2 = GuiUtil.getString("FMSG_SAVE_LOCKED_BY_ERROR", (String)object, string3);
                                    break;
                                }
                                string = GuiUtil.getString("FabricZoneNotebook_pingLockedWarning");
                                string2 = GuiUtil.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                string = GuiUtil.getString("FabricZoneNotebook_pingNoAgentWarning");
                                string2 = GuiUtil.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                string = GuiUtil.getString("FabricZoneNotebook_ZSCommError");
                                string2 = GuiUtil.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && !string.equals("")) {
                            JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, string2);
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(string, ZoneCNS.this.sanWWN);
                        }
                        if (hashMap.containsKey(GuiZoneConstants.TOKEN)) {
                            object = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                            ZoneCNS.this.startRefreshingToken((Token)object);
                            ZoneCNS.this.checkZoneDefinition(zoneConfigurationPanel2);
                        } else {
                            ZoneCNS.this.reDisplay();
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                }
            }
        }, this.sanWWN);
    }

    private void checkZoneDefinition(ZoneConfigurationPanel zoneConfigurationPanel) {
        final ZoneConfigurationPanel zoneConfigurationPanel2 = zoneConfigurationPanel;
        this.zoneAccessor.populateFabricZoneDefinition(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    ZoneDefinition zoneDefinition = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_FABRICZONEDEF);
                    if (zoneDefinition == null) {
                        ZoneCNS.this.displayZoneDefCheckErrorMessage(hashMap);
                        ZoneCNS.this.cleanBeforeWindowClosing();
                    } else if (!ZoneCNS.this.isSameZoneDef(zoneDefinition)) {
                        int n = JOptionPane.showConfirmDialog(zoneConfigurationPanel2, GuiUtil.getString("FMSG_FabricZone_ActiveMsgZCPanel"), GuiUtil.getString("FabricZone_ActiveMsgTitle"), 0);
                        if (n == 0) {
                            ZoneCNS.this.showZoneDefPanel();
                        } else {
                            ZoneCNS.this.cleanBeforeWindowClosing();
                        }
                    } else {
                        ZoneCNS.this.showZoneDefPanel();
                    }
                }
            }
        }, this.sanWWN, 0, this.myOldToken);
    }

    private boolean isSameZoneDef(ZoneDefinition zoneDefinition) {
        boolean bl = true;
        Zone[] zoneArray = zoneDefinition.getZones();
        int n = 0;
        while (n < zoneArray.length) {
            zoneArray[n].setSubType(new Integer(0).shortValue());
            zoneArray[n].setType(new Integer(0).shortValue());
            ++n;
        }
        zoneArray = this.origZoneDef.getZones();
        n = 0;
        while (n < zoneArray.length) {
            zoneArray[n].setSubType(new Integer(0).shortValue());
            zoneArray[n].setType(new Integer(0).shortValue());
            ++n;
        }
        bl = zoneDefinition.equalsIgnoreDescriptions(this.origZoneDef);
        return bl;
    }

    private void displayZoneDefCheckErrorMessage(HashMap hashMap) {
        int n = 1;
        if (hashMap.containsKey("pingError")) {
            n = (Integer)hashMap.get("pingError");
        }
        String string = "";
        String string2 = "";
        switch (n) {
            case 4: {
                string = GuiUtil.getString("FabricZone_TokenError");
                string2 = GuiUtil.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                break;
            }
            case 3: {
                String string3 = null;
                Date date = null;
                if (hashMap.containsKey(GuiZoneConstants.LOCKED_BY_USER)) {
                    string3 = (String)hashMap.get(GuiZoneConstants.LOCKED_BY_USER);
                }
                date = (Date)hashMap.get(GuiZoneConstants.LOCKED_MOMENT);
                String string4 = GuiUtil.formatDateTime(date);
                if (string3 != null) {
                    string = GuiUtil.getString("FMSG_FabricZoneNotebook_pingLockedByWarning", string3, string4);
                    string2 = GuiUtil.getString("FMSG_SAVE_LOCKED_BY_ERROR", string3, string4);
                    break;
                }
                string = GuiUtil.getString("FabricZoneNotebook_pingLockedWarning");
                string2 = GuiUtil.getString("FMSG_SAVE_LOCKED_ERROR");
                break;
            }
            case 5: {
                string = GuiUtil.getString("FabricZoneNotebook_pingNoAgentWarning");
                string2 = GuiUtil.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                break;
            }
            default: {
                string = GuiUtil.getString("FabricZoneNotebook_pingNoAgentWarning");
                string2 = GuiUtil.getString("FMSG_PING_GENERAL_ERROR");
            }
        }
        if (this.zoneDDI.mainPanel != null) {
            JOptionPane.showMessageDialog(this.zoneDDI.mainPanel, string2);
            this.zoneDDI.mainPanel.setStatusText(string, this.sanWWN);
        }
    }

    public void ping(final boolean bl) {
        this.zoneAccessor.ping(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    ZoneCNS.this.zoneCap = (ZoneCapabilities)hashMap.get("pingZoneAgent");
                    if (ZoneCNS.this.zoneCap == null) {
                        if (hashMap.containsKey("pingError")) {
                            int n = (Integer)hashMap.get("pingError");
                            String string = "";
                            String string2 = "";
                            switch (n) {
                                case 5: {
                                    string = Util.getString("FabricZone_TokenError");
                                    string2 = Util.getString("FMSG_PING_INVALID_TOKEN_ERROR");
                                    break;
                                }
                                case 3: {
                                    string = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                    string2 = Util.getString("FMSG_PING_LOCKED_ERROR");
                                    break;
                                }
                                case 4: {
                                    string = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    string2 = Util.getString("FMSG_PING_NOTAVAILABLE_ERROR");
                                    break;
                                }
                                case 1: {
                                    string = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    string2 = Util.getString("FMSG_PING_GENERAL_ERROR");
                                }
                            }
                            if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                                JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, string2);
                                if (bl) {
                                    ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(string, ZoneCNS.this.sanWWN);
                                }
                            }
                        } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && bl) {
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                        }
                        ZoneCNS.this.zoneCap = new ZoneCapabilities();
                    } else if (bl) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                    ZoneCNS.this.refreshConfigurationPanel();
                }
            }
        }, this.sanWWN);
        if (this.zoneDDI.mainPanel != null && bl) {
            this.zoneDDI.mainPanel.setStatusText(GuiUtil.getString("FabricZoneNotebook_GatheringZoning"), this.sanWWN);
        }
    }

    private void checkForZoningChangesAndSave(Token token, int n, ZoneDefinitionPanel zoneDefinitionPanel) {
        final int n2 = n;
        final ZoneDefinitionPanel zoneDefinitionPanel2 = zoneDefinitionPanel;
        final Token token2 = token;
        this.zoneAccessor.populateFabricZoneDefinition(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                boolean bl = true;
                if (s < 4) {
                    int n;
                    HashMap hashMap = (HashMap)response.responseData;
                    ZoneDefinition zoneDefinition = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_FABRICZONEDEF);
                    if (zoneDefinition == null) {
                        ZoneCNS.this.displayZoneDefCheckErrorMessage(hashMap);
                        bl = false;
                    } else if (!ZoneCNS.this.isSameZoneDef(zoneDefinition) && (n = JOptionPane.showConfirmDialog(zoneDefinitionPanel2, GuiUtil.getString("FabricZone_ActiveMsg"), GuiUtil.getString("FabricZone_ActiveTitle"), 0)) == 1) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                if (bl) {
                    ZoneCNS.this.saveZoneDefinition(token2, n2);
                    zoneDefinitionPanel2.setCloseNow(true);
                    ZoneCNS.this.closeDefTab();
                }
            }
        }, this.sanWWN, n, this.myOldToken);
    }

    private void saveZoneDefinition(Token token, int n) {
        final Token token2 = token;
        this.zoneAccessor.saveZoneDefinition(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    Integer n = (Integer)response.responseData;
                    new JobResultThread(n, token2).start();
                } else {
                    ZoneCNS.this.releaseToken(token2, false);
                }
            }
        }, this.sanWWN, n, this.zoneDef, token);
    }

    public void releaseTokenOnAbort(Token token) {
        this.zoneAccessor.releaseToken(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
            }
        }, this.sanWWN, token);
    }

    private void releaseToken(Token token, boolean bl) {
        if (bl) {
            this.saveZoneDescriptions();
        }
        this.zoneAccessor.releaseToken(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        int n = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String string = "";
                        String string2 = "";
                        switch (n) {
                            case 4: {
                                string = Util.getString("FabricZone_TokenError");
                                string2 = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                string = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                string2 = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                string = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                string2 = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                string = Util.getString("FabricZoneNotebook_ZSCommError");
                                string2 = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && !string.equals("")) {
                            JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, string2);
                            if (ZoneCNS.this.showStatusOnZCPanel) {
                                ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(string, ZoneCNS.this.sanWWN);
                            }
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && ZoneCNS.this.showStatusOnZCPanel) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                    ZoneCNS.this.reDisplay();
                }
                ZoneCNS.this.stopRefreshing();
            }
        }, this.sanWWN, token);
    }

    private void saveZoneDescriptions() {
        this.zoneAccessor.saveDescriptions(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
            }
        }, this.zoneDef, this.sanWWN);
    }

    public void saveZoneDefReserve(int n) {
        final int n2 = n;
        this.enableEditButton(false);
        this.enableRefreshButton(false);
        this.zoneDDI.mainPanel.setStatusText(Util.getString("FabricZoneNotebook_SavingZoningStatus"), this.sanWWN);
        this.zoneAccessor.reserveToken(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        int n = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String string = "";
                        String string2 = "";
                        switch (n) {
                            case 4: {
                                string = Util.getString("FabricZone_TokenError");
                                string2 = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                string = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                string2 = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                string = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                string2 = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                string = Util.getString("FabricZoneNotebook_ZSCommError");
                                string2 = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && !string.equals("")) {
                            JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, string2);
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(string, ZoneCNS.this.sanWWN);
                        }
                        if (hashMap.containsKey(GuiZoneConstants.TOKEN)) {
                            Token token = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                            ZoneCNS.this.saveZoneDefinition(token, n2);
                        } else {
                            ZoneCNS.this.reDisplay();
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                }
            }
        }, this.sanWWN);
    }

    public boolean isUnsupportedChar(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = this.getZoneCapabilities().getZcAgentType() == 0;
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '$' || cArray[n] == '-' || cArray[n] == ' ' || cArray[n] == '%') {
                return true;
            }
            if (bl && cArray[n] == '.') {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNum(char c) {
        return c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '0';
    }

    public void reDisplay() {
        this.enableEditButton(false);
        this.ping(this.showStatusOnZCPanel);
        this.resetZoneDefinition();
        this.refreshConfigurationPanel();
        this.refreshDefinitionPanel();
        this.showStatusOnZCPanel = true;
        this.zoneDDI.show();
    }

    private void closeTab(int n) {
        this.zoneDDI.mainPanel.closeTab(n);
    }

    public void closeDefTab() {
        this.zoneDDI.mainPanel.closeTab(this.getDefTabIndex());
        this.zoneDDI.mainPanel.remove(this.getDefTabIndex());
    }

    public void closeConfigTab() {
        this.zoneDDI.mainPanel.closeTab(this.getConfigTabIndex());
        this.zoneDDI.mainPanel.remove(this.getConfigTabIndex());
    }

    private int getConfigTabIndex() {
        return this.zoneDDI.mainPanel.getConfigTabIndex(this.sanWWN, this.sanLabel);
    }

    private int getDefTabIndex() {
        return this.zoneDDI.mainPanel.getDefTabIndex(this.sanWWN, this.sanLabel);
    }

    public void panelToBeNulled() {
        if (this.runNumber > 0) {
            this.remove();
        }
    }

    public ZoneCapabilities getZoneCapabilities() {
        return this.zoneCap;
    }

    public String getHelpID() {
        return "welcome_gettingstarted";
    }

    public String getSanLabel() {
        return this.sanLabel;
    }

    public String getSanWWN() {
        return this.sanWWN;
    }

    public ZoneDefinition getZoneDefinition(boolean bl) {
        if (bl) {
            return this.activeZoneDef;
        }
        return this.zoneDef;
    }

    private void clearZoneDefErrors() {
        this.zoneStatusTracker = new HashMap();
        this.zsStatusTracker = new HashMap();
    }

    public void resetZoneDefinition() {
        this.clearZoneDefErrors();
        this.switchZMems = null;
        this.deviceSPMap = null;
        this.nodeMemMap = null;
        this.deviceMemMap = null;
        this.portMap = null;
        this.origActiveZS = null;
        this.origZoneDef = new ZoneDefinition();
        this.zoneDef = new ZoneDefinition();
        this.activeZoneDef = new ZoneDefinition();
        this.zoneCap = new ZoneCapabilities();
        this.returnToDef = false;
        this.populateZoneDefinition();
    }

    public ZoneDefinition getOriginalZoneDefinition() {
        return this.origZoneDef;
    }

    public ZoneSet getOriginalActivatedZoneSet() {
        return this.origActiveZS;
    }

    public boolean isOriginalActiveZoneSet(ZoneSet zoneSet) {
        return this.origActiveZS != null && this.origActiveZS.getName().equals(zoneSet.getName());
    }

    public void setOriginalActivatedZoneSet(ZoneSet zoneSet) {
        this.origActiveZS = zoneSet;
    }

    public boolean isNodeZoneAsset() {
        return this.zoneCap.isSupportsNodeWWN();
    }

    public boolean isZoneSetActive(ZoneSet zoneSet) {
        ZoneSet zoneSet2 = this.zoneDef.getActiveZoneSet();
        if (zoneSet2 == null) {
            return false;
        }
        return zoneSet2.getName().equals(zoneSet.getName());
    }

    public int getStringLength() {
        return this.zoneCap.getMaxNameLength();
    }

    public void showZoneDefPanel() {
        this.zoneDDI.mainPanel.addZoneDefTab(this.sanWWN);
    }

    private void populateDebugZoneDefinition(ZoneDefinition zoneDefinition, boolean bl) {
        int n = 20;
        ZoneSet zoneSet = null;
        ++this.extra;
        int n2 = 0;
        while (n2 < n) {
            zoneSet = new ZoneSet("ZS name " + n2, "ZS Description " + this.extra + n2);
            if (n2 == 1) {
                zoneDefinition.addZoneSet(zoneSet);
                zoneDefinition.activateZoneSet(zoneSet);
            } else if (!bl) {
                zoneDefinition.addZoneSet(zoneSet);
            }
            int n3 = 0;
            while (n3 < n) {
                Zone zone = new Zone("zone " + n3, "description " + this.extra + n3);
                if (!bl) {
                    zoneDefinition.addZone(zoneSet, zone);
                } else if (n2 == 1) {
                    zoneDefinition.addZone(zoneSet, zone);
                }
                int n4 = 0;
                while (n4 < n) {
                    short s = 1;
                    ZoneMember zoneMember = new ZoneMember(s, "zmID " + n4);
                    if (!bl) {
                        zoneDefinition.addMember(zone, zoneMember);
                    } else if (n2 == 1) {
                        zoneDefinition.addMember(zone, zoneMember);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public boolean hasZoneError(String string) {
        return this.zoneStatusTracker.containsKey(String.valueOf(this.getZoneIdentifier()) + string);
    }

    public void addZoneConfigError(String string) {
        this.zoneStatusTracker.put(String.valueOf(this.getZoneIdentifier()) + string, this.ERROR_CONFIG);
    }

    public boolean removeZoneConfigError(String string) {
        if (this.zoneStatusTracker.containsKey(String.valueOf(this.getZoneIdentifier()) + string)) {
            this.zoneStatusTracker.remove(String.valueOf(this.getZoneIdentifier()) + string);
            return true;
        }
        return false;
    }

    public boolean hasAnyZoneError() {
        return this.zoneStatusTracker.size() > 0;
    }

    public boolean hasAnyZoneSetError() {
        return this.zsStatusTracker.size() > 0;
    }

    public void addZoneSetConfigError(String string) {
        this.zsStatusTracker.put(String.valueOf(this.getZoneSetIdentifier()) + string, this.ERROR_CONFIG);
    }

    public boolean hasZoneSetError(String string) {
        return this.zsStatusTracker.containsKey(String.valueOf(this.getZoneSetIdentifier()) + string);
    }

    public boolean removeZoneSetConfigError(String string) {
        if (this.zsStatusTracker.containsKey(String.valueOf(this.getZoneSetIdentifier()) + string)) {
            this.zsStatusTracker.remove(String.valueOf(this.getZoneSetIdentifier()) + string);
            return true;
        }
        return false;
    }

    public Vector checkForOrphanZones() {
        Vector<Zone> vector = new Vector<Zone>();
        Zone[] zoneArray = this.zoneDef.getZones();
        if (zoneArray != null) {
            int n = 0;
            while (n < zoneArray.length) {
                ZoneSet[] zoneSetArray = this.zoneDef.getZoneSets(zoneArray[n]);
                if (zoneSetArray == null || zoneSetArray.length == 0) {
                    vector.add(zoneArray[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    public String getZoneIdentifier() {
        return this.ZONE_CLASS;
    }

    public String getZoneSetIdentifier() {
        return this.ZONESET_CLASS;
    }

    public void deleteZoneSets(ZoneSet[] zoneSetArray) {
        this.zoneDef.deleteZoneSets(zoneSetArray);
    }

    public void deleteZoneSet(ZoneSet zoneSet) {
        this.zoneDef.deleteZoneSet(zoneSet);
    }

    public ZoneSet[] deleteZones(Zone[] zoneArray) {
        return this.zoneDef.deleteZonesAndReturnDeletedZoneSets(zoneArray);
    }

    public ZoneSet[] deleteZones(Zone zone) {
        return this.zoneDef.deleteZoneAndReturnDeletedZoneSets(zone);
    }

    public void deleteZone(Zone zone) {
        this.zoneDef.deleteZone(zone);
    }

    public void activateZoneSet(ZoneSet zoneSet) {
        this.zoneDef.activateZoneSet(zoneSet);
    }

    public String getActiveZoneSetLabel() {
        String string = null;
        ZoneSet zoneSet = this.activeZoneDef.getActiveZoneSet();
        if (zoneSet != null) {
            string = zoneSet.getName();
        }
        return string;
    }

    public void deactivateZoneSet(ZoneSet zoneSet) {
        this.zoneDef.deactivateZoneSet(zoneSet);
    }

    public void addZoneMember(ZoneMember zoneMember, Zone zone) {
        this.zoneDef.addMember(zone, zoneMember);
    }

    public void addZoneAlias(ZoneAlias zoneAlias, Zone zone) {
        this.zoneDef.addAlias(zone, zoneAlias);
    }

    public void addZone(Zone zone, ZoneSet zoneSet) {
        this.zoneDef.addZone(zoneSet, zone);
    }

    public void addZoneSets(ZoneSet[] zoneSetArray) {
        this.zoneDef.addZoneSets(zoneSetArray);
    }

    public void addZoneSet(ZoneSet zoneSet) {
        this.zoneDef.addZoneSet(zoneSet);
    }

    public void addZone(Zone zone) {
        this.zoneDef.addZone(zone);
    }

    public ZoneSet[] getZoneSets() {
        return this.zoneDef.getZoneSets();
    }

    public ZoneSet[] getZoneSets(Zone zone) {
        return this.zoneDef.getZoneSets(zone);
    }

    public ZoneSet getZoneSet(String string) {
        return this.zoneDef.getZoneSet(string);
    }

    public Zone[] getAllZones() {
        return this.zoneDef.getZones();
    }

    public ZoneAlias[] getAllZoneAliases() {
        return this.zoneDef.getAliases();
    }

    public Zone getZone(String string) {
        return this.zoneDef.getZone(string);
    }

    public Zone[] getZones(ZoneSet zoneSet) {
        return this.zoneDef.getZones(zoneSet);
    }

    public ZoneMember[] getZoneMembers(Zone zone) {
        return this.zoneDef.getMembers(zone);
    }

    public ZoneMember[] getAllMembers() {
        return this.zoneDef.getMembers();
    }

    public ZoneAlias[] getZoneAliases(Zone zone) {
        return this.zoneDef.getAliases(zone);
    }

    public boolean containsZoneSet(String string) {
        ZoneSet zoneSet = this.zoneDef.getZoneSet(string);
        return zoneSet != null;
    }

    public boolean containsZone(String string) {
        Zone zone = this.zoneDef.getZone(string);
        return zone != null;
    }

    public HashMap[] getPortZMHash() {
        return this.portMap;
    }

    public HashMap[] getSwitchZMHash() {
        return this.switchZMems;
    }

    public HashMap[] getNodeZMHash() {
        return this.nodeMemMap;
    }

    public HashMap[] getDeviceZMHash() {
        return this.deviceMemMap;
    }

    public HashMap[] getDeviceSPZMHash() {
        return this.deviceSPMap;
    }

    public void refreshConfigurationPanel() {
        this.zoneDDI.mainPanel.refreshConfigurationPanel(this.sanWWN);
    }

    public void refreshDefinitionPanel() {
        this.zoneDDI.mainPanel.refreshDefinitionPanel(this.sanWWN);
    }

    public boolean isDefinitionPanelOpened() {
        return this.zoneDDI.mainPanel.isDefinitionPanelOpened(this.sanWWN);
    }

    public void bringDefinitionPanelToFront() {
        this.zoneDDI.mainPanel.bringDefinitionPanelToFront(this.sanWWN);
    }

    private void enableEditButton(boolean bl) {
        if (this.capabilities.isFabricAdmin()) {
            this.zoneDDI.mainPanel.enableEditButton(bl, this.sanWWN);
        } else {
            this.zoneDDI.mainPanel.enableEditButton(false, this.sanWWN);
        }
    }

    private void enableRefreshButton(boolean bl) {
        this.zoneDDI.mainPanel.enableRefreshButton(bl, this.sanWWN);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            HashMap hashMap = (HashMap)response.responseData;
            if (hashMap != null && hashMap.containsKey(GuiZoneConstants.POPULATE_ACTIVEZONEDEF)) {
                this.activeZoneDef = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_ACTIVEZONEDEF);
                this.refreshConfigurationPanel();
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.POPULATE_ZONEDEF)) {
                this.origZoneDef = (ZoneDefinition)((ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_ZONEDEF)).clone();
                this.origActiveZS = this.origZoneDef.getActiveZoneSet();
                this.zoneDef = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_ZONEDEF);
                this.refreshDefinitionPanel();
                String[] stringArray = (String[])hashMap.get(GuiZoneConstants.NONSTD_ZONES);
                if (stringArray != null && stringArray.length > 0) {
                    String string = stringArray[0];
                    int n = 1;
                    while (n < stringArray.length) {
                        string = String.valueOf(string) + ", " + stringArray[n];
                        ++n;
                    }
                    String string2 = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZoneNotebook_NonStandardMembers"), new Object[]{this.sanWWN, new Integer(stringArray.length), string});
                    JOptionPane.showMessageDialog(this.zoneDDI.mainPanel, string2);
                } else {
                    this.enableEditButton(true);
                    this.enableRefreshButton(true);
                }
                this.refreshConfigurationPanel();
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_PORT)) {
                this.portMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_PORT);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_DEVICE)) {
                this.deviceMemMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_DEVICE);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_DEVICESP)) {
                this.deviceSPMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_DEVICESP);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_NODE)) {
                this.nodeMemMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_NODE);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_SWITCHES)) {
                this.switchZMems = (HashMap[])hashMap.get(GuiZoneConstants.ZM_SWITCHES);
            }
        }
    }

    private void saveZoneDefPanel(ZoneDefinitionPanel zoneDefinitionPanel, int n) {
        if (!this.returnToDef) {
            this.saveZoneDefReserve(n);
            zoneDefinitionPanel.setCloseNow(true);
            this.closeDefTab();
        }
    }

    public void saveZoneDef(ZoneDefinitionPanel zoneDefinitionPanel, int n) {
        if (this.refreshFailed) {
            this.stopRefreshing();
            this.showLockLostMessageAndContinue(zoneDefinitionPanel, n);
        } else {
            this.checkTokenAndSave(zoneDefinitionPanel, n);
        }
    }

    private void showLockLostMessageAndContinue(ZoneDefinitionPanel zoneDefinitionPanel, int n) {
        int n2 = JOptionPane.showConfirmDialog(zoneDefinitionPanel, GuiUtil.getString("FMSG_FabricZone_lockLost"), GuiUtil.getString("FabricZone_ActiveTitle"), 0);
        if (n2 != 1) {
            this.populateActiveZoneDefPreSave(zoneDefinitionPanel, n);
        }
    }

    private void checkTokenAndSave(ZoneDefinitionPanel zoneDefinitionPanel, int n) {
        final ZoneDefinitionPanel zoneDefinitionPanel2 = zoneDefinitionPanel;
        final int n2 = n;
        this.zoneAccessor.refreshToken(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey("refresh_token_status")) {
                        int n = (Integer)hashMap.get("refresh_token_status");
                        switch (n) {
                            case 2: {
                                System.out.println("refreshed error");
                                ZoneCNS.this.refreshFailed = true;
                                break;
                            }
                            case 1: {
                                System.out.println("refreshed success");
                                ZoneCNS.this.refreshFailed = false;
                            }
                        }
                    } else {
                        ZoneCNS.this.refreshFailed = true;
                    }
                    if (!ZoneCNS.this.refreshFailed) {
                        ZoneCNS.this.enableEditButton(false);
                        ZoneCNS.this.enableRefreshButton(false);
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(GuiUtil.getString("FabricZoneNotebook_SavingZoningStatus"), ZoneCNS.this.sanWWN);
                        if (ZoneCNS.this.getZoneCapabilities().getZcAgentType() != 0) {
                            ZoneCNS.this.checkForZoningChangesAndSave(ZoneCNS.this.myOldToken, n2, zoneDefinitionPanel2);
                        } else {
                            ZoneCNS.this.saveZoneDefinition(ZoneCNS.this.myOldToken, n2);
                            zoneDefinitionPanel2.setCloseNow(true);
                            ZoneCNS.this.closeDefTab();
                        }
                    } else {
                        ZoneCNS.this.stopRefreshing();
                        ZoneCNS.this.showLockLostMessageAndContinue(zoneDefinitionPanel2, n2);
                    }
                }
            }
        }, this.myOldToken);
    }

    private void refreshToken() {
        this.zoneAccessor.refreshToken(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey("refresh_token_status")) {
                        int n = (Integer)hashMap.get("refresh_token_status");
                        switch (n) {
                            case 2: {
                                ZoneCNS.this.refreshFailed = true;
                                break;
                            }
                            case 1: {
                                ZoneCNS.this.refreshFailed = false;
                            }
                        }
                    } else {
                        ZoneCNS.this.refreshFailed = true;
                    }
                }
            }
        }, this.myOldToken);
    }

    private TimerTask getRefreshTaskInstance() {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                if (ZoneCNS.this.refreshFailed) {
                    ZoneCNS.this.refreshTimer.cancel();
                } else {
                    ZoneCNS.this.refreshToken();
                }
            }
        };
        return timerTask;
    }

    public void stopRefreshing() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
        this.refreshTask = null;
        this.myOldToken = null;
    }

    private void startRefreshingToken(Token token) {
        this.myOldToken = token;
        long l = this.myOldToken.getUpdateInterval();
        this.refreshTimer = new Timer();
        this.refreshTask = this.getRefreshTaskInstance();
        this.refreshFailed = false;
        this.refreshTimer.schedule(this.getRefreshTaskInstance(), l, l);
    }

    public void cleanBeforeWindowClosing() {
        if (this.myOldToken != null) {
            this.releaseTokenOnAbort(this.myOldToken);
        }
        this.stopRefreshing();
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        Token token = null;

        public JobResultThread(int n, Token token) {
            this.jobID = n;
            this.token = token;
        }

        public void run() {
            Response response = GuiDeviceJob.getJobStatus(this.jobID, true, 32);
            if (response != null) {
                AsyncResult asyncResult = (AsyncResult)response.responseData;
                int n = asyncResult.getRc();
                if (n != 0) {
                    String string = FabricUtilConverter.getZCCmdFailureErrMsgID(FabricUtilConverter.getZCCmdFailureCode(n));
                    String string2 = FabricUtilConverter.getZCFabricErrMsgID(FabricUtilConverter.getZCFabricErrCode(n));
                    String string3 = MessageLog.getMessageNoID(string);
                    String string4 = MessageLog.getMessageNoID(string2);
                    String string5 = "<html>" + string3 + "<br>" + string4 + "</HTML>";
                    if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(string5, ZoneCNS.this.sanWWN);
                    }
                    ZoneCNS.this.showStatusOnZCPanel = false;
                    ZoneCNS.this.releaseToken(this.token, false);
                } else {
                    ZoneCNS.this.releaseToken(this.token, true);
                }
            } else {
                ZoneCNS.this.releaseToken(this.token, false);
            }
        }
    }
}

