/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;

public class GraphModel
implements Serializable {
    private static final long serialVersionUID = 3237592814742749472L;
    protected ID modelID;
    protected Hashtable store;
    protected boolean isWithPerfData;
    protected boolean isWithZoneData;
    protected Hashtable groupByCapabilitiesH;

    public GraphModel(ID iD) {
        this.modelID = iD;
        this.store = new Hashtable();
        this.groupByCapabilitiesH = new Hashtable();
        this.initGroupByCapabilities();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GraphModel(");
        stringBuffer.append("modelID=" + this.modelID);
        stringBuffer.append(", isWithPerfData=" + this.isWithPerfData + ", isWithZoneData=" + this.isWithZoneData);
        Vector<GraphEntity.Type> vector = new Vector<GraphEntity.Type>();
        Enumeration enumeration = this.store.keys();
        while (enumeration.hasMoreElements()) {
            GraphEntity.Type type = (GraphEntity.Type)enumeration.nextElement();
            vector.add(type);
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((GraphEntity.Type)object).getType().toString();
                String string2 = ((GraphEntity.Type)object2).getType().toString();
                return string.compareTo(string2);
            }

            public boolean equals(Object object) {
                return this.equals(object);
            }
        });
        int n = 0;
        while (n < vector.size()) {
            GraphEntity.Type type = (GraphEntity.Type)vector.elementAt(n);
            stringBuffer.append("\r\n  " + type + ":");
            Hashtable hashtable = (Hashtable)this.store.get(type);
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                Object v = enumeration2.nextElement();
                stringBuffer.append("\r\n    " + v);
            }
            ++n;
        }
        stringBuffer.append("\r\n)");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof GraphModel)) {
            return false;
        }
        GraphModel graphModel = (GraphModel)object;
        if (!this.modelID.equals(graphModel.getModelID())) {
            return false;
        }
        return this.store.equals(graphModel.store);
    }

    public int hashCode() {
        return this.modelID.hashCode();
    }

    public int compareTo(Object object) {
        ID iD = this.getModelID();
        ID iD2 = ((GraphModel)object).getModelID();
        return iD.compareTo(iD2);
    }

    public ID getModelID() {
        return this.modelID;
    }

    public void setModelID(ID iD) {
        this.modelID = iD;
    }

    public GraphEntity get(GraphEntity.ID iD) {
        if (iD == null) {
            return null;
        }
        GraphEntity.Type type = iD.getType();
        Hashtable hashtable = (Hashtable)this.store.get(type);
        GraphEntity graphEntity = null;
        if (hashtable != null) {
            graphEntity = (GraphEntity)hashtable.get(iD);
        }
        return graphEntity;
    }

    public Enumeration enumerate(GraphEntity.Type type) {
        Hashtable hashtable = (Hashtable)this.store.get(type);
        return hashtable == null ? new Vector().elements() : hashtable.elements();
    }

    public Enumeration enumerateID(GraphEntity.Type type) {
        Hashtable hashtable = (Hashtable)this.store.get(type);
        return hashtable == null ? new Vector().elements() : hashtable.keys();
    }

    public Enumeration associator(GraphEntity.Type type, GraphEntity.ID iD) {
        Vector<GraphEntity> vector = new Vector<GraphEntity>();
        if (type.isAssociation()) {
            Enumeration enumeration = this.enumerate(type);
            while (enumeration.hasMoreElements()) {
                GraphEntity graphEntity;
                GraphAssociation graphAssociation = (GraphAssociation)enumeration.nextElement();
                GraphEntity.ID iD2 = graphAssociation.getFromID();
                GraphEntity.ID iD3 = graphAssociation.getToID();
                if (iD2 != null && iD2.equals(iD) && (graphEntity = this.get(iD3)) != null) {
                    vector.add(graphEntity);
                }
                if (iD3 == null || !iD3.equals(iD) || (graphEntity = this.get(iD2)) == null) continue;
                vector.add(graphEntity);
            }
        }
        return vector.elements();
    }

    public Enumeration associatorID(GraphEntity.Type type, GraphEntity.ID iD) {
        Vector<GraphEntity.ID> vector = new Vector<GraphEntity.ID>();
        if (type.isAssociation()) {
            Enumeration enumeration = this.enumerate(type);
            while (enumeration.hasMoreElements()) {
                GraphAssociation graphAssociation = (GraphAssociation)enumeration.nextElement();
                GraphEntity.ID iD2 = graphAssociation.getFromID();
                GraphEntity.ID iD3 = graphAssociation.getToID();
                if (iD2 != null && iD2.equals(iD)) {
                    vector.add(iD3);
                }
                if (iD3 == null || !iD3.equals(iD)) continue;
                vector.add(iD2);
            }
        }
        return vector.elements();
    }

    public Enumeration reference(GraphEntity.Type type, GraphEntity.ID iD) {
        Vector<GraphAssociation> vector = new Vector<GraphAssociation>();
        if (type.isAssociation()) {
            Enumeration enumeration = this.enumerate(type);
            while (enumeration.hasMoreElements()) {
                GraphAssociation graphAssociation = (GraphAssociation)enumeration.nextElement();
                GraphEntity.ID iD2 = graphAssociation.getFromID();
                GraphEntity.ID iD3 = graphAssociation.getToID();
                if (iD2 != null && iD2.equals(iD)) {
                    vector.add(graphAssociation);
                }
                if (iD3 == null || !iD3.equals(iD)) continue;
                vector.add(graphAssociation);
            }
        }
        return vector.elements();
    }

    public Enumeration referenceID(GraphEntity.Type type, GraphEntity.ID iD) {
        Vector<GraphEntity.ID> vector = new Vector<GraphEntity.ID>();
        if (type.isAssociation()) {
            Enumeration enumeration = this.enumerateID(type);
            Hashtable hashtable = (Hashtable)this.store.get(type);
            while (enumeration.hasMoreElements()) {
                GraphEntity.ID iD2 = (GraphEntity.ID)enumeration.nextElement();
                GraphAssociation graphAssociation = (GraphAssociation)hashtable.get(iD2);
                GraphEntity.ID iD3 = graphAssociation.getFromID();
                GraphEntity.ID iD4 = graphAssociation.getToID();
                if (iD3 != null && iD3.equals(iD)) {
                    vector.add(iD2);
                }
                if (iD4 == null || !iD4.equals(iD)) continue;
                vector.add(iD2);
            }
        }
        return vector.elements();
    }

    public Enumeration enumerateType() {
        return this.store.keys();
    }

    public void put(GraphEntity graphEntity) {
        GraphEntity.ID iD = graphEntity.getEntityID();
        GraphEntity.Type type = iD.getType();
        Hashtable<GraphEntity.ID, GraphEntity> hashtable = (Hashtable<GraphEntity.ID, GraphEntity>)this.store.get(type);
        if (hashtable == null) {
            hashtable = new Hashtable<GraphEntity.ID, GraphEntity>();
            this.store.put(type, hashtable);
        }
        hashtable.put(iD, graphEntity);
    }

    public GraphEntity remove(GraphEntity.ID iD) {
        GraphEntity.Type type = iD.getType();
        Hashtable hashtable = (Hashtable)this.store.get(type);
        GraphEntity graphEntity = null;
        if (hashtable != null) {
            graphEntity = (GraphEntity)hashtable.remove(iD);
        }
        return graphEntity;
    }

    public Vector removeAll(GraphEntity.Type type) {
        Hashtable hashtable = (Hashtable)this.store.get(type);
        if (hashtable != null) {
            Vector vector = new Vector(hashtable.values());
            hashtable.clear();
            this.store.remove(type);
            return vector;
        }
        return new Vector();
    }

    public void clear() {
        this.store = new Hashtable();
        this.isWithPerfData = false;
        this.isWithZoneData = true;
    }

    public int size(GraphEntity.Type type) {
        Hashtable hashtable = (Hashtable)this.store.get(type);
        return hashtable == null ? 0 : hashtable.size();
    }

    public boolean isEmpty() {
        boolean bl = true;
        Enumeration enumeration = this.store.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            if (hashtable.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isWithPerfData() {
        return this.isWithPerfData;
    }

    public void setWithPerfData(boolean bl) {
        this.isWithPerfData = bl;
    }

    public boolean isWithZoneData() {
        return this.isWithZoneData;
    }

    public void setWithZoneData(boolean bl) {
        this.isWithZoneData = bl;
    }

    public void applyCollationKey() {
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        Enumeration enumeration = this.store.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                GraphEntity graphEntity = (GraphEntity)enumeration2.nextElement();
                String string = graphEntity.getDisplayName();
                if (string == null) continue;
                CollationKey collationKey = ruleBasedCollator.getCollationKey(string);
                graphEntity.setCollationKey(collationKey);
            }
        }
    }

    public void applyScope() {
    }

    public void applyPerfStatus() {
    }

    public void applyGrouping(Hashtable hashtable) {
    }

    public void applyFiltering(int n) {
    }

    protected void initGroupByCapabilities() {
    }

    public Integer getGroupByCapabilities(GraphScopedType graphScopedType) {
        return (Integer)this.groupByCapabilitiesH.get(graphScopedType);
    }

    public static class ID
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 2678167914799232634L;
        protected Object id;
        protected String focusLevel;
        protected GraphEntity.ID focusEntityID;
        protected boolean needPerfData;
        protected boolean needZoneData;

        private ID(Object object) {
            this.id = object;
        }

        public ID(String string, GraphEntity.ID iD) {
            this.focusLevel = string;
            this.focusEntityID = iD;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            if (iD != null) {
                stringBuffer.append("-" + iD.getID());
            }
            this.id = stringBuffer.toString();
        }

        public String toString() {
            return "GraphModel.ID(id=" + this.id + ", focusLevel=" + this.focusLevel + ", focusEntityID=" + this.focusEntityID + ")";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof ID)) {
                return false;
            }
            ID iD = (ID)object;
            return this.id.equals(iD.getID());
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public int compareTo(Object object) {
            Comparable comparable = (Comparable)this.getID();
            Object object2 = ((GraphEntity.ID)object).getID();
            return comparable.compareTo(object2);
        }

        public Object getID() {
            return this.id;
        }

        public void setID(Object object) {
            this.id = object;
        }

        public String getFocusLevel() {
            return this.focusLevel;
        }

        public GraphEntity.ID getFocusEntityID() {
            return this.focusEntityID;
        }

        public void setFocusEntityID(GraphEntity.ID iD) {
            this.focusEntityID = iD;
        }

        public boolean isNeedPerfData() {
            return this.needPerfData;
        }

        public void setNeedPerfData(boolean bl) {
            this.needPerfData = bl;
        }

        public boolean isNeedZoneData() {
            return this.needZoneData;
        }

        public void setNeedZoneData(boolean bl) {
            this.needZoneData = bl;
        }
    }

    public static class MultiEntityID
    extends ID {
        private static final long serialVersionUID = -626562821644277539L;
        protected GraphEntity srcGroupEntity;
        protected Vector childFocusEntityIDV;

        public MultiEntityID(Object object) {
            super(object);
        }

        public MultiEntityID(String string, GraphEntity graphEntity, Vector vector) {
            super(string, null);
            this.srcGroupEntity = graphEntity;
            this.childFocusEntityIDV = vector;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.id);
            if (graphEntity != null) {
                stringBuffer.append("-{" + graphEntity.getGroupKey().getFullLabel() + "}");
            }
            stringBuffer.append("-{");
            int n = 0;
            while (n < vector.size()) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                GraphEntity.ID iD = (GraphEntity.ID)vector.elementAt(n);
                stringBuffer.append(iD.getID());
                ++n;
            }
            stringBuffer.append("}");
            this.id = stringBuffer.toString();
        }

        public String toString() {
            return "GraphModel.MultiEntityID(id=" + this.id + ", focusLevel=" + this.focusLevel + ", focusEntityID=" + this.focusEntityID + ", childFocusEntityIDV=" + this.childFocusEntityIDV + ", srcGroupEntity=" + this.srcGroupEntity + ")";
        }

        public GraphEntity getSrcGroupEntity() {
            return this.srcGroupEntity;
        }

        public Vector getChildFocusEntityIDs() {
            return this.childFocusEntityIDV;
        }

        public void setChildFocusEntityIDs(Vector vector) {
            this.childFocusEntityIDV = vector;
        }
    }
}

