/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalPackageTable;

public class PhysicalPackage
extends TResPhysicalPackageTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static PhysicalPackageCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new PhysicalPackageCursor(dBConnection, hashtable, vector);
    }

    public PhysicalPackage() {
        this.clear();
    }

    public PhysicalPackage(int n, int n2, short s, short s2, short s3, float f, float f2, float f3, float f4, String string, short s4, short s5, String string2, short s6, String string3, Timestamp timestamp) {
        this.clear();
        this.m_PackageId = n;
        this.m_RemovalConditions = n2;
        this.m_Removable = s;
        this.m_Replaceable = s2;
        this.m_HotSwappable = s3;
        this.m_Height = f;
        this.m_Depth = f2;
        this.m_Width = f3;
        this.m_Weight = f4;
        this.m_ElementName = string;
        this.m_VendorId = s4;
        this.m_ModelId = s5;
        this.m_OtherIdentifyingInfo = string2;
        this.m_PoweredOn = s6;
        this.m_Location = string3;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_RemovalConditions != Integer.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("REMOVAL_CONDITIONS"), String.valueOf(this.m_RemovalConditions));
        }
        if (this.m_Removable != Short.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("REMOVABLE"), String.valueOf(this.m_Removable));
        }
        if (this.m_Replaceable != Short.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("REPLACEABLE"), String.valueOf(this.m_Replaceable));
        }
        if (this.m_HotSwappable != Short.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("HOT_SWAPPABLE"), String.valueOf(this.m_HotSwappable));
        }
        if (this.m_Height != Float.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("HEIGHT"), String.valueOf(this.m_Height));
        }
        if (this.m_Depth != Float.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("DEPTH"), String.valueOf(this.m_Depth));
        }
        if (this.m_Width != Float.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("WIDTH"), String.valueOf(this.m_Width));
        }
        if (this.m_Weight != Float.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("WEIGHT"), String.valueOf(this.m_Weight));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_OtherIdentifyingInfo != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("OTHER_IDENTIFYING_INFO"), this.m_OtherIdentifyingInfo);
        }
        if (this.m_PoweredOn != Short.MIN_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("POWERED_ON"), String.valueOf(this.m_PoweredOn));
        }
        if (this.m_Location != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("LOCATION"), this.m_Location);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(PhysicalPackage.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htColsAndValues.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_PACKAGE", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_PACKAGE", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_PACKAGE", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), hashtable.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_PACKAGE", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_PACKAGE", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), hashtable.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_PACKAGE", dBConnection, this.htWhereClause);
    }

    /*
     * Exception decompiling
     */
    public boolean retrieve(DBConnection var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 161->164)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static PhysicalPackage retrieve(DBConnection var0, Hashtable var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 232->235)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_PACKAGE", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_PACKAGE", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setPackageId(dBResultSet.getInt("PACKAGE_ID"));
        this.setRemovalConditions(dBResultSet.getInt("REMOVAL_CONDITIONS"));
        this.setRemovable(dBResultSet.getShort("REMOVABLE"));
        this.setReplaceable(dBResultSet.getShort("REPLACEABLE"));
        this.setHotSwappable(dBResultSet.getShort("HOT_SWAPPABLE"));
        this.setHeight(dBResultSet.getFloat("HEIGHT"));
        this.setDepth(dBResultSet.getFloat("DEPTH"));
        this.setWidth(dBResultSet.getFloat("WIDTH"));
        this.setWeight(dBResultSet.getFloat("WEIGHT"));
        this.setElementName(dBResultSet.getString("ELEMENT_NAME"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setOtherIdentifyingInfo(dBResultSet.getString("OTHER_IDENTIFYING_INFO"));
        this.setPoweredOn(dBResultSet.getShort("POWERED_ON"));
        this.setLocation(dBResultSet.getString("LOCATION"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class PhysicalPackageCursor
    extends DBCursor {
        private PhysicalPackage element = new PhysicalPackage();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
            }
            if (hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
            }
            return hashtable;
        }

        public PhysicalPackageCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_PHYSICAL_PACKAGE", dBConnection, PhysicalPackageCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public PhysicalPackage getObject() throws SQLException {
            PhysicalPackage physicalPackage = null;
            if (this.DBrs != null) {
                physicalPackage = new PhysicalPackage();
                physicalPackage.setFields(this.con, this.DBrs);
            }
            return physicalPackage;
        }

        public PhysicalPackage getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

