/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class PeripheralEntityXmlToDBMapper
extends DBAttributeMapper {
    private static final String SCSITYPE = "SCSI Type";
    private static final String PLATFORMTYPE = "Platform Type";
    private static final String RNIDTYPE = "RNID Type";
    private static final String SCSISUPPORT = "SCSI Support";
    private static final String SERIALNUMBER = "Serial Number";
    private static final String VENDOR = "Vendor";
    private static final String PRODUCTID = "Product ID";
    private static final String REVISION = "Revision";
    private static final String MGMTTELNETADDRESS = "Management Telnet Address";
    private static final String MGMTSNMPADDRESS = "Management Snmp Address";
    private static final String MGMTURLADDRESS = "Management URL Address";
    private static final String MANUALLYENTEREDNAME = "Manually Entered Name";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "PeripheralEntityXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public PeripheralEntityXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 2);
        this.m_dataConverter.addSimpleDataConversion(SCSITYPE.toLowerCase(), "PE_SCSI_Type");
        this.m_dataConverter.addSimpleDataConversion(PLATFORMTYPE.toLowerCase(), "Node_Type");
        this.m_dataConverter.addSimpleDataConversion(RNIDTYPE.toLowerCase(), "Node_Type");
        this.m_dataConverter.addSimpleDataConversion(SCSISUPPORT.toLowerCase(), "Node_SCSI_Support");
        ColumnInfo columnInfo = PhyPe.getColumnInfo("PE_NAME");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = PhyPe.getColumnInfo("PHY_PE_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), mapperInfo);
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put(VENDOR.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put(PRODUCTID.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put(REVISION.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("FIRMWARE_REVISION")));
        this.m_htAttribToMapperInfo.put(MGMTTELNETADDRESS.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MGMT_TEL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTSNMPADDRESS.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MGMT_SNMP_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTURLADDRESS.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MGMT_URL_ADDR")));
        this.m_htAttribToMapperInfo.put(SCSITYPE.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("SCSI_TYPE")));
        this.m_htAttribToMapperInfo.put(PLATFORMTYPE.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("PLATFORM_TYPE")));
        this.m_htAttribToMapperInfo.put(RNIDTYPE.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("RNID_TYPE")));
        this.m_htAttribToMapperInfo.put(SCSISUPPORT.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("SCSI_SUPPORT")));
        this.m_htAttribToMapperInfo.put(MANUALLYENTEREDNAME.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("DISPLAY_NAME")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        MapperResult mapperResult = null;
        String string3 = (String)hashtable.get(MGMTURLADDRESS);
        if (string3 != null && string3.indexOf("0.0.0.0") != -1) {
            hashtable.remove(MGMTURLADDRESS);
        }
        mapperResult = super.persist(dBConnection, hashtable, string);
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }
}

