/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.server.guireq.topology.request.handler.GraphHolder;

public class ViewerCache {
    public static Vector cache = new Vector();

    public static synchronized GraphModel getFromCache(GraphModel.ID iD, boolean bl) {
        new GraphHolder(iD);
        int n = cache.size();
        int n2 = 0;
        while (n2 < n) {
            if (cache.elementAt(n2).equals(iD)) {
                GraphHolder graphHolder = (GraphHolder)cache.remove(n2);
                cache.insertElementAt(graphHolder, 0);
                if (bl) {
                    if (graphHolder.isClosed()) {
                        return graphHolder.getModel();
                    }
                    return null;
                }
                return graphHolder.getModel();
            }
            ++n2;
        }
        return null;
    }

    public static Vector getAllElementsFromCache() {
        return cache;
    }

    public static synchronized void updateCache(int n, GraphModel.ID iD, GraphModel graphModel) {
        GraphHolder graphHolder = new GraphHolder(iD, graphModel);
        if (n != 0) {
            cache.remove(graphHolder);
        } else if (graphModel != null) {
            int n2 = cache.indexOf(graphHolder);
            if (n2 > -1) {
                ((GraphHolder)cache.elementAt(n2)).open();
            } else {
                cache.add(0, graphHolder);
            }
        }
    }

    public static synchronized void markAsClosed(GraphModel.ID iD) {
        GraphHolder graphHolder = new GraphHolder(iD);
        int n = cache.indexOf(graphHolder);
        if (n > -1) {
            ((GraphHolder)cache.elementAt(n)).close();
        }
    }

    public static synchronized void removeClosedTabs() {
        cache.size();
        Iterator iterator = cache.iterator();
        while (iterator.hasNext()) {
            GraphHolder graphHolder = (GraphHolder)iterator.next();
            if (!graphHolder.isClosed()) continue;
            iterator.remove();
        }
    }

    public static void clearCache() {
        cache.removeAllElements();
    }
}

