/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import org.eclipse.aperi.TStorm.gui.BaseAlertLogTableData;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskArrayAlertLogTableData
extends BaseAlertLogTableData {
    private static final int ACTIVE_COLUMN = 0;
    private static final int DISK_ARRAY_COLUMN = 1;
    private static final int COMPUTER_COLUMN = 2;
    private static final int DISK_COLUMN = 3;
    private static final int CONDITION_COLUMN = 4;
    private static final int FIRST_LOGGED_COLUMN = 5;
    private static final int LAST_LOGGED_COLUMN = 6;
    private static final int N_VIOLATIONS_COLUMN = 7;
    private static final int CREATOR_COLUMN = 8;
    private static final int NAME_COLUMN = 9;
    private static final int SCRIPT_NAME_COLUMN = 10;
    private static final int N_COLUMNS = 11;
    private static final String[] msgIDs;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "SAG0001L";
        stringArray[2] = "STG1102L";
        stringArray[3] = "STG7749L";
        stringArray[4] = "GUI2023L";
        stringArray[5] = "GUI2024L";
        stringArray[6] = "GUI2025L";
        stringArray[7] = "GUI2026L";
        stringArray[8] = "GUI2027L";
        stringArray[9] = "GUI2028L";
        stringArray[10] = "GUI2069L";
        msgIDs = stringArray;
    }

    private static boolean isDiscoveryAlert(AlertLog alertLog) {
        boolean bl = false;
        switch (alertLog.alAlertCondition) {
            case 64: 
            case 65: {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean isDiskAlert(AlertLog alertLog) {
        boolean bl = false;
        switch (alertLog.alAlertCondition) {
            case 5: 
            case 6: {
                bl = true;
            }
        }
        return bl;
    }

    public DiskArrayAlertLogTableData(AlertLogTable alertLogTable, ExtAlertLog[] extAlertLogArray) {
        super(alertLogTable, extAlertLogArray);
        this.columnNames = new String[11];
        this.columnNames[0] = " ";
        int n = 1;
        while (n < 11) {
            this.columnNames[n] = MessageLog.getMessageNoID(msgIDs[n]);
            ++n;
        }
    }

    public Object getTableDataItem(int n, int n2) {
        ExtAlertLog extAlertLog = this.array[n];
        Object object = null;
        switch (n2) {
            case 0: {
                object = this.byteToObject(n, extAlertLog.alState);
                break;
            }
            case 1: {
                if (DiskArrayAlertLogTableData.isDiskAlert(extAlertLog) || DiskArrayAlertLogTableData.isVolumeAlert(extAlertLog)) {
                    object = extAlertLog.alComputer;
                    break;
                }
                object = extAlertLog.getAlObjectName();
                break;
            }
            case 2: {
                if (!DiskArrayAlertLogTableData.isDiscoveryAlert(extAlertLog)) break;
                object = extAlertLog.alComputer;
                break;
            }
            case 3: {
                if (!DiskArrayAlertLogTableData.isDiskAlert(extAlertLog) && !DiskArrayAlertLogTableData.isVolumeAlert(extAlertLog)) break;
                object = extAlertLog.getAlObjectName();
                break;
            }
            case 4: {
                object = MessageLog.getMessageNoID(AlertConditionManager.getConditionMessageId(extAlertLog.alAlertCondition));
                break;
            }
            case 5: {
                object = this.timestampToObject(n, extAlertLog.alFirstAlertTime);
                break;
            }
            case 6: {
                object = this.timestampToObject(n, extAlertLog.alLastAlertTime);
                break;
            }
            case 7: {
                object = this.intToObject(n, extAlertLog.alAlertCount);
                break;
            }
            case 8: {
                object = extAlertLog.alCreator;
                break;
            }
            case 9: {
                object = extAlertLog.getAlName();
                break;
            }
            case 10: {
                if (Util.isEmpty(extAlertLog.alScriptLogFile)) break;
                object = extAlertLog.alScriptName;
            }
        }
        if (object == null) {
            object = AlertLogDDI.notApplicableText;
        }
        return object;
    }

    public void hideColumns(MegaTable megaTable) {
    }

    public int getNumberColumns() {
        return 11;
    }

    public int[] getRenderers() {
        int[] nArray = new int[11];
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 5;
        return nArray;
    }

    public int[] getHiddenColumns() {
        return null;
    }

    private static boolean isVolumeAlert(AlertLog alertLog) {
        boolean bl = false;
        switch (alertLog.alAlertCondition) {
            case 185: 
            case 186: {
                bl = true;
            }
        }
        return bl;
    }
}

