/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.San.gui.DiskArrayData;
import org.eclipse.aperi.San.gui.HostPathTable;
import org.eclipse.aperi.San.gui.LogicalUnitDDI;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeData;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LUNData
implements GuiRequestor,
ChangeListener {
    private LogicalUnitDDI ddi;
    private NameList computer;
    private int lunID;
    private JTabbedPane tabs;

    public LUNData(int n, NameList nameList, LogicalUnitDDI logicalUnitDDI) {
        this.lunID = n;
        this.computer = nameList;
        this.ddi = logicalUnitDDI;
    }

    public JComponent getComponent() {
        if (this.tabs == null) {
            Request request = GuiRequest.makeLogicalUnitRequest(this.computer.nlID, this.lunID);
            GuiClient.doRequest(this, request);
            this.tabs = new JTabbedPane();
        }
        return this.tabs;
    }

    private static void addAttribute(Container container, GridBagConstraints gridBagConstraints, String string, String string2) {
        Object[] objectArray = string2 == null ? (Object[])null : new Object[]{string2};
        String string3 = MessageLog.getMessageNoID(string, objectArray);
        LUNData.addAttributeX(container, gridBagConstraints, string3);
    }

    private static void addAttributeX(Container container, GridBagConstraints gridBagConstraints, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.plainFont);
        container.add((Component)jLabel, gridBagConstraints);
    }

    private Component makeTopPanel(LogicalDisk logicalDisk) {
        byte by;
        String string;
        String string2;
        String string3;
        boolean bl = false;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.top = 30;
        gridBagConstraints.anchor = 17;
        if (this.computer.nlID2 == 21) {
            string3 = logicalDisk.ldPath;
            int n = logicalDisk.ldPath.indexOf(":");
            if (n > 0) {
                string3 = logicalDisk.ldPath.substring(0, n);
            }
            DiskArrayData.addItem(jPanel, gridBagConstraints, "SAG0077L", string3);
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.bottom = 12;
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG4500L", this.computer.nlName);
            gridBagConstraints.insets.bottom = 0;
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG1162L", Util.formatBytes(logicalDisk.ldCapacity * 512L));
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG6054L", Util.formatBytes(logicalDisk.ldOverhead * 512L));
            string2 = LogicalDisk.VDISK_TYPES[logicalDisk.ldType];
        } else {
            if (this.computer.nlID2 == 15 || this.computer.nlID2 == 18) {
                DiskArrayData.addItem(jPanel, gridBagConstraints, "SAG0514L", logicalDisk.ldPath);
                gridBagConstraints.insets.top = 0;
                DiskArrayData.addItem(jPanel, gridBagConstraints, "SAG0619L", logicalDisk.ldName);
            } else if (this.computer.nlID2 == 12 || this.computer.nlID2 == 25 || this.computer.nlID2 == 27) {
                string3 = logicalDisk.ldPath;
                if (this.computer.nlID2 == 12 && string3.startsWith("0")) {
                    bl = true;
                }
                if (this.computer.nlID2 == 25 || this.computer.nlID2 == 27) {
                    bl = LogicalDisk.isCKD(logicalDisk.ldStorageType);
                    string3 = !Util.isEmpty(string3) ? String.valueOf(string3) + " (" + logicalDisk.ldDeviceId + ")" : "(" + logicalDisk.ldDeviceId + ")";
                }
                DiskArrayData.addItem(jPanel, gridBagConstraints, "SAG0514L", string3);
            } else if (this.computer.nlID2 == 14) {
                DiskArrayData.addItem(jPanel, gridBagConstraints, "SAG0514L", logicalDisk.ldName);
            } else {
                DiskArrayData.addItem(jPanel, gridBagConstraints, "SAG0514L", logicalDisk.ldPath);
            }
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.bottom = 12;
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG4201L", this.computer.nlName);
            gridBagConstraints.insets.bottom = 0;
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG1162L", Util.formatBytes(logicalDisk.ldCapacity << 9));
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG6054L", Util.formatBytes(logicalDisk.ldOverhead << 9));
            string2 = LogicalDisk.TYPES[logicalDisk.ldType];
        }
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(jPanel, gridBagConstraints, "STG1132L", string2);
        if (logicalDisk.ldRaid != -1) {
            DiskArrayData.addItem(jPanel, gridBagConstraints, "STG7568L", VolGroup.CONFIGS[logicalDisk.ldRaid]);
        }
        gridBagConstraints.insets.bottom = 0;
        string3 = MessageLog.getMessageNoID("STG3257L");
        JLabel jLabel = new JLabel(string3);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.boldFont);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 60;
        if (logicalDisk.isSnapshot()) {
            String string4 = logicalDisk.ldSnapSource != null ? logicalDisk.ldSnapSource.ldPath : null;
            string = string4 != null ? "SAG0013L" : "SAG0012L";
            LUNData.addAttribute(jPanel, gridBagConstraints, string, string4);
        }
        if (logicalDisk.isVCMDB()) {
            LUNData.addAttribute(jPanel, gridBagConstraints, "SAG0014L", null);
        }
        if ((by = logicalDisk.getReplicationMode()) != 0) {
            string = by == 1 ? "SAG0015L" : "SAG0016L";
            LUNData.addAttribute(jPanel, gridBagConstraints, string, null);
        }
        if (logicalDisk.notExposed()) {
            LUNData.addAttribute(jPanel, gridBagConstraints, "SAG0017L", null);
        } else {
            LUNData.addAttribute(jPanel, gridBagConstraints, "SAG0201L", null);
        }
        if (bl) {
            LUNData.addAttributeX(jPanel, gridBagConstraints, "CKD");
        }
        jPanel.add(Box.createVerticalStrut(14), gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    public void handleResponse(short s, Response response) {
        JPanel jPanel;
        boolean bl;
        if (s > 4) {
            return;
        }
        LogicalDisk logicalDisk = (LogicalDisk)response.responseData;
        Component component = this.makeTopPanel(logicalDisk);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(component, "North");
        jPanel2.add((Component)LogicalVolumeData.getLvTree(logicalDisk, (short)this.computer.nlID2), "Center");
        String string = MessageLog.getMessageNoID("STG5275L");
        this.tabs.addTab(string, jPanel2);
        boolean bl2 = bl = logicalDisk.ldHostPaths != null;
        if (bl) {
            jPanel = new HostPathTable(logicalDisk.ldHostPaths);
        } else {
            string = MessageLog.getMessageNoID("STG0020M");
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            jLabel.setFont(BaseTree.boldFont);
            jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)jLabel, new GridBagConstraints());
        }
        string = MessageLog.getMessageNoID("SAG0019L");
        this.tabs.addTab(string, jPanel);
        this.tabs.setEnabledAt(1, bl);
        this.tabs.setSelectedIndex(this.ddi.tabIndex);
        this.tabs.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.ddi.tabIndex = this.tabs.getSelectedIndex();
    }
}

