/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputerList;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputersAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String NETWORK = MessageLog.getMessageNoID("STG1281L");
    private static final String IPADDRESS = MessageLog.getMessageNoID("STG1280L");
    private static final String OSTYPE = MessageLog.getMessageNoID("STG1108L");
    private static final String OSVERSION = MessageLog.getMessageNoID("STG1109L");
    private static final String TIMEZONE = MessageLog.getMessageNoID("STG1282L");
    private static final String MANUFACT = MessageLog.getMessageNoID("STG1105L");
    private static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    private static final String SERNUM = MessageLog.getMessageNoID("STG1107L");
    private static final String TYPE = MessageLog.getMessageNoID("STG1110L");
    private static final String SPEED = MessageLog.getMessageNoID("STG1111L");
    private static final String PROCESSORS = MessageLog.getMessageNoID("STG1112L");
    private static final String RAM = MessageLog.getMessageNoID("STG1113L");
    private static final String SWAP = MessageLog.getMessageNoID("STG1114L");
    private static final String DISK_CAP = MessageLog.getMessageNoID("STG1115L");
    private static final String DISK_FREE = MessageLog.getMessageNoID("STG1116L");
    private static final String FS_FREE = MessageLog.getMessageNoID("STG1117L");
    private static final String LAST_BOOT = MessageLog.getMessageNoID("STG1118L");
    private static final String LAST_PROBE = MessageLog.getMessageNoID("STG1119L");
    private static final String PROBE_STAT = MessageLog.getMessageNoID("STG1120L");
    private static final String DISC_TIME = MessageLog.getMessageNoID("STG1134L");
    private static final String CPU_ARCH = MessageLog.getMessageNoID("STG1037L");
    private static final String NA = MessageLog.getMessageNoID("GEN0185T");
    public String[] columnNameList = new String[]{COMPUTER, NETWORK, IPADDRESS, OSTYPE, OSVERSION, TIMEZONE, MANUFACT, MODEL, SERNUM, TYPE, SPEED, PROCESSORS, RAM, SWAP, DISK_CAP, DISK_FREE, FS_FREE, LAST_BOOT, LAST_PROBE, PROBE_STAT, DISC_TIME, CPU_ARCH};
    private static final int COMPUTER_COL = 0;
    private static final int NETWORK_COL = 1;
    private static final int IPADDRESS_COL = 2;
    private static final int OSTYPE_COL = 3;
    private static final int OSVERSION_COL = 4;
    private static final int TIMEZONE_COL = 5;
    private static final int MANUFACT_COL = 6;
    private static final int MODEL_COL = 7;
    private static final int SERNUM_COL = 8;
    private static final int TYPE_COL = 9;
    public static final int SPEED_COL = 10;
    public static final int PROCESSORS_COL = 11;
    private static final int RAM_COL = 12;
    private static final int SWAP_COL = 13;
    private static final int DISK_CAP_COL = 14;
    private static final int DISK_FREE_COL = 15;
    private static final int FS_FREE_COL = 16;
    private static final int LAST_BOOT_COL = 17;
    private static final int LAST_PROBE_COL = 18;
    private static final int PROBE_STAT_COL = 19;
    private static final int DISC_TIME_COL = 20;
    private static final int CPU_ARCH_COL = 21;
    public static String[] probeStatus = new String[]{MessageLog.getMessageNoID("STG1121T"), MessageLog.getMessageNoID("STG1122T"), MessageLog.getMessageNoID("STG1123T"), MessageLog.getMessageNoID("STG0019T")};
    private Computer[] computers;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private GuiReportReq grr;
    private Comparator sorter;
    private ComputerList computerList;
    private int[] rendererArray;
    private boolean batch;
    public int frozenRows;
    private int rowCount;
    private short osType;
    private GComputer gcmpTotal;

    public ComputersAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 1;
        switch (guiReportReq.reportSubtype) {
            case 38: {
                this.firstColumn = 17;
                this.sorter = new LastBootSorter();
                break;
            }
            case 18: {
                this.firstColumn = 18;
                this.sorter = new LastProbeSorter();
                break;
            }
            case 37: {
                this.firstColumn = 20;
                this.sorter = new DiscTimeSorter();
                break;
            }
            default: {
                this.sorter = new ComputerSorter();
            }
        }
        this.rendererArray = new int[this.columnNameList.length];
        this.rendererArray[12] = 7;
        this.rendererArray[13] = 7;
        this.rendererArray[14] = 7;
        this.rendererArray[15] = 7;
        this.rendererArray[16] = 7;
        this.rendererArray[17] = 1;
        this.rendererArray[18] = 1;
        this.rendererArray[20] = 1;
        this.rendererArray[11] = 5;
        this.rendererArray[10] = 9;
        this.columnNameList = this.getCustomizedColNames(this.columnNameList);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        if (this.bHasTotalRow) {
            this.computers[0].gComputer = this.gcmpTotal;
        }
        Arrays.sort(this.computers, this.frozenRows, this.computers.length, this.sorter);
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.computers = (Computer[])objectArray;
        this.rowCount = this.computers.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mDate = new Date[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        if (bl) {
            this.computerList = new ComputerList();
        }
        int n = 0;
        while (n < this.rowCount) {
            this.mDate[n] = new Date();
            this.mInt[n] = new MutableInteger();
            this.mLong[n] = new MutableLong();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rowCount) {
            Computer computer = this.computers[n];
            computer.cmpDiskCapacity *= 512L;
            computer.cmpDiskFreeSpace *= 512L;
            computer.cmpFilesystemFreeSpace *= 512L;
            if (computer.cmpProcessorCount <= 0) {
                computer.cmpProcessorCount = (short)-1;
            }
            computer.gComputer = this.batch ? this.computerList.getComputer(computer.cmpID) : GuiUtil.getComputer(computer.cmpID);
            ++n;
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        columnDescriptorArray[3].cdValidValue = ColumnDescriptor.OS_TYPES;
        columnDescriptorArray[19].cdValidValue = ColumnDescriptor.PROBE_STATUS;
        columnDescriptorArray[21].cdValidValue = ColumnDescriptor.CPU_ARCHITECTURES;
    }

    public Object getArray() {
        return this.computers;
    }

    public int getNumberRows() {
        return this.computers.length;
    }

    public int getNumberColumns() {
        return this.columnNameList.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return 1;
    }

    public static String getCPUArchString(short s) {
        String string = Constants.getCPUArchDisplayName(0);
        String string2 = Constants.getCPUArchDisplayName(s);
        if (string2 == string) {
            string2 = "";
        }
        return string2;
    }

    public Object getCellData(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.computers[n].gComputer.gcTSName;
            }
            case 1: {
                return Util.getDotName(this.computers[n].gComputer.gcNetworkName, this.computers[n].gComputer.gcDomainName);
            }
            case 2: {
                if (this.computers[n].gComputer.gcIpAddress.equals(" ")) {
                    return NA;
                }
                return this.computers[n].gComputer.gcIpAddress;
            }
            case 3: {
                this.osType = this.computers[n].cmpOSType;
                if (this.osType > 0) {
                    return MessageLog.getMessageNoID(Constants.OSTYPES[this.osType]);
                }
                return "";
            }
            case 4: {
                if (this.computers[n].cmpOSVersion.equals(" ")) {
                    return NA;
                }
                return this.computers[n].cmpOSVersion;
            }
            case 5: {
                String string = this.computers[n].gComputer.gcTimezoneID;
                return string == null ? "" : Util.formatTimeZone(string);
            }
            case 6: {
                if (this.computers[n].cmpManufacturer.toLowerCase().equals("unknown")) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                return this.computers[n].cmpManufacturer;
            }
            case 7: {
                if (this.computers[n].cmpModel.equals(" ")) {
                    return NA;
                }
                return this.computers[n].cmpModel;
            }
            case 8: {
                if (this.computers[n].cmpSerialNumber.equals(" ")) {
                    return NA;
                }
                return this.computers[n].cmpSerialNumber;
            }
            case 9: {
                if (this.computers[n].cmpProcessorType.equals(" ")) {
                    return NA;
                }
                return this.computers[n].cmpProcessorType;
            }
            case 10: {
                this.mInt[n].value = this.computers[n].cmpProcessorSpeed;
                return new ComputerHertz(this.mInt[n].value);
            }
            case 11: {
                this.mInt[n].value = this.computers[n].cmpProcessorCount;
                return this.mInt[n];
            }
            case 12: {
                this.mLong[n].value = (long)this.computers[n].cmpRAM << 20;
                if (this.mLong[n].value == 0L) {
                    this.mLong[n].value = -1L;
                }
                return this.mLong[n];
            }
            case 13: {
                this.mLong[n].value = (long)this.computers[n].cmpSwapSpace << 20;
                return this.mLong[n];
            }
            case 14: {
                this.mLong[n].value = this.computers[n].cmpDiskCapacity;
                return this.mLong[n];
            }
            case 15: {
                this.mLong[n].value = this.computers[n].cmpDiskFreeSpace;
                return this.mLong[n];
            }
            case 16: {
                this.mLong[n].value = this.computers[n].cmpFilesystemFreeSpace;
                return this.mLong[n];
            }
            case 17: {
                if (this.computers[n].cmpLastBootTime < 0L) {
                    return NA;
                }
                this.mDate[n].setTime(this.computers[n].cmpLastBootTime);
                return this.mDate[n];
            }
            case 18: {
                this.mDate[n].setTime(this.computers[n].cmpLastProbeTime);
                return this.mDate[n];
            }
            case 19: {
                byte by = this.computers[n].cmpProbeStatus;
                return by < 0 ? "" : probeStatus[by];
            }
            case 20: {
                this.mDate[n].setTime(this.computers[n].cmpDiscoveredTime);
                return this.mDate[n];
            }
            case 21: {
                return ComputersAdjuster.getCPUArchString(this.computers[n].cmpCPUArchitecture);
            }
        }
        return null;
    }

    private void addTotal() {
        this.bHasTotalRow = true;
        Computer[] computerArray = new Computer[this.rowCount + 1];
        this.gcmpTotal = new GComputer();
        this.gcmpTotal.gcTSName = MessageLog.getMessageNoID("STG4136L");
        this.gcmpTotal.gcNetworkName = "";
        this.gcmpTotal.gcIpAddress = "";
        Computer computer = new Computer();
        computer.cmpOSType = (short)-1;
        computer.cmpCPUArchitecture = 0;
        computer.cmpOSVersion = "";
        computer.cmpManufacturer = "";
        computer.cmpModel = "";
        computer.cmpSerialNumber = "";
        computer.cmpProcessorType = "";
        computer.cmpDiskCapacity = -1L;
        computer.cmpDiskFreeSpace = -1L;
        computer.cmpProbeStatus = (byte)-1;
        computerArray[0] = computer;
        int n = 0;
        while (n < this.rowCount) {
            Computer computer2 = this.computers[n];
            if (computer2.cmpProcessorCount > 0) {
                computer.cmpProcessorCount = (short)(computer.cmpProcessorCount + computer2.cmpProcessorCount);
            }
            if (computer2.cmpRAM > 0) {
                computer.cmpRAM += computer2.cmpRAM;
            }
            if (computer2.cmpSwapSpace > 0) {
                computer.cmpSwapSpace += computer2.cmpSwapSpace;
            }
            if (computer2.cmpFilesystemFreeSpace > 0L) {
                computer.cmpFilesystemFreeSpace += computer2.cmpFilesystemFreeSpace;
            }
            computerArray[n + 1] = computer2;
            ++n;
        }
        this.computers = computerArray;
        this.frozenRows = 1;
        ++this.rowCount;
    }

    public static class ComputerHertz
    extends MutableInteger {
        private static final long serialVersionUID = 5131324640254325703L;

        public ComputerHertz(int n) {
            this.value = n;
        }
    }

    private class ComputerSorter
    implements Comparator {
        private ComputerSorter() {
        }

        public int compare(Object object, Object object2) {
            GComputer gComputer = ((Computer)object).gComputer;
            GComputer gComputer2 = ((Computer)object2).gComputer;
            return gComputer.gcTSName.compareTo(gComputer2.gcTSName);
        }
    }

    private class DiscTimeSorter
    implements Comparator {
        private DiscTimeSorter() {
        }

        public int compare(Object object, Object object2) {
            Computer computer = (Computer)object;
            Computer computer2 = (Computer)object2;
            if (computer.cmpDiscoveredTime == computer2.cmpDiscoveredTime) {
                return 0;
            }
            if (computer.cmpDiscoveredTime > computer2.cmpDiscoveredTime) {
                return -1;
            }
            return 1;
        }
    }

    private class LastBootSorter
    implements Comparator {
        private LastBootSorter() {
        }

        public int compare(Object object, Object object2) {
            Computer computer = (Computer)object;
            Computer computer2 = (Computer)object2;
            if (computer.cmpLastBootTime == computer2.cmpLastBootTime) {
                return 0;
            }
            if (computer.cmpLastBootTime > computer2.cmpLastBootTime) {
                return 1;
            }
            return -1;
        }
    }

    private class LastProbeSorter
    implements Comparator {
        private LastProbeSorter() {
        }

        public int compare(Object object, Object object2) {
            Computer computer = (Computer)object;
            Computer computer2 = (Computer)object2;
            if (computer.cmpLastProbeTime == computer2.cmpLastProbeTime) {
                return 0;
            }
            if (computer.cmpLastProbeTime > computer2.cmpLastProbeTime) {
                return 1;
            }
            return -1;
        }
    }
}

