/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.DiskCapacityAdjuster;
import org.eclipse.aperi.TStorm.common.DiskCapacityGrapher;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskCapacityTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    DiskCapacityModel diskCapacityModel;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespFSspace[] data;
    private DiskCapacityAdjuster adjuster;
    private DiskCapacityGrapher grapher;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();

    public DiskCapacityTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.setLayout(new BorderLayout());
        this.adjuster = new DiskCapacityAdjuster(guiReportReq);
        this.grapher = new DiskCapacityGrapher();
        this.grapher.setLegend(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        this.data = s <= 4 ? (RespFSspace[])response.responseData : null;
        int n = this.data != null ? this.data.length : 0;
        if (n == 0) {
            this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespFSspace[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.diskCapacityModel = new DiskCapacityModel();
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        if (this.grr.reportSubtype == 15) {
            this.table.setRowIcon(11, true);
        } else {
            this.table.setRowIcon(10, true);
            this.table.iconChanger = this.diskCapacityModel;
        }
        int[] nArray = this.adjuster.getHiddenColumns();
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                this.table.setColumnHidden(nArray[n2], true);
                ++n2;
            }
        }
        this.table.setBaseTableModel(this.diskCapacityModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        this.validate();
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public void showJumpChart() {
        String string = this.grr.reportSubtype == 15 ? "STG5525L" : "STG1294T";
        ActionEvent actionEvent = new ActionEvent(this, 777, string);
        ((ActionListener)((Object)this.myMouseListener)).actionPerformed(actionEvent);
    }

    public DiskCapacityTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = new Object[3];
        String[] stringArray = new String[]{"STG7530L", "STG7531L", "STG7555L"};
        byte[] byArray = new byte[]{1, 8, 1};
        byte[] byArray2 = new byte[]{1, 2, 5};
        objectArray[0] = stringArray;
        objectArray[1] = byArray;
        objectArray[2] = byArray2;
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        Object[] objectArray = new Object[2];
        if (n2 == 15) {
            String[] stringArray = new String[]{"STG5525L", "STG7529L"};
            byte[] byArray = new byte[]{103, 104};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
        } else {
            String[] stringArray = new String[]{"STG1294T"};
            byte[] byArray = new byte[]{101};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
        }
        return objectArray;
    }

    public int[] getGraphID(String string) {
        int[] nArray = new int[2];
        nArray[0] = string == "STG5556T" ? 101 : (string == "STG1294T" ? 102 : (string == "STG5525L" ? 103 : (string == "STG5524L" ? 104 : (string == "STG5105L" ? 1 : (string == "STG5106L" ? 2 : 5)))));
        return nArray;
    }

    private class DiskCapacityModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        DiskCapacityModel() {
            this.columnNames = ((DiskCapacityTable)DiskCapacityTable.this).adjuster.colNames;
            this.rowCount = DiskCapacityTable.this.data.length;
            this.commonAdjuster = DiskCapacityTable.this.adjuster;
        }

        public boolean changeIcon(int n) {
            return false;
        }

        public Object getTableDataItem(int n, int n2) {
            return DiskCapacityTable.this.adjuster.getCellData(n, DiskCapacityTable.this.adjuster.translateColumn(n2));
        }
    }

    public class SelectListener
    extends TJCTableMouseAdapter
    implements ActionListener {
        public boolean select(int n, int n2) {
            return n >= ((DiskCapacityTable)DiskCapacityTable.this).adjuster.frozenLabels;
        }

        public void doubleClick(int n, int n2) {
            if (n < 0 || DiskCapacityTable.this.adjuster.hasTotalsRow() && n == 0) {
                return;
            }
            if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype == 82) {
                GuiReportReq guiReportReq = DiskCapacityTable.this.grr.explode(((DiskCapacityTable)DiskCapacityTable.this).data[n].id);
                DiskCapacityTable.this.ddi.addReport(DiskCapacityTable.this.grr, guiReportReq, DiskCapacityTable.this.data[n].getName());
            } else if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype != 27) {
                GuiReportReq guiReportReq = DiskCapacityTable.this.grr.explode(((DiskCapacityTable)DiskCapacityTable.this).data[n].id);
                if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportType == 72) {
                    guiReportReq.reportType = 8;
                    guiReportReq.reportSubtype = 27;
                }
                DiskCapacityTable.this.ddi.addReport(DiskCapacityTable.this.grr, guiReportReq, Util.getDotName(((DiskCapacityTable)DiskCapacityTable.this).data[n].creator, DiskCapacityTable.this.data[n].getName()));
            } else if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype == 27) {
                new DiskDDI(null, ((DiskCapacityTable)DiskCapacityTable.this).data[n].fs_id, DiskCapacityTable.this.data[n].getName(), ((DiskCapacityTable)DiskCapacityTable.this).data[n].id);
            }
        }

        public void showPopup(int n, int n2, Component component, int n3, int n4) {
            JMenuItem jMenuItem;
            boolean bl = false;
            if (DiskCapacityTable.this.data != null && DiskCapacityTable.this.data.length > 0) {
                bl = true;
            }
            boolean bl2 = DiskCapacityTable.this.table.rowsSelected();
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype == 15) {
                jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5525L"));
                jMenuItem.setEnabled(bl);
                jMenuItem.setActionCommand("STG5525L");
                jMenuItem.addActionListener(this);
                jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5524L"));
                jMenuItem.setEnabled(bl);
                jMenuItem.setActionCommand("STG5524L");
                jMenuItem.addActionListener(this);
            } else {
                jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5556T"));
                jMenuItem.setActionCommand("STG5556T");
                jMenuItem.setEnabled(bl2);
                jMenuItem.addActionListener(this);
                jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG1294T"));
                jMenuItem.setEnabled(bl);
                jMenuItem.setActionCommand("STG1294T");
                jMenuItem.addActionListener(this);
            }
            jPopupMenu.addSeparator();
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5105L"));
            jMenuItem.setActionCommand("STG5105L");
            jMenuItem.setEnabled(bl2);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5106L"));
            jMenuItem.setActionCommand("STG5106L");
            jMenuItem.setEnabled(bl2);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5109L"));
            jMenuItem.setActionCommand("STG5109L");
            jMenuItem.setEnabled(bl2);
            jMenuItem.addActionListener(this);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }

        public void showDefaultChart(int n) {
            int[] nArray = DiskCapacityTable.this.getGraphID("STG5525L");
            ((DiskCapacityTable)DiskCapacityTable.this).grr.chartSubtype = (byte)nArray[0];
            DiskCapacityTable.this.grapher.createPieChart(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, DiskCapacityTable.this.adjuster, DiskCapacityTable.this.ddi, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            String string = actionEvent.getActionCommand();
            if (string == "STG5525L") {
                int[] nArray2 = DiskCapacityTable.this.getGraphID("STG5525L");
                ((DiskCapacityTable)DiskCapacityTable.this).grr.chartSubtype = (byte)nArray2[0];
                DiskCapacityTable.this.grapher.createPieChart(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, DiskCapacityTable.this.adjuster, DiskCapacityTable.this.ddi, null);
                return;
            }
            if (string == "STG1294T" || string == "STG5524L") {
                nArray = DiskCapacityTable.this.adjuster.hasTotalsRow() ? new int[DiskCapacityTable.this.data.length - 1] : new int[DiskCapacityTable.this.data.length];
                int n = nArray.length - 1;
                while (n >= 0) {
                    nArray[n] = DiskCapacityTable.this.table.getDataRow(n + ((DiskCapacityTable)DiskCapacityTable.this).adjuster.frozenRows);
                    --n;
                }
            } else {
                nArray = DiskCapacityTable.this.table.getSelectedRows();
            }
            if (string == "STG1294T" || string == "STG5556T" || string == "STG5524L") {
                int[] nArray3 = DiskCapacityTable.this.getGraphID(string);
                ((DiskCapacityTable)DiskCapacityTable.this).grr.chartSubtype = (byte)nArray3[0];
                DiskCapacityTable.this.grapher.createChart(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, nArray, DiskCapacityTable.this.adjuster, DiskCapacityTable.this.ddi, null);
            } else {
                GuiReportReq guiReportReq = DiskCapacityTable.this.grapher.createHistory(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, nArray, string);
                DiskCapacityTable.this.ddi.addObject(DiskCapacityTable.this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(guiReportReq.historyTitle), DiskCapacityTable.this);
            }
        }
    }
}

