/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class MultiPicker
implements GuiRequestor,
ListSelectionListener,
ActionListener,
MouseListener,
ObjectChangeListener {
    private static final String ADD = "A";
    private static final String DELETE = "D";
    private static final String NEW = "N";
    private static final String EDIT = "E";
    private static final int TITLE_PAD = 2;
    private int nLists;
    private JList availableList;
    private DefaultListModel availableModel;
    private short objectType;
    private short requestType;
    private Container panel;
    private JButton newButton;
    private Class editorClass;
    private String objectLabelID;
    private NameList rightClicked;
    private JPopupMenu popupMenu;
    public NameList available;
    private Runnable nextInChain;
    private Icon icon;
    public short qualifier;
    public short resourceType;
    public short includeType = (short)-1;
    private SelectedList[] selected;
    private NameList[] initiallySelected;

    private void possiblyRemove(NameList nameList, int n) {
        --nameList.nlID3;
        if (nameList.nlID3 <= 0) {
            this.availableModel.remove(n);
        }
    }

    private boolean addToModel(NameList nameList, DefaultListModel defaultListModel) {
        Object[] objectArray = defaultListModel.toArray();
        int n = 1;
        int n2 = 0;
        while (n > 0 && n2 < objectArray.length) {
            NameList nameList2 = (NameList)objectArray[n2];
            n = nameList.nlName.compareTo(nameList2.nlName);
            ++n2;
        }
        if (n == 0) {
            return false;
        }
        if (n < 0) {
            --n2;
        }
        defaultListModel.add(n2, nameList);
        return true;
    }

    private void add(NameList nameList) {
        if (nameList.nlID3 <= 0) {
            this.addToModel(nameList, this.availableModel);
        }
        ++nameList.nlID3;
    }

    private void setIcon(JList jList) {
        DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)jList.getCellRenderer();
        defaultListCellRenderer.setIcon(this.icon);
    }

    public MultiPicker(short s, NameList[] nameListArray, Class clazz, String string, String string2, String string3, String[] stringArray, Runnable runnable, boolean bl) {
        Component component;
        this.nextInChain = runnable;
        this.objectType = this.requestType = s;
        this.qualifier = 0;
        this.resourceType = 0;
        NameList nameList = new NameList();
        nameList.nlInfo = this.objectType;
        this.icon = NameListTreeCellRenderer.iconForObject(nameList);
        nameList = null;
        this.initiallySelected = nameListArray;
        this.editorClass = clazz;
        this.objectLabelID = string2;
        this.nLists = this.initiallySelected.length;
        this.selected = new SelectedList[this.nLists];
        int n = 0;
        while (n < this.nLists) {
            this.selected[n] = new SelectedList(stringArray[n]);
            ++n;
        }
        this.availableModel = new DefaultListModel();
        this.availableList = new JList(this.availableModel);
        this.availableList.setSelectionMode(2);
        this.availableList.addListSelectionListener(this);
        if (bl) {
            this.availableList.addMouseListener(this);
        }
        this.setIcon(this.availableList);
        JScrollPane jScrollPane = new JScrollPane(this.availableList);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 2;
        String string4 = MessageLog.getMessageNoID(string);
        JLabel jLabel = new JLabel(string4);
        GuiUtil.setAccessibleLabel(jLabel, this.availableList, "", jLabel.getText(), jLabel.getText());
        Font font = jLabel.getFont().deriveFont(1);
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.panel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = this.nLists;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left = 13;
        gridBagConstraints.insets.top = 10;
        this.panel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.right = 13;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weighty = 1.0 / (double)this.nLists;
        n = 0;
        while (n < this.nLists) {
            this.panel.add(this.selected[n].getComponent(), gridBagConstraints);
            ++n;
        }
        if (!bl) {
            gridBagConstraints.insets.top = 0;
            component = Box.createVerticalStrut(1);
        } else {
            gridBagConstraints.insets.top = 14;
            string4 = MessageLog.getMessageNoID(string3);
            this.newButton = new JButton(string4);
            GuiUtil.setAccessible(this.newButton, this.newButton.getText(), this.newButton.getText());
            this.newButton.setActionCommand(NEW);
            this.newButton.addActionListener(this);
            component = this.newButton;
        }
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 11;
        gridBagConstraints.insets.right = 47;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.panel.add(component, gridBagConstraints);
        if (bl) {
            this.popupMenu = new JPopupMenu();
            string4 = MessageLog.getMessageNoID("GUI0105L");
            JMenuItem jMenuItem = new JMenuItem(string4);
            jMenuItem.setActionCommand(EDIT);
            jMenuItem.addActionListener(this);
            this.popupMenu.add(jMenuItem);
        }
    }

    public MultiPicker(short s, NameList[] nameListArray, Class clazz, String string, String string2, String string3, String[] stringArray) {
        this(s, nameListArray, clazz, string, string2, string3, stringArray, null, true);
    }

    public Component getComponent() {
        Request request = EditableObjectLabel.makeRequest(this.requestType, this.resourceType, this.qualifier);
        GuiClient.doRequest(this, request);
        return this.panel;
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public NameList getData(int n, MutableInteger mutableInteger) {
        DefaultListModel defaultListModel = this.selected[n].model;
        int n2 = defaultListModel.getSize();
        if (mutableInteger != null) {
            mutableInteger.value = n2;
        }
        NameList nameList = null;
        while (n2 > 0) {
            NameList nameList2 = (NameList)defaultListModel.getElementAt(--n2);
            NameList nameList3 = (NameList)nameList2.clone();
            nameList3.nlNext = nameList;
            nameList = nameList3;
        }
        return nameList;
    }

    public NameList getData(int n) {
        return this.getData(n, null);
    }

    private void moveOver(int n, NameList nameList) {
        NameList nameList2 = this.available;
        int n2 = 0;
        boolean bl = true;
        while (bl && nameList2 != null) {
            if (nameList2.nlID3 > 0) {
                if (nameList2.nlID == nameList.nlID) {
                    bl = false;
                } else {
                    ++n2;
                }
            }
            if (!bl) continue;
            nameList2 = nameList2.nlNext;
        }
        if (nameList2 != null) {
            this.possiblyRemove(nameList2, n2);
            this.selected[n].model.addElement(nameList2);
        }
    }

    private void possiblyPopUp(MouseEvent mouseEvent) {
        Point point;
        if (!mouseEvent.isPopupTrigger() || this.popupMenu == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JList jList = (JList)mouseEvent.getSource();
        int n3 = jList.locationToIndex(point = new Point(n, n2));
        if (n3 < 0) {
            return;
        }
        this.rightClicked = (NameList)jList.getModel().getElementAt(n3);
        this.popupMenu.show(jList, n, n2);
    }

    private void moveSelectedOver() {
        int n = 0;
        while (n < this.nLists) {
            NameList nameList = this.initiallySelected[n];
            while (nameList != null) {
                this.moveOver(n, nameList);
                nameList = nameList.nlNext;
            }
            ++n;
        }
    }

    public void replace(NameList[] nameListArray) {
        this.initiallySelected = nameListArray;
        int n = 0;
        while (n < this.nLists) {
            this.selected[n].clear();
            ++n;
        }
        this.moveSelectedOver();
    }

    public void setHeading(int n, String string) {
        this.selected[n].heading.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string;
        String string2 = actionEvent.getActionCommand();
        if (string2 == NEW) {
            string = null;
            n = 0;
        } else {
            string = this.rightClicked.nlName;
            n = this.rightClicked.nlID;
        }
        CreateOrEditDDI createOrEditDDI = new CreateOrEditDDI();
        createOrEditDDI.buildEditor(this.editorClass, string, n, this.objectType);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.availableList.getSelectedIndex() >= 0;
        int n = 0;
        while (n < this.selected.length) {
            this.selected[n].addButton.setEnabled(bl);
            if (bl) {
                ListSelectionModel listSelectionModel = this.selected[n].list.getSelectionModel();
                listSelectionModel.clearSelection();
            }
            ++n;
        }
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NameList nameList = this.available = GuiUtil.sortNameList((NameList)response.responseData);
        while (nameList != null) {
            this.availableModel.addElement(nameList);
            nameList.nlID3 = this.nLists;
            nameList = nameList.nlNext;
        }
        this.moveSelectedOver();
        if (this.nextInChain != null) {
            SwingUtilities.invokeLater(this.nextInChain);
            this.nextInChain = null;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.possiblyPopUp(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.possiblyPopUp(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n != 1) {
            return;
        }
        nameList = (NameList)nameList.clone();
        nameList.nlID3 = this.nLists;
        int n2 = 1;
        NameList nameList2 = null;
        NameList nameList3 = this.available;
        while (nameList3 != null && (n2 = nameList.nlName.compareTo(nameList3.nlName)) > 0) {
            nameList2 = nameList3;
            nameList3 = nameList3.nlNext;
        }
        if (n2 == 0) {
            nameList3.nlID = nameList.nlID;
            nameList3.nlID2 = nameList.nlID2;
        } else {
            if (nameList2 == null) {
                this.available = nameList;
            } else {
                nameList2.nlNext = nameList;
            }
            nameList.nlNext = nameList3;
            this.addToModel(nameList, this.availableModel);
        }
    }

    private class SelectedList
    implements ActionListener,
    ListSelectionListener {
        public JButton addButton = new JButton(">>");
        private JButton delButton;
        public JList list;
        public DefaultListModel model;
        private Container panel;
        public JLabel heading;

        public SelectedList(String string) {
            this.addButton.setEnabled(false);
            this.addButton.setActionCommand(MultiPicker.ADD);
            this.addButton.addActionListener(this);
            Font font = this.addButton.getFont().deriveFont(1);
            this.addButton.setFont(font);
            GuiUtil.setAccessible(this.addButton, Util.getString("NAME_ADD"), Util.getString("DESCRIPTION_ADD"));
            this.delButton = new JButton("<<");
            this.delButton.setEnabled(false);
            this.delButton.setActionCommand(MultiPicker.DELETE);
            this.delButton.addActionListener(this);
            this.delButton.setFont(font);
            GuiUtil.setAccessible(this.addButton, Util.getString("NAME_DELETE"), Util.getString("DESCRIPTION_DELETE"));
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            jPanel.add((Component)this.addButton, gridBagConstraints);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridheight = 0;
            jPanel.add((Component)this.delButton, gridBagConstraints);
            this.panel = new JPanel(new GridBagLayout());
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 1;
            this.panel.add((Component)jPanel, gridBagConstraints);
            this.heading = new JLabel(MessageLog.getMessageNoID(string));
            this.heading.setFont(font);
            jPanel = new JPanel(new GridBagLayout());
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.bottom = 2;
            jPanel.add((Component)this.heading, gridBagConstraints);
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.setSelectionMode(2);
            this.list.addListSelectionListener(this);
            this.list.addMouseListener(MultiPicker.this);
            GuiUtil.setAccessibleLabel(this.heading, this.list, "", this.heading.getText(), this.heading.getText());
            MultiPicker.this.setIcon(this.list);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jScrollPane, gridBagConstraints);
            this.panel.add((Component)jPanel, gridBagConstraints);
        }

        public Component getComponent() {
            return this.panel;
        }

        public void clear() {
            int n = this.model.getSize();
            while (n > 0) {
                NameList nameList = (NameList)this.model.remove(--n);
                MultiPicker.this.add(nameList);
            }
            this.valueChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == MultiPicker.ADD) {
                int[] nArray = MultiPicker.this.availableList.getSelectedIndices();
                int n = nArray.length - 1;
                while (n >= 0) {
                    int n2 = nArray[n];
                    NameList nameList = (NameList)MultiPicker.this.availableModel.get(n2);
                    if (MultiPicker.this.addToModel(nameList, this.model)) {
                        MultiPicker.this.possiblyRemove(nameList, n2);
                    }
                    --n;
                }
                MultiPicker.this.valueChanged(null);
            } else {
                int[] nArray = this.list.getSelectedIndices();
                int n = nArray.length - 1;
                while (n >= 0) {
                    int n3 = nArray[n];
                    NameList nameList = (NameList)this.model.remove(n3);
                    MultiPicker.this.add(nameList);
                    --n;
                }
                this.valueChanged(null);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = this.list.getSelectedIndex() >= 0;
            this.delButton.setEnabled(bl);
            if (bl) {
                ListSelectionModel listSelectionModel = MultiPicker.this.availableList.getSelectionModel();
                listSelectionModel.clearSelection();
            }
        }
    }
}

