/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.SimpleMindedTable;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.TableDataSource;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportFilterDialog
implements TableDataSource,
ActionListener {
    private CustomReportDataAdjuster adjuster;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private static final short ENUMERATED = 0;
    private static final int[] VALID_OPERATORS = new int[]{12483, 16383, 15615, 15423, 15423, 15420, 15423};
    private static final int[] HAS_EDITOR = new int[]{192, 960, 192, 3135, 3135, 3135, 3135};
    private static final String[] OPERATOR_NAMES = new String[]{"=", "<>", "<=", "<", ">=", ">", "IN", "NOT IN", "LIKE", "NOT LIKE", "BETWEEN", "NOT BETWEEN", "IS NULL", "NOT NULL"};
    private static final String[] COLUMN_NAMES;
    private static final int DELETE_COLUMN = 0;
    private static final int COLUMN_COLUMN = 1;
    private static final int OPERATOR_COLUMN = 2;
    private static final int VALUE1_COLUMN = 3;
    private static final int VALUE2_COLUMN = 4;
    private static final int EDIT_COLUMN = 5;
    private static final char ADD = '+';
    private static final char DELETE_ALL = 'A';
    private static final char OK = 'K';
    private static final char CANCEL = 'X';
    private GuiReportReq grr;
    private int[] idMap;
    private ColumnDescriptor[] descriptorArray;
    private boolean[] columnUsed;
    private NameList[] columnComboElements;
    private NameList[] operatorComboElements;
    private TableRow[] filterSpecs;
    private int nFilters;
    private JCheckBox caseSensitive;
    private JRadioButton orFilters;
    private JButton addButton;
    private JButton okButton;
    private SimpleMindedTable table;
    private JDialog dialog;
    private String editButtonText;
    private String[] columnNames;
    private short operator;
    private int selectedIndex;
    private FreeForm invalidField;

    static {
        String[] stringArray = new String[6];
        stringArray[1] = "STG3274L";
        stringArray[2] = "STG3275L";
        stringArray[3] = "STG3280L";
        stringArray[4] = "STG3281L";
        stringArray[5] = "GUI0046L";
        COLUMN_NAMES = stringArray;
    }

    private static short getDataType(ColumnFilter columnFilter) {
        short s = columnFilter.clfColumn.cdValidValue != null ? (short)0 : columnFilter.clfDataType;
        return s;
    }

    private static ColumnFilter newFilter(ColumnDescriptor columnDescriptor) {
        ColumnFilter columnFilter = new ColumnFilter(columnDescriptor);
        short s = ReportFilterDialog.getDataType(columnFilter);
        switch (s) {
            case 0: {
                columnFilter.clfCondition = (short)7;
                break;
            }
            case 1: {
                columnFilter.clfCondition = (short)9;
                break;
            }
            default: {
                columnFilter.clfCondition = (short)5;
            }
        }
        return columnFilter;
    }

    private static boolean hasEditButton(ColumnFilter columnFilter) {
        int n;
        int n2;
        short s = ReportFilterDialog.getDataType(columnFilter);
        return (HAS_EDITOR[s] & (n2 = 1 << (n = columnFilter.clfCondition - 1))) != 0;
    }

    private static boolean isMultiple(int n) {
        boolean bl = false;
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                bl = true;
            }
        }
        return bl;
    }

    private static JButton makeDelIconButton() {
        String string = MessageLog.getMessageNoID("GUI0106L");
        ImageIcon imageIcon = IconFactory.getRaggedBlackXIcon();
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(1, 0, 0, 0));
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jButton.setToolTipText(string);
        return jButton;
    }

    private static FreeForm constructFreeForm(ColumnFilter columnFilter, boolean bl) {
        FreeForm freeForm = null;
        short s = columnFilter.clfCondition;
        if (s == 13 || s == 14) {
            return freeForm;
        }
        short s2 = ReportFilterDialog.getDataType(columnFilter);
        switch (s2) {
            case 0: {
                if (ReportFilterDialog.isMultiple(s)) {
                    freeForm = new EnumeratedMultipleFreeForm(columnFilter);
                    break;
                }
                freeForm = new EnumeratedFreeForm(columnFilter);
                break;
            }
            case 1: {
                if (ReportFilterDialog.isMultiple(s)) {
                    freeForm = new StringMultipleFreeForm(columnFilter);
                    break;
                }
                freeForm = new StringFreeForm(columnFilter);
                break;
            }
            case 2: {
                if (ReportFilterDialog.isMultiple(s)) {
                    freeForm = new IntegerMultipleFreeForm(columnFilter);
                    break;
                }
                freeForm = new IntegerFreeForm(columnFilter);
                break;
            }
            case 5: {
                if (ReportFilterDialog.isMultiple(s)) {
                    freeForm = new StorageMultipleFreeForm(columnFilter);
                    break;
                }
                freeForm = new StorageFreeForm(columnFilter);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                freeForm = new DateFreeForm(columnFilter);
            }
        }
        if (freeForm != null) {
            if (freeForm instanceof StorageFreeForm) {
                ((StorageFreeForm)freeForm).refresh(bl);
            } else {
                ((FreeForm)freeForm).refresh();
            }
        }
        return freeForm;
    }

    private int idToSorted(int n) {
        int n2 = -1;
        try {
            n2 = this.idMap[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return n2;
    }

    private Vector getOperatorComboItems(ColumnFilter columnFilter) {
        this.selectedIndex = -1;
        Vector<NameList> vector = new Vector<NameList>(14);
        short s = ReportFilterDialog.getDataType(columnFilter);
        int n = VALID_OPERATORS[s];
        this.operator = 1;
        while (this.operator <= 14 && vector != null) {
            if ((n & 1) != 0) {
                if (this.operator == columnFilter.clfCondition) {
                    this.selectedIndex = vector.size();
                }
                vector.add(this.operatorComboElements[this.operator - 1]);
            } else if (this.operator == columnFilter.clfCondition) {
                vector = null;
                continue;
            }
            n >>= 1;
            this.operator = (short)(this.operator + 1);
        }
        return vector;
    }

    private void makeOperatorComboFromItems(TableRow tableRow, Vector vector) {
        TComboBox tComboBox = new TComboBox(vector);
        tComboBox.setSelectedIndex(this.selectedIndex);
        tComboBox.addItemListener(tableRow);
        tableRow.operatorCombo = tComboBox;
    }

    private Vector getColumnComboItems(int n) {
        this.selectedIndex = -1;
        int n2 = this.columnUsed.length;
        Vector<NameList> vector = new Vector<NameList>(n2);
        int n3 = 0;
        while (n3 < n2) {
            boolean bl;
            if (n3 != n) {
                bl = !this.columnUsed[n3];
            } else {
                bl = true;
                this.selectedIndex = vector.size();
            }
            if (bl) {
                vector.add(this.columnComboElements[n3]);
            }
            ++n3;
        }
        return vector;
    }

    private void makeColumnComboFromItems(TableRow tableRow, Vector vector) {
        tableRow.columnCombo = new TComboBox(vector);
        tableRow.columnCombo.setSelectedIndex(this.selectedIndex);
        tableRow.columnCombo.addItemListener(tableRow);
    }

    private void createColumnCombos(int[] nArray) {
        int n = 0;
        while (n < this.nFilters) {
            Vector vector = this.getColumnComboItems(nArray[n]);
            if (this.selectedIndex < 0) {
                throw new RuntimeException();
            }
            this.makeColumnComboFromItems(this.filterSpecs[n], vector);
            ++n;
        }
    }

    private void makeFilterSpecDelButton(TableRow tableRow) {
        tableRow.deleteButton = ReportFilterDialog.makeDelIconButton();
        tableRow.deleteButton.addActionListener(tableRow);
    }

    private void handleEditButton(TableRow tableRow) {
        if (!ReportFilterDialog.hasEditButton(tableRow.filter)) {
            tableRow.editButton = null;
        } else {
            tableRow.editButton = new JButton(this.editButtonText);
            tableRow.editButton.addActionListener(tableRow);
        }
    }

    public ReportFilterDialog(GuiReportReq guiReportReq, CustomReportDataAdjuster customReportDataAdjuster) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Serializable serializable;
        ColumnFilter[] columnFilterArray;
        this.grr = guiReportReq;
        this.adjuster = customReportDataAdjuster;
        ColumnDescriptor columnDescriptor = customReportDataAdjuster.getColumnDescriptors();
        int n2 = 0;
        short s = -1;
        ColumnDescriptor columnDescriptor2 = columnDescriptor;
        boolean bl = false;
        while (columnDescriptor2 != null) {
            ++n2;
            if (columnDescriptor2.cdID > s) {
                s = columnDescriptor2.cdID;
            }
            columnDescriptor2 = columnDescriptor2.cdNext;
        }
        this.descriptorArray = new ColumnDescriptor[n2];
        this.columnComboElements = new NameList[n2];
        this.idMap = new int[s + 1];
        Arrays.fill(this.idMap, -1);
        n2 = 0;
        columnDescriptor2 = columnDescriptor;
        while (columnDescriptor2 != null) {
            this.descriptorArray[n2] = columnDescriptor2;
            this.idMap[columnDescriptor2.cdID] = n2;
            NameList nameList = new NameList();
            nameList.nlName = columnDescriptor2.cdReportName;
            nameList.nlID = n2;
            this.columnComboElements[n2] = nameList;
            ++n2;
            columnDescriptor2 = columnDescriptor2.cdNext;
        }
        this.editButtonText = MessageLog.getMessageNoID("GUI0105L");
        this.operatorComboElements = new NameList[14];
        int n3 = 1;
        while (n3 <= 14) {
            columnFilterArray = new NameList();
            columnFilterArray.nlName = OPERATOR_NAMES[n3 - 1];
            columnFilterArray.nlID = n3;
            this.operatorComboElements[n3 - 1] = columnFilterArray;
            ++n3;
        }
        this.columnUsed = new boolean[n2];
        this.filterSpecs = new TableRow[n2];
        this.nFilters = 0;
        columnFilterArray = this.grr.columnFilters;
        n3 = columnFilterArray == null ? 0 : columnFilterArray.length;
        if (n3 == 0) {
            columnFilterArray = new ColumnFilter[]{ReportFilterDialog.newFilter(this.descriptorArray[0])};
            n3 = 1;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            serializable = columnFilterArray[n4];
            object5 = null;
            short s2 = ((ColumnFilter)serializable).clfColumnID;
            int n5 = this.idToSorted(s2);
            if (n5 < 0) {
                object5 = "STG3276E";
            } else if (this.columnUsed[n5]) {
                object5 = "STG3277E";
            }
            if (object5 != null) {
                object4 = new Object[]{new Integer(n4), new Integer(s2)};
                object3 = MessageLog.getMessageNoTS((String)object5, (Object[])object4);
                GuiUtil.displayErrorMessage((String)object3);
            } else {
                object4 = new TableRow();
                ((TableRow)object4).filter = (ColumnFilter)((ColumnFilter)serializable).clone();
                ((TableRow)object4).filter.clfValueList = (ColumnFilterValue)Packer.unpack(((TableRow)object4).filter.clfValue);
                ((TableRow)object4).filter.clfValue = null;
                ((TableRow)object4).filter.clfColumn = this.descriptorArray[n5];
                this.columnUsed[n5] = true;
                nArray[this.nFilters] = n5;
                object3 = this.getOperatorComboItems(((TableRow)object4).filter);
                if (object3 == null) {
                    object5 = "STG3278E";
                } else if (this.selectedIndex < 0) {
                    object5 = "STG3279E";
                    this.operator = ((ColumnFilter)serializable).clfCondition;
                }
                if (object5 != null) {
                    n = ReportFilterDialog.getDataType(((TableRow)object4).filter);
                    object2 = new Object[]{new Integer(n4), new Integer(this.operator), new Integer(n)};
                    object = MessageLog.getMessageNoTS((String)object5, (Object[])object2);
                    GuiUtil.displayErrorMessage((String)object);
                } else {
                    this.makeOperatorComboFromItems((TableRow)object4, (Vector)object3);
                    if (((ColumnFilter)serializable).clfCondition == 4 || ((ColumnFilter)serializable).clfCondition == 5 || ((ColumnFilter)serializable).clfCondition == 11) {
                        bl = true;
                    }
                    ((TableRow)object4).lowerLimit = ReportFilterDialog.constructFreeForm(((TableRow)object4).filter, bl);
                    if (((ColumnFilter)serializable).clfCondition == 11 || ((ColumnFilter)serializable).clfCondition == 12) {
                        ColumnFilter columnFilter = (ColumnFilter)((TableRow)object4).filter.clone();
                        if (columnFilter.clfValueList == null) {
                            object2 = null;
                        } else {
                            object2 = columnFilter.clfValueList.fvNext;
                            ((TableRow)object4).filter.clfValueList.fvNext = null;
                        }
                        columnFilter.clfValueList = object2;
                        ((TableRow)object4).upperLimit = ReportFilterDialog.constructFreeForm(columnFilter, false);
                    }
                    this.makeFilterSpecDelButton((TableRow)object4);
                    this.handleEditButton((TableRow)object4);
                    this.filterSpecs[this.nFilters] = object4;
                    ++this.nFilters;
                }
            }
            ++n4;
        }
        this.createColumnCombos(nArray);
        String string = MessageLog.getMessageNoID("STG3287L");
        serializable = new JRadioButton(string);
        ((AbstractButton)serializable).setSelected(!this.grr.orFilters);
        string = MessageLog.getMessageNoID("STG3273L");
        this.orFilters = new JRadioButton(string);
        this.orFilters.setSelected(this.grr.orFilters);
        object5 = new ButtonGroup();
        ((ButtonGroup)object5).add((AbstractButton)serializable);
        ((ButtonGroup)object5).add(this.orFilters);
        JPanel jPanel = new JPanel(new GridBagLayout());
        string = MessageLog.getMessageNoID("STG3286L");
        jPanel.setBorder(GuiUtil.getBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 4;
        jPanel.add((Component)serializable, gridBagConstraints);
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)this.orFilters, gridBagConstraints);
        object4 = new JPanel(new BorderLayout());
        ((Container)object4).add((Component)jPanel, "Center");
        string = MessageLog.getMessageNoID("GUI0043L");
        this.addButton = new JButton(string);
        if (this.nFilters >= n2) {
            this.addButton.setEnabled(false);
        }
        string = ReportingSelectionDriver.charToString('+');
        this.addButton.setActionCommand(string);
        object3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 0;
        ((Container)object3).add((Component)this.addButton, gridBagConstraints);
        this.addButton.addActionListener(this);
        string = MessageLog.getMessageNoID("GUI0062L");
        serializable = new JButton(string);
        string = ReportingSelectionDriver.charToString('A');
        ((AbstractButton)serializable).setActionCommand(string);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        ((Container)object3).add((Component)serializable, gridBagConstraints);
        ((AbstractButton)serializable).addActionListener(this);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)object3, gridBagConstraints);
        string = MessageLog.getMessageNoID("STG3282L");
        this.caseSensitive = new JCheckBox(string);
        this.caseSensitive.setSelected(!this.grr.filtersIgnoreCase);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)this.caseSensitive, gridBagConstraints);
        ((Container)object4).add((Component)jPanel, "West");
        this.columnNames = new String[COLUMN_NAMES.length];
        n = 0;
        while (n < COLUMN_NAMES.length) {
            this.columnNames[n] = COLUMN_NAMES[n] != null ? MessageLog.getMessageNoID(COLUMN_NAMES[n]) : "";
            ++n;
        }
        Dimension[] dimensionArray = new Dimension[this.columnNames.length];
        object2 = ReportFilterDialog.makeDelIconButton();
        dimensionArray[0] = ((Component)object2).getPreferredSize();
        object = new Vector(50);
        int n6 = 0;
        while (n6 < this.columnComboElements.length) {
            ((Vector)object).add(this.columnComboElements[n6]);
            ++n6;
        }
        object2 = new TComboBox((Vector)object);
        dimensionArray[1] = ((Component)object2).getPreferredSize();
        ((Vector)object).clear();
        n6 = 0;
        while (n6 < this.operatorComboElements.length) {
            ((Vector)object).add(this.operatorComboElements[n6]);
            ++n6;
        }
        object2 = new TComboBox((Vector)object);
        dimensionArray[2] = ((Component)object2).getPreferredSize();
        object = null;
        ColumnFilter columnFilter = new ColumnFilter();
        StorageFreeForm storageFreeForm = new StorageFreeForm(columnFilter);
        object2 = storageFreeForm.getComponent();
        dimensionArray[3] = ((Component)object2).getPreferredSize();
        dimensionArray[4] = new Dimension(100, dimensionArray[3].height);
        storageFreeForm = null;
        columnFilter = null;
        object2 = new JButton(this.editButtonText);
        dimensionArray[5] = ((Component)object2).getPreferredSize();
        object2 = null;
        this.table = new SimpleMindedTable(this, this.columnNames, n2, dimensionArray, 3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        string = MessageLog.getMessageNoID("STG3169L");
        this.dialog = new JDialog(this.guiMain.getFrame(), string, true);
        Help.setHelpID(this.dialog.getRootPane(), "reover15");
        this.dialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.dialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        Container container = this.dialog.getContentPane();
        container.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 6;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        container.add((Component)object4, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)jScrollPane, gridBagConstraints);
        object3 = new JPanel(new GridBagLayout());
        string = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(string);
        string = ReportingSelectionDriver.charToString('K');
        this.okButton.setActionCommand(string);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        ((Container)object3).add((Component)this.okButton, gridBagConstraints);
        this.okButton.addActionListener(this);
        string = MessageLog.getMessageNoID("GUI0114L");
        serializable = new JButton(string);
        string = ReportingSelectionDriver.charToString('X');
        ((AbstractButton)serializable).setActionCommand(string);
        gridBagConstraints.gridwidth = 0;
        ((Container)object3).add((Component)serializable, gridBagConstraints);
        ((AbstractButton)serializable).addActionListener(this);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)object3, gridBagConstraints);
    }

    public void show() {
        this.dialog.pack();
        this.table.fixNonWeighted();
        Dimension dimension = this.dialog.getSize();
        dimension.width = dimension.width * 21 / 20;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.height * 9 / 10;
        if (dimension.height > n) {
            dimension.height = n;
        }
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        this.dialog.setSize(dimension);
        GuiUtil.centerDialog(this.dialog);
        this.dialog.show();
    }

    private void undeceive(TableRow tableRow) {
        ColumnFilter columnFilter = tableRow.upperLimit.getFilter();
        ColumnFilterValue columnFilterValue = columnFilter.clfValueList;
        if (tableRow.filter.clfValueList != null) {
            tableRow.filter.clfValueList.fvNext = columnFilterValue;
        }
    }

    public int getRowCount() {
        return this.nFilters;
    }

    public Component getComponentAt(int n, int n2) {
        Component component = null;
        TableRow tableRow = this.filterSpecs[n];
        if (tableRow == null) {
            return component;
        }
        switch (n2) {
            case 0: {
                component = tableRow.deleteButton;
                break;
            }
            case 1: {
                component = tableRow.columnCombo;
                break;
            }
            case 2: {
                component = tableRow.operatorCombo;
                break;
            }
            case 3: {
                if (tableRow.lowerLimit == null) break;
                component = tableRow.lowerLimit.getComponent();
                break;
            }
            case 4: {
                if (tableRow.upperLimit == null) break;
                component = tableRow.upperLimit.getComponent();
                break;
            }
            case 5: {
                component = tableRow.editButton;
            }
        }
        return component;
    }

    private int rowFromSpec(TableRow tableRow) {
        int n = 0;
        while (n < this.nFilters && this.filterSpecs[n] != tableRow) {
            ++n;
        }
        return n;
    }

    private void newTableRow(ColumnDescriptor columnDescriptor, TableRow tableRow) {
        ColumnFilter columnFilter;
        tableRow.filter = columnFilter = ReportFilterDialog.newFilter(columnDescriptor);
        Vector vector = this.getOperatorComboItems(columnFilter);
        this.makeOperatorComboFromItems(tableRow, vector);
        tableRow.lowerLimit = ReportFilterDialog.constructFreeForm(tableRow.filter, false);
        tableRow.upperLimit = null;
        this.handleEditButton(tableRow);
    }

    private void columnChanged(TableRow tableRow) {
        int n = this.idToSorted(tableRow.filter.clfColumnID);
        NameList nameList = (NameList)tableRow.columnCombo.getSelectedItem();
        int n2 = nameList.nlID;
        if (n2 == n) {
            return;
        }
        this.columnUsed[n] = false;
        this.columnUsed[n2] = true;
        int n3 = 0;
        while (n3 < this.nFilters) {
            TableRow tableRow2 = this.filterSpecs[n3];
            if (tableRow2 != tableRow) {
                JComboBox jComboBox = tableRow2.columnCombo;
                MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)jComboBox.getModel();
                mutableComboBoxModel.removeElement(this.columnComboElements[n2]);
                int n4 = mutableComboBoxModel.getSize();
                int n5 = 0;
                boolean bl = true;
                while (bl && n5 < n4) {
                    NameList nameList2 = (NameList)mutableComboBoxModel.getElementAt(n5);
                    if (nameList2.nlID < n) {
                        ++n5;
                        continue;
                    }
                    bl = false;
                }
                mutableComboBoxModel.insertElementAt(this.columnComboElements[n], n5);
            }
            ++n3;
        }
        ColumnDescriptor columnDescriptor = this.descriptorArray[n2];
        this.newTableRow(columnDescriptor, tableRow);
        this.table.refresh();
    }

    public void getData(TableRow tableRow) throws GeneralException {
        this.invalidField = tableRow.lowerLimit;
        if (this.invalidField == null) {
            return;
        }
        this.invalidField.getData();
        this.invalidField = tableRow.upperLimit;
        if (this.invalidField != null) {
            this.invalidField.getData();
            this.invalidField = null;
        }
    }

    public void getAdjustedData(TableRow tableRow) throws GeneralException {
        double d = 0.0;
        double d2 = 0.0;
        switch (tableRow.filter.clfCondition) {
            case 11: 
            case 12: {
                d = StorageFreeForm.subAmt;
                d2 = StorageFreeForm.addAmt;
                break;
            }
            case 4: 
            case 5: {
                d = StorageFreeForm.subAmt;
                break;
            }
            case 3: 
            case 6: {
                d = StorageFreeForm.addAmt;
            }
        }
        this.invalidField = tableRow.lowerLimit;
        if (this.invalidField == null) {
            return;
        }
        if (this.invalidField instanceof StorageFreeForm) {
            ((StorageFreeForm)this.invalidField).getAdjustedData(d);
        } else {
            this.invalidField.getData();
        }
        this.invalidField = tableRow.upperLimit;
        if (this.invalidField != null) {
            if (this.invalidField instanceof StorageFreeForm) {
                ((StorageFreeForm)this.invalidField).getAdjustedData(d2);
            } else {
                this.invalidField.getData();
            }
            this.invalidField = null;
        }
    }

    private void operatorChanged(TableRow tableRow) {
        ColumnFilter columnFilter = tableRow.filter;
        NameList nameList = (NameList)tableRow.operatorCombo.getSelectedItem();
        columnFilter.clfCondition = (short)nameList.nlID;
        if (columnFilter.clfCondition == 13 || columnFilter.clfCondition == 14) {
            columnFilter.clfValueList = null;
        } else {
            try {
                this.getData(tableRow);
                if (columnFilter.clfValueList != null && this.isSingleValueCondition(columnFilter.clfCondition)) {
                    columnFilter.clfValueList.fvNext = null;
                }
            }
            catch (GeneralException generalException) {
                columnFilter.clfValueList = null;
            }
        }
        tableRow.lowerLimit = ReportFilterDialog.constructFreeForm(tableRow.filter, false);
        if (columnFilter.clfCondition != 11 && columnFilter.clfCondition != 12) {
            tableRow.upperLimit = null;
        } else {
            if (columnFilter.clfValueList != null) {
                columnFilter.clfValueList.fvNext = null;
            }
            ColumnFilterValue columnFilterValue = null;
            if (tableRow.upperLimit != null) {
                columnFilterValue = tableRow.upperLimit.getFilter().clfValueList;
            }
            ColumnFilter columnFilter2 = (ColumnFilter)columnFilter.clone();
            columnFilter2.clfValueList = columnFilterValue;
            tableRow.upperLimit = ReportFilterDialog.constructFreeForm(columnFilter2, false);
        }
        this.handleEditButton(tableRow);
        this.table.refresh();
    }

    private boolean isSingleValueCondition(short s) {
        return s <= 6;
    }

    private void editButtonPressed(TableRow tableRow) {
        Object object;
        ColumnFilter columnFilter;
        block10: {
            columnFilter = tableRow.filter;
            try {
                tableRow.lowerLimit.getData();
            }
            catch (GeneralException generalException) {
                columnFilter.clfValueList = null;
            }
            if (tableRow.upperLimit != null) {
                try {
                    tableRow.upperLimit.getData();
                    this.undeceive(tableRow);
                }
                catch (GeneralException generalException) {
                    object = columnFilter.clfValueList;
                    if (object == null) break block10;
                    ((ColumnFilterValue)object).fvNext = null;
                }
            }
        }
        object = new ValueEditorDialog(this.dialog, columnFilter);
        boolean bl = ((ValueEditorDialog)object).show();
        if (tableRow.upperLimit != null) {
            ColumnFilterValue columnFilterValue;
            if (columnFilter.clfValueList == null) {
                columnFilterValue = null;
            } else {
                columnFilterValue = columnFilter.clfValueList.fvNext;
                columnFilter.clfValueList.fvNext = null;
            }
            ColumnFilter columnFilter2 = tableRow.upperLimit.getFilter();
            columnFilter2.clfDataType = columnFilter.clfDataType;
            columnFilter2.clfValueList = columnFilterValue;
            if (bl) {
                tableRow.upperLimit.refresh();
            }
        }
        if (bl) {
            tableRow.lowerLimit.refresh();
        }
        this.table.refresh();
    }

    private void deleteButtonPressed(TableRow tableRow) {
        Object object;
        LinkedList<MutableInteger> linkedList = new LinkedList<MutableInteger>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < this.nFilters) {
            object = this.filterSpecs[n];
            NameList nameList = (NameList)((TableRow)object).columnCombo.getSelectedItem();
            if (object == tableRow) {
                this.columnUsed[nameList.nlID] = false;
                n2 = n;
            } else {
                this.filterSpecs[n3] = object;
                ++n3;
                linkedList.add(new MutableInteger(nameList.nlID));
            }
            ++n;
        }
        if (n3 == n) {
            throw new RuntimeException();
        }
        this.addButton.setEnabled(true);
        this.nFilters = n3;
        object = new int[this.nFilters];
        n3 = 0;
        for (MutableInteger mutableInteger : linkedList) {
            object[n3] = mutableInteger.value;
            ++n3;
        }
        this.createColumnCombos((int[])object);
        this.table.refresh();
        if (this.nFilters > 1) {
            if (n2 >= this.nFilters) {
                n2 = this.nFilters - 1;
            }
            this.filterSpecs[n2].deleteButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void deleteAllPressed() {
        if (this.nFilters == 0) {
            return;
        }
        this.nFilters = 0;
        this.addButton.setEnabled(true);
        Arrays.fill(this.columnUsed, false);
        this.table.refresh();
    }

    private void addPressed() {
        Object object;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n2 < 2 && n3 < this.columnUsed.length) {
            if (!this.columnUsed[n3]) {
                if (n < 0) {
                    n = n3;
                }
                ++n2;
            }
            ++n3;
        }
        if (n < 0) {
            throw new RuntimeException();
        }
        this.columnUsed[n] = true;
        if (n2 <= 1) {
            this.addButton.setEnabled(false);
        }
        n3 = 0;
        while (n3 < this.nFilters) {
            object = (MutableComboBoxModel)this.filterSpecs[n3].columnCombo.getModel();
            int n4 = object.getSize();
            boolean bl = true;
            while (bl && n4 > 0) {
                NameList nameList = (NameList)object.getElementAt(--n4);
                if (nameList.nlID != n) continue;
                bl = false;
            }
            object.removeElementAt(n4);
            ++n3;
        }
        TableRow tableRow = new TableRow();
        object = this.getColumnComboItems(n);
        this.makeColumnComboFromItems(tableRow, (Vector)object);
        ColumnDescriptor columnDescriptor = this.descriptorArray[n];
        this.newTableRow(columnDescriptor, tableRow);
        this.makeFilterSpecDelButton(tableRow);
        this.filterSpecs[this.nFilters] = tableRow;
        ++this.nFilters;
        this.table.refresh();
    }

    private void okPressed() {
        ColumnFilter columnFilter;
        GeneralException generalException = null;
        TableRow tableRow = null;
        List list = null;
        try {
            int n = 0;
            while (n < this.nFilters) {
                tableRow = this.filterSpecs[n];
                this.getAdjustedData(tableRow);
                if (tableRow.upperLimit != null) {
                    this.undeceive(tableRow);
                    list = this.validateBetween(this.filterSpecs[n], list);
                }
                ++n;
            }
        }
        catch (GeneralException generalException2) {
            generalException = generalException2;
        }
        if (generalException != null) {
            GuiUtil.displayException(generalException);
            if (this.invalidField != null) {
                JComponent jComponent = this.invalidField instanceof EnumeratedMultipleFreeForm || this.invalidField instanceof DateFreeForm ? tableRow.editButton : (JComponent)this.invalidField.getComponent();
                jComponent.requestFocus();
            }
            return;
        }
        if (list != null) {
            if (!GuiUtil.getConfirmation(this.dialog, "STG3284L", "STG3285T", true)) {
                tableRow = (TableRow)list.get(0);
                tableRow.lowerLimit.getComponent().requestFocus();
                return;
            }
            int n = list.size() - 1;
            while (n >= 0) {
                ColumnFilterValue columnFilterValue;
                tableRow = (TableRow)list.get(n);
                columnFilter = tableRow.filter;
                ColumnFilterValue columnFilterValue2 = columnFilter.clfValueList;
                columnFilter.clfValueList = columnFilterValue = columnFilterValue2.fvNext;
                columnFilterValue.fvNext = columnFilterValue2;
                columnFilterValue2.fvNext = null;
                --n;
            }
        }
        if (this.nFilters == 0) {
            this.grr.columnFilters = null;
        } else {
            this.grr.columnFilters = new ColumnFilter[this.nFilters];
            int n = 0;
            while (n < this.nFilters) {
                columnFilter = this.filterSpecs[n].filter;
                columnFilter.clfValue = (ColumnFilterValue[])Packer.pack(columnFilter.clfValueList);
                columnFilter.clfValueList = null;
                this.grr.columnFilters[n] = columnFilter;
                ++n;
            }
        }
        this.grr.filtersIgnoreCase = !this.caseSensitive.isSelected();
        this.grr.orFilters = this.orFilters.isSelected();
        this.dialog.dispose();
    }

    private List validateBetween(TableRow tableRow, List arrayList) {
        boolean bl;
        ColumnFilter columnFilter = tableRow.filter;
        ColumnFilterValue columnFilterValue = columnFilter.clfValueList;
        Comparable comparable = (Comparable)columnFilterValue.fvValue;
        Comparable comparable2 = (Comparable)columnFilterValue.fvNext.fvValue;
        if (columnFilter.clfDataType != 1 || this.caseSensitive.isSelected()) {
            bl = comparable.compareTo(comparable2) <= 0;
        } else {
            String string = (String)((Object)comparable);
            String string2 = (String)((Object)comparable2);
            boolean bl2 = bl = string.compareToIgnoreCase(string2) <= 0;
        }
        if (!bl) {
            if (arrayList == null) {
                arrayList = new ArrayList<TableRow>();
            }
            arrayList.add(tableRow);
        }
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        char c = actionEvent.getActionCommand().charAt(0);
        switch (c) {
            case '+': {
                this.addPressed();
                break;
            }
            case 'A': {
                this.deleteAllPressed();
                break;
            }
            case 'K': {
                this.okPressed();
                break;
            }
            case 'X': {
                this.dialog.dispose();
            }
        }
    }

    private class TableRow
    implements ActionListener,
    ItemListener {
        public ColumnFilter filter;
        public JButton deleteButton;
        public JComboBox columnCombo;
        public JComboBox operatorCombo;
        public FreeForm lowerLimit;
        public FreeForm upperLimit;
        public JButton editButton;

        private TableRow() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            if (itemEvent.getSource() == this.operatorCombo) {
                ReportFilterDialog.this.operatorChanged(this);
                this.operatorCombo.requestFocus();
            } else {
                ReportFilterDialog.this.columnChanged(this);
                this.columnCombo.requestFocus();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.editButton) {
                ReportFilterDialog.this.editButtonPressed(this);
            } else {
                ReportFilterDialog.this.deleteButtonPressed(this);
            }
        }
    }
}

