/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.File;
import java.io.FilenameFilter;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;

public class JobUtil
implements FilenameFilter,
Comparator {
    public static final int RESTART = -4096;
    public static String scriptsDir = "scripts";
    private static NumberFormat schedRunFormat;
    private static NumberFormat jobRunFormat;
    private SortedMap sorter;
    private RunReq run;
    private long purgeBefore;
    private boolean purgeNecessary;

    public static void setUpScriptsDir(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("scripts");
        scriptsDir = stringBuffer.toString();
    }

    private int componentMatches(String string, String string2, int n) {
        int n2 = string2.indexOf(46, n);
        if (n2 < 0) {
            return n2;
        }
        if (!string.regionMatches(0, string2, n, n2 - n)) {
            return -1;
        }
        return n2 + 1;
    }

    public boolean accept(File file, String string) {
        int n = string.length();
        if (n < 20) {
            return false;
        }
        if (!string.endsWith(".log")) {
            return false;
        }
        String string2 = string.substring(0, n - 4);
        int n2 = string2.indexOf(46);
        if (n2 < 0) {
            return false;
        }
        File file2 = new File(file, string);
        long l = file2.lastModified();
        if (l < this.purgeBefore) {
            return true;
        }
        if (this.sorter == null) {
            return false;
        }
        if (!string.regionMatches(0, this.run.getSchedCreator(), 0, n2)) {
            return false;
        }
        n2 = this.componentMatches(this.run.getSchedName(), string, n2 + 1);
        if (n2 < 0) {
            return false;
        }
        if ((n2 = string.indexOf(95, n2)) < 0) {
            return false;
        }
        if (this.componentMatches(this.run.getJobName(), string, n2 + 1) >= 0) {
            Long l2 = new Long(l);
            this.sorter.put(l2, string);
        }
        return false;
    }

    public int compare(Object object, Object object2) {
        Long l = (Long)object;
        Long l2 = (Long)object2;
        return -l.compareTo(l2);
    }

    private JobUtil(RunReq runReq) {
        this.run = runReq;
        if (this.run.getRetainDays() <= 0) {
            this.purgeBefore = Long.MIN_VALUE;
        } else {
            long l = this.run.getRetainDays();
            l *= 86400000L;
            if (Variables.whoAmI == 2) {
                this.purgeBefore = System.currentTimeMillis() - l;
                this.purgeNecessary = true;
            } else {
                try {
                    this.purgeBefore = CurrentTime.getTimestamp().getTime() - l;
                    this.purgeNecessary = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception(JobUtil.class.getName(), "constructor", exception);
                    }
                    return;
                }
            }
        }
        if (this.run.getRetention() > 0) {
            this.sorter = new TreeMap(this);
            this.purgeNecessary = true;
        }
    }

    public static void purgeLogFiles(RunReq runReq, String string) {
        File file;
        JobUtil jobUtil = new JobUtil(runReq);
        if (!jobUtil.purgeNecessary) {
            return;
        }
        File file2 = new File(string);
        String[] stringArray = file2.list(jobUtil);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                file = new File(file2, stringArray[n]);
                file.delete();
                ++n;
            }
        }
        if (jobUtil.sorter == null) {
            return;
        }
        int n = 0;
        Iterator iterator = jobUtil.sorter.values().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (++n <= runReq.getRetention()) continue;
            file = new File(file2, string2);
            file.delete();
        }
    }

    public static WindowsScript resolveWindowsScript(String string, StringBuffer stringBuffer) {
        WindowsScript windowsScript = null;
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            File file = new File(String.valueOf(scriptsDir) + File.separatorChar + string);
            if (file.exists()) {
                string2 = string.substring(n + 1);
                int n2 = WindowsScript.indexForExtension(string2);
                windowsScript = new WindowsScript(n2, string);
            }
        } else {
            int n3 = Integer.MAX_VALUE;
            String string3 = null;
            File file = new File(scriptsDir);
            Matcher matcher = new Matcher(string);
            String[] stringArray = file.list(matcher);
            if (stringArray != null) {
                int n4 = 0;
                while (n4 < stringArray.length) {
                    string2 = stringArray[n4].substring(matcher.length);
                    int n5 = WindowsScript.indexForExtension(string2);
                    if (n5 < n3) {
                        n3 = n5;
                        string3 = stringArray[n4];
                    }
                    ++n4;
                }
                if (string3 != null) {
                    windowsScript = new WindowsScript(n3, string3);
                    if (stringBuffer != null) {
                        stringBuffer.append(string2);
                    }
                }
            }
        }
        return windowsScript;
    }

    public static WindowsScript resolveWindowsScript(String string) {
        return JobUtil.resolveWindowsScript(string, null);
    }

    public static String resolveUnixScript(String string, StringBuffer stringBuffer) {
        File file;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if (stringBuffer != null) {
            stringBuffer.append(string);
        }
        if (!(file = new File(String.valueOf(scriptsDir) + File.separatorChar + string)).exists()) {
            string = null;
        }
        return string;
    }

    public static String resolveUnixScript(String string) {
        return JobUtil.resolveUnixScript(string, null);
    }

    private static class Matcher
    implements FilenameFilter {
        private String root;
        public int length;

        public Matcher(String string) {
            this.root = String.valueOf(string) + '.';
            this.length = this.root.length();
        }

        public boolean accept(File file, String string) {
            return this.root.regionMatches(true, 0, string, 0, this.length);
        }
    }
}

