/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintOptions
implements Serializable {
    static final long serialVersionUID = -3533266123877784522L;
    public static final byte PRINTER = 1;
    public static final byte PDF = 2;
    public static final byte HTML = 3;
    public static final byte PS = 4;
    public static final byte PCL = 5;
    public static final byte SCREEN = 6;
    public static final byte CSV = 7;
    public static final byte FORMATTED = 8;
    public static final byte PORTRAIT = 1;
    public static final byte LANDSCAPE = 2;
    public static final byte LETTER = 1;
    public static final byte A4 = 2;
    public Object printer;
    public FileOutputStream outFile;
    public byte outputType;
    public byte orientation;
    public byte size = 1;
    public boolean includeHeaders;
    public boolean includeTotals;
    public String creator;
    public String title;
    public String fileMask;
    public String fileName;
    public boolean partialLandscape;
    public int defaultWidth;
    public int defaultHeight;
    public transient AperiChart htmlChart;

    public void printTitle(FileOutputStream fileOutputStream) {
        String string = MessageLog.getMessageNoID("GEN0192L");
        String string2 = MessageLog.getMessageNoID("GEN0193L");
        OutputStreamWriter outputStreamWriter = null;
        PrintWriter printWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        }
        catch (Exception exception) {
            GuiUtil.displayErrorMessage(exception.getMessage());
        }
        printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        if (printWriter != null) {
            printWriter.println("<html>");
            if (this.title != null) {
                printWriter.println(this.title);
                printWriter.println("");
            }
            if (this.creator != null) {
                printWriter.println(String.valueOf(string) + " " + this.creator + "      " + string2 + " " + Util.formatDateTime(Calendar.getInstance().getTime()));
                printWriter.println("");
            }
        }
    }
}

