/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Timer;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Unzip {
    private final String DEFAULT_PERM = "755";
    boolean bInterrupted = false;
    private Process process = null;

    private void ensureDirectoryExists(String string) throws LocalizableException {
        File file;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "ensureDirectoryExists", "directory");
        }
        if ((file = new File(string)).exists()) {
            if (file.isDirectory()) {
                return;
            }
            Object[] objectArray = new Object[]{string};
            throw new LocalizableException("INS2078E", objectArray);
        }
        String string2 = file.getParent();
        if (string2 != null) {
            this.ensureDirectoryExists(string2);
        }
        file.mkdir();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "ensureDirectoryExists");
        }
    }

    private boolean doCopy(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        boolean bl = false;
        byte[] byArray = new byte[2000];
        boolean bl2 = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "doCopy", "in,out,inFileName,outFileName");
        }
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                bl2 = true;
                outputStream.write(byArray, 0, n);
                bl2 = false;
            }
            bl2 = true;
            outputStream.close();
            bl = true;
        }
        catch (IOException iOException) {
            String string3;
            Object[] objectArray = new Object[1];
            if (bl2) {
                string3 = "GEN0152E";
                objectArray[0] = string2;
            } else {
                string3 = "GEN0209E";
                objectArray[0] = string;
            }
            MessageLog.logException(string3, (Exception)iOException, objectArray);
        }
        if (!bl) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "doCopy");
        }
        return bl;
    }

    private ZipEntry nextEntry(ZipInputStream zipInputStream, MutableBoolean mutableBoolean) {
        ZipEntry zipEntry = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "nextEntry", "in,status");
        }
        try {
            zipEntry = zipInputStream.getNextEntry();
        }
        catch (IOException iOException) {
            MessageLog.logException("GEN0552E", iOException);
            mutableBoolean.value = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "nextEntry");
        }
        return zipEntry;
    }

    public boolean unZIP(String string, String string2) {
        return this.unZIP(string, string2, "755", false);
    }

    public boolean unZIP(String string, String string2, String string3, boolean bl) {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "unZIP", "strZipFileName,strOutDir,strPerm, bDoNotSetPermOnExistFiles");
        }
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            return false;
        }
        boolean bl2 = Unzip.isWindows();
        MutableBoolean mutableBoolean = new MutableBoolean(true);
        while (mutableBoolean.value && (zipEntry = this.nextEntry(zipInputStream, mutableBoolean)) != null) {
            Object object;
            String string4 = zipEntry.getName();
            if (bl2 && (string4.length() <= 1 || string4.charAt(0) != ':')) {
                string4 = String.valueOf(string2) + "\\" + string4;
            }
            if (!(bl2 || string4.length() > 0 && string4.charAt(0) == '/')) {
                string4 = String.valueOf(string2) + "/" + string4;
            }
            if (zipEntry.isDirectory()) {
                string4 = string4.substring(0, string4.length() - 1);
                try {
                    this.ensureDirectoryExists(string4);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    mutableBoolean.value = false;
                }
                continue;
            }
            int n = string4.lastIndexOf(47);
            if (n > 0) {
                object = string4.substring(0, n);
                try {
                    this.ensureDirectoryExists((String)object);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    mutableBoolean.value = false;
                    continue;
                }
            }
            object = null;
            boolean bl3 = true;
            if (bl) {
                bl3 = new File(string4).exists();
            }
            try {
                if (string4.endsWith(".so") && new File(string4).exists()) {
                    new File(string4).delete();
                    bl3 = false;
                }
                object = new FileOutputStream(string4);
            }
            catch (IOException iOException) {
                MessageLog.logException("GEN0036E", iOException);
            }
            if (object == null) {
                mutableBoolean.value = false;
                continue;
            }
            mutableBoolean.value = this.doCopy(zipInputStream, (OutputStream)object, string, string4);
            if (mutableBoolean.value) {
                try {
                    if (!bl || !bl3) {
                        this.makeExecutable(string4, string3);
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    mutableBoolean.value = false;
                }
            }
            if (!mutableBoolean.value) continue;
            File file = new File(string4);
            file.setLastModified(zipEntry.getTime());
        }
        try {
            zipInputStream.close();
        }
        catch (IOException iOException) {}
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "unZIP");
        }
        return mutableBoolean.value;
    }

    private boolean makeExecutable(String string, String string2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "makeExecutable", "strFileName,strPermission");
        }
        if (System.getProperty("os.name").startsWith("Win")) {
            return true;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "makeExecutable");
        }
        if (string2 != null && string2.trim().length() > 0) {
            String[] stringArray = new String[]{"sh", "-c", "chmod " + string2 + " \"" + this.AddEscapeChar(string, '$') + "\""};
            return this.executeAction(stringArray);
        }
        return true;
    }

    private String AddEscapeChar(String string, char c) {
        int n = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "AddEscapeChar", "strFileName,cEscapeChar");
        }
        while ((n = string.indexOf(c, n)) != -1) {
            string = String.valueOf(string.substring(0, n)) + "\\" + string.substring(n);
            n += 2;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "AddEscapeChar");
        }
        return string;
    }

    private boolean executeAction(String[] stringArray) {
        Object object;
        int n = 60;
        Timer timer = null;
        this.bInterrupted = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "executeAction", "strCommandArr");
        }
        if (stringArray == null || stringArray.length == 0 || stringArray[0].trim().length() == 0) {
            return false;
        }
        try {
            Object object2;
            object = DateFormat.getDateTimeInstance(3, 1);
            ((DateFormat)object).format(new Date());
            this.process = stringArray.length == 1 ? Runtime.getRuntime().exec(stringArray[0]) : Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            try {
                object2 = "";
                while ((object2 = bufferedReader.readLine()) != null) {
                    System.out.println((String)object2);
                }
            }
            catch (IOException iOException) {}
            try {
                while (bufferedReader2.readLine() != null) {
                }
            }
            catch (IOException iOException) {}
            ((DateFormat)object).format(new Date());
            object2 = new TimerTask();
            timer = new Timer(n * 1000, (ActionListener)object2);
            timer.setRepeats(false);
            timer.start();
            ((DateFormat)object).format(new Date());
            this.process.waitFor();
            ((DateFormat)object).format(new Date());
            if (timer != null) {
                ((DateFormat)object).format(new Date());
                timer.stop();
                ((DateFormat)object).format(new Date());
            }
            try {
                bufferedReader.close();
                bufferedReader2.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException.getMessage());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "executeAction");
        }
        if (this.bInterrupted) {
            return true;
        }
        if (this.process == null || this.process.exitValue() != 0) {
            object = "";
            int n2 = 0;
            while (n2 < stringArray.length) {
                object = String.valueOf(object) + stringArray[n2] + " ";
                ++n2;
            }
            return false;
        }
        return true;
    }

    private void sendInterrupt() {
        if (this.process != null) {
            this.bInterrupted = true;
            this.process.destroy();
        }
        Thread.currentThread().interrupt();
    }

    public static void main(String[] stringArray) {
        Unzip unzip = new Unzip();
        boolean bl = Unzip.isWindows();
        int n = 4;
        if (bl) {
            n = 2;
        }
        if (stringArray.length < n) {
            Unzip.printUsage();
            return;
        }
        if (bl) {
            unzip.unZIP(stringArray[0], stringArray[1]);
        } else {
            boolean bl2 = false;
            if (stringArray[3].trim().compareToIgnoreCase("true") == 0) {
                bl2 = true;
            }
            unzip.unZIP(stringArray[0], stringArray[1], stringArray[2], bl2);
        }
    }

    static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Win");
    }

    public static void printUsage() {
        boolean bl = Unzip.isWindows();
        if (!bl) {
            System.out.println("Usage: unzip <zipFileName> <ExtractLocation> <Permission> <DoNotSetPermOnExistingFiles>");
        } else {
            System.out.println("Usage: unzip <zipFileName> <ExtractLocation>");
        }
        System.out.println("       zipFileName: This is the name of the zip file you want to unzip.");
        System.out.println("       ExtractLocation: Location where you want to unzip files.");
        if (!bl) {
            System.out.println("       Permission: Unix permission format. e.g. 755");
            System.out.println("       DoNotSetPermOnExistingFiles: True if you do not want to change permission on existing files else False");
        }
    }

    private class TimerTask
    implements ActionListener {
        private TimerTask() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Unzip.this.sendInterrupt();
        }
    }
}

