/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.identifier;

import org.eclipse.aperi.common.identifier.DeviceId;
import org.eclipse.aperi.common.identifier.SRMIdentifier;

public abstract class ComponentId
extends SRMIdentifier {
    private DeviceId tdiDevId;
    static final long serialVersionUID = 6208430139381340757L;

    public ComponentId(DeviceId deviceId, String string) throws IllegalArgumentException {
        this(deviceId, string, null);
    }

    public ComponentId(DeviceId deviceId, String string, String string2) throws IllegalArgumentException {
        super(string, string2);
        this.setDeviceId(deviceId);
    }

    public final DeviceId getDeviceId() {
        return this.tdiDevId;
    }

    public synchronized void setDeviceId(DeviceId deviceId) {
        if (deviceId == null) {
            throw new IllegalArgumentException("The specified device ID is invalid (null).");
        }
        this.tdiDevId = deviceId;
    }

    public boolean equals(Object object) {
        if (object instanceof ComponentId) {
            return super.equals(object) && this.tdiDevId.equals(((ComponentId)object).tdiDevId);
        }
        return false;
    }

    public int compareTo(Object object) {
        int n = this.tdiDevId.compareTo(((ComponentId)object).tdiDevId);
        if (n == 0) {
            n = super.compareTo(object);
        }
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public boolean isIdentical(Object object) {
        return object instanceof ComponentId && this.tdiDevId.isIdentical(((ComponentId)object).tdiDevId) && super.isIdentical(object);
    }

    public int hashCode() {
        String string = this.getInternalName();
        int n = string.length();
        return (n < 4 ? 0 : string.charAt(n - 4) << 24) + (n < 3 ? 0 : string.charAt(n - 3) << 16) + (n < 2 ? 0 : string.charAt(n - 2) << 8) + (n < 1 ? 0 : (int)string.charAt(n - 1));
    }

    public String toString() {
        return String.valueOf(this.getInternalName()) + '+' + this.tdiDevId.toString();
    }

    public Object clone() {
        ComponentId componentId = (ComponentId)super.clone();
        componentId.tdiDevId = (DeviceId)this.tdiDevId.clone();
        if (componentId.tdiDevId == null) {
            componentId = null;
        }
        return componentId;
    }
}

