/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;

public class PrintComponent {
    public static void print(PrintOptions printOptions, Component component, String string, String string2, String string3, boolean bl) {
        if (printOptions != null) {
            printOptions.creator = string;
            printOptions.title = string2;
            printOptions.fileMask = string3;
            if (printOptions.fileName == null && (printOptions.outputType == 2 || printOptions.outputType == 3 || printOptions.outputType == 4 || printOptions.outputType == 7 || printOptions.outputType == 8 || printOptions.outputType == 5)) {
                printOptions.fileName = PrintTableData.getFileName(printOptions);
                if (printOptions.fileName == null) {
                    return;
                }
            }
            if (bl) {
                printOptions.partialLandscape = true;
            }
            if (printOptions.htmlChart != null && printOptions.outputType == 3) {
                PrintComponent.printHTMLChart(printOptions);
                return;
            }
            PrintManager.getPrinter(printOptions);
            if (printOptions.printer != null) {
                String cfr_ignored_0 = printOptions.title;
                if (printOptions.creator != null && printOptions.outputType == 1) {
                    byte cfr_ignored_1 = printOptions.orientation;
                }
                byte cfr_ignored_2 = printOptions.outputType;
                PrintManager.printDocument(printOptions);
            }
        }
    }

    private static void printHTMLChart(PrintOptions printOptions) {
        printOptions.outFile = null;
        OutputStreamWriter outputStreamWriter = null;
        PrintWriter printWriter = null;
        AperiChartAdapter aperiChartAdapter = null;
        AperiChart aperiChart = printOptions.htmlChart;
        Component[] componentArray = aperiChart.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof AperiChartAdapter) {
                aperiChartAdapter = (AperiChartAdapter)componentArray[n];
            }
            ++n;
        }
        if (aperiChartAdapter != null) {
            try {
                printOptions.outFile = new FileOutputStream(printOptions.fileName);
            }
            catch (IOException iOException) {
                GuiUtil.displayErrorMessage(iOException.getMessage());
                printOptions.outFile = null;
            }
            int n2 = aperiChartAdapter.getHeight();
            int n3 = aperiChartAdapter.getWidth();
            if (n2 <= 0 || n3 <= 0) {
                n2 = printOptions.defaultHeight;
                n3 = printOptions.defaultWidth;
                aperiChartAdapter.setSize(n3, n2);
            }
            BufferedImage bufferedImage = new BufferedImage(n3, n2, 1);
            aperiChartAdapter.paint(bufferedImage.createGraphics());
            int n4 = printOptions.fileName.lastIndexOf(File.separatorChar);
            String string = printOptions.fileName.substring(0, n4 + 1);
            String string2 = "img" + System.currentTimeMillis() + ".png";
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string) + string2);
                if (!ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream)) {
                    System.out.println("PrintComponent.printHTMLChart: Failed to create PNG image file.");
                }
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                GuiUtil.displayErrorMessage(iOException.getMessage());
            }
            if (printOptions.outFile != null) {
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)printOptions.outFile, "UTF-8");
                    printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                }
                catch (Exception exception) {
                    GuiUtil.displayErrorMessage(exception.getMessage());
                }
            }
            if (printWriter != null) {
                printWriter.println("<html>");
                printWriter.println("<head>");
                printWriter.print("<title>");
                printWriter.print(printOptions.title);
                printWriter.println("</title>");
                printWriter.println(" ");
                printWriter.print("<meta http-equiv=\"Content-Type\" ");
                printWriter.println("content=\"text/html; charset=UTF-8\" />");
                printWriter.println("<style type=\"text/css\">");
                printWriter.println("   .title   { color: #000066  }");
                printWriter.println("   table.report { background-color: #FFFFFF   }");
                printWriter.println("   tr.header { background-color: #6666FF  }");
                printWriter.println("   tr.totals { background-color: #FFFF99 }");
                printWriter.println("   tr.gray   { background-color: #CCCCFF   }");
                printWriter.println("</style>");
                printWriter.println(" ");
                printWriter.println("</head>");
                printWriter.println("<body>");
                printWriter.println(" ");
                printWriter.print("<h2 class=\"title\">");
                printWriter.print(printOptions.title);
                printWriter.println("</h2>");
                printWriter.println(" ");
                printWriter.print("<h4 class=\"title\">");
                printWriter.print(PrintPreviewable.CREATED_BY);
                printWriter.print(" ");
                printWriter.print(printOptions.creator);
                printWriter.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                printWriter.print(PrintPreviewable.PRINTED_ON);
                printWriter.print(" ");
                printWriter.print(DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime()));
                printWriter.println("</h4>");
                printWriter.println(" ");
                printWriter.println("<br>");
                printWriter.println("<br>");
                printWriter.println("<p align=\"center\">");
                printWriter.print("<img src=\"");
                printWriter.print(string2);
                printWriter.print("\" width=\"" + n3);
                printWriter.print("\" height=\"" + n2);
                printWriter.println("\" alt=\"" + printOptions.title + "\">");
                printWriter.println("</p>");
                printWriter.println(" ");
                printWriter.println("</body>");
                printWriter.println("</html>");
                printWriter.close();
            }
        }
    }
}

