/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.aperi.gui.SizeLimitedDocument;

public class TTextField
extends JTextField
implements ActionListener,
DocumentListener {
    private boolean onDialog;
    private boolean disable = true;
    private JButton defaultButton;

    private TTextField(Document document, String string, int n, boolean bl) {
        super(document, string, n);
        this.onDialog = bl;
        if (this.onDialog) {
            document.addDocumentListener(this);
        }
        this.addActionListener(this);
    }

    private TTextField(Document document, String string, int n, boolean bl, boolean bl2) {
        super(document, string, n);
        this.onDialog = bl;
        this.disable = bl2;
        if (this.onDialog) {
            document.addDocumentListener(this);
        }
        this.addActionListener(this);
    }

    public static TTextField newTTextField(String string, int n, int n2, boolean bl, boolean bl2) {
        SizeLimitedDocument sizeLimitedDocument = new SizeLimitedDocument(n2, bl);
        return new TTextField(sizeLimitedDocument, string, n, bl2);
    }

    public static TTextField newTTextField(String string, int n, int n2, boolean bl) {
        return TTextField.newTTextField(string, n, n2, bl, false);
    }

    public static TTextField newTTextField(String string, int n, boolean bl) {
        return TTextField.newTTextField(string, n, n, bl);
    }

    public static TTextField newTTextField(int n, boolean bl) {
        return TTextField.newTTextField(null, n, n, bl);
    }

    public static TTextField newTTextField(int n, int n2, boolean bl) {
        return TTextField.newTTextField(null, n, n2, bl);
    }

    public static TTextField newTTextField(Document document, String string, int n, boolean bl) {
        return new TTextField(document, string, n, bl);
    }

    public static TTextField newTTextField(Document document, String string, int n, boolean bl, boolean bl2) {
        return new TTextField(document, string, n, bl, bl2);
    }

    public void setDisable(boolean bl) {
        this.disable = bl;
    }

    public String getText() {
        String string = super.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private void getDefaultButton() {
        if (this.defaultButton != null) {
            return;
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            this.defaultButton = jRootPane.getDefaultButton();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.onDialog) {
            FocusManager.getCurrentManager().focusNextComponent(this);
            return;
        }
        String string = this.getText();
        if (string.length() == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.getDefaultButton();
        if (this.defaultButton != null) {
            this.defaultButton.doClick();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.getDefaultButton();
        if (this.defaultButton != null) {
            this.defaultButton.setEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        Document document;
        if (this.disable && (document = documentEvent.getDocument()).getLength() == 0) {
            this.getDefaultButton();
            if (this.defaultButton != null) {
                this.defaultButton.setEnabled(false);
            }
        }
    }
}

