/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JTable;
import javax.swing.RepaintManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TablePrinter
extends Component
implements Printable {
    private JTable pTable;
    private String pTitle;
    private PrinterJob printJob = PrinterJob.getPrinterJob();
    private PageFormat pageFormat = this.printJob.defaultPage();
    private JTableHeader tableHeader;
    private int[] pageWidths = null;
    private boolean pageinfoCalculated = false;
    private int totalNumPages = 0;
    private int prevPageIndex = 0;
    private int subPageIndex = 0;
    private int numPagesWide = 1;
    private double tableHeightOnFullPage;
    private double headerHeight;
    private double pageWidth;
    private double pageHeight;
    private int fontHeight;
    private int fontDesent;
    private double tableHeight;
    private double rowHeight;

    public static void printTable(JTable jTable, String string) {
        TablePrinter tablePrinter = new TablePrinter();
        tablePrinter.pTable = jTable;
        tablePrinter.pTitle = string;
        RepaintManager.currentManager(tablePrinter).setDoubleBufferingEnabled(false);
        tablePrinter.pageFormat.setOrientation(0);
        tablePrinter.printJob.setPrintable(tablePrinter, tablePrinter.pageFormat);
        try {
            tablePrinter.printJob.print();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.pageinfoCalculated) {
            this.getPageInfo(graphics, pageFormat);
        }
        graphics2D.setColor(Color.black);
        if (n >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != n) {
            ++this.subPageIndex;
            if (this.subPageIndex == this.numPagesWide) {
                this.subPageIndex = 0;
            }
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n2 = n / this.numPagesWide;
        this.printTablePart(graphics2D, pageFormat, n2, this.subPageIndex);
        this.prevPageIndex = n;
        return 0;
    }

    public void getPageInfo(Graphics graphics, PageFormat pageFormat) {
        this.pageWidths = null;
        this.prevPageIndex = 0;
        this.fontHeight = graphics.getFontMetrics().getHeight();
        this.fontDesent = graphics.getFontMetrics().getDescent();
        this.tableHeader = this.pTable.getTableHeader();
        this.tableHeader.getWidth();
        this.headerHeight = this.tableHeader.getHeight() + this.pTable.getRowMargin();
        this.pageHeight = pageFormat.getImageableHeight();
        this.pageWidth = pageFormat.getImageableWidth();
        this.pTable.getColumnModel().getTotalColumnWidth();
        this.tableHeight = this.pTable.getHeight();
        this.rowHeight = this.pTable.getRowHeight() + this.pTable.getRowMargin();
        this.tableHeightOnFullPage = (int)(this.pageHeight - this.headerHeight - (double)(this.fontHeight * 2));
        this.tableHeightOnFullPage = (double)((int)(this.tableHeightOnFullPage / this.rowHeight)) * this.rowHeight;
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int n2 = tableColumnModel.getColumnMargin();
        int[] nArray = new int[n];
        int n3 = 0;
        nArray[0] = 0;
        int n4 = 0;
        this.numPagesWide = 1;
        while (n3 < n) {
            int n5 = tableColumnModel.getColumn(n3).getWidth();
            if ((double)(n4 + n5 + n2) > this.pageWidth) {
                nArray[this.numPagesWide] = nArray[this.numPagesWide - 1] + n4;
                n4 = n5;
                ++this.numPagesWide;
            } else {
                n4 += n5 + n2;
            }
            ++n3;
        }
        nArray[this.numPagesWide] = nArray[this.numPagesWide - 1] + n4;
        this.pageWidths = new int[this.numPagesWide + 1];
        int n6 = 0;
        while (n6 <= this.numPagesWide) {
            this.pageWidths[n6] = nArray[n6];
            ++n6;
        }
        this.totalNumPages = (int)(this.tableHeight / this.tableHeightOnFullPage);
        if (this.tableHeight % this.tableHeightOnFullPage >= this.rowHeight) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.numPagesWide;
        this.pageinfoCalculated = true;
    }

    public void printTablePart(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        String string = "Page: " + (n + 1);
        if (this.numPagesWide > 1) {
            string = String.valueOf(string) + "-" + (n2 + 1);
        }
        int n3 = this.pageWidths[n2];
        int n4 = this.pageWidths[n2 + 1];
        graphics2D.drawString(this.pTitle, 5, (int)(this.pageHeight - (double)this.fontHeight));
        graphics2D.drawString(string, (int)this.pageWidth - 70, (int)(this.pageHeight - (double)this.fontHeight));
        double d = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)n * this.tableHeightOnFullPage);
        int n5 = n4 - n3;
        graphics2D.translate(-this.pageWidths[n2], 0);
        graphics2D.setClip(n3, 0, n5, (int)this.headerHeight);
        this.tableHeader.paint(graphics2D);
        graphics2D.translate(0.0, this.headerHeight);
        graphics2D.translate(0.0, -this.tableHeightOnFullPage * (double)n);
        graphics2D.setClip(n3, (int)this.tableHeightOnFullPage * n, n5, (int)d);
        this.pTable.paint(graphics2D);
        double d2 = this.tableHeightOnFullPage * (double)n - this.headerHeight;
        graphics2D.drawRect(n3, (int)d2, n5, (int)(d + this.headerHeight));
    }
}

