/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public class WindowMenu
extends JMenu
implements ActionListener,
MenuListener {
    private static final String WINDOW = Util.getString("LABEL_WINDOW_MENU");
    private static final String closeAllStr = MessageLog.getMessageNoID("GUI0063L");
    private static final String showDashStr = MessageLog.getMessageNoID("GUI6001L");
    private static final String showWindowsStr = MessageLog.getMessageNoID("GUI0082L");
    private static final JMenuItem closeAll = new JMenuItem(closeAllStr);
    private static final JMenuItem showDash = new JMenuItem(showDashStr);
    private final JMenu showWindows = new windowJMenu(showWindowsStr);
    private static Icon redPointer = IconFactory.getCurrentPointerChangesPendingIcon();
    private static Icon blackPointer = IconFactory.getCurrentPointerIcon();
    private static Icon blank = IconFactory.getBlankIcon(redPointer.getIconWidth());

    public WindowMenu() {
        super(WINDOW);
        super.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_WINDOW"));
        super.getAccessibleContext().setAccessibleName(WINDOW);
        super.getAccessibleContext().setAccessibleDescription(WINDOW);
        GuiUtil.setAccessible(closeAll, closeAllStr, closeAllStr);
        GuiUtil.setAccessible(showDash, showDashStr, showDashStr);
        GuiUtil.setAccessible(this.showWindows, showWindowsStr, showWindowsStr);
        closeAll.addActionListener(this);
        closeAll.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        showDash.addActionListener(this);
        this.add(closeAll);
        this.add(showDash);
        this.add(this.showWindows);
        this.addMenuListener(this);
    }

    public void menuDeselected(MenuEvent menuEvent) {
        closeAll.setEnabled(true);
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.showWindows.removeAll();
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
        DataDisplayInfo dataDisplayInfo2 = DataDisplayInfo.getCurrent();
        int n = 0;
        while (dataDisplayInfo != null) {
            JMenuItem jMenuItem = new JMenuItem(dataDisplayInfo.getDescription());
            jMenuItem.setActionCommand(Integer.toString(n++));
            jMenuItem.addActionListener(this);
            if (dataDisplayInfo == dataDisplayInfo2) {
                if (dataDisplayInfo.changesPending()) {
                    jMenuItem.setIcon(redPointer);
                } else {
                    jMenuItem.setIcon(blackPointer);
                }
            } else if (dataDisplayInfo.changesPending()) {
                jMenuItem.setIcon(IconFactory.getRedLightIcon());
            } else {
                jMenuItem.setIcon(blank);
            }
            this.showWindows.add(jMenuItem);
            dataDisplayInfo = dataDisplayInfo.getNext();
        }
        this.showWindows.setEnabled(n != 0);
        closeAll.setEnabled(n != 0);
        showDash.setEnabled(GuiManager.getGuiManager().getGuiMain().getNullDDI().panel == null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        if (actionEvent.getSource() == closeAll) {
            DataDisplayInfo.removeAllWithoutChanges();
            iGuiMain.removeAllDDIChanged();
            if (DataDisplayInfo.getCurrent() == null) {
                iGuiMain.showNull();
            } else {
                DataDisplayInfo.getCurrent().reDisplay();
            }
        } else if (actionEvent.getSource() == showDash) {
            iGuiMain.showNull();
        } else {
            int n = Integer.decode(actionEvent.getActionCommand());
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
            int n2 = 0;
            while (n2++ < n) {
                dataDisplayInfo = dataDisplayInfo.getNext();
            }
            dataDisplayInfo.reDisplay();
        }
    }

    class windowJMenu
    extends JMenu {
        public windowJMenu(String string) {
            super(string);
        }

        protected Point getPopupMenuOrigin() {
            int n = 0;
            int n2 = 0;
            JPopupMenu jPopupMenu = this.getPopupMenu();
            jPopupMenu.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            Dimension dimension3 = jPopupMenu.getPreferredSize();
            Point point = this.getLocationOnScreen();
            n = point.x + dimension2.width + dimension3.width < dimension.width ? dimension2.width : 0 - dimension3.width;
            n2 = point.y + dimension3.height < dimension.height - 26 ? 0 : dimension.height - 26 - point.y - dimension3.height;
            return new Point(n, n2);
        }
    }
}

