/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.xmsg.MessageLog;

public class JobDetail
extends JPanel
implements ActionListener {
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private JLabel iHeader = new JLabel(MessageLog.getMessageNoID("ADG0226L", null));
    private JLabel iBlank0 = new JLabel(" ");
    private JLabel iSchedLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0215L", null)) + ":    ");
    private JLabel iSched = new JLabel();
    private JLabel iJobLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0216L", null)) + ":    ");
    private JLabel iJob = new JLabel();
    private JLabel iRunLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0217L", null)) + ":    ");
    private JLabel iRun = new JLabel();
    private JLabel iBlank1 = new JLabel(" ");
    private JLabel iStatusLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0218L", null)) + ":    ");
    private JLabel iStatus = new JLabel();
    private JLabel iToStartLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0220L", null)) + ":    ");
    private JLabel iToStart = new JLabel();
    private JLabel iStartedLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0221L", null)) + ":    ");
    private JLabel iStarted = new JLabel();
    private JLabel iFinishLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0224L", null)) + ":    ");
    private JLabel iFinish = new JLabel();
    private JLabel iElapsedLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0227L", null)) + ":    ");
    private JLabel iElapsed = new JLabel();
    private JLabel iRetCodeLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0225L", null)) + ":    ");
    private JLabel iRetCode = new JLabel();
    private JLabel iBlank3 = new JLabel(" ");
    private JLabel iBlank4 = new JLabel(" ");
    private JButton logButton = new JButton(MessageLog.getMessageNoID("ADG0017L", null));
    private JLabel iRunDoneLabel = new JLabel(MessageLog.getMessageNoID("ADG0228T", null));
    private JLabel iFiller1 = new JLabel("                         ");
    private JLabel iFiller2 = new JLabel(" ");
    private String INIT = MessageLog.getMessageNoID("ADG0234T", null);
    private String WAITING = MessageLog.getMessageNoID("ADG0235T", null);
    private String EXECUTING = MessageLog.getMessageNoID("ADG0236T", null);
    private String COMPLETED = MessageLog.getMessageNoID("ADG0237T", null);
    private String logFileName = null;
    private AgentTreeNode node = null;

    public JobDetail(StartedJob startedJob, AgentTreeNode agentTreeNode) {
        this.setLayout(this.gridBag);
        this.logFileName = startedJob.getLogFileName();
        this.node = agentTreeNode;
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        JobRun jobRun = startedJob.getJobRun();
        long l = startedJob.getStarted();
        long l2 = startedJob.getFinished();
        byte by = startedJob.getJobStatus();
        this.iSched.setText(String.valueOf(jobRun.getSchedCreator()) + "." + startedJob.getJobRun().getSchedName());
        this.iJob.setText(jobRun.getJobName());
        this.iRun.setText(Integer.toString(startedJob.getRunNumber()));
        switch (by) {
            case 87: {
                this.iStatus.setText(this.WAITING);
                break;
            }
            case 73: {
                this.iStatus.setText(this.INIT);
                break;
            }
            case 69: {
                this.iStatus.setText(this.EXECUTING);
                break;
            }
            case 67: {
                this.iStatus.setText(this.COMPLETED);
            }
        }
        this.iToStart.setText(jobRun.getDesiredStartTime() == 0L ? " " : dateFormat.format(new Date(jobRun.getDesiredStartTime())));
        if (l == 0L) {
            this.iStarted.setText(" ");
            this.iStartedLabel.setEnabled(false);
            this.iFinish.setText(" ");
            this.iFinishLabel.setEnabled(false);
            this.iElapsed.setText(" ");
            this.iElapsedLabel.setEnabled(false);
        } else {
            this.iStarted.setText(dateFormat.format(new Date(l)));
            this.iStartedLabel.setEnabled(true);
            if (l2 == 0L) {
                this.iFinish.setText(" ");
                this.iFinishLabel.setEnabled(false);
                this.iElapsed.setText(" ");
                this.iElapsedLabel.setEnabled(false);
            } else {
                this.iFinish.setText(dateFormat.format(new Date(l2)));
                this.iFinishLabel.setEnabled(true);
                this.iElapsed.setText(GuiUtil.formatElapsed(l2 - l, false));
                this.iElapsedLabel.setEnabled(true);
            }
        }
        this.iRetCode.setText(Integer.toString(startedJob.getExitCode()));
        this.gbConstraints.fill = 1;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.gridwidth = 2;
        this.gbConstraints.gridheight = 30;
        this.add((Component)this.iFiller1, this.gbConstraints);
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.weighty = 0.0;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iFiller2, this.gbConstraints);
        this.gbConstraints.weightx = 0.0;
        this.add((Component)this.iHeader, this.gbConstraints);
        this.iHeader.setFont(this.iHeader.getFont().deriveFont(16.0f));
        this.add((Component)this.iBlank0, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iSchedLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iSched, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iJobLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iJob, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iRunLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iRun, this.gbConstraints);
        this.add((Component)this.iBlank1, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iStatusLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iStatus, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iToStartLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iToStart, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iStartedLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iStarted, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iFinishLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iFinish, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iElapsedLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iElapsed, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        this.add((Component)this.iRetCodeLabel, this.gbConstraints);
        this.gbConstraints.gridwidth = 0;
        this.add((Component)this.iRetCode, this.gbConstraints);
        this.add((Component)this.iBlank3, this.gbConstraints);
        this.add((Component)this.iBlank4, this.gbConstraints);
        this.gbConstraints.gridwidth = 1;
        if (by == 69 || by == 67) {
            this.add((Component)this.logButton, this.gbConstraints);
        }
        this.logButton.addActionListener(this);
        this.logButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_VIEWLOG"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new LogViewer(this.node.computerID, (BaseTreeNode)this.node, this.logFileName);
    }
}

