/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.admin.ConfigSettingsDDI;
import org.eclipse.aperi.gui.admin.ConfigSettingsPanel;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogFileRetentionPanel
extends ConfigSettingsPanel
implements ComponentListener {
    private JTextField runsField;
    private JTextField daysField;
    private ConfigSettings settings;
    private boolean setFocus;
    private ConfigSettingsDDI ddi;
    private Component invalidField;

    public LogFileRetentionPanel(ConfigSettingsDDI configSettingsDDI) {
        this.ddi = configSettingsDDI;
        this.setFocus = false;
    }

    public JComponent getComponent(ConfigSettings configSettings) {
        this.settings = configSettings != null ? configSettings : this.makeDefaultSettings();
        String string = MessageLog.getMessageNoID("GUI2082L");
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.boldFont);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 6;
        gridBagConstraints.insets.left = 6;
        jPanel.add((Component)jLabel, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2084L");
        jLabel = new JLabel(string);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        string = String.valueOf(this.settings.csRetainCopies);
        this.runsField = TTextField.newTTextField(string, 3, 4, true);
        gridBagConstraints.insets.left = 4;
        GuiUtil.setAccessibleLabel(jLabel, this.runsField, "MNEMONIC_LABEL_RUNS", this.runsField.getText(), this.runsField.getText());
        jPanel2.add((Component)this.runsField, gridBagConstraints);
        jLabel = new JLabel("");
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2085L");
        jLabel = new JLabel(string);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        string = String.valueOf(this.settings.csRetainDays);
        this.daysField = TTextField.newTTextField(string, 3, 5, true);
        gridBagConstraints.insets.left = 4;
        jPanel2.add((Component)this.daysField, gridBagConstraints);
        jLabel = new JLabel("");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left = 2;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.left = 20;
        GuiUtil.setAccessibleLabel(jLabel, this.daysField, "MNEMONIC_LABEL_DAYS", this.daysField.getText(), this.daysField.getText());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public ConfigSettings getData() {
        String string = this.runsField.getText();
        if (!Util.isEmpty(string)) {
            try {
                this.settings.csRetainCopies = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!Util.isEmpty(string = this.daysField.getText())) {
            try {
                this.settings.csRetainDays = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.settings;
    }

    public void validate(ConfigSettings configSettings) throws GeneralException {
        int n = -1;
        String string = this.runsField.getText();
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        if (n <= 0) {
            this.ddi.badField = 1;
            string = MessageLog.getMessageNoTS("GUI2086E", null);
            throw new GeneralException(string);
        }
        n = -1;
        string = this.daysField.getText();
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        if (n < 0) {
            this.ddi.badField = 2;
            string = MessageLog.getMessageNoTS("GUI2087E", null);
            throw new GeneralException(string);
        }
    }

    private void setInvalidField() {
        this.invalidField = this.ddi.badField == 1 ? this.runsField : this.daysField;
    }

    public void selectField(boolean bl) {
        this.setInvalidField();
        if (bl) {
            this.invalidField.requestFocus();
        } else {
            this.setFocus = true;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (!this.setFocus) {
            return;
        }
        Component component = componentEvent.getComponent();
        if (component == this.invalidField) {
            this.setFocus = false;
            component.requestFocus();
        }
    }
}

