/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.TextUtil;
import org.eclipse.aperi.server.guireq.SnmpDestination;
import org.eclipse.aperi.xmsg.MessageLog;

public class SnmpSettingsPanel
extends JPanel {
    private JTextField community;
    private JTextField host;
    private JTextField port;
    private boolean setFocus;
    private SnmpDestination snmp;

    public SnmpSettingsPanel(SnmpDestination snmpDestination, int n) {
        this.snmp = snmpDestination;
        this.setFocus = false;
        String string = Util.isEmpty(snmpDestination.csSnmpCommunity) ? null : snmpDestination.csSnmpCommunity;
        this.community = TTextField.newTTextField(string, 12, 64, false);
        string = Util.isEmpty(snmpDestination.csSnmpServer) ? null : snmpDestination.csSnmpServer;
        this.host = TTextField.newTTextField(string, 20, 128, false);
        string = snmpDestination.csSnmpPort > 0 ? Integer.toString(snmpDestination.csSnmpPort) : null;
        this.port = TTextField.newTTextField(string, 5, true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        string = MessageLog.getMessageNoID("GUI0270L", Integer.toString(n + 1));
        JLabel jLabel = new BlackLabel(string);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 4;
        string = MessageLog.getMessageNoID("GUI2048L");
        jLabel = new JLabel(string);
        this.add((Component)jLabel, gridBagConstraints);
        GuiUtil.setAccessibleLabel(jLabel, this.community, "MNEMONIC_COMMUNITY", string, "DESCRIPTION_COMMUNITY");
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.community, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2049L");
        jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 0;
        this.add((Component)jLabel, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2050L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.host, "MNEMONIC_HOST", string, "DESCRIPTION_HOST");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.host, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2051L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.port, "MNEMONIC_PORT", string, "DESCRIPTION_PORT");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.port, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2052L");
        jLabel = new JLabel(string);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jLabel, gridBagConstraints);
    }

    public SnmpDestination getData() {
        this.snmp.csSnmpServer = TextUtil.getTrimmedText(this.host);
        boolean bl = !Util.isEmpty(this.snmp.csSnmpServer);
        String string = this.port.getText();
        this.snmp.csSnmpPort = string.length() > 0 ? Integer.parseInt(string) : (bl ? 162 : 0);
        string = TextUtil.getTrimmedText(this.community);
        this.snmp.csSnmpCommunity = string.length() > 0 ? string : (bl ? "public" : null);
        return this.snmp;
    }

    public boolean validateData() throws GeneralException {
        if ((this.snmp.csSnmpPort > 0 || !Util.isEmpty(this.snmp.csSnmpCommunity)) && Util.isEmpty(this.snmp.csSnmpServer)) {
            String string = MessageLog.getMessageNoTS("GUI2060E", null);
            throw new GeneralException(string);
        }
        return !Util.isEmpty(this.snmp.csSnmpServer);
    }

    public void requestFocus() {
        this.host.requestFocus();
    }
}

