/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.OutOfBandAgentDialog;
import org.eclipse.aperi.gui.admin.agent.AgentListTreeNode;
import org.eclipse.aperi.gui.admin.agent.AgentTreeNodesStore;
import org.eclipse.aperi.gui.admin.agent.OutOfBandFabricAgentTableModel;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutbandFabricAgentSection
extends ConfigSection
implements ActionListener,
TJCTableMouseInterface {
    private MegaTable table = null;
    private OutOfBandFabricAgentTableModel tableModel = null;
    private JButton link2detail = null;
    private JButton addBtn = null;
    private JButton checkBtn = null;
    private JButton discoverBtn = null;
    private JLabel noData = null;
    private ArrayList outbandagtNodePath = null;
    private ArrayList outbandjobNodePath = null;
    private ArrayList agents = null;
    private ArrayList agentsInfo = null;
    private int countTotal = 0;
    private int countNormal = 0;
    private int countUnknown = 0;

    public OutbandFabricAgentSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.outbandagtNodePath = new ArrayList();
        this.outbandagtNodePath.add(AdminTreeLabel.class);
        this.outbandagtNodePath.add(MessageLog.getMessageNoID("ADG0200L", null));
        this.outbandagtNodePath.add(AgentListTreeNode.class);
        this.outbandagtNodePath.add(GuiUtil.getString("OUT_OF_BAND_FABRIC"));
        this.outbandjobNodePath = new ArrayList();
        this.outbandjobNodePath.add(AdminTreeLabel.class);
        this.outbandjobNodePath.add(MessageLog.getMessageNoID("STG4091L"));
        this.outbandjobNodePath.add(MessageLog.getMessageNoID("STG7572L"));
        this.outbandjobNodePath.add(new Integer(-1));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_OOBAGENT_TITLE_EXPANDED");
        if (!this.isExpanded()) {
            string = Util.getString("CONFIG_OOBAGENT_TITLE_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countNormal), String.valueOf(this.countUnknown)});
        }
        return string;
    }

    private void getAgents() {
        Request request = new Request();
        ServerRequest.guiInfo(request, 7, -2);
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    NameList nameList = (NameList)response.responseData;
                    OutbandFabricAgentSection.this.agents = new ArrayList();
                    OutbandFabricAgentSection.this.agentsInfo = new ArrayList();
                    OutbandFabricAgentSection.this.resetStateCount();
                    while (nameList != null) {
                        OutbandFabricAgentSection.this.agents.add(nameList);
                        OutbandFabricAgentSection.this.agentsInfo.add(new OutOfBandFabricAgentInfo());
                        OutbandFabricAgentSection.this.setStateCount(nameList.nlState);
                        nameList = nameList.nlNext;
                    }
                    if (OutbandFabricAgentSection.this.agents.size() == 0 && OutbandFabricAgentSection.this.table != null) {
                        OutbandFabricAgentSection.this.remove(OutbandFabricAgentSection.this.table);
                    }
                    if (OutbandFabricAgentSection.this.agents.size() == 0) {
                        OutbandFabricAgentSection.this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_OOBF_AGENTS"));
                        OutbandFabricAgentSection.this.add((Component)OutbandFabricAgentSection.this.noData, "Center");
                    }
                    OutbandFabricAgentSection.this.sendAgentRequest(new AgentRequestor());
                }
            }
        }, request);
    }

    private void updatePanel() {
        this.tableModel = new OutOfBandFabricAgentTableModel(this.agents, this.agentsInfo);
        if (this.agents.size() != 0 && this.tableModel != null) {
            if (this.table != null) {
                this.remove(this.table);
            }
            if (this.noData != null) {
                this.remove(this.noData);
            }
            this.table = new MegaTable();
            this.table.setVisibleRows(10);
            this.table.setMouseListener(this);
            this.table.setBaseTableModel(this.tableModel);
            this.table.setCellRenderer(Number.class, new NumberRenderer());
            this.table.setCellRenderer(JLabel.class, new LabelRenderer());
            this.table.setSelectionPolicy(0);
            this.table.sortByColumn(2, 1);
            this.selectionChanged(true);
            this.table.updateUI();
            this.add((Component)this.table, "Center");
        }
        if (this.getContainer() != null) {
            this.getContainer().updateSectionTitle();
        }
        this.selectionChanged(false);
        this.revalidate();
        this.repaint();
    }

    private void resetStateCount() {
        this.countNormal = 0;
        this.countUnknown = 0;
        this.countTotal = 0;
    }

    private void setStateCount(int n) {
        if (n == 1) {
            ++this.countNormal;
        } else {
            ++this.countUnknown;
        }
        ++this.countTotal;
    }

    public void refresh(boolean bl) {
        if (this.addBtn == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.addBtn = new JButton(GuiUtil.getString("CONFIG_OOBAGENT_BUTTON_ADD"));
            this.addBtn.addActionListener(this);
            jPanel2.add(this.addBtn);
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_OOBAGENT_BUTTON_DETAILS"));
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            this.link2detail.addActionListener(this);
            jPanel2.add(this.link2detail);
            this.checkBtn = new JButton(FabricGuiUtil.getString("FabricOutOfBand_Check"));
            GuiUtil.setAccessible(this.checkBtn, this.checkBtn.getText(), this.checkBtn.getText());
            this.checkBtn.addActionListener(this);
            jPanel2.add(this.checkBtn);
            this.discoverBtn = new JButton(GuiUtil.getString("CONFIG_OOBF_RUN_BTN"));
            GuiUtil.setAccessible(this.discoverBtn, this.discoverBtn.getText(), this.discoverBtn.getText());
            this.discoverBtn.addActionListener(this);
            jPanel2.add(this.discoverBtn);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_OOBAGENT_NOTE"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
        }
        if (bl || this.tableModel == null) {
            this.getAgents();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2detail) {
            NameList nameList = this.getSelectedAgent();
            if (nameList != null) {
                BaseTreeNode baseTreeNode = new ConfigUtil().getNode(this.outbandagtNodePath);
                AgentTreeNodesStore.getTreeNode(nameList, 7, baseTreeNode, true, false);
            }
        } else if (actionEvent.getSource() == this.addBtn) {
            OutOfBandAgentDialog outOfBandAgentDialog = new OutOfBandAgentDialog(guiMain.getFrame(), true);
            outOfBandAgentDialog.setParentNode(new ConfigUtil().getNode(this.outbandagtNodePath));
            outOfBandAgentDialog.show();
            this.refresh(true);
        } else if (actionEvent.getSource() == this.checkBtn) {
            NameList nameList = this.getSelectedAgent();
            if (nameList != null) {
                Request request = new Request();
                request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
                request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
                request.userName = GuiUtil.getUserName();
                OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
                request.requestData = outOfBandFabricAgentInfo;
                request.flags = (byte)4;
                outOfBandFabricAgentInfo.request_type = 4;
                outOfBandFabricAgentInfo.hostname = nameList.nlName;
                outOfBandFabricAgentInfo.ipaddress = nameList.nlName2;
                GuiClient.doRequest(new AgentCheckRequestor(nameList), request);
            }
        } else if (actionEvent.getSource() == this.discoverBtn) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
            request.flags = (byte)4;
            NameList nameList = new NameList();
            nameList.nlID = 111;
            nameList.nlInfo = (short)105;
            request.requestData = nameList;
            GuiClient.doRequest(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = MessageLog.getMessageNoID("STG7581L");
                        Object[] objectArray2 = objectArray;
                        JSgcScheduleCreateWhenData.displayJobSubmittedMessage(objectArray2);
                        ArrayList arrayList = new ArrayList(OutbandFabricAgentSection.this.outbandjobNodePath);
                        new ConfigUtil().selectNode(arrayList);
                    }
                }
            }, request);
        }
    }

    public NameList getSelectedAgent() {
        int[] nArray;
        if (this.tableModel != null && this.tableModel.getNumRows() != 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
            int n = nArray[0];
            return (NameList)this.agents.get(n);
        }
        return null;
    }

    private void updateAgentInfo(OutOfBandFabricAgentInfo[] outOfBandFabricAgentInfoArray) {
        if (outOfBandFabricAgentInfoArray != null) {
            int n = 0;
            while (n < outOfBandFabricAgentInfoArray.length) {
                OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = outOfBandFabricAgentInfoArray[n];
                int n2 = 0;
                while (n2 < this.agents.size()) {
                    NameList nameList = (NameList)this.agents.get(n2);
                    if (nameList.nlName2.equals(outOfBandFabricAgentInfo.ipaddress)) {
                        this.agentsInfo.set(n2, outOfBandFabricAgentInfo);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void sendAgentRequest(GuiRequestor guiRequestor) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
        request.requestData = outOfBandFabricAgentInfo;
        request.flags = (byte)4;
        outOfBandFabricAgentInfo.request_type = 6;
        GuiClient.doRequest(guiRequestor, request);
    }

    public void selectionChanged(boolean bl) {
        NameList nameList = this.getSelectedAgent();
        if (nameList != null) {
            this.link2detail.setEnabled(true);
            this.checkBtn.setEnabled(true);
        } else {
            this.link2detail.setEnabled(false);
            this.checkBtn.setEnabled(false);
        }
        if (!this.capabilities.isAperiAdmin()) {
            this.addBtn.setEnabled(false);
            this.link2detail.setEnabled(false);
            this.discoverBtn.setEnabled(false);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    static /* synthetic */ IGuiMain access$0() {
        return ConfigSection.guiMain;
    }

    public class AgentCheckRequestor
    implements GuiRequestor {
        NameList agent = null;

        public AgentCheckRequestor(NameList nameList) {
            this.agent = nameList;
        }

        public void handleResponse(short s, Response response) {
            if (s == 0) {
                OutbandFabricAgentSection.this.refresh(true);
                OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = (OutOfBandFabricAgentInfo)response.responseData;
                this.agent.nlState = (byte)outOfBandFabricAgentInfo.status;
                if (outOfBandFabricAgentInfo.status == 2) {
                    String string = MessageLog.getMessageNoID("ADG0294M", this.agent.nlName);
                    JOptionPane.showMessageDialog(OutbandFabricAgentSection.access$0().getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                } else {
                    String string = String.valueOf(this.agent.nlName) + " " + FabricGuiUtil.getInbandFabricAgentStatusString(outOfBandFabricAgentInfo.status);
                    JOptionPane.showMessageDialog(OutbandFabricAgentSection.access$0().getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                }
            }
        }
    }

    public class AgentRequestor
    implements GuiRequestor {
        public void handleResponse(short s, Response response) {
            if (s <= 4) {
                OutOfBandFabricAgentInfo[] outOfBandFabricAgentInfoArray = (OutOfBandFabricAgentInfo[])response.responseData;
                OutbandFabricAgentSection.this.updateAgentInfo(outOfBandFabricAgentInfoArray);
                OutbandFabricAgentSection.this.updatePanel();
            }
        }
    }
}

