/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectHostPortsStep;
import org.eclipse.aperi.request.Response;

public class CreateVDiskReviewStep
extends WizardPage {
    private JLabel titleLabel = null;
    private JTextArea descLabel = null;
    private JLabel quantityLabel = null;
    private JLabel sizeLabel = null;
    private JLabel typeLabel = null;
    private JLabel nameLabel = null;
    private JLabel vdiskListLabel = null;
    private JLabel formatLabel = null;
    private JLabel roundRobinLabel = null;
    private JLabel ioGroupLabel = null;
    private JLabel mdiskGroupLabel = null;
    private JLabel zoneActionLabel = null;
    private JLabel hostPortLabel = null;
    private JLabel ssPortLabel = null;
    private JLabel mdisksLabel = null;
    private JScrollPane mdiskScrollPanel = null;
    private JLabel hostPortTypeLabel = null;
    private JLabel hostPortTypeTextLabel = null;
    private JLabel quantityTextLabel = null;
    private JLabel sizeTextLabel = null;
    private JLabel typeTextLabel = null;
    private JLabel mdiskGroupTextLabel = null;
    private JLabel ioGroupTextLabel = null;
    private JTextArea mdisksTextLabel = null;
    private JLabel nameTextLabel = null;
    private JLabel formatTextLabel = null;
    private JLabel roundRobinTextLabel = null;
    private JList vdiskList = null;
    private JList zoneActionList = null;
    private JList hostPortList = null;
    private JList ssPortList = null;
    private DefaultListModel vdiskListModel = null;
    private DefaultListModel zoneActionListModel = null;
    private DefaultListModel hostPortListModel = null;
    private DefaultListModel ssPortListModel = null;
    private CreateVDiskWizard cvWizard = null;
    private HashMap vdiskData = null;
    private int width = -1;
    private int height = -1;
    private String subsystemID;
    private HashMap vdisksmap = new HashMap();
    private boolean isData = false;
    private Vector vdiskNameList = new Vector();

    public CreateVDiskReviewStep(int n, String string) {
        super(n);
        this.subsystemID = string;
        this.setName("CreateVDiskReviewStep");
        Container container = this.getContentPane();
        container.add(this.create());
        this.setUpHelp(DiskConstants.DISK_CREATE_VDISK_REVIEW);
    }

    public Object next() {
        return null;
    }

    public Component create() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setDefaultInsets(new Insets(0, 12, 0, 8));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VDISK_REVIEW_SETTINGS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        jPanel.add(this.titleLabel);
        jPanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        gridBagPanel.add((JComponent)jPanel, 23);
        gridBagPanel.newRow();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.descLabel = new JTextArea(Util.getString("DISK_VDISK_REVIEW_SETTINGS_DESC_LABEL"));
        this.descLabel.setEditable(false);
        this.descLabel.setLineWrap(true);
        this.descLabel.setWrapStyleWord(true);
        this.descLabel.setBackground((Color)UIManager.get("Label.background"));
        this.descLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.descLabel.setFont((Font)UIManager.get("Label.font"));
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.add(this.descLabel);
        gridBagPanel.add((JComponent)jPanel2, 0, 1, 2);
        gridBagPanel.newRow();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.quantityLabel = new JLabel(Util.getString("DISK_VDISK_QUANTITY_LABEL"));
        this.quantityTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)this.quantityLabel, gridBagConstraints);
        this.quantityLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.quantityTextLabel, gridBagConstraints);
        this.quantityTextLabel.setAlignmentX(0.0f);
        this.sizeLabel = new JLabel(Util.getString("DISK_VDISK_SIZE_LABEL"));
        this.sizeTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.sizeTextLabel, gridBagConstraints);
        this.sizeTextLabel.setAlignmentX(0.0f);
        this.ioGroupLabel = new JLabel(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
        this.ioGroupTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.ioGroupLabel, gridBagConstraints);
        this.ioGroupLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.ioGroupTextLabel, gridBagConstraints);
        this.ioGroupTextLabel.setAlignmentX(0.0f);
        this.mdiskGroupLabel = new JLabel(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdiskGroupTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.mdiskGroupLabel, gridBagConstraints);
        this.mdiskGroupLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.mdiskGroupTextLabel, gridBagConstraints);
        this.mdiskGroupTextLabel.setAlignmentX(0.0f);
        this.typeLabel = new JLabel(Util.getString("DISK_TYPE_LABEL"));
        this.typeTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.typeLabel, gridBagConstraints);
        this.typeLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.typeTextLabel, gridBagConstraints);
        this.typeTextLabel.setAlignmentX(0.0f);
        this.hostPortTypeLabel = new JLabel(GuiUtil.getString("DISK_VOLUME_HOST_PORT_TYPE_LABEL"));
        this.hostPortTypeTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.hostPortTypeLabel, gridBagConstraints);
        this.hostPortTypeLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.hostPortTypeTextLabel, gridBagConstraints);
        this.hostPortTypeTextLabel.setAlignmentX(0.0f);
        this.nameLabel = new JLabel(Util.getString("DISK_VDISK_NAME_PREFIX_LABEL"));
        this.nameTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.nameLabel, gridBagConstraints);
        this.nameLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.nameTextLabel, gridBagConstraints);
        this.nameTextLabel.setAlignmentX(0.0f);
        this.formatLabel = new JLabel(Util.getString("DISK_VDISK_FORMAT_LABEL"));
        this.formatTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.formatLabel, gridBagConstraints);
        this.formatLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.formatTextLabel, gridBagConstraints);
        this.formatTextLabel.setAlignmentX(0.0f);
        this.roundRobinLabel = new JLabel(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL"));
        this.roundRobinTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.roundRobinLabel, gridBagConstraints);
        this.roundRobinLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.roundRobinTextLabel, gridBagConstraints);
        this.roundRobinTextLabel.setAlignmentX(0.0f);
        this.mdisksLabel = new JLabel(Util.getString("DISK_VDISK_MANAGED_DISK_LABEL"));
        this.mdisksTextLabel = new JTextArea();
        this.mdisksTextLabel.setEditable(false);
        this.mdisksTextLabel.setLineWrap(true);
        this.mdisksTextLabel.setWrapStyleWord(true);
        this.mdisksTextLabel.setBackground((Color)UIManager.get("Label.background"));
        this.mdisksTextLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.mdisksTextLabel.setFont((Font)UIManager.get("Label.font"));
        this.mdiskScrollPanel = new JScrollPane(this.mdisksTextLabel);
        this.width = 16 * this.mdisksTextLabel.getFontMetrics(this.getFont()).charWidth(0);
        this.height = this.mdisksTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.mdiskScrollPanel.setPreferredSize(new Dimension(this.width, this.height));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.mdisksLabel, gridBagConstraints);
        this.mdisksLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.mdiskScrollPanel, gridBagConstraints);
        this.mdisksTextLabel.setAlignmentX(0.0f);
        gridBagPanel.add(jPanel3);
        gridBagPanel.newRow();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.vdiskListLabel = new JLabel(Util.getString("DISK_VDISK_CREATE_VDISK_LABEL"));
        jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel5.add(this.vdiskListLabel);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.vdiskList = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.vdiskList);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(jScrollPane);
        gridBagPanel.add(jPanel5);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel4, 0, 1, 2);
        gridBagPanel.newRow();
        this.width = 16 * this.vdiskList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.vdiskList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel4.setMinimumSize(new Dimension(this.width, this.height));
        jPanel4.setPreferredSize(new Dimension(this.width, this.height));
        jPanel4.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.vdiskList.setSelectionMode(0);
        GuiUtil.setAccessibleLabel(this.vdiskListLabel, this.vdiskList, "", this.vdiskListLabel.getText(), this.vdiskListLabel.getText());
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        this.zoneActionLabel = new JLabel(Util.getString("DISK_ZONE_ACTIONS_LABEL"));
        jPanel7.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel7.add(this.zoneActionLabel);
        jPanel7.add(Box.createHorizontalGlue());
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        this.zoneActionList = new JList();
        JScrollPane jScrollPane2 = new JScrollPane(this.zoneActionList);
        jPanel6.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel6.add(jScrollPane2);
        gridBagPanel.add(jPanel7);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel6, 0, 1, 2);
        gridBagPanel.newRow();
        this.width = 16 * this.zoneActionList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.zoneActionList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel6.setMinimumSize(new Dimension(this.width, this.height));
        jPanel6.setPreferredSize(new Dimension(this.width, this.height));
        jPanel6.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.zoneActionLabel, this.zoneActionList, "", this.zoneActionLabel.getText(), this.zoneActionLabel.getText());
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        this.hostPortLabel = new JLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel9.add(this.hostPortLabel);
        jPanel9.add(Box.createHorizontalGlue());
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        this.hostPortList = new JList();
        JScrollPane jScrollPane3 = new JScrollPane(this.hostPortList);
        jPanel8.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel8.add(jScrollPane3);
        gridBagPanel.add(jPanel9);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel8, 0, 1, 2);
        gridBagPanel.newRow();
        this.width = 16 * this.hostPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.hostPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel8.setMinimumSize(new Dimension(this.width, this.height));
        jPanel8.setPreferredSize(new Dimension(this.width, this.height));
        jPanel8.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.hostPortLabel, this.hostPortList, "", this.hostPortLabel.getText(), this.hostPortLabel.getText());
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        this.ssPortLabel = new JLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel11.add(this.ssPortLabel);
        jPanel11.add(Box.createHorizontalGlue());
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        this.ssPortList = new JList();
        JScrollPane jScrollPane4 = new JScrollPane(this.ssPortList);
        jPanel10.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel10.add(jScrollPane4);
        gridBagPanel.add(jPanel11);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel10, 0, 1, 2);
        gridBagPanel.newRow();
        GuiUtil.setAccessibleLabel(this.ssPortLabel, this.ssPortList, "", this.ssPortLabel.getText(), this.ssPortLabel.getText());
        this.width = 16 * this.ssPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.ssPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel10.setMinimumSize(new Dimension(this.width, this.height));
        jPanel10.setPreferredSize(new Dimension(this.width, this.height));
        jPanel10.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel10.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        this.getNextButton().setEnabled(false);
        this.getExistingVDisks();
        gridBagPanel.add((JComponent)new JLabel(), 1);
        return gridBagPanel;
    }

    public void fillData() {
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        if (this.isData) {
            return;
        }
        this.vdiskData = this.cvWizard.getData();
        this.quantityTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_QUANTITY_LABEL")).toString());
        this.sizeTextLabel.setText(String.valueOf(this.vdiskData.get(Util.getString("DISK_VDISK_SIZE_LABEL")).toString()) + " " + this.vdiskData.get(Util.getString("DISK_UNITS_LABEL")).toString());
        this.typeTextLabel.setText(this.vdiskData.get(Util.getString("DISK_TYPE_LABEL")).toString());
        String string = this.vdiskData.get(Util.getString("DISK_VDISK_NAME_LABEL")).toString();
        if (string.length() <= 0) {
            string = Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL");
        }
        this.nameTextLabel.setText(string);
        this.hostPortTypeTextLabel.setText(this.vdiskData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_TYPE_NAME_DATA).toString());
        GUIIOGroup gUIIOGroup = (GUIIOGroup)this.vdiskData.get(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
        if (gUIIOGroup == null) {
            this.ioGroupTextLabel.setText(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"));
        } else {
            this.ioGroupTextLabel.setText(gUIIOGroup.toString());
        }
        GUIMDiskGroup gUIMDiskGroup = (GUIMDiskGroup)this.vdiskData.get(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdiskGroupTextLabel.setText(gUIMDiskGroup.getDeviceId());
        this.formatTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_FORMAT_LABEL")).toString());
        this.roundRobinTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL")).toString());
        Vector vector = (Vector)this.vdiskData.get(Util.getString("DISK_VDISK_MDISKS_LABEL"));
        String string2 = new String();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                string2 = String.valueOf(string2) + vector.get(n) + ", ";
                ++n;
            }
            n = string2.lastIndexOf(",");
            string2 = string2.substring(0, n);
        }
        this.mdisksTextLabel.setText(string2);
        if (this.typeTextLabel.getText().equals(Util.getString("DISK_STRIPED_LABEL"))) {
            vector = new Vector();
        }
        Vector vector2 = this.generateVDiskList(this.nameTextLabel.getText(), Integer.valueOf(this.quantityTextLabel.getText()), vector);
        if (this.vdiskNameList.size() == 1) {
            this.nameTextLabel.setText(vector2.get(0).toString());
        }
        if (this.vdiskNameList.size() == 0) {
            this.vdiskNameList = null;
        }
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_CREATE_VDISK_LABEL"), this.vdiskNameList);
        this.vdiskListModel = this.addVectorToModel(vector2);
        this.vdiskList.setModel(this.vdiskListModel);
        Vector vector3 = (Vector)this.vdiskData.get(CreateVDiskSelectHostPortsStep.HOSTPORTS_DATA);
        Vector<String> vector4 = new Vector<String>();
        GUIPort gUIPort = null;
        String string3 = new String();
        String string4 = new String();
        String string5 = new String();
        int n = 0;
        while (vector3 != null && n < vector3.size()) {
            try {
                gUIPort = (GUIPort)vector3.get(n);
            }
            catch (ClassCastException classCastException) {
                gUIPort = null;
            }
            if (gUIPort != null) {
                string3 = gUIPort.getWwpn();
                string4 = gUIPort.getHostName();
                string5 = gUIPort.getTypeName();
                if (string4 != null && string4.trim().length() > 0) {
                    string3 = String.valueOf(string3) + "( " + string4;
                    if (string5 != null && string5.trim().length() > 0 && gUIPort.getType() != 0) {
                        string3 = String.valueOf(string3) + ", " + string5;
                    }
                    string3 = String.valueOf(string3) + " )";
                }
                vector4.add(string3);
            } else {
                vector4.add((String)vector3.get(n));
            }
            ++n;
        }
        this.hostPortListModel = this.addVectorToModel(vector4);
        this.hostPortList.setModel(this.hostPortListModel);
        HashMap hashMap = (HashMap)this.vdiskData.get(CreateVDiskZoneActionStep.ZONE_LIST_DATA);
        Vector<Object> vector5 = new Vector();
        if (hashMap != null) {
            vector5 = new Vector(hashMap.values());
        }
        this.zoneActionListModel = this.addVectorToModel(vector5);
        this.zoneActionList.setModel(this.zoneActionListModel);
        Vector vector6 = (Vector)this.vdiskData.get(CreateVDiskSelectHostPortsStep.SUBSYSTEM_DATA);
        Vector<String> vector7 = new Vector<String>();
        gUIPort = null;
        int n2 = 0;
        while (vector6 != null && n2 < vector6.size()) {
            gUIPort = (GUIPort)vector6.get(n2);
            string3 = gUIPort.getWwpn();
            string4 = gUIPort.getHostName();
            if (string4 != null && string4.trim().length() > 0) {
                string3 = String.valueOf(string3) + " (" + string4 + ")";
            }
            vector7.add(string3);
            ++n2;
        }
        this.ssPortListModel = this.addVectorToModel(vector7);
        this.ssPortList.setModel(this.ssPortListModel);
        this.isData = true;
    }

    public boolean previousBegin() {
        this.isData = false;
        return true;
    }

    private Vector generateVDiskList(String string, int n, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        this.vdiskNameList = new Vector();
        if (string.length() == 0) {
            vector2.add(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"));
            return vector2;
        }
        String string2 = new String();
        int n2 = 0;
        if (n == 1) {
            string2 = string;
            while (this.vdisksmap.get(string2) != null) {
                string2 = String.valueOf(string) + ++n2;
            }
            if (vector.size() > 0) {
                vector2.add(String.valueOf(string2) + " (" + vector.get(0) + ")");
            } else {
                vector2.add(string2);
            }
            if (!string.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
                this.vdiskNameList.add(string2);
            }
            return vector2;
        }
        String string3 = new String();
        n2 = 1;
        if (vector.size() > 0) {
            if (vector.size() == 1) {
                string3 = vector.get(0).toString();
                int n3 = 0;
                while (n3 < n) {
                    string2 = String.valueOf(string) + n2;
                    while (this.vdisksmap.get(string2) != null) {
                        string2 = String.valueOf(string) + ++n2;
                    }
                    vector2.add(String.valueOf(string2) + " (" + string3 + ")");
                    this.vdiskNameList.add(string2);
                    string2 = String.valueOf(string) + ++n2;
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    string2 = String.valueOf(string) + n2;
                    while (this.vdisksmap.get(string2) != null) {
                        string2 = String.valueOf(string) + ++n2;
                    }
                    vector2.add(String.valueOf(string2) + " (" + vector.get(n4) + ")");
                    this.vdiskNameList.add(string2);
                    string2 = String.valueOf(string) + ++n2;
                    ++n4;
                }
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                string2 = String.valueOf(string) + n2;
                while (this.vdisksmap.get(string2) != null) {
                    string2 = String.valueOf(string) + ++n2;
                }
                vector2.add(string2);
                this.vdiskNameList.add(string2);
                string2 = String.valueOf(string) + ++n2;
                ++n5;
            }
        }
        if (string.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
            this.vdiskNameList = new Vector();
        }
        return vector2;
    }

    private void getExistingVDisks() {
        DiskDataAccessor diskDataAccessor = DiskDataAccessor.getInstance();
        diskDataAccessor.getVolumeNamesBySubsystem(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    String[] stringArray = (String[])response.responseData;
                    CreateVDiskReviewStep.this.vdisksmap = new HashMap();
                    int n = 0;
                    while (stringArray != null && n < stringArray.length) {
                        CreateVDiskReviewStep.this.vdisksmap.put(stringArray[n], stringArray[n]);
                        ++n;
                    }
                }
            }
        }, this.subsystemID);
    }

    private DefaultListModel addVectorToModel(Vector vector) {
        DefaultListModel defaultListModel = new DefaultListModel();
        if (vector == null) {
            return defaultListModel;
        }
        int n = 0;
        while (n < vector.size()) {
            defaultListModel.add(n, vector.get(n));
            ++n;
        }
        return defaultListModel;
    }
}

