/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.FormattedTextFieldVerifier;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskAddMDiskDialog;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class CreateVDiskSetCharacteristicsStep
extends WizardPage
implements ActionListener,
ChangeListener,
TJCTableMouseInterface {
    private String svcID = "0";
    private DiskDataAccessor diskAccessor = null;
    private HashMap iogroupsmap = null;
    private HashMap mdgroupsmap = null;
    private String[] vdiskIDs;
    private HashMap mdiskMap = null;
    private String[] mdiskIDs = null;
    private JDialog wizardDialog = null;
    private JLabel titleLabel = null;
    private JLabel descLabel = null;
    private JLabel typeLabel = null;
    private JLabel vdiskQuantityLabel = null;
    private JLabel vdiskSizeLabel = null;
    private JLabel unitsLabel = null;
    private JLabel vdiskNameLabel = null;
    private JLabel vdiskPrefixLabel = null;
    private JLabel ioGroupLabel = null;
    private JLabel mdGroupLabel = null;
    private JLabel mdiskLabel = null;
    private JLabel noDataLabel = null;
    private JComboBox typeComboBox = null;
    private JSpinner vdiskQuantitySpinner = null;
    private JSpinner vdiskSizeSpinner = null;
    private JComboBox unitsComboBox = null;
    private JComboBox ioGroupComboBox = null;
    private JComboBox mdGroupComboBox = null;
    private JTextField vdiskNameTextField = null;
    private MegaTable mdiskTable = null;
    public JButton addMDiskButton = null;
    public JButton nextButton = null;
    private JCheckBox roundRobinCheckBox = null;
    private JCheckBox formatCheckBox = null;
    private JFormattedTextField vdiskQuantityTextField = new JFormattedTextField();
    private JFormattedTextField vdiskSizeTextField = new JFormattedTextField();
    private int minSpinnerValue = 1;
    private int maxQuantitySpinnerValue = 1024;
    private int minSizeSpinnerValue = 0;
    private int maxSizeSpinnerValue = 1000000;
    private int spinnerStep = 1;
    private CreateVDiskWizard cvWizard = null;
    private boolean dblClick = false;
    private mdiskTableModel tableModel = null;
    private int width = -1;
    private int height = -1;
    private long maxVDiskSize = -1L;
    private long vdiskSizeBytes = -1L;
    private boolean isHelpSet = false;
    private int nameLen = -1;
    private HashMap mdiskGroups = new HashMap();
    private Vector mdiskGroupStrings = new Vector();
    private Vector ioGroups = new Vector();
    private GUIMDiskGroup mdiskGroup = null;
    private GUIIOGroup ioGroup = null;
    private JPanel mdTablePanel = null;
    public boolean isMdiskQueryComplete = false;
    public boolean isIOGroupQueryComplete = false;
    public boolean isMDGroupQueryComplete = false;
    private String vdiskType = null;
    private String vdiskName = null;
    private String vdiskQuantity = null;
    private String vdiskSize = null;
    private String units = null;
    private Vector mdisks = null;
    private String roundRobin = null;
    private String format = null;
    private String[] vdiskTypes = new String[]{Util.getString("DISK_VDISK_TYPE_STRIPED"), Util.getString("DISK_VDISK_TYPE_SEQUENTIAL")};
    private String[] unitsArray = new String[]{Util.getString("DISK_BYTES"), Util.getString("DISK_KB"), Util.getString("DISK_MB"), Util.getString("DISK_GB"), Util.getString("DISK_TB"), Util.getString("DISK_PB")};
    private static final String[] COL_NAMES = new String[]{Util.getString("DISK_MDISKID_LABEL"), Util.getString("DISK_NAME_LABEL"), Util.getString("DISK_STATUS_LABEL"), Util.getString(Util.getString("DISK_CAPACITY_LABEL_MB"))};
    private static final int MDISK_ID = 0;
    private static final int MDISK_NAME = 1;
    private static final int MDISK_STATUS = 2;
    private static final int MDISK_CAPACITY = 3;

    public CreateVDiskSetCharacteristicsStep(int n, String string) {
        super(n);
        this.setName("CreateVDiskSetCharacteristicsStep");
        this.diskAccessor = DiskDataAccessor.getInstance();
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        this.svcID = string;
        this.getFinishButton().setEnabled(false);
        this.getPreviousButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container container = this.getContentPane();
        container.add(this.create());
        this.setUpHelp(DiskConstants.DISK_CREATE_VDISK_SET_CHARACTERISTICS);
    }

    public Object next() {
        return "CreateVDiskSelectHostPortsStep";
    }

    public Component create() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VDISK_CHARACTERISTICS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.titleLabel);
        jPanel2.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.descLabel = new JLabel(Util.getString("DISK_VDISK_CHARACTERISTICS_DESC_LABEL"));
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.add(this.descLabel);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        int n = 125;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.typeLabel = new JLabel(Util.getString("DISK_TYPE_LABEL"));
        this.typeComboBox = new JComboBox<String>(this.vdiskTypes);
        this.typeComboBox.addActionListener(this);
        this.width = this.vdiskTypes[1].length() * this.typeComboBox.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.typeComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.typeComboBox.setPreferredSize(new Dimension(this.width, this.height));
        GuiUtil.setAccessibleLabel(this.typeLabel, this.typeComboBox, "", this.typeLabel.getText(), this.typeLabel.getText());
        jPanel4.add(this.typeLabel);
        jPanel4.add(Box.createRigidArea(new Dimension(n - this.typeLabel.getPreferredSize().width, 0)));
        jPanel4.add(this.typeComboBox);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel5.setAlignmentX(1.0f);
        this.vdiskQuantityLabel = new JLabel(Util.getString("DISK_VDISK_QUANTITY_LABEL"));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.minSpinnerValue, this.minSpinnerValue, this.maxQuantitySpinnerValue, this.spinnerStep);
        this.vdiskQuantitySpinner = new JSpinner(spinnerNumberModel);
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.vdiskQuantitySpinner.getEditor();
        this.vdiskQuantityTextField = numberEditor.getTextField();
        this.vdiskQuantityTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.vdiskQuantitySpinner.addChangeListener(this);
        this.width = spinnerNumberModel.getMaximum().toString().length() * this.vdiskQuantitySpinner.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = this.vdiskQuantitySpinner.getFontMetrics(this.getFont()).getHeight() + 5;
        this.vdiskQuantitySpinner.setPreferredSize(new Dimension(this.width, this.height));
        jPanel5.add(this.vdiskQuantityLabel);
        if (n < this.vdiskQuantityLabel.getPreferredSize().width) {
            n = this.vdiskQuantityLabel.getPreferredSize().width + 2;
        }
        jPanel5.add(Box.createRigidArea(new Dimension(n - this.vdiskQuantityLabel.getPreferredSize().width, 0)));
        jPanel5.add(this.vdiskQuantitySpinner);
        jPanel5.add(Box.createHorizontalGlue());
        GuiUtil.setAccessibleLabel(this.vdiskQuantityLabel, this.vdiskQuantitySpinner, "", this.vdiskQuantityLabel.getText(), this.vdiskQuantityLabel.getText());
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel6.setAlignmentX(1.0f);
        this.vdiskSizeLabel = new JLabel(Util.getString("DISK_VDISK_SIZE_LABEL"));
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.minSizeSpinnerValue, this.minSizeSpinnerValue, this.maxSizeSpinnerValue, this.spinnerStep);
        this.vdiskSizeSpinner = new JSpinner(spinnerNumberModel2);
        JSpinner.NumberEditor numberEditor2 = (JSpinner.NumberEditor)this.vdiskSizeSpinner.getEditor();
        this.vdiskSizeTextField = numberEditor2.getTextField();
        this.vdiskSizeTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.width = spinnerNumberModel2.getMaximum().toString().length() * this.vdiskSizeSpinner.getFontMetrics(this.getFont()).charWidth(0);
        this.height = this.vdiskSizeSpinner.getFontMetrics(this.getFont()).getHeight() + 5;
        this.vdiskSizeSpinner.setPreferredSize(new Dimension(this.width, this.height));
        jPanel6.add(this.vdiskSizeLabel);
        if (n < this.vdiskSizeLabel.getPreferredSize().width) {
            n = this.vdiskSizeLabel.getPreferredSize().width + 2;
        }
        jPanel6.add(Box.createRigidArea(new Dimension(n - this.vdiskSizeLabel.getPreferredSize().width, 0)));
        jPanel6.add(this.vdiskSizeSpinner);
        GuiUtil.setAccessibleLabel(this.vdiskSizeLabel, this.vdiskSizeSpinner, "", this.vdiskSizeLabel.getText(), this.vdiskSizeLabel.getText());
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        this.unitsLabel = new JLabel(Util.getString("DISK_UNITS_LABEL"));
        this.unitsComboBox = new JComboBox<String>(this.unitsArray);
        this.unitsComboBox.addActionListener(this);
        jPanel7.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel7.add(this.unitsLabel);
        jPanel7.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel7.add(this.unitsComboBox);
        this.width = this.unitsArray[3].length() * this.unitsComboBox.getFontMetrics(this.getFont()).charWidth(0) + 30;
        this.height = this.unitsComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.unitsComboBox.setMinimumSize(new Dimension(this.width, this.height));
        this.unitsComboBox.setPreferredSize(new Dimension(this.width, this.height));
        this.unitsComboBox.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.unitsComboBox.setSelectedIndex(2);
        jPanel6.add(Box.createHorizontalGlue());
        jPanel6.add(jPanel7);
        GuiUtil.setAccessible(this.unitsComboBox, this.unitsComboBox.getName(), this.unitsComboBox.getName());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 2));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.vdiskNameLabel = new JLabel(Util.getString("DISK_NAME_LABEL"));
        this.vdiskPrefixLabel = new JLabel(Util.getString("DISK_VDISK_PREFIX_LABEL"));
        PlainDocument plainDocument = new PlainDocument(){

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null && string.length() + this.getLength() <= 15) {
                    super.insertString(n, string, attributeSet);
                }
            }
        };
        this.vdiskNameTextField = new JTextField(plainDocument, "", 15);
        this.width = 16 * this.vdiskNameTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.vdiskNameTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.vdiskNameTextField.setMinimumSize(new Dimension(this.width, this.height));
        this.vdiskNameTextField.setPreferredSize(new Dimension(this.width, this.height));
        this.vdiskNameTextField.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.vdiskNameTextField.setAlignmentX(0.0f);
        jPanel8.add(this.vdiskNameLabel);
        if (n < this.vdiskNameLabel.getPreferredSize().width) {
            n = this.vdiskNameLabel.getPreferredSize().width + 2;
        }
        jPanel8.add(Box.createRigidArea(new Dimension(n - this.vdiskNameLabel.getPreferredSize().width, 0)));
        jPanel8.add(this.vdiskNameTextField);
        jPanel7.add(Box.createRigidArea(new Dimension(15, 0)));
        jPanel8.add(this.vdiskPrefixLabel);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel.add(jPanel8);
        GuiUtil.setAccessibleLabel(this.vdiskNameLabel, this.vdiskNameTextField, "", this.vdiskNameLabel.getText(), this.vdiskNameLabel.getText());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.ioGroupLabel = new JLabel(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
        this.ioGroupComboBox = new JComboBox(new Vector());
        this.ioGroupComboBox.addActionListener(this);
        this.width = this.ioGroups.size() > 0 ? this.ioGroups.get(0).toString().length() : 25;
        this.width = this.width * this.ioGroupComboBox.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.ioGroupComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.ioGroupComboBox.setPreferredSize(new Dimension(this.width, this.height));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel9.add(this.ioGroupLabel);
        if (n < this.ioGroupLabel.getPreferredSize().width) {
            n = this.ioGroupLabel.getPreferredSize().width + 2;
        }
        jPanel9.add(Box.createRigidArea(new Dimension(n - this.ioGroupLabel.getPreferredSize().width, 0)));
        jPanel9.add(this.ioGroupComboBox);
        jPanel9.add(Box.createHorizontalGlue());
        GuiUtil.setAccessibleLabel(this.ioGroupLabel, this.ioGroupComboBox, "", this.ioGroupLabel.getText(), this.ioGroupLabel.getText());
        jPanel.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        jPanel10.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        jPanel11.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.mdGroupLabel = new JLabel(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdGroupComboBox = new JComboBox(new Vector());
        this.mdGroupComboBox.addActionListener(this);
        this.width = this.mdiskGroupStrings.size() > 0 ? this.mdiskGroupStrings.get(0).toString().length() : 25;
        this.width *= this.mdGroupComboBox.getFontMetrics(this.getFont()).charWidth(0);
        this.height = this.mdGroupComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.mdGroupComboBox.setPreferredSize(new Dimension(this.width, this.height));
        jPanel11.add(this.mdGroupLabel);
        if (n < this.mdGroupLabel.getPreferredSize().width) {
            n = this.mdGroupLabel.getPreferredSize().width + 2;
        }
        jPanel11.add(Box.createRigidArea(new Dimension(n - this.mdGroupLabel.getPreferredSize().width, 0)));
        jPanel11.add(this.mdGroupComboBox);
        jPanel11.add(Box.createHorizontalGlue());
        GuiUtil.setAccessibleLabel(this.mdGroupLabel, this.mdGroupComboBox, "", this.mdGroupLabel.getText(), this.mdGroupLabel.getText());
        jPanel10.add(jPanel11);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 0));
        this.mdiskLabel = new JLabel(Util.getString("DISK_VDISK_MANAGED_DISK_LABEL"));
        this.mdiskLabel.setAlignmentX(0.0f);
        jPanel12.add(Box.createRigidArea(new Dimension(45, 0)));
        jPanel12.add(this.mdiskLabel);
        jPanel10.add(jPanel12);
        jPanel12.add(Box.createHorizontalGlue());
        this.mdTablePanel = new JPanel();
        this.mdTablePanel.setLayout(new BoxLayout(this.mdTablePanel, 0));
        this.mdTablePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.mdTablePanel.setPreferredSize(new Dimension(145, 120));
        this.mdiskTable = new MegaTable();
        this.mdiskTable.setMouseListener(this);
        this.mdiskTable.setColumnHidden(0, true);
        this.mdiskTable.setRowIcon(10, false);
        this.mdiskTable.setCellRenderer(BigDecimal.class, TableCellRenderers.number);
        this.mdTablePanel.add(Box.createRigidArea(new Dimension(n - this.mdGroupLabel.getPreferredSize().width, 0)));
        this.mdTablePanel.add(this.mdiskTable);
        this.mdTablePanel.add(Box.createHorizontalGlue());
        jPanel10.add(this.mdTablePanel);
        this.mdiskTable.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.noDataLabel = new JLabel(Util.getString("DISK_NO_DATA_LABEL"));
        this.noDataLabel.setAlignmentX(0.0f);
        this.addMDiskButton = new JButton(Util.getString("DISK_VDISK_ADDMDISK_LABEL"));
        this.addMDiskButton.addActionListener(this);
        jPanel10.add(Box.createHorizontalGlue());
        jPanel10.add(this.addMDiskButton);
        jPanel10.add(Box.createHorizontalGlue());
        jPanel.add(jPanel10);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 3));
        jPanel13.setAlignmentX(1.0f);
        this.roundRobinCheckBox = new JCheckBox(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL"), true);
        jPanel13.add(this.roundRobinCheckBox);
        this.roundRobinCheckBox.setEnabled(false);
        this.roundRobinCheckBox.setSelected(false);
        GuiUtil.setAccessible(this.roundRobinCheckBox, this.roundRobinCheckBox.getText(), this.roundRobinCheckBox.getText());
        jPanel13.add(Box.createHorizontalGlue());
        this.formatCheckBox = new JCheckBox(Util.getString("DISK_VDISK_FORMAT_LABEL"), true);
        jPanel13.add(this.formatCheckBox);
        jPanel13.add(Box.createRigidArea(new Dimension(5, 0)));
        GuiUtil.setAccessible(this.formatCheckBox, this.formatCheckBox.getText(), this.formatCheckBox.getText());
        jPanel.add(jPanel13);
        this.setIOGroups();
        this.setMDiskGroups();
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = null;
        if (actionEvent == null) {
            return;
        }
        object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.typeComboBox)) {
            if (1 == this.typeComboBox.getSelectedIndex()) {
                n = Integer.parseInt(this.vdiskQuantitySpinner.getValue().toString());
                if (n > 1) {
                    this.roundRobinCheckBox.setEnabled(true);
                }
            } else {
                this.roundRobinCheckBox.setSelected(false);
                this.roundRobinCheckBox.setEnabled(false);
            }
        }
        if (object.equals(this.ioGroupComboBox)) {
            int n2;
            n = 0;
            if (this.ioGroupComboBox.getSelectedIndex() != 0) {
                this.ioGroup = (GUIIOGroup)this.ioGroupComboBox.getModel().getSelectedItem();
                this.getVDisksQuantityForIOGroup(this.ioGroup);
            }
            if ((n2 = Integer.valueOf(this.vdiskQuantitySpinner.getModel().getValue().toString()).intValue()) > (n = ((Integer)((SpinnerNumberModel)this.vdiskQuantitySpinner.getModel()).getMaximum()).intValue())) {
                String[] stringArray = new String[]{String.valueOf(n)};
                String string = Util.getString("DMSG_DISK_VDISK_MAX_QUANTITY", stringArray);
                JOptionPane.showMessageDialog(this, string, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
            }
        }
        if (object.equals(this.mdGroupComboBox)) {
            String string = (String)this.mdGroupComboBox.getModel().getSelectedItem();
            this.mdiskGroupStrings.indexOf(string);
            this.mdiskGroup = (GUIMDiskGroup)this.mdiskGroups.get(string);
            this.invalidateMDGroups();
        }
        if (object.equals(this.addMDiskButton)) {
            String string = (String)this.mdGroupComboBox.getModel().getSelectedItem();
            this.mdiskGroupStrings.indexOf(string);
            this.mdiskGroup = (GUIMDiskGroup)this.mdiskGroups.get(string);
            if (this.mdiskGroup != null) {
                CreateVDiskAddMDiskDialog createVDiskAddMDiskDialog = CreateVDiskAddMDiskDialog.getAddMDiskDialogInstance(this, this.svcID, this.mdiskGroup);
                createVDiskAddMDiskDialog.pack();
                GuiUtil.centerDialog(createVDiskAddMDiskDialog);
                createVDiskAddMDiskDialog.show();
            }
        }
    }

    public void invalidateMDGroups() {
        String string = null;
        string = this.mdiskGroup.getId();
        this.fillData(this.svcID, string);
        long l = this.getMaxVDiskSize(this.mdiskGroup);
        long l2 = Long.valueOf(this.vdiskSizeSpinner.getModel().getValue().toString());
        this.vdiskSizeBytes = GUIEntityUtil.convertStorageCapacity(l2, this.unitsComboBox.getSelectedIndex(), 0);
        if (this.vdiskSizeBytes > l) {
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            l = GUIEntityUtil.convertStorageCapacity(l, 0, this.unitsComboBox.getSelectedIndex());
            this.vdiskSizeSpinner.setValue(new Integer(String.valueOf(l)));
        }
        if (this.vdiskSizeBytes > l) {
            String[] stringArray = new String[]{String.valueOf(l)};
            String string2 = Util.getString("DMSG_DISK_VDISK_MAX_SIZE", stringArray);
            JOptionPane.showMessageDialog(this, string2, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
        }
        this.invalidate();
    }

    private void enableControls(boolean bl) {
        if (bl && this.isMdiskQueryComplete && this.isIOGroupQueryComplete && this.isMDGroupQueryComplete) {
            this.nextButton.setEnabled(bl);
            this.addMDiskButton.setEnabled(bl);
        } else {
            this.nextButton.setEnabled(false);
            this.addMDiskButton.setEnabled(false);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = null;
        if (changeEvent == null) {
            return;
        }
        object = changeEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.vdiskQuantitySpinner)) {
            int n = Integer.parseInt(this.vdiskQuantitySpinner.getValue().toString());
            if (1 == this.typeComboBox.getSelectedIndex() && n > 1) {
                this.roundRobinCheckBox.setEnabled(true);
            } else {
                this.roundRobinCheckBox.setEnabled(false);
            }
            n = n < 10 ? 1 : (n < 100 ? 2 : (n < 1000 ? 3 : 4));
            this.nameLen = 15 - n;
            String string = this.vdiskNameTextField.getText();
            PlainDocument plainDocument = new PlainDocument(){

                public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (string != null && string.length() + this.getLength() <= CreateVDiskSetCharacteristicsStep.this.nameLen) {
                        super.insertString(n, string, attributeSet);
                    }
                }
            };
            this.vdiskNameTextField.setDocument(plainDocument);
            this.vdiskNameTextField.setColumns(this.nameLen);
            if (string.length() > this.nameLen) {
                string = string.substring(0, this.nameLen);
            }
            this.vdiskNameTextField.setText(string);
        }
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showDefaultChart(int n) {
    }

    public void selectionChanged(boolean bl) {
    }

    public void doubleClick(int n, int n2) {
        this.dblClick = true;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    private void setIOGroups() {
        this.ioGroups = new Vector();
        this.enableControls(false);
        this.diskAccessor.getIOGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.iogroupsmap = (HashMap)response.responseData;
                    if (CreateVDiskSetCharacteristicsStep.this.iogroupsmap != null) {
                        CreateVDiskSetCharacteristicsStep.this.ioGroups = new Vector(CreateVDiskSetCharacteristicsStep.this.iogroupsmap.values());
                    }
                    CreateVDiskSetCharacteristicsStep.this.ioGroups = GUIEntityUtil.sort(CreateVDiskSetCharacteristicsStep.this.ioGroups);
                    CreateVDiskSetCharacteristicsStep.this.ioGroups.insertElementAt(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"), 0);
                    DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(CreateVDiskSetCharacteristicsStep.this.ioGroups);
                    CreateVDiskSetCharacteristicsStep.this.ioGroupComboBox.setModel(defaultComboBoxModel);
                    CreateVDiskSetCharacteristicsStep.this.ioGroupComboBox.setSelectedIndex(0);
                }
                CreateVDiskSetCharacteristicsStep.this.isIOGroupQueryComplete = true;
                CreateVDiskSetCharacteristicsStep.this.enableControls(true);
            }
        }, this.svcID);
    }

    public JDialog getWizardDialog() {
        CreateVDiskWizard createVDiskWizard = (CreateVDiskWizard)this.getParent();
        JDialog jDialog = (JDialog)createVDiskWizard.getParent().getParent().getParent().getParent();
        return jDialog;
    }

    private void setMDiskGroups() {
        this.mdiskGroups = new HashMap();
        this.mdiskGroupStrings = new Vector();
        this.enableControls(false);
        this.diskAccessor.getMDiskGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.mdgroupsmap = (HashMap)response.responseData;
                    GUIMDiskGroup gUIMDiskGroup2 = null;
                    String string = new String();
                    float f = 0.0f;
                    if (CreateVDiskSetCharacteristicsStep.this.mdgroupsmap != null) {
                        for (GUIMDiskGroup gUIMDiskGroup2 : CreateVDiskSetCharacteristicsStep.this.mdgroupsmap.values()) {
                            f = gUIMDiskGroup2.getUnusedCapacity();
                            f = GUIEntityUtil.convertStorageCapacityDecimal(gUIMDiskGroup2.getUnusedCapacity(), 0, 3, 2);
                            string = String.valueOf(gUIMDiskGroup2.getDeviceId()) + " (" + f + " " + CreateVDiskSetCharacteristicsStep.this.unitsArray[3] + " )";
                            CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings.add(string);
                            CreateVDiskSetCharacteristicsStep.this.mdiskGroups.put(string, gUIMDiskGroup2);
                        }
                        Collections.sort(CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings);
                    }
                    DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings);
                    CreateVDiskSetCharacteristicsStep.this.mdGroupComboBox.setModel(defaultComboBoxModel);
                    if (CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings.size() > 0) {
                        CreateVDiskSetCharacteristicsStep.this.mdGroupComboBox.setSelectedIndex(0);
                    }
                }
                CreateVDiskSetCharacteristicsStep.this.isMDGroupQueryComplete = true;
                CreateVDiskSetCharacteristicsStep.this.enableControls(true);
            }
        }, this.svcID);
    }

    private Vector getselectedMDisks() {
        Vector<GUIMDisk> vector = new Vector<GUIMDisk>();
        if (!this.mdiskTable.isVisible() || this.mdiskGroup == null) {
            return vector;
        }
        int[] nArray = this.mdiskTable.getSelectedRows();
        if (nArray == null) {
            return vector;
        }
        if (nArray.length <= 0) {
            return vector;
        }
        GUIMDisk gUIMDisk = null;
        mdiskTableModel mdiskTableModel2 = (mdiskTableModel)this.mdiskTable.getDataSource();
        int n = 0;
        while (mdiskTableModel2 != null && n < nArray.length) {
            gUIMDisk = mdiskTableModel2.getMDisk(nArray[n]);
            if (gUIMDisk != null) {
                vector.add(gUIMDisk);
            }
            ++n;
        }
        return vector;
    }

    private long getMaxVDiskSize(GUIMDiskGroup gUIMDiskGroup) {
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        l2 = gUIMDiskGroup.getUnusedCapacity();
        l3 = Long.valueOf(this.vdiskQuantitySpinner.getModel().getValue().toString());
        if (l3 > 0L) {
            l = l2 / l3;
        }
        return l;
    }

    private int getVDisksQuantityForIOGroup(GUIIOGroup gUIIOGroup) {
        int n = 0;
        if (gUIIOGroup == null) {
            return n;
        }
        this.nextButton.setEnabled(false);
        this.addMDiskButton.setEnabled(false);
        this.diskAccessor.getVDiskIdsByIOGroup(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.vdiskIDs = (String[])response.responseData;
                    int n = CreateVDiskSetCharacteristicsStep.this.vdiskIDs.length;
                    n = 1024 - n;
                    ((SpinnerNumberModel)CreateVDiskSetCharacteristicsStep.this.vdiskQuantitySpinner.getModel()).setMaximum(new Integer(n));
                }
                CreateVDiskSetCharacteristicsStep.this.nextButton.setEnabled(true);
                CreateVDiskSetCharacteristicsStep.this.addMDiskButton.setEnabled(true);
            }
        }, this.svcID, gUIIOGroup.getId());
        return n;
    }

    private boolean validateName(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (string.toLowerCase(this.getLocale()).startsWith(Util.getString("DISK_TOOLTIP_VDISK_LABEL").toLowerCase(this.getLocale()))) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (Character.isDigit(cArray[0])) {
            return false;
        }
        if (cArray[0] == '-') {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (!(cArray[n] >= 'a' && cArray[n] <= 'z' || cArray[n] >= 'A' && cArray[n] <= 'Z' || cArray[n] >= '0' && cArray[n] <= '9' || cArray[n] == '_' || cArray[n] == '-')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean validateSize(long l, long l2) {
        if (l < 512L || l / 512L * 512L != l) {
            return false;
        }
        return l <= l2;
    }

    private boolean validateSizeQuantity(long l) {
        long l2 = -1L;
        long l3 = 0L;
        long l4 = Long.parseLong(this.vdiskQuantity);
        switch (this.typeComboBox.getSelectedIndex()) {
            case 0: {
                int n = 0;
                while (n < this.mdisks.size()) {
                    l2 = ((GUIMDisk)this.mdisks.get(n)).getUnusedCapacity();
                    if (l2 == -1L) {
                        return false;
                    }
                    l3 += l2;
                    ++n;
                }
                this.maxVDiskSize = l3 / l4;
                break;
            }
            case 1: {
                l3 = Long.MAX_VALUE;
                int n = 0;
                while (n < this.mdisks.size()) {
                    l2 = ((GUIMDisk)this.mdisks.get(n)).getUnusedCapacity();
                    if (l2 == -1L) {
                        return false;
                    }
                    if (l2 < l3) {
                        l3 = l2;
                    }
                    ++n;
                }
                this.maxVDiskSize = l3 / l4;
            }
        }
        return this.vdiskSizeBytes <= this.maxVDiskSize;
    }

    public void fillData(String string, String string2) {
        this.enableControls(true);
        this.diskAccessor.getMDisksByMDiskGroup(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.mdiskMap = (HashMap)response.responseData;
                    CreateVDiskSetCharacteristicsStep.this.mdiskIDs = CreateVDiskSetCharacteristicsStep.this.mdiskMap.keySet().toArray(new String[0]);
                    int n = CreateVDiskSetCharacteristicsStep.this.mdiskMap.size();
                    CreateVDiskSetCharacteristicsStep.this.tableModel = new mdiskTableModel();
                    CreateVDiskSetCharacteristicsStep.this.mdiskTable.setBaseTableModel(CreateVDiskSetCharacteristicsStep.this.tableModel);
                    if (n <= 0) {
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.setVisible(false);
                        CreateVDiskSetCharacteristicsStep.this.mdTablePanel.add(CreateVDiskSetCharacteristicsStep.this.noDataLabel);
                        CreateVDiskSetCharacteristicsStep.this.mdTablePanel.add(Box.createHorizontalGlue());
                    } else {
                        CreateVDiskSetCharacteristicsStep.this.mdTablePanel.remove(CreateVDiskSetCharacteristicsStep.this.noDataLabel);
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.setVisible(true);
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.sortByColumn(0, 1);
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.setFrozenColumns(0);
                    }
                }
                CreateVDiskSetCharacteristicsStep.this.isMdiskQueryComplete = true;
                CreateVDiskSetCharacteristicsStep.this.enableControls(true);
            }
        }, string, string2);
    }

    public boolean nextBegin() {
        int n = -1;
        new String();
        this.vdiskType = (String)this.typeComboBox.getModel().getSelectedItem();
        n = this.ioGroupComboBox.getSelectedIndex();
        this.ioGroup = n == 0 ? null : (GUIIOGroup)this.ioGroups.get(n);
        String string = (String)this.mdGroupComboBox.getSelectedItem();
        this.mdiskGroup = (GUIMDiskGroup)this.mdiskGroups.get(string);
        this.vdiskQuantity = this.vdiskQuantitySpinner.getModel().getValue().toString();
        this.vdiskSize = this.vdiskSizeSpinner.getModel().getValue().toString();
        this.units = (String)this.unitsComboBox.getModel().getSelectedItem();
        this.mdisks = this.getselectedMDisks();
        this.roundRobin = this.roundRobinCheckBox.isSelected() ? Util.getString("FabricDetails_true") : Util.getString("FabricDetails_false");
        this.format = this.formatCheckBox.isSelected() ? Util.getString("FabricDetails_true") : Util.getString("FabricDetails_false");
        this.vdiskName = this.vdiskNameTextField.getText();
        this.vdiskSizeBytes = GUIEntityUtil.convertStorageCapacity(Long.parseLong(this.vdiskSize), this.unitsComboBox.getSelectedIndex(), 0);
        if (this.mdisks.size() <= 0) {
            if (1 == this.typeComboBox.getSelectedIndex() || this.mdiskGroup == null) {
                String string2 = Util.getString("DMSG_DISK_VDISK_MDISK");
                JOptionPane.showMessageDialog(this, string2, Util.getString("DISK_VDISK_MDISKS_LABEL"), 0);
                return false;
            }
            int n2 = ((mdiskTableModel)this.mdiskTable.getDataSource()).getNumRows();
            int n3 = 0;
            while (n3 < n2) {
                this.mdisks.add(((mdiskTableModel)this.mdiskTable.getDataSource()).getMDisk(n3));
                ++n3;
            }
        }
        if (!this.validateName(this.vdiskName)) {
            String string3 = Util.getString("DMSG_DISK_VDISK_NAME");
            JOptionPane.showMessageDialog(this, string3, Util.getString("DISK_VDISK_NAME_LABEL"), 0);
            return false;
        }
        if (this.typeComboBox.getSelectedIndex() == 1) {
            if (this.roundRobinCheckBox.isEnabled()) {
                if (this.roundRobinCheckBox.isSelected()) {
                    if (Integer.parseInt(this.vdiskQuantity) != this.mdisks.size()) {
                        String[] stringArray = new String[]{this.vdiskQuantity};
                        String string4 = Util.getString("DMSG_DISK_VDISK_SEQENTIAL_ROUNDROBIN_QUANTITY", stringArray);
                        JOptionPane.showMessageDialog(this, string4, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
                        return false;
                    }
                } else if (this.mdisks.size() != 1) {
                    String string5 = Util.getString("DMSG_DISK_VDISK_SEQENTIAL_QUANTITY");
                    JOptionPane.showMessageDialog(this, string5, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
                    return false;
                }
            } else if (Integer.parseInt(this.vdiskQuantity) != this.mdisks.size()) {
                String[] stringArray = new String[]{this.vdiskQuantity};
                String string6 = Util.getString("DMSG_DISK_VDISK_SEQENTIAL_ROUNDROBIN_QUANTITY", stringArray);
                JOptionPane.showMessageDialog(this, string6, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
                return false;
            }
        }
        long l = this.getMaxVDiskSize(this.mdiskGroup);
        if (this.vdiskSizeBytes == 0L) {
            String[] stringArray = new String[]{String.valueOf(String.valueOf(512)) + " " + this.unitsArray[0]};
            String string7 = Util.getString("DMSG_DISK_VOLUME_MIN_SIZE", stringArray);
            JOptionPane.showMessageDialog(this, string7, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
            return false;
        }
        if (!this.validateSize(this.vdiskSizeBytes, l)) {
            l = GUIEntityUtil.convertStorageCapacity(l, 0, this.unitsComboBox.getSelectedIndex());
            String[] stringArray = new String[]{String.valueOf(String.valueOf(l)) + " " + this.units};
            String string8 = Util.getString("DMSG_DISK_VDISK_SIZE", stringArray);
            JOptionPane.showMessageDialog(this, string8, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
            return false;
        }
        int n4 = this.getVDisksQuantityForIOGroup(this.ioGroup);
        if (Integer.valueOf(this.vdiskQuantity) <= 0) {
            String[] stringArray = new String[]{String.valueOf(n4)};
            String string9 = Util.getString("DMSG_DISK_VDISK_QUANTITY", stringArray);
            JOptionPane.showMessageDialog(this, string9, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
            return false;
        }
        if (!this.validateSizeQuantity(this.vdiskSizeBytes)) {
            this.maxVDiskSize = GUIEntityUtil.convertStorageCapacity(this.maxVDiskSize, 0, this.unitsComboBox.getSelectedIndex());
            String[] stringArray = new String[]{String.valueOf(String.valueOf(this.maxVDiskSize)) + " " + this.units};
            String string10 = Util.getString("DMSG_DISK_VDISK_MAX_SIZE", stringArray);
            JOptionPane.showMessageDialog(this, string10, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
            return false;
        }
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        this.cvWizard.addVDiskData(Util.getString("DISK_TYPE_LABEL"), this.vdiskType);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_QUANTITY_LABEL"), this.vdiskQuantity);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_SIZE_LABEL"), this.vdiskSize);
        this.cvWizard.addVDiskData(Util.getString("DISK_UNITS_LABEL"), this.units);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_NAME_LABEL"), this.vdiskName);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_IOGROUP_LABEL"), this.ioGroup);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_MDGROUP_LABEL"), this.mdiskGroup);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_MDISKS_LABEL"), this.mdisks);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL"), this.roundRobin);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_FORMAT_LABEL"), this.format);
        return true;
    }

    protected class mdiskTableModel
    extends BaseTableModel {
        private String[] mdiskStatus = new String[]{Util.getString("DISK_MDISK_STATUS_OFFLINE"), Util.getString("DISK_MDISK_STATUS_ONLINE"), Util.getString("DISK_MDISK_STATUS_DEGRADED"), Util.getString("DISK_MDISK_STATUS_EXCLUDED")};

        public mdiskTableModel() {
            this.columnNames = COL_NAMES;
            this.rowCount = CreateVDiskSetCharacteristicsStep.this.mdiskMap.size();
        }

        public GUIMDisk getMDisk(int n) {
            return (GUIMDisk)CreateVDiskSetCharacteristicsStep.this.mdiskMap.get(CreateVDiskSetCharacteristicsStep.this.mdiskIDs[n]);
        }

        public Object getTableDataItem(int n, int n2) {
            this.rowCount = CreateVDiskSetCharacteristicsStep.this.mdiskMap.size();
            if (this.rowCount <= 0) {
                return null;
            }
            GUIMDisk gUIMDisk = (GUIMDisk)CreateVDiskSetCharacteristicsStep.this.mdiskMap.get(CreateVDiskSetCharacteristicsStep.this.mdiskIDs[n]);
            switch (n2) {
                case 0: {
                    return gUIMDisk.getId();
                }
                case 1: {
                    return gUIMDisk.getName();
                }
                case 2: {
                    return this.mdiskStatus[gUIMDisk.getNativeStatus()];
                }
                case 3: {
                    long l = new Long(gUIMDisk.getCapacity());
                    l = GUIEntityUtil.convertStorageCapacity(l, 0, 2);
                    return new BigDecimal(l);
                }
            }
            return "";
        }
    }
}

