/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.BaseDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.BladeTableModel;
import org.eclipse.aperi.gui.fabric.details.DetailsDDI;
import org.eclipse.aperi.gui.fabric.details.DetailsSubPanel;
import org.eclipse.aperi.gui.fabric.details.DoDeviceRequestThread;
import org.eclipse.aperi.gui.fabric.details.EventTableModel;
import org.eclipse.aperi.gui.fabric.details.MaxSizePanel;
import org.eclipse.aperi.gui.fabric.details.MyStringTokenizer;
import org.eclipse.aperi.gui.fabric.details.SensorTableModel;
import org.eclipse.aperi.gui.fabric.details.TablePanel;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;

public class SwitchDetailsPanel
extends BaseDetailsPanel
implements ChangeListener {
    static final String END_OF_ENTITY = ">EOE<";
    DetailsSubPanel detailsPanel;
    TablePanel sensorsPanel;
    TablePanel eventsPanel;
    TablePanel bladesPanel;
    TablePanel blades2Panel;
    JPanel sensorsPanel2;
    JPanel eventsPanel2;
    private static final boolean DEBUG_LAYOUT = false;
    JPanel outerPanel;
    boolean hasBeenRun = false;
    boolean bladesDisplayed = false;
    JTabbedPane tab;

    public SwitchDetailsPanel(String string, String string2) {
        super(string, string2);
    }

    public void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeDetailPanel(), "Center");
    }

    public JPanel makeTabbedPanel(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    public JPanel makeDetailPanel() {
        this.hasBeenRun = false;
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(15, 15));
        this.tab = new JTabbedPane();
        this.detailsPanel = new DetailsSubPanel(this.entityType, this.entityID, new Insets(0, 0, 0, 0), false);
        this.tab.add((Component)this.makeTabbedPanel(this.detailsPanel), FabricGuiUtil.getString("FabricDetails_DetailsTwistie"));
        this.outerPanel.add(this.tab);
        this.sensorsPanel = new TablePanel();
        this.eventsPanel = new TablePanel();
        this.bladesPanel = new TablePanel();
        this.sensorsPanel2 = this.makeTabbedPanel(this.sensorsPanel);
        this.tab.add((Component)this.sensorsPanel2, FabricGuiUtil.getString("FabricDetails_SensorsTwistie"));
        this.eventsPanel2 = this.makeTabbedPanel(this.eventsPanel);
        this.tab.add((Component)this.eventsPanel2, FabricGuiUtil.getString("FabricDetails_EventsTwistie"));
        this.tab.addChangeListener(this);
        return this.outerPanel;
    }

    public JPanel makeTabelPanel(BaseTableModel baseTableModel) {
        MaxSizePanel maxSizePanel = new MaxSizePanel();
        maxSizePanel.setLayout(new BorderLayout());
        MegaTable megaTable = new MegaTable();
        megaTable.setPreferredSize(new Dimension(2048, 2048));
        if (baseTableModel != null) {
            megaTable.setBaseTableModel(baseTableModel);
        }
        maxSizePanel.add((Component)megaTable, "Center");
        return maxSizePanel;
    }

    public void queryData() {
        GuiDetailsReq guiDetailsReq = new GuiDetailsReq(this.entityType, this.entityID, 0);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsHndlr", guiDetailsReq);
        this.doRequest(this, request);
    }

    void parseSensor(MyStringTokenizer myStringTokenizer, Vector vector) {
        try {
            myStringTokenizer.nextToken();
            myStringTokenizer.nextToken();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string = myStringTokenizer.nextToken();
            while (!string.trim().equals(END_OF_ENTITY)) {
                MyStringTokenizer myStringTokenizer2 = new MyStringTokenizer(string);
                String string2 = myStringTokenizer2.nextToken().trim();
                myStringTokenizer2.nextToken();
                String string3 = myStringTokenizer2.nextTokenSafe("");
                if (string2.equals("Type")) {
                    hashtable.put("FabricSensorsEvents_Type", string3);
                } else if (string2.equals("Status")) {
                    hashtable.put("FabricSensorsEvents_Status", string3);
                } else if (string2.equals("Message")) {
                    hashtable.put("FabricSensorsEvents_Message", string3);
                }
                string = myStringTokenizer.nextTokenSafe();
            }
            vector.add(hashtable);
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    void parseEvent(MyStringTokenizer myStringTokenizer, Vector vector) {
        try {
            myStringTokenizer.nextToken();
            myStringTokenizer.nextToken();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string = myStringTokenizer.nextToken();
            while (!string.trim().equals(END_OF_ENTITY)) {
                MyStringTokenizer myStringTokenizer2 = new MyStringTokenizer(string);
                String string2 = myStringTokenizer2.nextToken().trim();
                myStringTokenizer2.nextToken();
                String string3 = myStringTokenizer2.nextTokenSafe("").trim();
                if (string2.equals("Type")) {
                    hashtable.put("FabricSensorsEvents_Type", string3);
                } else if (string2.equals("RealTime")) {
                    string3 = String.valueOf(string3.substring(9, 11)) + ":" + string3.substring(11, 13);
                    hashtable.put("FabricSensorsEvents_Time", string3);
                } else if (string2.equals("Index")) {
                    hashtable.put("FabricSensorsEvents_ID", string3);
                } else if (string2.equals("Description")) {
                    hashtable.put("FabricSensorsEvents_Description", string3);
                }
                string = myStringTokenizer.nextTokenSafe();
            }
            vector.add(hashtable);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    void parseEntity(MyStringTokenizer myStringTokenizer, Vector vector, Vector vector2) {
        String string = myStringTokenizer.nextToken();
        MyStringTokenizer myStringTokenizer2 = new MyStringTokenizer(string);
        myStringTokenizer2.nextToken();
        myStringTokenizer2.nextToken();
        String string2 = myStringTokenizer2.nextToken();
        if (string2.trim().equals("sensor")) {
            this.parseSensor(myStringTokenizer, vector);
        } else if (string2.trim().equals("event")) {
            this.parseEvent(myStringTokenizer, vector2);
        } else {
            while (!myStringTokenizer.nextToken().trim().equals(END_OF_ENTITY)) {
            }
        }
    }

    void parseSensorAndEventData(GuiDetailsReq guiDetailsReq) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < guiDetailsReq.sensorsEvents.getResults().length) {
            Object object;
            Object object2 = guiDetailsReq.sensorsEvents.getResults()[n];
            String string = (String)object2;
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).trim().equals("Entity")) {
                    string2 = String.valueOf(string2) + END_OF_ENTITY + "\n";
                }
                string2 = String.valueOf(string2) + (String)object + "\n";
            }
            string = String.valueOf(string2) + END_OF_ENTITY + "\n";
            try {
                object = new MyStringTokenizer(string, "\n");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((MyStringTokenizer)object).nextToken();
                    if (!string3.trim().equals("Entity")) continue;
                    this.parseEntity((MyStringTokenizer)object, vector, vector2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            ++n;
        }
        this.sensorsPanel.setTableModel(new SensorTableModel(vector));
        this.eventsPanel.setTableModel(new EventTableModel(vector2));
    }

    public void handleResponse(short s, Response response) {
        this.sensorsPanel.setStatus("");
        this.eventsPanel.setStatus("");
        if (response != null && s == 0) {
            GuiDetailsReq guiDetailsReq = (GuiDetailsReq)response.responseData;
            if (guiDetailsReq.mode != 1) {
                if (guiDetailsReq.mode == 0) {
                    this.dataInDb = guiDetailsReq;
                    this.displayDataInPanel(guiDetailsReq);
                    if (this.guiMain instanceof GuiMain) {
                        GuiMain.setTheTitle(this.getTheTitle(guiDetailsReq));
                    }
                    DetailsDDI.setDDIDescription(this, this.getTheTitle(guiDetailsReq));
                    if (guiDetailsReq.blades != null && guiDetailsReq.blades.size() > 0) {
                        this.bladesPanel.setTableModel(new BladeTableModel(guiDetailsReq.blades));
                        if (!this.bladesDisplayed) {
                            this.tab.add((Component)this.makeTabbedPanel(this.bladesPanel), FabricGuiUtil.getString("FabricDetails_BladesTwistie"));
                            this.bladesDisplayed = true;
                        }
                    }
                } else if (guiDetailsReq.mode == 3 && guiDetailsReq.sensorsEvents != null) {
                    this.parseSensorAndEventData(guiDetailsReq);
                }
            }
        }
    }

    void getSensorAndEventData() {
        if (!this.hasBeenRun) {
            this.hasBeenRun = true;
            if (this.dataInDb != null && this.dataInDb.data != null) {
                String string;
                GuiDetailsReq guiDetailsReq = new GuiDetailsReq(this.entityType, this.entityID, 3);
                guiDetailsReq.switchId = string = (String)this.dataInDb.data.get("FabricDetails_WWN");
                DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsDeviceHndlr");
                deviceRequest.requestData = guiDetailsReq;
                this.sensorsPanel.setStatus(FabricGuiUtil.getString("FabricSensorsEvents_sensorAndEventInfo"));
                this.eventsPanel.setStatus(FabricGuiUtil.getString("FabricSensorsEvents_sensorAndEventInfo"));
                new DoDeviceRequestThread(this, deviceRequest);
            }
        }
    }

    static void dumpPanel(Container container, String string) {
        string = String.valueOf(string) + " ";
        System.out.println(String.valueOf(string) + "container2 " + container.getClass().getName());
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                SwitchDetailsPanel.dumpPanel((Container)componentArray[n], string);
            } else {
                System.out.println(String.valueOf(string) + "component " + componentArray[n].getClass().getName());
            }
            ++n;
        }
    }

    static void invalidateTree(Container container) {
        container.invalidate();
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                componentArray[n].invalidate();
                SwitchDetailsPanel.invalidateTree((Container)componentArray[n]);
            }
            ++n;
        }
    }

    public boolean isEditable() {
        return true;
    }

    public void getDataFromPanel(GuiDetailsReq guiDetailsReq) {
        if (this.detailsPanel != null) {
            this.detailsPanel.getDataFromPanel(guiDetailsReq);
        }
    }

    public void displayDataInPanel(GuiDetailsReq guiDetailsReq) {
        if (guiDetailsReq != null && this.detailsPanel != null) {
            this.detailsPanel.displayDataInPanel(guiDetailsReq);
        }
    }

    public boolean changesPending() {
        boolean bl = false;
        if (this.detailsPanel != null) {
            bl = this.detailsPanel.changesPending();
        }
        return bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.tab.getSelectedComponent() == this.sensorsPanel2 || this.tab.getSelectedComponent() == this.eventsPanel2) {
            this.getSensorAndEventData();
        }
    }
}

