/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.common.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResCapabilityDataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeCartridgeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeDriveTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeFrameTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeIoportTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaChangerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;
import org.eclipse.aperi.logging.TraceLogger;

public class TapeLibraryDBHelper {
    private static String CLASSNAME = TapeLibraryDBHelper.class.getName();
    private int cSUCCESS = 0;
    private int cNOLIBRARY = 1;
    private int cDBNOCONNECTIONERROR = 2;
    private int cDBERROR = 3;
    private int cROLLBACKERROR = 4;
    private int cDELETIONERROR = 5;
    private RetryDeleteParameters cRetryParms = new RetryDeleteParameters();

    public TapeLibraryDBHelper() {
        this.cRetryParms.init(null);
    }

    public int saveProperties(String string, Hashtable hashtable) {
        String string2 = "saveProperties";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string2, "lib name: " + string + ", props: " + hashtable);
        }
        String string3 = (String)hashtable.get("USER_PROVIDED_NAME");
        String string4 = (String)hashtable.get("USER_ATTRIB1");
        String string5 = (String)hashtable.get("USER_ATTRIB2");
        String string6 = (String)hashtable.get("USER_ATTRIB3");
        int n = this.cSUCCESS;
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException sQLException) {
            n = this.cDBNOCONNECTIONERROR;
            return n;
        }
        try {
            TapeLibrary tapeLibrary = new TapeLibrary();
            String[] stringArray = string.split("-multikey-");
            tapeLibrary.setName(stringArray[0]);
            if (stringArray.length > 1) {
                tapeLibrary.setNameFormat(Short.parseShort(stringArray[1]));
            }
            tapeLibrary.retrieve(dBConnection);
            if (tapeLibrary.getTapeLibraryId() > 0) {
                tapeLibrary.setUserProvidedName(string3);
                tapeLibrary.setUserAttrib1(string4);
                tapeLibrary.setUserAttrib2(string5);
                tapeLibrary.setUserAttrib3(string6);
                tapeLibrary.update(dBConnection);
                dBConnection.commit();
                int n2 = n = this.cSUCCESS;
                return n2;
            }
            int n3 = n = this.cNOLIBRARY;
            return n3;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, string2, sQLException);
            }
            int n4 = n = this.cDBERROR;
            return n4;
        }
        finally {
            block22: {
                if (dBConnection != null) {
                    try {
                        DBConnPoolDataSource.returnConnection(dBConnection);
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(CLASSNAME, string2, sQLException);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CLASSNAME, string2, n);
            }
        }
    }

    public int deleteLibrary(String string) {
        String string2 = "deleteLibrary";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string2, "lib name: " + string);
        }
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, string2, sQLException);
            }
            return this.cDBNOCONNECTIONERROR;
        }
        TapeLibrary tapeLibrary = new TapeLibrary();
        String[] stringArray = string.split("-multikey-");
        tapeLibrary.setName(stringArray[0]);
        if (stringArray.length > 1) {
            tapeLibrary.setNameFormat(Short.parseShort(stringArray[1]));
        }
        try {
            tapeLibrary.retrieve(dBConnection);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, string2, sQLException);
            }
            return this.cNOLIBRARY;
        }
        int n = this.deleteLibraryByID(tapeLibrary.getTapeLibraryId());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, string2, n);
        }
        return n;
    }

    public void deleteLibrariesByID(int[] nArray) {
        String string = "deleteLibrariesByID";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string, "lib IDs: " + nArray);
        }
        int n = 0;
        while (n < nArray.length) {
            this.deleteLibraryByID(n);
            ++n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, string);
        }
    }

    public int deleteLibraryByID(int n) {
        String string = "deleteLibraryByID";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string, "lib ID: " + n);
        }
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, string, sQLException);
            }
            return this.cDBNOCONNECTIONERROR;
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        hashtable2.put(TResTapeCartridgeTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable3 = new Hashtable<ColumnInfo, String>();
        hashtable3.put(TResTapeIoportTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable4 = new Hashtable<ColumnInfo, String>();
        hashtable4.put(TResTapeMediaChangerTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable5 = new Hashtable<ColumnInfo, String>();
        hashtable5.put(TResTapeDriveTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable6 = new Hashtable<ColumnInfo, String>();
        hashtable6.put(TResTapeFrameTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable7 = new Hashtable<ColumnInfo, String>();
        hashtable7.put(TResTapeMediaLocationTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable8 = new Hashtable<ColumnInfo, String>();
        hashtable8.put(TResNodeTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        Hashtable<ColumnInfo, String> hashtable9 = new Hashtable<ColumnInfo, String>();
        hashtable9.put(TResTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        try {
            Vector vector = this.getCapabilityIDs(dBConnection, n);
            int n12 = 0;
            while (n12 < vector.size()) {
                Hashtable<ColumnInfo, String> hashtable10 = new Hashtable<ColumnInfo, String>();
                hashtable10.put(TResCapabilityDataTable.getColumnInfo("CAPABILITY_DATA_ID"), ((Integer)vector.elementAt(n12)).toString());
                n11 += DBQueryAssistant.performDelete(TResCapabilityDataTable.getTablename(), dBConnection, hashtable10);
                ++n12;
            }
            n2 = DBQueryAssistant.performDelete(TResCimkeyTapeLibraryTable.getTablename(), dBConnection, hashtable);
            n3 = DBQueryAssistant.performDelete(TResTapeCartridgeTable.getTablename(), dBConnection, hashtable2);
            n4 = DBQueryAssistant.performDelete(TResTapeIoportTable.getTablename(), dBConnection, hashtable3);
            n5 = DBQueryAssistant.performDelete(TResTapeMediaChangerTable.getTablename(), dBConnection, hashtable4);
            n6 = DBQueryAssistant.performDelete(TResTapeDriveTable.getTablename(), dBConnection, hashtable5);
            n7 = DBQueryAssistant.performDelete(TResTapeFrameTable.getTablename(), dBConnection, hashtable6);
            n9 = DBQueryAssistant.performDelete(TResTapeMediaLocationTable.getTablename(), dBConnection, hashtable7);
            n8 = DBQueryAssistant.performDelete(TResNodeTable.getTablename(), dBConnection, hashtable8);
            n10 = DBQueryAssistant.performDelete(TResTapeLibraryTable.getTablename(), dBConnection, hashtable9);
            dBConnection.commit();
            if (TraceLogger.enableTrace) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Deleted TAPE_LIBRARY with ID: " + n + "\n");
                stringBuffer.append("  - CIMKEY_TAPE_LIBRARY: " + n2 + "\n");
                stringBuffer.append("  - CARTRIDGES: " + n3 + "\n");
                stringBuffer.append("  - IO_PORTS: " + n4 + "\n");
                stringBuffer.append("  - CHANGER_DEVICE: " + n5 + "\n");
                stringBuffer.append("  - DRIVE: " + n6 + "\n");
                stringBuffer.append("  - FRAME: " + n7 + "\n");
                stringBuffer.append("  - STORAGE_MEDIA_LOCATION: " + n9 + "\n");
                stringBuffer.append("  - NODES: " + n8 + "\n");
                stringBuffer.append("  - CAPABILITIES: " + n11 + "\n");
                stringBuffer.append("  - LIBRARIES: " + n10 + "\n");
                stringBuffer.append("---------------------------------------------\n");
                TraceLogger.traceMessage(1, CLASSNAME, string, stringBuffer.toString());
            }
            int n13 = this.cSUCCESS;
            return n13;
        }
        catch (SQLException sQLException) {
            try {
                dBConnection.rollback();
                int n14 = this.cDELETIONERROR;
                return n14;
            }
            catch (SQLException sQLException2) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(CLASSNAME, string, sQLException2);
                }
                int n15 = this.cROLLBACKERROR;
                return n15;
            }
        }
        finally {
            block25: {
                if (dBConnection != null) {
                    try {
                        DBConnPoolDataSource.returnConnection(dBConnection);
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block25;
                        TraceLogger.exception(CLASSNAME, string, sQLException);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CLASSNAME, string);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteTapeDriveByID(int var1_1) {
        var2_2 = "deleteTapeDriveByID";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(TapeLibraryDBHelper.CLASSNAME, var2_2, "drive ID: " + var1_1);
        }
        var3_3 = null;
        var4_4 = new StringBuffer();
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        while (true) {
            if (!this.cRetryParms.isToRetry()) break;
            var3_3 = ServiceUtils.getConnection();
            var3_3.setAutoCommit(false);
            try {
                var10_10 = this.getDrive(var3_3, var1_1);
            }
            catch (SQLException v0) lbl-1000:
            // 5 sources

            {
                while (true) {
                    var4_4.append("Deleted Drive with ID: " + var1_1 + "\n");
                    var4_4.append("  - TAPE_DRIVE: " + var5_5 + "\n");
                    var4_4.append("  - MEDIA_LOCATION: " + var6_6 + "\n");
                    var4_4.append("  - TAPE_CARTRIDGE: " + var7_7 + "\n");
                    var4_4.append("  - NODE: " + var8_8 + "\n");
                    var4_4.append("  - PORT: " + var9_9 + "\n");
                    var4_4.append("---------------------------------------------\n");
                    try {
                        var3_3.close();
                    }
                    catch (SQLException v1) {}
                    return false;
                }
            }
            try {
                if (var10_10.isEmpty()) ** GOTO lbl-1000
                var11_12 = (Integer)var10_10.get("LOCATION_ID");
                var12_13 = (Integer)var10_10.get("NODE_ID");
                var13_14 = new Hashtable<ColumnInfo, String>();
                var13_14.put(TResTapeDriveTable.getColumnInfo("TAPE_DRIVE_ID"), Integer.toString(var1_1));
                var14_15 = new Hashtable<ColumnInfo, String>();
                var14_15.put(TResTapeMediaLocationTable.getColumnInfo("LOCATION_ID"), Integer.toString(var11_12));
                var15_16 = new Hashtable<ColumnInfo, String>();
                var15_16.put(TResTapeCartridgeTable.getColumnInfo("LOCATION_ID"), Integer.toString(var11_12));
                var16_17 = new Hashtable<ColumnInfo, String>();
                var16_17.put(TResNodeTable.getColumnInfo("NODE_ID"), Integer.toString(var12_13));
                var17_18 = new Hashtable<ColumnInfo, String>();
                var17_18.put(TResPortTable.getColumnInfo("NODE_ID"), Integer.toString(var11_12));
                var5_5 = DBQueryAssistant.performDelete(TResTapeDriveTable.getTablename(), var3_3, var13_14);
                var6_6 = DBQueryAssistant.performDelete(TResTapeMediaLocationTable.getTablename(), var3_3, var14_15);
                var7_7 = DBQueryAssistant.performDelete(TResTapeCartridgeTable.getTablename(), var3_3, var15_16);
                var8_8 = DBQueryAssistant.performDelete(TResNodeTable.getTablename(), var3_3, var16_17);
                var9_9 = DBQueryAssistant.performDelete(TResPortTable.getTablename(), var3_3, var17_18);
                var3_3.commit();
                this.cRetryParms.setToRetry(false);
                continue;
                {
                    catch (SQLException var10_11) {
                        try {
                            if (SQLExceptionHelper.isDeadlock(var3_3, var10_11)) {
                                if (!TapeLibraryDBHelper.handleDeadlock(var3_3, null, this.cRetryParms, var10_11)) continue;
                                continue;
                            }
                            var10_11.printStackTrace();
                            try {
                                var3_3.rollback();
                                ** GOTO lbl-1000
                            }
                            catch (SQLException v2) {
                            }
                        }
                        catch (SQLException v3) {}
                        ** continue;
                    }
                }
            }
            catch (Throwable var18_19) {
                var4_4.append("Deleted Drive with ID: " + var1_1 + "\n");
                var4_4.append("  - TAPE_DRIVE: " + var5_5 + "\n");
                var4_4.append("  - MEDIA_LOCATION: " + var6_6 + "\n");
                var4_4.append("  - TAPE_CARTRIDGE: " + var7_7 + "\n");
                var4_4.append("  - NODE: " + var8_8 + "\n");
                var4_4.append("  - PORT: " + var9_9 + "\n");
                var4_4.append("---------------------------------------------\n");
                try {
                    var3_3.close();
                }
                catch (SQLException v4) {}
                throw var18_19;
            }
            break;
        }
        var4_4.append("Deleted Drive with ID: " + var1_1 + "\n");
        var4_4.append("  - TAPE_DRIVE: " + var5_5 + "\n");
        var4_4.append("  - MEDIA_LOCATION: " + var6_6 + "\n");
        var4_4.append("  - TAPE_CARTRIDGE: " + var7_7 + "\n");
        var4_4.append("  - NODE: " + var8_8 + "\n");
        var4_4.append("  - PORT: " + var9_9 + "\n");
        var4_4.append("---------------------------------------------\n");
        try {
            var3_3.close();
        }
        catch (SQLException v5) {}
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage(1, TapeLibraryDBHelper.CLASSNAME, var2_2, var4_4.toString());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteTapeMediaChangerByID(int var1_1) {
        var2_2 = "deleteTapeMediaChangerByID";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(TapeLibraryDBHelper.CLASSNAME, var2_2, "media changer ID: " + var1_1);
        }
        var3_3 = null;
        var4_4 = new StringBuffer();
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        while (true) {
            if (!this.cRetryParms.isToRetry()) break;
            var3_3 = ServiceUtils.getConnection();
            var3_3.setAutoCommit(false);
            try {
                var10_10 = this.getMediaChanger(var3_3, var1_1);
            }
            catch (SQLException v0) lbl-1000:
            // 5 sources

            {
                while (true) {
                    var4_4.append("Deleted Changer with ID: " + var1_1 + "\n");
                    var4_4.append("  - TAPE_MEDIA_CHANGER: " + var5_5 + "\n");
                    var4_4.append("  - MEDIA_LOCATION: " + var6_6 + "\n");
                    var4_4.append("  - TAPE_CARTRIDGE: " + var7_7 + "\n");
                    var4_4.append("  - NODE: " + var8_8 + "\n");
                    var4_4.append("  - PORT: " + var9_9 + "\n");
                    var4_4.append("---------------------------------------------\n");
                    try {
                        var3_3.close();
                    }
                    catch (SQLException v1) {}
                    return false;
                }
            }
            try {
                if (var10_10.isEmpty()) ** GOTO lbl-1000
                var11_12 = (Integer)var10_10.get("LOCATION_ID");
                var12_13 = (Integer)var10_10.get("NODE_ID");
                var13_14 = new Hashtable<ColumnInfo, String>();
                var13_14.put(TResTapeMediaChangerTable.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), Integer.toString(var1_1));
                var14_15 = new Hashtable<ColumnInfo, String>();
                var14_15.put(TResTapeMediaLocationTable.getColumnInfo("LOCATION_ID"), Integer.toString(var11_12));
                var15_16 = new Hashtable<ColumnInfo, String>();
                var15_16.put(TResTapeCartridgeTable.getColumnInfo("LOCATION_ID"), Integer.toString(var11_12));
                var16_17 = new Hashtable<ColumnInfo, String>();
                var16_17.put(TResNodeTable.getColumnInfo("NODE_ID"), Integer.toString(var12_13));
                var17_18 = new Hashtable<ColumnInfo, String>();
                var17_18.put(TResPortTable.getColumnInfo("NODE_ID"), Integer.toString(var11_12));
                var5_5 = DBQueryAssistant.performDelete(TResTapeMediaChangerTable.getTablename(), var3_3, var13_14);
                var6_6 = DBQueryAssistant.performDelete(TResTapeMediaLocationTable.getTablename(), var3_3, var14_15);
                var7_7 = DBQueryAssistant.performDelete(TResTapeCartridgeTable.getTablename(), var3_3, var15_16);
                var8_8 = DBQueryAssistant.performDelete(TResNodeTable.getTablename(), var3_3, var16_17);
                var9_9 = DBQueryAssistant.performDelete(TResPortTable.getTablename(), var3_3, var17_18);
                var3_3.commit();
                this.cRetryParms.setToRetry(false);
                continue;
                {
                    catch (SQLException var10_11) {
                        try {
                            if (SQLExceptionHelper.isDeadlock(var3_3, var10_11)) {
                                if (!TapeLibraryDBHelper.handleDeadlock(var3_3, null, this.cRetryParms, var10_11)) continue;
                                continue;
                            }
                            var10_11.printStackTrace();
                            try {
                                var3_3.rollback();
                                ** GOTO lbl-1000
                            }
                            catch (SQLException v2) {
                            }
                        }
                        catch (SQLException v3) {}
                        ** continue;
                    }
                }
            }
            catch (Throwable var18_19) {
                var4_4.append("Deleted Changer with ID: " + var1_1 + "\n");
                var4_4.append("  - TAPE_MEDIA_CHANGER: " + var5_5 + "\n");
                var4_4.append("  - MEDIA_LOCATION: " + var6_6 + "\n");
                var4_4.append("  - TAPE_CARTRIDGE: " + var7_7 + "\n");
                var4_4.append("  - NODE: " + var8_8 + "\n");
                var4_4.append("  - PORT: " + var9_9 + "\n");
                var4_4.append("---------------------------------------------\n");
                try {
                    var3_3.close();
                }
                catch (SQLException v4) {}
                throw var18_19;
            }
            break;
        }
        var4_4.append("Deleted Changer with ID: " + var1_1 + "\n");
        var4_4.append("  - TAPE_MEDIA_CHANGER: " + var5_5 + "\n");
        var4_4.append("  - MEDIA_LOCATION: " + var6_6 + "\n");
        var4_4.append("  - TAPE_CARTRIDGE: " + var7_7 + "\n");
        var4_4.append("  - NODE: " + var8_8 + "\n");
        var4_4.append("  - PORT: " + var9_9 + "\n");
        var4_4.append("---------------------------------------------\n");
        try {
            var3_3.close();
        }
        catch (SQLException v5) {}
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage(1, TapeLibraryDBHelper.CLASSNAME, var2_2, var4_4.toString());
        }
        return true;
    }

    public int deleteTapeDrive(String string) {
        String string2 = "deleteTapeDrive";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string2, "device ID: " + string);
        }
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, string2, sQLException);
            }
            return this.cDBNOCONNECTIONERROR;
        }
        TapeDrive tapeDrive = new TapeDrive();
        tapeDrive.setDeviceId(string);
        try {
            tapeDrive.retrieve(dBConnection);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, string2, sQLException);
            }
            return this.cNOLIBRARY;
        }
        int n = 0;
        this.deleteTapeDriveByID(tapeDrive.getTapeDriveId());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, string2, n);
        }
        return n;
    }

    public boolean deleteTapeDrivesByID(int[] nArray) {
        String string = "deleteTapeDrivesByID";
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string, "drive IDs: " + nArray);
        }
        int n = 0;
        while (n < nArray.length) {
            boolean bl2 = this.deleteTapeDriveByID(nArray[n]);
            if (!bl2) {
                bl = false;
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, string);
        }
        return bl;
    }

    public boolean deleteTapeMediaChangersByID(int[] nArray) {
        String string = "deleteTapeDrivesByID";
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, string, "media changer IDs: " + nArray);
        }
        int n = 0;
        while (n < nArray.length) {
            boolean bl2 = this.deleteTapeMediaChangerByID(nArray[n]);
            if (!bl2) {
                bl = false;
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, string);
        }
        return bl;
    }

    private Vector getCapabilityIDs(DBConnection dBConnection, int n) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(n));
        String string = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE " + "TAPE_LIBRARY_ID" + " = (?)";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
        Vector<Integer> vector = new Vector<Integer>();
        while (dBResultSet.next()) {
            vector.add(new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        return vector;
    }

    private HashMap getDrive(DBConnection dBConnection, int n) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResTapeDriveTable.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(n));
        String string = "SELECT LOCATION_ID,NODE_ID FROM " + TResTapeDriveTable.getTablename() + " WHERE " + "TAPE_DRIVE_ID" + " = (?)";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (dBResultSet.next()) {
            hashMap.put("NODE_ID", new Integer(dBResultSet.getInt(2)));
            hashMap.put("LOCATION_ID", new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        return hashMap;
    }

    private HashMap getMediaChanger(DBConnection dBConnection, int n) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResTapeMediaChangerTable.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), String.valueOf(n));
        String string = "SELECT LOCATION_ID,NODE_ID FROM " + TResTapeMediaChangerTable.getTablename() + " WHERE " + "TAPE_MEDIA_CHANGER_ID" + " = (?)";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (dBResultSet.next()) {
            hashMap.put("NODE_ID", new Integer(dBResultSet.getInt(2)));
            hashMap.put("LOCATION_ID", new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        return hashMap;
    }

    public static boolean handleDeadlock(DBConnection dBConnection, LogTraceHelper logTraceHelper, RetryDeleteParameters retryDeleteParameters, Exception exception) {
        logTraceHelper.traceInfo("Deadlock ..... rollback!");
        try {
            dBConnection.rollback();
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceInfo("Exception in rollback  " + sQLException.getMessage());
            retryDeleteParameters.setToRetry(false);
            throw DiskMessageHelper.getServerException("HWN021503E", exception.getMessage(), logTraceHelper);
        }
        retryDeleteParameters.setNumRetries(retryDeleteParameters.getNumRetries() + 1);
        if (retryDeleteParameters.getNumRetries() > retryDeleteParameters.getAllowed_Retries()) {
            retryDeleteParameters.setToRetry(false);
            return false;
        }
        logTraceHelper.traceInfo("Retry " + retryDeleteParameters.getNumRetries() + " after deadlock");
        retryDeleteParameters.setToRetry(true);
        retryDeleteParameters.setMsWaitPeriod((long)((double)retryDeleteParameters.getMult_Retry_Interval() * RetryDeleteParameters.getRandGen().nextDouble() * (double)retryDeleteParameters.getNumRetries()));
        if (retryDeleteParameters.getMsWaitPeriod() < retryDeleteParameters.getMin_Retry_Internal()) {
            retryDeleteParameters.setMsWaitPeriod(retryDeleteParameters.getMin_Retry_Internal());
        }
        try {
            Thread.sleep(retryDeleteParameters.getMsWaitPeriod());
        }
        catch (InterruptedException interruptedException) {
            logTraceHelper.traceInfo("InterruptedException " + exception.getMessage());
        }
        return true;
    }
}

