/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelStorageL0
extends GraphModel {
    private static final long serialVersionUID = 6774716902275923587L;
    public static final GraphScopedType SUBSYSTEMGROUP = new GraphScopedType(GraphSubsystemGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType TAPELIBRARYGROUP = new GraphScopedType(GraphTapeLibraryGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelStorageL0(ID iD) {
        super(iD);
    }

    protected void initGroupByCapabilities() {
        int n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL;
        Integer n2 = new Integer(n);
        this.groupByCapabilitiesH.put(SUBSYSTEMGROUP, n2);
        n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        n2 = new Integer(n);
        this.groupByCapabilitiesH.put(TAPELIBRARYGROUP, n2);
    }

    public void applyGrouping(Hashtable hashtable) {
        this.groupFocusSubsystem(hashtable);
        this.groupFocusTapeLibrary(hashtable);
    }

    private void groupFocusSubsystem(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphSubsystemGroup.TYPE);
        this.removeAll(GraphSubsystemGroup2Subsystem.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphSubsystem.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphSubsystem)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(SUBSYSTEMGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphSubsystemGroup graphSubsystemGroup = new GraphSubsystemGroup(string);
            GraphSubsystemGroup.ID iD = (GraphSubsystemGroup.ID)graphSubsystemGroup.getEntityID();
            graphSubsystemGroup.setDisplayName(graphGroupKey.getLabel());
            graphSubsystemGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphSubsystemGroup.setSortingValue(graphGroupKey);
            graphSubsystemGroup.setGroupKey(graphGroupKey);
            this.put(graphSubsystemGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphSubsystem graphSubsystem = (GraphSubsystem)vector.elementAt(n);
                GraphSubsystem.ID iD2 = (GraphSubsystem.ID)graphSubsystem.getEntityID();
                GraphSubsystemGroup2Subsystem graphSubsystemGroup2Subsystem = new GraphSubsystemGroup2Subsystem(iD.getID() + "+" + iD2.getID());
                graphSubsystemGroup2Subsystem.setSubsystemGroupID(iD);
                graphSubsystemGroup2Subsystem.setSubsystemID(iD2);
                this.put(graphSubsystemGroup2Subsystem);
                ++n;
            }
        }
    }

    private void groupFocusTapeLibrary(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphTapeLibraryGroup.TYPE);
        this.removeAll(GraphTapeLibraryGroup2TapeLibrary.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphTapeLibrary.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphTapeLibrary)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(TAPELIBRARYGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphTapeLibraryGroup graphTapeLibraryGroup = new GraphTapeLibraryGroup(string);
            GraphTapeLibraryGroup.ID iD = (GraphTapeLibraryGroup.ID)graphTapeLibraryGroup.getEntityID();
            graphTapeLibraryGroup.setDisplayName(graphGroupKey.getLabel());
            graphTapeLibraryGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphTapeLibraryGroup.setSortingValue(graphGroupKey);
            graphTapeLibraryGroup.setGroupKey(graphGroupKey);
            this.put(graphTapeLibraryGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)vector.elementAt(n);
                GraphTapeLibrary.ID iD2 = (GraphTapeLibrary.ID)graphTapeLibrary.getEntityID();
                GraphTapeLibraryGroup2TapeLibrary graphTapeLibraryGroup2TapeLibrary = new GraphTapeLibraryGroup2TapeLibrary(iD.getID() + "+" + iD2.getID());
                graphTapeLibraryGroup2TapeLibrary.setTapeLibraryGroupID(iD);
                graphTapeLibraryGroup2TapeLibrary.setTapeLibraryID(iD2);
                this.put(graphTapeLibraryGroup2TapeLibrary);
                ++n;
            }
        }
    }

    public void applyFiltering(int n) {
        Boolean bl;
        GraphEntity graphEntity;
        Enumeration enumeration;
        int n2;
        int n3;
        GraphEntity.ID iD;
        GraphEntity graphEntity2;
        Enumeration enumeration2 = this.enumerate(GraphSubsystemGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity2 = (GraphSubsystemGroup)enumeration2.nextElement();
            iD = (GraphSubsystemGroup.ID)graphEntity2.getEntityID();
            n3 = 0;
            n2 = 0;
            enumeration = this.associator(GraphSubsystemGroup2Subsystem.TYPE, iD);
            while (enumeration.hasMoreElements()) {
                graphEntity = (GraphSubsystem)enumeration.nextElement();
                ++n3;
                bl = n == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(graphEntity) ? Boolean.FALSE : Boolean.TRUE);
                graphEntity.setIsFilterable(bl);
                if (bl.booleanValue()) continue;
                ++n2;
            }
            ((GraphSubsystemGroup)graphEntity2).setNumOfSubsystems(new Integer(n3));
            ((GraphSubsystemGroup)graphEntity2).setNumOfAbnormalSubsystems(new Integer(n2));
            graphEntity2.setIsFilterable(n2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity2 = (GraphTapeLibraryGroup)enumeration2.nextElement();
            iD = (GraphTapeLibraryGroup.ID)graphEntity2.getEntityID();
            n3 = 0;
            n2 = 0;
            enumeration = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, iD);
            while (enumeration.hasMoreElements()) {
                graphEntity = (GraphTapeLibrary)enumeration.nextElement();
                ++n3;
                bl = n == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(graphEntity) ? Boolean.FALSE : Boolean.TRUE);
                graphEntity.setIsFilterable(bl);
                if (bl.booleanValue()) continue;
                ++n2;
            }
            ((GraphTapeLibraryGroup)graphEntity2).setNumOfTapeLibraries(new Integer(n3));
            ((GraphTapeLibraryGroup)graphEntity2).setNumOfAbnormalTapeLibraries(new Integer(n2));
            graphEntity2.setIsFilterable(n2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        private static final long serialVersionUID = -2211714331969547911L;

        public ID() {
            super("StorageL0", null);
        }
    }
}

