/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.guid;

import java.io.Serializable;
import org.eclipse.aperi.guid.impl.GUIDImpl;

public class GUID
implements Serializable {
    static final long serialVersionUID = 8852999985820224541L;
    private GUIDImpl guidImpl;

    public static GUID readGUID() {
        return new GUID(GUIDImpl.readGUID());
    }

    private GUID(GUIDImpl gUIDImpl) {
        this.guidImpl = gUIDImpl;
    }

    public GUID(String string) throws Exception {
        this.guidImpl = new GUIDImpl(string);
    }

    public GUID(String string, int n) {
        this.guidImpl = new GUIDImpl(string, n);
    }

    public String toString() {
        return this.guidImpl.toString();
    }

    public String toNoDotString() {
        return this.guidImpl.toNoDotString();
    }

    public String toJava15String() {
        return this.guidImpl.toJava15String();
    }

    public byte[] toByteArray() {
        return this.guidImpl.toByteArray();
    }

    public static void main(String[] stringArray) {
        try {
            GUID.testDottedGUID();
            GUID.testUndottedGUID();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void testDottedGUID() throws Exception {
        String string = "44.bd.be.51.ce.67.11.da.81.6e.00.0d.60.6f.7f.c9";
        String string2 = "44bdbe51-ce67-11da-816e-000d606f7fc9";
        String string3 = "44.bd.be.51.ce.67.11.da.81.6e.00.0d.60.6f.7f.c9";
        String string4 = "44bdbe51ce6711da816e000d606f7fc9";
        short[] sArray = new short[16];
        sArray[0] = 68;
        sArray[1] = 189;
        sArray[2] = 190;
        sArray[3] = 81;
        sArray[4] = 206;
        sArray[5] = 103;
        sArray[6] = 17;
        sArray[7] = 218;
        sArray[8] = 129;
        sArray[9] = 110;
        sArray[11] = 13;
        sArray[12] = 96;
        sArray[13] = 111;
        sArray[14] = 127;
        sArray[15] = 201;
        short[] sArray2 = sArray;
        GUID gUID = new GUID(string);
        System.out.println("Test dots constructor for " + string);
        if (!gUID.toJava15String().equals(string2)) {
            throw new Exception("test FAILED");
        }
        System.out.println("j15    PASSED: " + string2);
        if (!gUID.toString().equals(string3)) {
            throw new Exception("test FAILED");
        }
        System.out.println("dots   PASSED: " + string3);
        if (!gUID.toNoDotString().equals(string4)) {
            throw new Exception("test FAILED");
        }
        System.out.println("nodots PASSED: " + string4);
        byte[] byArray = gUID.toByteArray();
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xFF) != (sArray2[n] & 0xFF)) {
                throw new Exception("Test FAILED " + byArray[n] + " != " + (sArray2[n] & 0xFF));
            }
            ++n;
        }
        System.out.println("toByteArray() PASSED");
        System.out.println("");
    }

    private static void testUndottedGUID() throws Exception {
        String string = "44bdbe51ce6711da816e000d606f7fc9";
        String string2 = "44bdbe51-ce67-11da-816e-000d606f7fc9";
        String string3 = "44.bd.be.51.ce.67.11.da.81.6e.00.0d.60.6f.7f.c9";
        String string4 = "44bdbe51ce6711da816e000d606f7fc9";
        short[] sArray = new short[16];
        sArray[0] = 68;
        sArray[1] = 189;
        sArray[2] = 190;
        sArray[3] = 81;
        sArray[4] = 206;
        sArray[5] = 103;
        sArray[6] = 17;
        sArray[7] = 218;
        sArray[8] = 129;
        sArray[9] = 110;
        sArray[11] = 13;
        sArray[12] = 96;
        sArray[13] = 111;
        sArray[14] = 127;
        sArray[15] = 201;
        short[] sArray2 = sArray;
        GUID gUID = new GUID(string, 1);
        System.out.println("Test no dots constructor for " + string);
        if (!gUID.toJava15String().equals(string2)) {
            throw new Exception("test FAILED");
        }
        System.out.println("j15    PASSED: " + string2);
        if (!gUID.toString().equals(string3)) {
            throw new Exception("test FAILED");
        }
        System.out.println("dots   PASSED: " + string3);
        if (!gUID.toNoDotString().equals(string4)) {
            throw new Exception("test FAILED");
        }
        System.out.println("nodots PASSED: " + string4);
        byte[] byArray = gUID.toByteArray();
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xFF) != (sArray2[n] & 0xFF)) {
                throw new Exception("Test FAILED " + byArray[n] + " != " + (sArray2[n] & 0xFF));
            }
            ++n;
        }
        System.out.println("toByteArray() PASSED");
        System.out.println("");
    }
}

