/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.aperi.infrastructure.database.DBConnection;

public class Database
implements Serializable {
    static final String className = Database.class.getName();
    private static final String db2AppDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
    private static final String db2NetDriver = "COM.ibm.db2.jdbc.net.DB2Driver";
    private static final String db2JccDriver = "com.ibm.db2.jcc.DB2Driver";
    private String driver = "COM.ibm.db2.jdbc.app.DB2Driver";
    private boolean isJccDriver = false;
    private String url;
    private String user;
    private String password;
    private boolean autoCommit = false;
    private static ClassLoader loader = null;
    private static Driver driverInstance = null;
    private static Class loadedDriverClass = null;
    private static final String envName = "APERI";

    public Database(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.password = string3;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
        if (string != null && string.equals(db2JccDriver)) {
            this.isJccDriver = true;
        }
    }

    public static void setDriverJar(String string) {
        if (string != null) {
            URL[] uRLArray = null;
            if (string.toLowerCase().endsWith("db2jcc.jar")) {
                int n = string.lastIndexOf(File.separator);
                String string2 = null;
                string2 = n == -1 ? "" : string.substring(0, n + 1);
                uRLArray = new URL[2];
                try {
                    uRLArray[0] = new URL("file", null, String.valueOf(string2) + "db2jcc.jar");
                    uRLArray[1] = new URL("file", null, String.valueOf(string2) + "db2jcc_license_cu.jar");
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return;
                }
            }
            uRLArray = new URL[1];
            try {
                uRLArray[0] = new URL("file", null, string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
            loader = new URLClassLoader(uRLArray, Database.class.getClassLoader());
        }
    }

    public static synchronized Class loadDriver(String string) {
        Class<?> clazz = loadedDriverClass;
        if (loadedDriverClass == null) {
            try {
                clazz = loader == null ? Class.forName(string) : Class.forName(string, true, loader);
                driverInstance = (Driver)clazz.newInstance();
                loadedDriverClass = clazz;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            loadedDriverClass.getName().equals(string);
        }
        return clazz;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return null;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public synchronized DBConnection getConnection() throws SQLException {
        return this.getConnection(this.url, this.user, this.password);
    }

    private synchronized DBConnection getConnection(String string, String string2, String string3) throws SQLException {
        DBConnection dBConnection = null;
        Connection connection = null;
        Database.loadDriver(this.driver);
        Properties properties = new Properties();
        properties.setProperty("user", string2);
        properties.setProperty("password", string3);
        if (this.isJccDriver) {
            properties.setProperty("clientProgramName", envName + Thread.currentThread().getName());
        }
        connection = driverInstance == null ? DriverManager.getConnection(string, properties) : driverInstance.connect(string, properties);
        connection.setAutoCommit(this.autoCommit);
        dBConnection = new DBConnection(connection);
        return dBConnection;
    }
}

