/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.Debug;

public class TpcDBDataPopulator {
    protected static String schema = "Aperi.";
    protected static String url = "jdbc:derby://localhost:1527/Aperi";
    protected static String user = "Aperi";
    protected static String password = "Aperi";
    static boolean failIfAlreadyExists = false;
    static Random rand = new Random(0L);
    static Connection con = null;
    public static final String INSERT_SERVER = "INSERT INTO " + schema + "T_RES_HOST " + "\t(GUID, HOST_URL, OS_TYPE, OS_VERSION, " + "\tNETWORK_NAME, DOMAIN_NAME, COMPUTER_ID, HOST_NAME, HARDWARE_ID, VENDOR_ID, " + "\tTIME_ZONE, DISCOVERED_TIME, CPU_ARCHITECTURE, ORIGINAL_ALIAS," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int modelId = 0;
    public static String INSERT_MODEL = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (?,?,?)";
    public static String[] NAMES = new String[]{"Mayaguez", "Aguadilla", "CaboRojo", "Moca", "SanGerman", "Ponce", "Patillas", "Penuelas", "SanJuan", "Vieques", "Culebra", "Anasco", "Arecibo", "Adjuntas", "Aibonito", "Aguada", "Isabela", "LasMarias", "Maricao", "SabanaGrande", "Guanica", "Lares", "Cayey", "Camuy", "Carolina", "Canovanas", "RioGrande", "RioPiedras", "VegaBaja", "VegaAlta", "ToaBaja", "Jayuya", "Utuado", "Florida", "Hatillo", "Quebradillas", "SanSebastian", "Yauco", "Fajardo", "SantaIsabelle", "Humacao", "Manati", "Ciales", "Villalba", "Barceloneta", "Naranjito", "Comerio", "AguasBuenas", "Cidra", "Luquillo", "Naguabo", "Ceiba", "SanLorenzo", "Arroyo", "Maunabo", "Orocovis", "Bayamon"};
    static int TOTAL_SERVERS = 800;
    static int TOTAL_SWITCHES = 10;
    static int TOTAL_SA = 10;
    static int guid = 0;
    static int nameCtr = 0;
    static int computerId = 299;
    public static final String INSERT_HBA = "INSERT INTO " + schema + "T_RES_HBA " + "\t(VENDOR_ID, MODEL_ID, API_VERSION, HBA_WWN, HBA_ID, NAME, SERIAL_NUMBER, DRIVER_VERSION," + "\tDRIVER_NAME, HOST_ID," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static int nodeId = 0;
    public static final String INSERT_NODE = "INSERT INTO " + schema + "T_RES_NODE " + "\t(SCSI_SUPPORT, " + "\tNODE_ID, " + "\tNAME, " + "\tNAME_FORMAT, " + "\tPLATFORM_TYPE, RNID_TYPE, SYSTEM_ID," + "\tBLADE_ID, DISPLAY_NAME, DISPLAY_ICON_TYPE, " + "\tMGMT_URL_ADDR, MGMT_TEL_ADDR, MGMT_SNMP_ADDR," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static int node2HbaId = 0;
    public static final String INSERT_NODE2HBA = "INSERT INTO " + schema + "T_RES_NODE2HBA " + "\t(NODE2HBA_ID, NODE_ID, HBA_ID," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?)";
    static int portId = 0;
    public static final String INSERT_PORT = "INSERT INTO " + schema + "T_RES_PORT " + "\t(PORT_ID, NAME, NAME_FORMAT, PORT_NUMBER, TYPE, " + "\tNODE_ID, DISPLAY_NAME, DISPLAY_ICON_TYPE, RIO_LOOP_ID, " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ? )";
    public static int portStatId = 0;
    public static final String INSERT_PORT_STAT = "INSERT INTO " + schema + "T_PRF_FABRIC_PORT " + "\t(TIME_ID, PORT_ID, INTERVAL_LEN, SEND_KB, RECV_KB, SEND_PKTS, RECV_PKTS, PEAK_TX_RATE, PEAK_RX_RATE)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int hbaID = 0;
    public static final String INSERT_SWITCH = "INSERT INTO " + schema + "T_RES_SWITCH " + "\t(SWITCH_WWN, SWITCH_ID, VENDOR_ID, MODEL_ID, PARENT_SWITCH_WWN, SERIAL_NUMBER, DESCRIPTION," + "\tCONTACT, LOCATION, IP_ADDRESS,  DISPLAY_NAME, DOMAIN, MANAGEMENT_ID, MGMT_TEL_ADDR," + "\tMGMT_SNMP_ADDR, MGMT_URL_ADDR, VERSION," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS, USER_ATTRIB1, USER_ATTRIB2, USER_ATTRIB3)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int switch2portId = 0;
    public static final String INSERT_SWITCH2PORT = "INSERT INTO " + schema + "T_RES_SWITCH2PORT " + "\t(SWITCH2PORT_ID, SWITCH_WWN, PORT_ID)" + "\tVALUES (?, ?, ?)";
    public static int switchId = 0;
    public static final String INSERT_STORAGE_SUBSYSTEM = "INSERT INTO " + schema + "T_RES_STORAGE_SUBSYSTEM " + "\t(SUBSYSTEM_ID, " + "\tALLOCATED_CAPACITY, " + "\tAVAILABLE_CAPACITY, " + "\tBACKEND_STORAGE_CAPACITY," + "\tVENDOR_ID, " + "\tMODEL_ID," + "\tNAME, " + "\tNAME_FORMAT, " + "\tCACHE, " + "\tNVS, " + "\tDG_FREESPACE," + "\tN_DISKS, " + "\tN_LUNS, " + "\tLAST_PROBE_TIME, " + "\tPROBE_STATUS, " + "\tGROUP_ID, \t" + "\tVG_CAPACITY," + "\tVG_FREESPACE, " + "\tOS_TYPE, " + "\tPRODUCT_STATES, " + "\tTYPE, " + "\tIP_ADDRESS, " + "\tCODE_LEVEL," + "\tSERIAL_NUMBER," + "\tDISPLAY_NAME,  " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + "\t\t?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_PHY_PE = "INSERT INTO " + schema + "T_RES_PHY_PE " + "\t(PHY_PE_ID, PE_NAME, SERIAL_NUMBER, VENDOR_ID, MODEL_ID, FIRMWARE_REVISION, DISPLAY_NAME) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_PE2NODE = "INSERT INTO " + schema + "T_RES_PE2NODE " + "\t(PE2NODE_ID, PHY_PE_ID, NODE_ID, DETECTABLE) " + "\tVALUES (?, ?, ?, ?)";
    public static int pe2nodeId = 0;
    public static int phyPEId = 0;
    public static short subsystemId = 0;
    public static int fabricId = 0;
    public static final String INSERT_FABRIC = "INSERT INTO " + schema + "T_RES_FABRIC " + "\t(FABRIC_WWN, " + "\tFABRIC_ID, SAN_WWN, SUPPORTS_ZONING, ACTIVE, PARENT_FABRIC_WWN, IS_PHYSICAL, DISPLAY_NAME, " + "\tCREATION_CLASS_NAME_ID, " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS, USER_ATTRIB1, USER_ATTRIB2, USER_ATTRIB3)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int fabrid2SwitchID = 0;
    public static final String INSERT_FABRIC2SWITCH = "INSERT INTO " + schema + "T_RES_FABRIC2SWITCH " + "\t(FABRIC2SWITCH_ID, FABRIC_WWN, SWITCH_WWN," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?)";
    public static int port2portId = 0;
    public static final String INSERT_PORT2PORT = "INSERT INTO " + schema + "T_RES_PORT2PORT " + "\t(PORT2PORT_ID, PORT_ID1, PORT_ID2," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?)";
    public static final String INSERT_STORAGE_VOLUME = "INSERT INTO " + schema + "T_RES_STORAGE_VOLUME " + "\t(SVID, CAPACITY, PACKAGE_REDUNDANCY, DATA_REDUNDANCY, SIZE_ALLOCATED," + "\tBLOCK_SIZE, CONSUMABLE_BLOCKS, NATIVE_STATUS, NUMBER_OF_BLOCKS, THROTTLE," + "\tNAME, NAME_FORMAT, SUBSYSTEM_ID, " + "\t POOL_ID,  LOGICAL_DISK_TYPE, MIRROR_COUNT," + "\tIS_SWAP, USE_COUNT, SNAP_SOURCE_ID, IS_VCMDB, REPLICATION_MODE, NOT_EXPOSED, OVERHEAD, LSS," + "\tSERIAL_NUMBER, " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + "\t?, ?, ?, ?, ?, ?)";
    static int vol = 1;
    public static final String INSERT_STORAGE_POOL = "INSERT INTO " + schema + "T_RES_STORAGE_POOL" + "\t(POOL_ID, TOTAL_MANAGED_SPACE, REMAINING_MANAGED_SPACE, PRIMORDIAL, CAPACITY, " + "\tEXTENT_SIZE, NATIVE_STATUS, NUMBER_OF_BACKEND_VOLUMES, NUMBER_OF_STORAGE_VOLUMES, " + "\tTOTAL_AVAILABLE_SPACE, ELEMENT_TYPE, RAID_LEVEL, NAME, " + "\tINSTANCE_ID, SUBSYSTEM_ID,  VOL_GROUP_TYPE,  CONFIG, DISK_GROUP_ID, " + "\tFORMAT, SURFACED_LUN_CAP, UNSURFACED_LUN_CAP, DISCOVERED_TIME, LAST_PROBE_TIME," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS, CLASS_NAME_ID) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, " + "\t?, ?, ?, ?, ?, ?, ?)";
    public static int physicalVolumeId = 0;
    public static String INSERT_PHYSICAL_VOLUME = "INSERT INTO " + schema + "T_RES_PHYSICAL_VOLUME " + "\t(PHYSICAL_VOLUME_ID, VENDOR_ID, MODEL_ID, DISK_GROUP_ID, SUBSYSTEM_ID, CAPACITY, OPERATIONAL_STATUS, DEVICE_ID) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    public static int diskGroupId = 0;
    public static final String INSERT_DISK_GROUP = "INSERT INTO " + schema + "T_RES_DISK_GROUP " + "\t(DISK_GROUP_ID, NAME, DESCRIPTION, RAID_LEVEL, ARRAY, STORAGE_EXTENT_ID, SUBSYSTEM_ID, TAG ) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    public static int extentId = 0;
    public static final String INSERT_STORAGE_EXTENT = "INSERT INTO " + schema + "T_RES_STORAGE_EXTENT " + "\t(STORAGE_EXTENT_ID, " + "\tNUM_EXTENTS, EXTENT_TYPE, POOL_ID, TOTAL_CAPACITY, FREE_SPACE, VOLS_IN_STORAGE_EXTENT, NAME, OTHER_NAME," + "\tCONFIG, VOL_GROUP_ID, GROUP_ID, CREATION_CLASS_NAME_ID, SYSTEM_CREATION_CLASS_NAME_ID, DEVICE_ID, SUBSYSTEM_ID, SYSTEM_NAMES_ID) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
    public static final String INSERT_DATA_PATH = "INSERT INTO " + schema + "T_RES_DATA_PATH" + "\t(DATA_PATH_ID, HOST_LUN_ID, DEVICE_LUN_ID, INITIATOR_PORT_ID, TARGET_PORT_ID, VOLUME_ID, UNKNOWN_HOST_NAME)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String SELECT_HOST_FROM_WWN = "select distinct       HOST.COMPUTER_ID HOST_ID from       " + schema + "T_RES_HOST HOST, " + "\t\t" + schema + "T_RES_HBA HBA, " + schema + "T_RES_NODE2HBA NODE2HBA, " + schema + "T_RES_NODE NODE, " + "      " + schema + "T_RES_PORT PORT1 " + "where " + "      HOST.COMPUTER_ID = HBA.HOST_ID and " + "      HBA.HBA_ID = NODE2HBA.HBA_ID and " + "      NODE2HBA.NODE_ID = NODE.NODE_ID and " + "      NODE.NODE_ID = PORT1.NODE_ID and " + "      PORT1.NAME = ?";
    public static final String INSERT_ZSET = "INSERT INTO " + schema + "T_RES_ZSET " + "\t(ZSET_ID, SAN_WWN, ACTIVE, DESCRIPTION, ZSET_NAME)" + "\tVALUES (?, ?, ?, ?, ?)";
    public static final String INSERT_ZONE = "INSERT INTO " + schema + "T_RES_ZONE " + "\t(ZONE_ID, SAN_WWN, ZONE_TYPE, VENDOR_MODEL, ACTIVE, ZONE_NAME, DESCRIPTION)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_ZSET2ZONE = "INSERT INTO " + schema + "T_RES_ZSET2ZONE " + "\t(ZONE_ID, ZSET_ID)" + "\tVALUES (?, ?)";
    public static final String INSERT_ZSONE2PORT = "INSERT INTO " + schema + "T_RES_ZSET2PORT " + "\t(PORT_WWN, ZONE_ID)" + "\tVALUES (?, ?)";
    public static final String INSERT_ZONE2MEMBER = "INSERT INTO " + schema + "T_RES_ZONE2MEMBER " + "\t(ZONE_ID, MEMBER)" + "\tVALUES (?, ?)";
    public static String SELECT_PORTS_FROM_HOST = "select distinct    " + schema + "T_RES_HOST.COMPUTER_ID COMPUTER_ID, " + "    PORT1.PORT_ID PORT_ID " + "from " + "    " + schema + "T_RES_HOST," + schema + "T_RES_HBA HBA," + schema + "T_RES_NODE2HBA NODE2HBA," + schema + "T_RES_NODE NODE, " + "     " + schema + "T_RES_PORT PORT1 " + "where " + "     " + schema + "T_RES_HOST.COMPUTER_ID = HBA.HOST_ID and " + "      HBA.HBA_ID = NODE2HBA.HBA_ID and " + "      NODE2HBA.NODE_ID = NODE.NODE_ID and " + "      NODE.NODE_ID = PORT1.NODE_ID and" + "\t\t" + schema + "T_RES_HOST.COMPUTER_ID = ?";
    public static String SELECT_PORTS_FROM_SWITCH = "select distinct     PORT.PORT_ID PORT_ID from    " + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_SWITCH2PORT SWITCH2PORT, " + "    " + schema + "T_RES_PORT PORT " + "where " + "  SWITCH.SWITCH_WWN = ? and " + "  SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN and " + "  SWITCH2PORT.PORT_ID = PORT.PORT_ID";
    public static String SELECT_PORTS_FROM_SUBSYSTEM = "select distinct     PORT.PORT_ID PORT_ID from    " + schema + "T_RES_STORAGE_SUBSYSTEM SUBSYSTEM," + schema + "T_RES_NODE NODE, " + "   " + schema + "T_RES_PORT PORT " + "where " + "  SUBSYSTEM.SUBSYSTEM_ID = ? and " + "  SUBSYSTEM.SUBSYSTEM_ID = NODE.SYSTEM_ID and " + "  NODE.NODE_ID = PORT.NODE_ID";
    public static final String SELECT_CONNECTED_PORT = "select distinct     PORT2PORT.PORT_ID1 PORT_ID from     " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT2PORT PORT2PORT " + "where " + "      PORT1.PORT_ID = ? and " + "      PORT1.PORT_ID = PORT2PORT.PORT_ID2 " + "union " + "select distinct " + "    PORT2PORT.PORT_ID2 PORT_ID " + "from " + "    " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT2PORT PORT2PORT " + "where " + "      PORT1.PORT_ID = ? and " + "      PORT1.PORT_ID = PORT2PORT.PORT_ID1";
    public static final String SELECT_PORT_WWN_FROM_PORT_ID = "select distinct     PORT1.NAME NAME from     " + schema + "T_RES_PORT PORT1 " + "where " + "      PORT1.PORT_ID = ?";
    public static final String SELECT_HOST_FROM_ARRAY = "    select \t  HOST2FABRIC.COMPUTER_ID COMPUTER_ID from      (     SELECT distinct         FABRIC.FABRIC_WWN FABRIC_WWN,        " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID " + "    FROM " + "       " + schema + "T_RES_FABRIC FABRIC," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_SWITCH2PORT SWITCH2PORT, " + "       " + schema + "T_RES_NODE NODE," + schema + "T_RES_PORT2PORT PORT2PORT, " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM," + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2 " + "    WHERE " + "        FABRIC.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN AND " + "        FABRIC2SWITCH.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "        SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND " + "        SWITCH2PORT.PORT_ID = PORT1.PORT_ID AND " + "        (PORT1.PORT_ID = PORT2PORT.PORT_ID1 AND PORT2PORT.PORT_ID2 = PORT2.PORT_ID) and " + "        PORT2.NODE_ID = NODE.NODE_ID AND " + "        NODE.SYSTEM_ID =" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ? " + "    union " + "    SELECT distinct " + "        FABRIC.FABRIC_WWN FABRIC_WWN, " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID " + "    FROM " + "       " + schema + "T_RES_FABRIC FABRIC," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_SWITCH2PORT SWITCH2PORT, " + "       " + schema + "T_RES_NODE NODE," + schema + "T_RES_PORT2PORT PORT2PORT, " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM," + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2 " + "    WHERE " + "        FABRIC.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN AND " + "        FABRIC2SWITCH.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "        SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND " + "        SWITCH2PORT.PORT_ID = PORT1.PORT_ID AND " + "        (PORT1.PORT_ID = PORT2PORT.PORT_ID2 AND PORT2PORT.PORT_ID1 = PORT2.PORT_ID) and " + "        PORT2.NODE_ID = NODE.NODE_ID AND " + "        NODE.SYSTEM_ID =" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ? " + "        ) as FABRIC2SUBSYSTEM, " + " (  select distinct " + "     " + schema + "T_RES_HOST.COMPUTER_ID, " + "      FABRIC.FABRIC_WWN " + "      from " + "           " + schema + "T_RES_HOST," + schema + "T_RES_HBA HBA," + schema + "T_RES_NODE2HBA NODE2HBA," + schema + "T_RES_NODE NODE, " + "           " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2," + schema + "T_RES_PORT2PORT PORT2PORT, " + "           " + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_FABRIC FABRIC, " + "           " + schema + "T_RES_SWITCH2PORT SWITCH2PORT " + "      where " + "           " + schema + "T_RES_HOST.COMPUTER_ID = HBA.HOST_ID and " + "            HBA.HBA_ID = NODE2HBA.HBA_ID and " + "            NODE2HBA.NODE_ID = NODE.NODE_ID and " + "            NODE.NODE_ID = PORT1.NODE_ID and " + "            (PORT1.PORT_ID = PORT2PORT.PORT_ID2 and PORT2.PORT_ID = PORT2PORT.PORT_ID1) and " + "            PORT2.PORT_ID = SWITCH2PORT.PORT_ID and " + "            SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "            SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN and " + "            FABRIC2SWITCH.FABRIC_WWN = FABRIC.FABRIC_WWN " + "      union " + "      select distinct " + "     " + schema + "T_RES_HOST.COMPUTER_ID, " + "      FABRIC.FABRIC_WWN " + "      from " + "           " + schema + "T_RES_HOST," + schema + "T_RES_HBA HBA," + schema + "T_RES_NODE2HBA NODE2HBA," + schema + "T_RES_NODE NODE, " + "           " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2," + schema + "T_RES_PORT2PORT PORT2PORT, " + "           " + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_FABRIC FABRIC, " + "           " + schema + "T_RES_SWITCH2PORT SWITCH2PORT " + "      where " + "           " + schema + "T_RES_HOST.COMPUTER_ID = HBA.HOST_ID and " + "            HBA.HBA_ID = NODE2HBA.HBA_ID and " + "            NODE2HBA.NODE_ID = NODE.NODE_ID and " + "            NODE.NODE_ID = PORT1.NODE_ID and " + "            (PORT1.PORT_ID = PORT2PORT.PORT_ID1 and PORT2.PORT_ID = PORT2PORT.PORT_ID2) and " + "            PORT2.PORT_ID = SWITCH2PORT.PORT_ID and " + "            SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "            SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN and " + "            FABRIC2SWITCH.FABRIC_WWN = FABRIC.FABRIC_WWN " + "      ) as HOST2FABRIC " + "    where " + "       HOST2FABRIC.FABRIC_WWN = FABRIC2SUBSYSTEM.FABRIC_WWN ";
    public static final String SELECT_VOLUME_FROM_SUBSYSTEM = "SELECT distinct  \t" + schema + "T_RES_STORAGE_VOLUME.SVID SVID " + "FROM " + "   " + schema + "T_RES_STORAGE_VOLUME," + schema + "T_RES_STORAGE_SUBSYSTEM " + "WHERE " + "   " + schema + "T_RES_STORAGE_VOLUME.SUBSYSTEM_ID =" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and " + "   " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static final String SELECT_SUBSYSTEM = "SELECT distinct \t" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID " + "FROM " + "   " + schema + "T_RES_STORAGE_SUBSYSTEM";

    public static void executeStmt(PreparedStatement preparedStatement) throws SQLException {
        block3: {
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (failIfAlreadyExists) {
                    throw sQLException;
                }
                if ("23505".equals(sQLException.getSQLState())) break block3;
                throw sQLException;
            }
        }
    }

    public static void deleteTable(String string) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement("DELETE FROM " + string);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning("Deleting tableNamed: " + string);
            Debug.warning(exception);
            System.exit(-1);
        }
    }

    public static void cleanupFabric() {
        TpcDBDataPopulator.deleteTable(schema + "T_RES_HOST");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_SWITCH");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_SWITCH_BLADE");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_SWITCH_BLADE_TYPE");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_SWITCH2PORT");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_STORAGE_SUBSYSTEM");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_PORT");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_HBA");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_PORT2PORT");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_NODE");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_NODE2HBA");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_FABRIC2SWITCH");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_NODE2HBA");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_STORAGE_POOL");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_STORAGE_VOLUME");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_STORAGE_EXTENT");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_PHYSICAL_VOLUME");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_DISK_GROUP");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_DATA_PATH");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_DATA_PATH");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_MODEL");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_VENDOR");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_USER_ATTRIBUTES");
        TpcDBDataPopulator.deleteTable(schema + "T_PRF_FABRIC_PORT");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_PE2NODE");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_PHY_PE");
    }

    public static void cleanupZones() {
        TpcDBDataPopulator.deleteTable(schema + "T_RES_ZONE");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_ZSET2ZONE");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_ZSET");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_ZONE2ALIAS");
    }

    public static void cleanupConfiguration() {
        TpcDBDataPopulator.deleteTable(schema + "T_RES_REGISTERED_CIMOM");
        TpcDBDataPopulator.deleteTable(schema + "T_RES_STORAGE_SUBSYSTEM");
    }

    public static void updateTable(String string) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(string);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning("INSERTING QUERY: " + string);
            Debug.warning(exception);
            System.exit(-1);
        }
    }

    public static void populateConfiguration() {
        String cfr_ignored_0 = "INSERT INTO " + schema + "T_RES_HOST (" + "GUID, HOST_URL, OS_TYPE, OS_VERSION, HOST_NAME, NETWORK_NAME, DOMAIN_NAME,COMPUTER_ID,HARDWARE_ID,\tVENDOR,\tTIME_ZONE,\tDISCOVERED_TIME) " + "VALUES ('12345678901234567890123456789000','mayaguez.almaden.ibm.com',\t1,'Windows XP',\t'9.1.72.75','9.1.72.75','almaden.ibm.com',299, 'PXS-100', 2, 'America/Los_Angeles','2005-01-01 11:11:11')";
        String cfr_ignored_1 = "INSERT INTO " + schema + "T_RES_HOST (" + "GUID, HOST_URL, OS_TYPE, OS_VERSION, HOST_NAME, NETWORK_NAME, DOMAIN_NAME,COMPUTER_ID,HARDWARE_ID,\tVENDOR,\tTIME_ZONE,\tDISCOVERED_TIME) " + "VALUES ('12345678901234567890123456789000','mayaguez.almaden.ibm.com',\t2,'Windows XP',\t'9.1.72.76','9.1.72.76','almaden.ibm.com',375, 'PXS-100', 2, 'America/Los_Angeles','2005-01-01 11:11:11')";
        TpcDBDataPopulator.populateModels();
        TpcDBDataPopulator.populateVendors();
        TpcDBDataPopulator.populateSwitchBladeTypes();
    }

    public static void populateModels() {
        String string = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (0, 'Unknown','Unknown')";
        String string2 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (1, 'Unknown','Unknown')";
        String string3 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (2, 'Unknown','Unknown')";
        String string4 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (3, 'Unknown','Unknown')";
        String string5 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (4, 'Unknown','Unknown')";
        String string6 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (10, 'DS4000','Model1')";
        String string7 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (11, 'DS8000','Model2')";
        String string8 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (12, 'ESS800','Model5')";
        String string9 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (20, 'Clarion','Model1')";
        String string10 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (21, 'Simetrix','Model2')";
        String string11 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (22, 'CIMEX','Model3')";
        String string12 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (30, 'EVA','Model1')";
        String string13 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (31, 'XP128','Model2')";
        String string14 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (32, 'EMA','Model3')";
        String string15 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (60, 'Sphereon 4500','Model3')";
        String string16 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (70, 'SilkWorm 6400','Model3')";
        String string17 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (80, 'MDS 9000','Model3')";
        String cfr_ignored_0 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (90, 'SANbox 5200','Model3')";
        String cfr_ignored_1 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (91, 'SAN Blade 2310','Model3')";
        String string18 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (100, 'ST3120020A','Model1')";
        String string19 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (101, 'ST3120022A','Model2')";
        String string20 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (102, 'ST3120022AS','Model3')";
        TpcDBDataPopulator.updateTable(string);
        TpcDBDataPopulator.updateTable(string2);
        TpcDBDataPopulator.updateTable(string3);
        TpcDBDataPopulator.updateTable(string4);
        TpcDBDataPopulator.updateTable(string5);
        TpcDBDataPopulator.updateTable(string6);
        TpcDBDataPopulator.updateTable(string7);
        TpcDBDataPopulator.updateTable(string8);
        TpcDBDataPopulator.updateTable(string9);
        TpcDBDataPopulator.updateTable(string10);
        TpcDBDataPopulator.updateTable(string11);
        TpcDBDataPopulator.updateTable(string12);
        TpcDBDataPopulator.updateTable(string13);
        TpcDBDataPopulator.updateTable(string14);
        TpcDBDataPopulator.updateTable(string15);
        TpcDBDataPopulator.updateTable(string16);
        TpcDBDataPopulator.updateTable(string17);
        TpcDBDataPopulator.updateTable(string18);
        TpcDBDataPopulator.updateTable(string19);
        TpcDBDataPopulator.updateTable(string20);
    }

    public static void populateVendors() {
        String string = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (0, 'Unknown','Unknown')";
        String string2 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (1, 'IBM','IBM Inc.')";
        String string3 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (2, 'EMX','Vendor 2')";
        String string4 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (3, 'HP','Vendor 3')";
        String string5 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (4, 'Veritas','Vendor 3')";
        String string6 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (5, 'Hitachi','Vendor 3')";
        String string7 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (6, 'McData','Vendor 3')";
        String string8 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (7, 'Brocade','Vendor 3')";
        String string9 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (8, 'Cisco','Vendor 3')";
        String string10 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (9, 'Cisco','Vendor 3')";
        String string11 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (10, 'Seagate','Vendor 3')";
        TpcDBDataPopulator.updateTable(string);
        TpcDBDataPopulator.updateTable(string2);
        TpcDBDataPopulator.updateTable(string3);
        TpcDBDataPopulator.updateTable(string4);
        TpcDBDataPopulator.updateTable(string5);
        TpcDBDataPopulator.updateTable(string6);
        TpcDBDataPopulator.updateTable(string7);
        TpcDBDataPopulator.updateTable(string8);
        TpcDBDataPopulator.updateTable(string9);
        TpcDBDataPopulator.updateTable(string10);
        TpcDBDataPopulator.updateTable(string11);
    }

    public static void populateSwitchBladeTypes() {
        String string = "INSERT INTO " + schema + "T_RES_SWITCH_BLADE_TYPE (SWITCH_BLADE_TYPE_ID, TYPE_NAME) VALUES (0, 'Unknown')";
        String string2 = "INSERT INTO " + schema + "T_RES_SWITCH_BLADE_TYPE (SWITCH_BLADE_TYPE_ID, TYPE_NAME) VALUES (1, 'Unknown')";
        TpcDBDataPopulator.updateTable(string);
        TpcDBDataPopulator.updateTable(string2);
    }

    public static void cleanup() {
        TpcDBDataPopulator.deleteTable(schema + "T_RES_FABRIC");
        TpcDBDataPopulator.cleanupFabric();
        TpcDBDataPopulator.cleanupConfiguration();
    }

    public static String zeropadded(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - stringBuffer.length();
        while (n2-- > 0) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static String zeropadded(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l, 16));
        int n2 = n - stringBuffer.length();
        while (n2-- > 0) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static Vector nameGenerator(int n) {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < NAMES.length && n > 0) {
            vector.add(NAMES[n2]);
            --n;
            ++n2;
        }
        n2 = 0;
        while (n2 < NAMES.length - 1 && n > 0) {
            int n3 = n2 + 1;
            while (n3 < NAMES.length && n > 0) {
                vector.add(String.valueOf(NAMES[n2]) + "_" + NAMES[n3]);
                --n;
                ++n3;
            }
            ++n2;
        }
        NAMES = new String[vector.size()];
        vector.toArray(NAMES);
        return vector;
    }

    public static String ctrToIP(long l) {
        int n = (int)(l % 255L) + 1;
        int n2 = (int)(l / 255L % 255L) + 1;
        int n3 = (int)(l / 65025L % 255L) + 1;
        int n4 = (int)(l / 16581375L % 255L) + 1;
        return String.valueOf(String.valueOf(n4 += 8)) + "." + String.valueOf(n3) + "." + String.valueOf(n2) + "." + String.valueOf(n);
    }

    public static int createPort(String string, int n, Integer n2, int n3, String string2) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(INSERT_PORT);
            int n4 = 1;
            preparedStatement.setInt(n4++, portId++);
            preparedStatement.setString(n4++, string);
            preparedStatement.setInt(n4++, 0);
            preparedStatement.setShort(n4++, (short)n);
            preparedStatement.setShort(n4++, (short)n3);
            if (n2 == null) {
                preparedStatement.setNull(n4++, 4);
            } else {
                preparedStatement.setObject(n4++, n2);
            }
            preparedStatement.setString(n4++, string2);
            preparedStatement.setShort(n4++, (short)1);
            preparedStatement.setInt(n4++, 1);
            preparedStatement.setShort(n4++, (short)rand.nextInt());
            preparedStatement.setShort(n4++, (short)0);
            preparedStatement.setShort(n4++, (short)0);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return portId - 1;
    }

    public static void createServerGroup(int n, String string, long l, String string2, int n2, int n3, int n4, int n5, int n6, String string3, String string4, int n7, int n8) {
        try {
            int n9 = 16 - string2.length();
            String string5 = null;
            int n10 = 1;
            int n11 = 0;
            while (n11 < n) {
                String string6 = String.valueOf(string2) + TpcDBDataPopulator.zeropadded(n2, n9);
                PreparedStatement preparedStatement = null;
                String string7 = null;
                String string8 = NAMES[nameCtr++ % NAMES.length];
                preparedStatement = con.prepareStatement(INSERT_SERVER);
                n10 = 1;
                string5 = String.valueOf(string8) + "." + string;
                string7 = TpcDBDataPopulator.zeropadded(string6, 32);
                preparedStatement.setString(n10++, string7);
                preparedStatement.setString(n10++, string5);
                Random random = new Random();
                String string9 = null;
                int n12 = Math.abs(random.nextInt() % 7);
                switch (n12) {
                    case 0: {
                        string9 = "Unknown";
                        break;
                    }
                    case 1: {
                        switch (Math.abs(random.nextInt() % 3)) {
                            case 0: {
                                string9 = "Red Hat";
                                break;
                            }
                            case 1: {
                                string9 = "Mandrake";
                                break;
                            }
                            case 2: {
                                string9 = "Suse";
                            }
                        }
                        break;
                    }
                    case 2: {
                        string9 = "AIX 5.0";
                        break;
                    }
                    case 3: {
                        string9 = "HPUX";
                        break;
                    }
                    case 4: {
                        switch (Math.abs(random.nextInt() % 2)) {
                            case 0: {
                                string9 = "Windows NT 4.0 sp2";
                                break;
                            }
                            case 1: {
                                string9 = "Windows NT";
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (Math.abs(random.nextInt() % 3)) {
                            case 0: {
                                string9 = "Windows 2000";
                                break;
                            }
                            case 1: {
                                string9 = "Windows XP";
                                break;
                            }
                            case 2: {
                                string9 = "Windowx XP Advance Server";
                            }
                        }
                        break;
                    }
                    case 6: {
                        string9 = "Solaris 8.0";
                    }
                }
                preparedStatement.setInt(n10++, n12);
                preparedStatement.setString(n10++, string9);
                preparedStatement.setString(n10++, TpcDBDataPopulator.ctrToIP(l));
                ++l;
                preparedStatement.setString(n10++, string);
                preparedStatement.setInt(n10++, computerId);
                preparedStatement.setString(n10++, string5);
                int n13 = string5.length() < 19 ? string5.length() - 1 : 19;
                preparedStatement.setBytes(n10++, TpcDBDataPopulator.zeropadded(string5.substring(0, n13), 20).getBytes());
                preparedStatement.setShort(n10++, (short)1);
                preparedStatement.setString(n10++, "PST");
                preparedStatement.setTimestamp(n10++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                preparedStatement.setShort(n10++, (short)0);
                preparedStatement.setString(n10++, "alias");
                int n14 = 0;
                int n15 = rand.nextInt() % 1000;
                n14 = n15 < 700 ? 0 : 1;
                preparedStatement.setShort(n10++, (short)n14);
                n15 = rand.nextInt() % 1000;
                n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                preparedStatement.setShort(n10++, (short)(n14 * (rand.nextInt() % 3)));
                preparedStatement.setShort(n10++, (short)n14);
                if (n6 <= 0) {
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                }
                preparedStatement.close();
                long l2 = n3 / 16;
                long l3 = n2;
                int n16 = 0;
                while (n16 < n4) {
                    String string10 = String.valueOf(string2) + TpcDBDataPopulator.zeropadded(l3, n9);
                    preparedStatement = con.prepareStatement(INSERT_HBA);
                    n10 = 1;
                    preparedStatement.setShort(n10++, (short)n7);
                    preparedStatement.setShort(n10++, (short)n8);
                    preparedStatement.setShort(n10++, (short)1);
                    preparedStatement.setString(n10++, string10);
                    preparedStatement.setInt(n10++, hbaID);
                    if (n7 == 9) {
                        preparedStatement.setString(n10++, "SAN Blade 2310");
                    } else {
                        preparedStatement.setString(n10++, "HBA Name:" + string10);
                    }
                    String string11 = "23DF-JI8Q-KWS9WK28SKF-DKASIK2-DFJM28SA-KE498SKLASDAK-LASD892-3HAJU1J-H1SKJ-DAH12-312";
                    int n17 = Math.abs(string10.hashCode()) % (string11.length() - 16);
                    String string12 = string11.substring(n17, n17 + 15);
                    preparedStatement.setString(n10++, string12);
                    String string13 = null;
                    switch (Math.abs(string10.hashCode()) % 6) {
                        case 0: {
                            string13 = "1.0.1";
                            break;
                        }
                        case 1: {
                            string13 = "2.0.4";
                            break;
                        }
                        case 2: {
                            string13 = "1.0.3";
                            break;
                        }
                        case 3: {
                            string13 = "1.0.2";
                            break;
                        }
                        case 4: {
                            string13 = "2.0.1";
                            break;
                        }
                        case 5: {
                            string13 = "1.0.0";
                            break;
                        }
                        default: {
                            string13 = "3.0.1";
                        }
                    }
                    preparedStatement.setString(n10++, string13);
                    preparedStatement.setString(n10++, "driver name");
                    preparedStatement.setInt(n10++, computerId);
                    n14 = 0;
                    n15 = rand.nextInt() % 1000;
                    n14 = n15 < 700 ? 0 : 1;
                    preparedStatement.setShort(n10++, (short)n14);
                    n15 = rand.nextInt() % 1000;
                    n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                    preparedStatement.setShort(n10++, (short)(n14 * (rand.nextInt() % 3)));
                    preparedStatement.setShort(n10++, (short)n14);
                    if (n6 <= 0) {
                        TpcDBDataPopulator.executeStmt(preparedStatement);
                    }
                    preparedStatement.close();
                    long l4 = l2 / 16L;
                    long l5 = l3;
                    int n18 = 0;
                    while (n18 < n5) {
                        String string14 = String.valueOf(string2) + TpcDBDataPopulator.zeropadded(l5, n9);
                        preparedStatement = con.prepareStatement(INSERT_NODE);
                        n10 = 1;
                        preparedStatement.setShort(n10++, (short)1);
                        preparedStatement.setInt(n10++, nodeId);
                        preparedStatement.setString(n10++, string14);
                        preparedStatement.setInt(n10++, 0);
                        preparedStatement.setShort(n10++, (short)1);
                        preparedStatement.setShort(n10++, (short)1);
                        preparedStatement.setNull(n10++, 4);
                        preparedStatement.setNull(n10++, 4);
                        if (string3 != null) {
                            preparedStatement.setString(n10++, String.valueOf(string3) + ":" + n18);
                        } else {
                            preparedStatement.setNull(n10++, 12);
                        }
                        preparedStatement.setShort(n10++, (short)1);
                        preparedStatement.setString(n10++, "Mgmt URL Addr");
                        preparedStatement.setString(n10++, "Mgmt TEL Addr");
                        preparedStatement.setString(n10++, "Mgmt SNMP Addr");
                        n15 = rand.nextInt() % 1000;
                        n14 = n15 < 700 ? 0 : 1;
                        preparedStatement.setShort(n10++, (short)n14);
                        n15 = rand.nextInt() % 1000;
                        n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                        preparedStatement.setShort(n10++, (short)(n14 * (rand.nextInt() % 3)));
                        preparedStatement.setShort(n10++, (short)n14);
                        TpcDBDataPopulator.executeStmt(preparedStatement);
                        preparedStatement.close();
                        preparedStatement = con.prepareStatement(INSERT_NODE2HBA);
                        n10 = 1;
                        preparedStatement.setInt(n10++, node2HbaId++);
                        preparedStatement.setInt(n10++, nodeId);
                        preparedStatement.setInt(n10++, hbaID);
                        n14 = 0;
                        n15 = rand.nextInt() % 1000;
                        n14 = n15 < 700 ? 0 : 1;
                        preparedStatement.setShort(n10++, (short)n14);
                        n15 = rand.nextInt() % 1000;
                        n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                        preparedStatement.setShort(n10++, (short)(n14 * (rand.nextInt() % 3)));
                        preparedStatement.setShort(n10++, (short)n14);
                        if (n6 <= 0) {
                            TpcDBDataPopulator.executeStmt(preparedStatement);
                        }
                        preparedStatement.close();
                        long l6 = l4 / 16L;
                        long l7 = l5;
                        int n19 = 0;
                        while (n19 < 2) {
                            String string15 = String.valueOf(string2) + TpcDBDataPopulator.zeropadded(l7, n9);
                            preparedStatement = con.prepareStatement(INSERT_PORT);
                            n10 = 1;
                            preparedStatement.setInt(n10++, portId++);
                            preparedStatement.setString(n10++, string15);
                            preparedStatement.setInt(n10++, 0);
                            preparedStatement.setShort(n10++, (short)n19);
                            preparedStatement.setShort(n10++, (short)1);
                            preparedStatement.setInt(n10++, nodeId);
                            if (string4 != null) {
                                preparedStatement.setString(n10++, String.valueOf(string4) + n19);
                            } else {
                                preparedStatement.setNull(n10++, 12);
                            }
                            preparedStatement.setShort(n10++, (short)1);
                            preparedStatement.setInt(n10++, 1);
                            n14 = 0;
                            n15 = rand.nextInt() % 1000;
                            n14 = n15 < 700 ? 0 : 1;
                            preparedStatement.setShort(n10++, (short)n14);
                            n15 = rand.nextInt() % 1000;
                            n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                            preparedStatement.setShort(n10++, (short)(n14 * (rand.nextInt() % 3)));
                            preparedStatement.setShort(n10++, (short)n14);
                            TpcDBDataPopulator.executeStmt(preparedStatement);
                            preparedStatement.close();
                            Debug.info("PortWWN:" + string15);
                            l7 += l6;
                            ++n19;
                        }
                        l5 += l2;
                        ++nodeId;
                        ++n18;
                    }
                    l3 += l2;
                    ++hbaID;
                    ++n16;
                }
                n2 += n3;
                ++computerId;
                --n6;
                ++n11;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
            System.exit(-1);
        }
    }

    public static void createServers() {
    }

    public static void createRealSwitchGroup(int n, String string, int n2, int n3, long l, int n4, int n5, int n6, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, String string8) {
        try {
            int n7 = 1;
            int n8 = 16 - string.length();
            int n9 = 0;
            while (n9 < n) {
                int n10 = 0;
                String string9 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(n2, n8);
                PreparedStatement preparedStatement = null;
                preparedStatement = con.prepareStatement(INSERT_SWITCH);
                n7 = 1;
                int n11 = Math.abs(string9.hashCode());
                preparedStatement.setString(n7++, string9);
                preparedStatement.setInt(n7++, switchId);
                preparedStatement.setShort(n7++, (short)n5);
                preparedStatement.setShort(n7++, (short)n6);
                preparedStatement.setString(n7++, string5);
                String string10 = "23DF-JI8Q-KWS9WK28SKF-DKASIK2-DFJM28SA-KE498SKLASDAK-LASD892-3HAJU1J-H1SKJ-DAH12-312";
                int n12 = n11 % (string10.length() - 16);
                String string11 = string10.substring(n12, n12 + 15);
                if (bl) {
                    preparedStatement.setString(n7++, string11);
                } else {
                    preparedStatement.setNull(n7++, 12);
                }
                preparedStatement.setString(n7++, "Switch: " + string9);
                preparedStatement.setString(n7++, string2);
                String string12 = null;
                switch (n11 % 3) {
                    case 0: {
                        string12 = "Almaden";
                        break;
                    }
                    case 1: {
                        string12 = "San Jose";
                        break;
                    }
                    case 2: {
                        string12 = "Boulder";
                    }
                }
                preparedStatement.setString(n7++, string12);
                preparedStatement.setString(n7++, TpcDBDataPopulator.ctrToIP(l++));
                preparedStatement.setString(n7++, string3);
                preparedStatement.setString(n7++, string4);
                preparedStatement.setString(n7++, "");
                preparedStatement.setString(n7++, "");
                preparedStatement.setString(n7++, "");
                preparedStatement.setString(n7++, "");
                String string13 = null;
                switch (n11 % 6) {
                    case 0: {
                        string13 = "1.0.1";
                        break;
                    }
                    case 1: {
                        string13 = "2.1.0";
                        break;
                    }
                    case 2: {
                        string13 = "2.2.1";
                        break;
                    }
                    case 3: {
                        string13 = "2.4.1";
                        break;
                    }
                    case 4: {
                        string13 = "2.2.3";
                        break;
                    }
                    case 5: {
                        string13 = "1.8.1";
                        break;
                    }
                    default: {
                        string13 = "3.0.1";
                    }
                }
                preparedStatement.setString(n7++, string13);
                int n13 = 0;
                int n14 = rand.nextInt() % 1000;
                n13 = n14 < 700 ? 0 : 1;
                preparedStatement.setShort(n7++, (short)n13);
                n14 = rand.nextInt() % 1000;
                n13 = n14 < 800 ? 0 : (n14 < 950 ? 1 : 2);
                preparedStatement.setShort(n7++, (short)0);
                preparedStatement.setShort(n7++, (short)n13);
                preparedStatement.setString(n7++, string6);
                preparedStatement.setString(n7++, string7);
                preparedStatement.setString(n7++, string8);
                TpcDBDataPopulator.executeStmt(preparedStatement);
                preparedStatement.close();
                System.out.println("Switch Port:");
                long l2 = n2;
                long l3 = n3 / 4096;
                int n15 = 0;
                while (n15 < n4) {
                    String string14 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(l2, n8);
                    n7 = 1;
                    preparedStatement = con.prepareStatement(INSERT_PORT);
                    preparedStatement.setInt(n7++, portId);
                    preparedStatement.setString(n7++, string14);
                    preparedStatement.setInt(n7++, 0);
                    preparedStatement.setShort(n7++, (short)n10++);
                    preparedStatement.setShort(n7++, (short)1);
                    preparedStatement.setNull(n7++, 4);
                    preparedStatement.setString(n7++, "Manually Entered name");
                    preparedStatement.setShort(n7++, (short)1);
                    preparedStatement.setInt(n7++, 1);
                    n14 = rand.nextInt() % 1000;
                    n13 = n14 < 700 ? 0 : 1;
                    preparedStatement.setShort(n7++, (short)n13);
                    n14 = rand.nextInt() % 1000;
                    n13 = n14 < 800 ? 0 : (n14 < 950 ? 1 : 2);
                    preparedStatement.setShort(n7++, (short)0);
                    preparedStatement.setShort(n7++, (short)n13);
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                    preparedStatement.close();
                    preparedStatement = con.prepareStatement(INSERT_SWITCH2PORT);
                    n7 = 1;
                    preparedStatement.setInt(n7++, switch2portId++);
                    preparedStatement.setString(n7++, string9);
                    preparedStatement.setInt(n7++, portId);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    Debug.info("PortWWN:" + string14);
                    l2 += l3;
                    ++portId;
                    ++n15;
                }
                n2 += n3;
                ++switchId;
                ++n9;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
            System.exit(-1);
        }
    }

    public static void createStorageGroup(int n, int n2, int n3, String string, int n4, int n5, long l, int n6, boolean bl, boolean bl2, String string2, String string3, String string4, boolean bl3, long l2, long l3, long l4, int n7, int n8, String string5) {
        try {
            int n9 = 16 - string.length();
            int n10 = 0;
            while (n10 < n) {
                String string6 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(n4, n9);
                PreparedStatement preparedStatement = null;
                int n11 = Math.abs(string6.hashCode());
                preparedStatement = con.prepareStatement(INSERT_STORAGE_SUBSYSTEM);
                int n12 = 1;
                preparedStatement.setInt(n12++, n2);
                preparedStatement.setBigDecimal(n12++, new BigDecimal(l2));
                preparedStatement.setBigDecimal(n12++, new BigDecimal(l3));
                preparedStatement.setBigDecimal(n12++, new BigDecimal(l4));
                preparedStatement.setShort(n12++, (short)n7);
                preparedStatement.setShort(n12++, (short)n8);
                preparedStatement.setString(n12++, "Storage Array: " + string6);
                preparedStatement.setShort(n12++, subsystemId);
                preparedStatement.setInt(n12++, 0x100000);
                preparedStatement.setInt(n12++, 1024);
                preparedStatement.setBigDecimal(n12++, new BigDecimal(10000000));
                preparedStatement.setInt(n12++, 0);
                preparedStatement.setInt(n12++, 0);
                preparedStatement.setTimestamp(n12++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                preparedStatement.setString(n12++, "1");
                preparedStatement.setInt(n12++, 1);
                preparedStatement.setBigDecimal(n12++, new BigDecimal(10000000));
                preparedStatement.setBigDecimal(n12++, new BigDecimal(10000000));
                preparedStatement.setShort(n12++, (short)1);
                preparedStatement.setString(n12++, "Product States");
                preparedStatement.setString(n12++, string5);
                preparedStatement.setString(n12++, TpcDBDataPopulator.ctrToIP(l++));
                String string7 = null;
                switch (n11 % 6) {
                    case 0: {
                        string7 = "1.0.1";
                        break;
                    }
                    case 1: {
                        string7 = "2.1.0";
                        break;
                    }
                    case 2: {
                        string7 = "2.2.1";
                        break;
                    }
                    case 3: {
                        string7 = "2.4.1";
                        break;
                    }
                    case 4: {
                        string7 = "2.2.3";
                        break;
                    }
                    case 5: {
                        string7 = "1.8.1";
                    }
                }
                preparedStatement.setString(n12++, string7);
                String string8 = "23DFJ I8QKWS9 WK28S KFDKASI K2DFJM2 8SAKE4 98SKL ASDAK LASD8 923HAJ U1JH1S KJDAH 12312";
                int n13 = n11 % (string8.length() - 16);
                String string9 = string8.substring(n13, n13 + 15);
                if (bl3) {
                    preparedStatement.setString(n12++, string9);
                } else {
                    preparedStatement.setNull(n12++, 12);
                }
                preparedStatement.setString(n12++, String.valueOf(string2) + (n10 > 0 ? "" + n10 : ""));
                int n14 = 0;
                int n15 = rand.nextInt() % 1000;
                n14 = n15 < 700 ? 0 : 1;
                preparedStatement.setShort(n12++, (short)n14);
                n15 = rand.nextInt() % 1000;
                n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                preparedStatement.setShort(n12++, (short)0);
                preparedStatement.setShort(n12++, (short)n14);
                if (bl) {
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                }
                preparedStatement.close();
                n12 = 1;
                preparedStatement = con.prepareStatement(INSERT_PHY_PE);
                preparedStatement.setInt(n12++, phyPEId);
                preparedStatement.setString(n12++, "Storage Array: " + string6);
                preparedStatement.setString(n12++, string8);
                preparedStatement.setInt(n12++, n7);
                preparedStatement.setInt(n12++, n8);
                preparedStatement.setString(n12++, string7);
                preparedStatement.setString(n12++, String.valueOf(string4) + (n10 > 0 ? "" + n10 : ""));
                if (bl2) {
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                }
                preparedStatement.close();
                long l5 = n5 / 16;
                long l6 = n4;
                int n16 = 0;
                while (n16 < 1) {
                    String string10 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(l6, n9);
                    preparedStatement = con.prepareStatement(INSERT_NODE);
                    n12 = 1;
                    preparedStatement.setShort(n12++, (short)1);
                    preparedStatement.setInt(n12++, nodeId);
                    preparedStatement.setString(n12++, string10);
                    preparedStatement.setInt(n12++, 0);
                    preparedStatement.setShort(n12++, (short)1);
                    preparedStatement.setShort(n12++, (short)1);
                    preparedStatement.setInt(n12++, n2);
                    preparedStatement.setNull(n12++, 4);
                    preparedStatement.setString(n12++, String.valueOf(string3) + ":" + n16);
                    preparedStatement.setString(n12++, null);
                    preparedStatement.setString(n12++, null);
                    preparedStatement.setString(n12++, null);
                    preparedStatement.setString(n12++, null);
                    n14 = 0;
                    n15 = rand.nextInt() % 1000;
                    n14 = n15 < 700 ? 0 : 1;
                    preparedStatement.setShort(n12++, (short)n14);
                    n15 = rand.nextInt() % 1000;
                    n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                    preparedStatement.setShort(n12++, (short)0);
                    preparedStatement.setShort(n12++, (short)n14);
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                    preparedStatement.close();
                    preparedStatement = con.prepareStatement(INSERT_PE2NODE);
                    n12 = 1;
                    preparedStatement.setInt(n12++, pe2nodeId++);
                    preparedStatement.setInt(n12++, phyPEId);
                    preparedStatement.setInt(n12++, nodeId);
                    preparedStatement.setInt(n12++, 0);
                    if (bl2) {
                        TpcDBDataPopulator.executeStmt(preparedStatement);
                    }
                    preparedStatement.close();
                    long l7 = l6;
                    long l8 = l5 / 4096L;
                    int n17 = 0;
                    while (n17 < n6) {
                        String string11 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(l7, n9);
                        preparedStatement = con.prepareStatement(INSERT_PORT);
                        n12 = 1;
                        preparedStatement.setInt(n12++, portId++);
                        preparedStatement.setString(n12++, string11);
                        preparedStatement.setInt(n12++, 0);
                        preparedStatement.setShort(n12++, (short)n17);
                        preparedStatement.setShort(n12++, (short)1);
                        preparedStatement.setInt(n12++, nodeId);
                        preparedStatement.setString(n12++, null);
                        preparedStatement.setString(n12++, null);
                        preparedStatement.setInt(n12++, 1);
                        n14 = 0;
                        n15 = rand.nextInt() % 1000;
                        n14 = n15 < 700 ? 0 : 1;
                        preparedStatement.setShort(n12++, (short)n14);
                        n15 = rand.nextInt() % 1000;
                        n14 = n15 < 800 ? 0 : (n15 < 950 ? 1 : 2);
                        preparedStatement.setShort(n12++, (short)0);
                        preparedStatement.setShort(n12++, (short)n14);
                        TpcDBDataPopulator.executeStmt(preparedStatement);
                        preparedStatement.close();
                        Debug.info("PortWWN from Subsystem:" + string11);
                        l7 += l8;
                        ++n17;
                    }
                    l6 += l5;
                    ++nodeId;
                    ++n16;
                }
                n2 += n3;
                n4 += n5;
                subsystemId = (short)(subsystemId + 1);
                ++phyPEId;
                ++n10;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void createSanGroup(int n, String string, int n2, int n3, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, String string6, String string7) {
        try {
            int n4 = 16 - string.length();
            int n5 = 0;
            while (n5 < n) {
                String string8 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(n2, n4);
                PreparedStatement preparedStatement = null;
                preparedStatement = con.prepareStatement(INSERT_FABRIC);
                int n6 = 1;
                preparedStatement.setString(n6++, string8);
                preparedStatement.setInt(n6++, fabricId++);
                preparedStatement.setString(n6++, string4);
                preparedStatement.setShort(n6++, (short)(bl2 ? 1 : 0));
                preparedStatement.setShort(n6++, (short)(bl ? 1 : 0));
                if (string2 != null) {
                    preparedStatement.setString(n6++, string2);
                } else {
                    preparedStatement.setNull(n6++, 12);
                }
                preparedStatement.setShort(n6++, (short)(string2 == null ? 1 : 0));
                if (string3 != null) {
                    preparedStatement.setString(n6++, string3);
                } else {
                    preparedStatement.setNull(n6++, 12);
                }
                preparedStatement.setShort(n6++, (short)1);
                int n7 = 0;
                int n8 = rand.nextInt() % 1000;
                n7 = n8 < 700 ? 0 : 1;
                preparedStatement.setShort(n6++, (short)n7);
                n8 = rand.nextInt() % 1000;
                n7 = n8 < 800 ? 0 : (n8 < 950 ? 1 : 2);
                preparedStatement.setShort(n6++, (short)0);
                preparedStatement.setShort(n6++, (short)n7);
                preparedStatement.setString(n6++, string5);
                preparedStatement.setString(n6++, string6);
                preparedStatement.setString(n6++, string7);
                TpcDBDataPopulator.executeStmt(preparedStatement);
                preparedStatement.close();
                n2 += n3;
                ++n5;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void createSan2Switch(String string, String string2) {
        try {
            int n = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_FABRIC2SWITCH);
            preparedStatement.setInt(n++, fabrid2SwitchID++);
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n++, string2);
            int n2 = 0;
            int n3 = rand.nextInt() % 1000;
            n2 = n3 < 700 ? 0 : 1;
            preparedStatement.setShort(n++, (short)n2);
            n3 = rand.nextInt() % 1000;
            n2 = n3 < 800 ? 0 : (n3 < 950 ? 1 : 2);
            preparedStatement.setShort(n++, (short)0);
            preparedStatement.setShort(n++, (short)n2);
            Debug.info("SAN WWN:" + string);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    private static int getPortIdForWwn(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = con.prepareStatement("SELECT PORT.PORT_ID PORT_ID FROM " + schema + "T_RES_PORT PORT WHERE PORT.NAME = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            try {
                return resultSet.getInt("PORT_ID");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1;
    }

    public static boolean connectionExits(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = con.prepareStatement("SELECT     PORT2PORT.PORT_ID1 PORT_ID FROM     " + schema + "T_RES_PORT PORT, " + "    " + schema + "T_RES_PORT2PORT PORT2PORT " + "WHERE " + "    (PORT.PORT_ID = PORT2PORT.PORT_ID1 and " + "    PORT.NAME = ?) or " + "    (PORT.PORT_ID = PORT2PORT.PORT_ID2 and " + "    PORT.NAME = ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            preparedStatement.close();
            return true;
        }
        preparedStatement.close();
        return false;
    }

    public static void createPort2Port(String string, String string2) {
        TpcDBDataPopulator.createPort2Port(string, string2, true);
    }

    public static void createPort2Port(int n, int n2) {
        try {
            int n3 = 1;
            Debug.info("Port2port: " + n + " -> " + n2);
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_PORT2PORT);
            preparedStatement.setInt(n3++, port2portId++);
            preparedStatement.setInt(n3++, n);
            preparedStatement.setInt(n3++, n2);
            int n4 = 0;
            int n5 = rand.nextInt() % 1000;
            n4 = n5 < 700 ? 0 : 1;
            preparedStatement.setShort(n3++, (short)n4);
            n5 = rand.nextInt() % 1000;
            n4 = n5 < 800 ? 0 : (n5 < 950 ? 1 : 2);
            preparedStatement.setShort(n3++, (short)0);
            preparedStatement.setShort(n3++, (short)n4);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void createPort2Port(String string, String string2, boolean bl) {
        try {
            int n = 1;
            Debug.info("Port2port: " + string + " -> " + string2);
            if (bl && failIfAlreadyExists && TpcDBDataPopulator.connectionExits(string)) {
                throw new RuntimeException("Connection to port already exits: " + string);
            }
            if (bl && failIfAlreadyExists && TpcDBDataPopulator.connectionExits(string2)) {
                throw new RuntimeException("Connection to port already exits:" + string2);
            }
            int n2 = TpcDBDataPopulator.getPortIdForWwn(string);
            int n3 = TpcDBDataPopulator.getPortIdForWwn(string2);
            if (n2 == -1 || n3 == -1) {
                if (n2 == -1) {
                    Debug.warning("Port not found for WWN:" + string);
                } else {
                    Debug.warning("Port not found for WWN:" + string2);
                }
                throw new RuntimeException("Invalid port number");
            }
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_PORT2PORT);
            preparedStatement.setInt(n++, port2portId++);
            preparedStatement.setInt(n++, n2);
            preparedStatement.setInt(n++, n3);
            int n4 = 0;
            int n5 = rand.nextInt() % 1000;
            n4 = n5 < 700 ? 0 : 1;
            preparedStatement.setShort(n++, (short)n4);
            n5 = rand.nextInt() % 1000;
            n4 = n5 < 800 ? 0 : (n5 < 950 ? 1 : 2);
            preparedStatement.setShort(n++, (short)0);
            preparedStatement.setShort(n++, (short)n4);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
            if (bl && !TpcDBDataPopulator.connectionExits(string)) {
                throw new RuntimeException("Connection to port wasnt created: " + string);
            }
            if (bl && !TpcDBDataPopulator.connectionExits(string2)) {
                throw new RuntimeException("Connection to port wasnt created:" + string2);
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void createStorageVolume(int n, int n2, int n3, String string, int n4, String string2, int n5) {
        try {
            int n6 = 0;
            while (n6 < n) {
                PreparedStatement preparedStatement = null;
                preparedStatement = con.prepareStatement(INSERT_STORAGE_VOLUME);
                int n7 = 1;
                Debug.info("Volume ID: " + n2 + " on SP:" + n4 + " on Subsystem:" + n5);
                preparedStatement.setInt(n7++, n2);
                preparedStatement.setBigDecimal(n7++, new BigDecimal(1000000000));
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setDouble(n7++, 1.0);
                preparedStatement.setBigDecimal(n7++, new BigDecimal(1000000000));
                preparedStatement.setBigDecimal(n7++, new BigDecimal(1000000000));
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setBigDecimal(n7++, new BigDecimal(1000000000));
                preparedStatement.setBigDecimal(n7++, new BigDecimal(1000000000));
                preparedStatement.setString(n7++, "Volume: " + n2);
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setInt(n7++, n5);
                preparedStatement.setInt(n7++, n4);
                preparedStatement.setString(n7++, "1");
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setString(n7++, "Y");
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setInt(n7++, 1);
                preparedStatement.setString(n7++, "Y");
                preparedStatement.setString(n7++, "1");
                preparedStatement.setString(n7++, "Y");
                preparedStatement.setBigDecimal(n7++, new BigDecimal(1000000000));
                preparedStatement.setShort(n7++, (short)1);
                preparedStatement.setString(n7++, "SerialNumber");
                int n8 = 0;
                int n9 = rand.nextInt() % 1000;
                n8 = n9 < 700 ? 0 : 1;
                preparedStatement.setShort(n7++, (short)n8);
                n9 = rand.nextInt() % 1000;
                n8 = n9 < 800 ? 0 : (n9 < 950 ? 1 : 2);
                preparedStatement.setShort(n7++, (short)0);
                preparedStatement.setShort(n7++, (short)n8);
                TpcDBDataPopulator.executeStmt(preparedStatement);
                preparedStatement.close();
                n2 += n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
            System.exit(-1);
        }
    }

    public static void createStoragePool(int n, int n2, int n3, int n4, int n5, int n6, long l, long l2, double d, int n7, long l3) {
        try {
            int n8 = 1;
            int n9 = 0;
            while (n9 < n) {
                PreparedStatement preparedStatement = null;
                preparedStatement = con.prepareStatement(INSERT_STORAGE_POOL);
                n8 = 1;
                preparedStatement.setInt(n8++, n2);
                preparedStatement.setBigDecimal(n8++, new BigDecimal(l));
                preparedStatement.setBigDecimal(n8++, new BigDecimal(l2));
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setDouble(n8++, d);
                preparedStatement.setInt(n8++, n7);
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setInt(n8++, 1);
                preparedStatement.setInt(n8++, 1);
                preparedStatement.setBigDecimal(n8++, new BigDecimal(l3));
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setString(n8++, "" + (n9 + 1));
                preparedStatement.setString(n8++, "SP:" + n2);
                preparedStatement.setInt(n8++, n4);
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setInt(n8++, 1);
                preparedStatement.setShort(n8++, (short)1);
                preparedStatement.setBigDecimal(n8++, new BigDecimal(1000000000));
                preparedStatement.setBigDecimal(n8++, new BigDecimal(1000000000));
                preparedStatement.setTimestamp(n8++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                preparedStatement.setTimestamp(n8++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                int n10 = 0;
                int n11 = rand.nextInt() % 1000;
                n10 = n11 < 700 ? 0 : 1;
                preparedStatement.setShort(n8++, (short)n10);
                n11 = rand.nextInt() % 1000;
                n10 = n11 < 800 ? 0 : (n11 < 950 ? 1 : 2);
                preparedStatement.setShort(n8++, (short)(n10 * (rand.nextInt() % 3)));
                preparedStatement.setShort(n8++, (short)n10);
                preparedStatement.setShort(n8++, (short)1);
                TpcDBDataPopulator.executeStmt(preparedStatement);
                preparedStatement.close();
                int n12 = 0;
                while (n12 < n5) {
                    preparedStatement = con.prepareStatement(INSERT_STORAGE_EXTENT);
                    n8 = 1;
                    preparedStatement.setInt(n8++, extentId);
                    preparedStatement.setInt(n8++, 1);
                    preparedStatement.setInt(n8++, 1);
                    preparedStatement.setInt(n8++, n2);
                    preparedStatement.setInt(n8++, 10000);
                    preparedStatement.setInt(n8++, 1000);
                    preparedStatement.setInt(n8++, 1);
                    preparedStatement.setString(n8++, "ExtentName: " + extentId);
                    preparedStatement.setString(n8++, "Other Name:" + extentId);
                    preparedStatement.setString(n8++, "Config");
                    preparedStatement.setInt(n8++, 1);
                    preparedStatement.setString(n8++, "Group Id");
                    preparedStatement.setInt(n8++, 1);
                    preparedStatement.setInt(n8++, 1);
                    preparedStatement.setString(n8++, "DeviceId:" + extentId);
                    preparedStatement.setInt(n8++, n4);
                    preparedStatement.setShort(n8++, (short)1);
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                    preparedStatement.close();
                    preparedStatement = con.prepareStatement(INSERT_DISK_GROUP);
                    n8 = 1;
                    preparedStatement.setInt(n8++, diskGroupId);
                    preparedStatement.setString(n8++, "DiskGroup Name:" + diskGroupId);
                    preparedStatement.setString(n8++, "Description:");
                    preparedStatement.setString(n8++, "RAID5");
                    preparedStatement.setString(n8++, "Array Name:");
                    preparedStatement.setInt(n8++, extentId);
                    preparedStatement.setInt(n8++, n4);
                    preparedStatement.setString(n8++, "Tag");
                    TpcDBDataPopulator.executeStmt(preparedStatement);
                    preparedStatement.close();
                    int n13 = 0;
                    while (n13 < n6) {
                        preparedStatement = con.prepareStatement(INSERT_PHYSICAL_VOLUME);
                        n8 = 1;
                        n10 = 0;
                        n11 = rand.nextInt() % 1000;
                        n10 = n11 < 900 ? 0 : 1;
                        preparedStatement.setInt(n8++, physicalVolumeId++);
                        preparedStatement.setInt(n8++, 10);
                        preparedStatement.setInt(n8++, 100);
                        preparedStatement.setInt(n8++, diskGroupId);
                        preparedStatement.setInt(n8++, n4);
                        preparedStatement.setInt(n8++, 16000000);
                        preparedStatement.setInt(n8++, n10);
                        preparedStatement.setString(n8++, "DeviceID");
                        TpcDBDataPopulator.executeStmt(preparedStatement);
                        preparedStatement.close();
                        ++n13;
                    }
                    ++diskGroupId;
                    ++extentId;
                    ++n12;
                }
                n2 += n3;
                ++n9;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void populateStorageExtent(int n) {
        String cfr_ignored_0 = "INSERT INTO " + schema + "T_RES_STORAGE_EXTENT (STORAGE_EXTENT_ID, SUBSYSTEM_ID, NAME, NAME_FORMAT) " + "\tVALUES (1, " + n + ", 'RAID0', 'RAID0')";
    }

    private static int getHostIdFromWwn(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = con.prepareStatement(SELECT_HOST_FROM_WWN);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            try {
                return resultSet.getInt("HOST_ID");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1;
    }

    public static void createDataPath(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            int n7 = 1;
            Debug.info("DataPath=Initiator=" + n4 + ", target=" + n5 + ", hostLun=" + n2 + ", devLun=" + n3 + ", svid=" + n6 + ", dpId=" + n);
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_DATA_PATH);
            preparedStatement.setInt(n7++, n);
            preparedStatement.setInt(n7++, n2);
            preparedStatement.setInt(n7++, n3);
            preparedStatement.setInt(n7++, n4);
            preparedStatement.setInt(n7++, n5);
            preparedStatement.setInt(n7++, n6);
            preparedStatement.setString(n7++, "Unknown Host Name");
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static final void createZoneSet(int n, int n2, int n3, String string, short s) {
        try {
            int n4 = 1;
            int n5 = 0;
            while (n5 < n) {
                PreparedStatement preparedStatement = null;
                preparedStatement = con.prepareStatement(INSERT_ZSET);
                n4 = 1;
                preparedStatement.setInt(n4++, n2);
                preparedStatement.setString(n4++, string);
                preparedStatement.setShort(n4++, s);
                preparedStatement.setString(n4++, "ZoneSet:" + n2);
                preparedStatement.setString(n4++, "ZoneSet:" + n2);
                TpcDBDataPopulator.executeStmt(preparedStatement);
                preparedStatement.close();
                n2 += n3;
                ++n5;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static final void createZone(int n, int n2, int n3, String string, short s, short s2) {
        try {
            int n4 = 1;
            int n5 = 0;
            while (n5 < n) {
                PreparedStatement preparedStatement = null;
                preparedStatement = con.prepareStatement(INSERT_ZONE);
                n4 = 1;
                preparedStatement.setInt(n4++, n2);
                preparedStatement.setString(n4++, string);
                preparedStatement.setShort(n4++, s2);
                preparedStatement.setInt(n4++, 0);
                preparedStatement.setShort(n4++, s);
                preparedStatement.setString(n4++, "ZoneName:" + TpcDBDataPopulator.zeropadded(n2, 16) + ":" + s);
                preparedStatement.setString(n4++, "Description:" + TpcDBDataPopulator.zeropadded(n2, 16) + ":" + s);
                TpcDBDataPopulator.executeStmt(preparedStatement);
                preparedStatement.close();
                n2 += n3;
                ++n5;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static final void createZSet2Zone(int n, int n2) {
        try {
            int n3 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_ZSET2ZONE);
            preparedStatement.setInt(n3++, n);
            preparedStatement.setInt(n3++, n2);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static final void createZSet2Port(String string, int n) {
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_ZSONE2PORT);
            preparedStatement.setString(n2++, string);
            preparedStatement.setInt(n2++, n);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static final void createZSet2Member(int n, String string) {
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(INSERT_ZONE2MEMBER);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setString(n2++, string);
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void createSwitches() {
    }

    public static void connectSwitches(String string, long l, long l2, long l3, String string2, long l4, long l5, long l6) {
        int n = 16 - string.length();
        long l7 = l2 / 4096L;
        String string3 = String.valueOf(string) + TpcDBDataPopulator.zeropadded(l + l7 * (l3 - 1L), n);
        long l8 = l5 / 4096L;
        String string4 = String.valueOf(string2) + TpcDBDataPopulator.zeropadded(l4 + l8 * (l6 - 1L), n);
        TpcDBDataPopulator.createPort2Port(string3, string4);
    }

    public static Vector getPortsFromHost(int n) {
        Vector<Object> vector = new Vector<Object>();
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_PORTS_FROM_HOST);
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getObject("PORT_ID"));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return vector;
    }

    public static Vector getPortsFromSwitch(String string) {
        Vector<Object> vector = new Vector<Object>();
        try {
            int n = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_PORTS_FROM_SWITCH);
            preparedStatement.setString(n++, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getObject("PORT_ID"));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return vector;
    }

    public static Vector getPortsFromSubsystem(int n) {
        Vector<Object> vector = new Vector<Object>();
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_PORTS_FROM_SUBSYSTEM);
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getObject("PORT_ID"));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return vector;
    }

    public static Vector getConnectedPorts(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        for (Integer n : vector) {
            if (TpcDBDataPopulator.getConnectedPort(n) == -1) continue;
            vector2.add(n);
        }
        return vector2;
    }

    public static Vector getDisconnectedPorts(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        for (Integer n : vector) {
            if (TpcDBDataPopulator.getConnectedPort(n) != -1) continue;
            vector2.add(n);
        }
        return vector2;
    }

    public static Vector getDisconnectedPortsFromHost(int n) {
        return TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromHost(n));
    }

    public static Vector getDisconnectedPortsFromSubsystem(int n) {
        return TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(n));
    }

    public static Vector getDisconnectedPortsFromSwitch(String string) {
        return TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSwitch(string));
    }

    public static int getConnectedPort(int n) {
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_CONNECTED_PORT);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getInt("PORT_ID");
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return -1;
    }

    public static String getPortWWN(int n) {
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_PORT_WWN_FROM_PORT_ID);
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString("NAME");
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return "";
    }

    public static Vector getHostFromArray(int n) {
        Vector<Object> vector = new Vector<Object>();
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_HOST_FROM_ARRAY);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getObject("COMPUTER_ID"));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return vector;
    }

    public static Vector getVolumeFromArray(int n) {
        Vector<Object> vector = new Vector<Object>();
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_VOLUME_FROM_SUBSYSTEM);
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getObject("SVID"));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return vector;
    }

    public static Vector getArrays() {
        Vector<Object> vector = new Vector<Object>();
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = con.prepareStatement(SELECT_SUBSYSTEM);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getObject("SUBSYSTEM_ID"));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
        return vector;
    }

    public static void addDiskToSubsystem(int n, int n2, int n3, int n4, int n5) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(INSERT_PHYSICAL_VOLUME);
            int n6 = 1;
            preparedStatement.setInt(n6++, physicalVolumeId++);
            preparedStatement.setInt(n6++, n2);
            preparedStatement.setInt(n6++, n3);
            preparedStatement.setNull(n6++, 4);
            preparedStatement.setInt(n6++, n);
            preparedStatement.setInt(n6++, n4);
            preparedStatement.setInt(n6++, n5);
            preparedStatement.setString(n6++, "Device ID");
            TpcDBDataPopulator.executeStmt(preparedStatement);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static void populateStorageSubsystem(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 1000;
            int n9 = 1;
            TpcDBDataPopulator.createStoragePool(n5, n2, n8, n, 1, 2, 100000000L, 100000000L, 9.0, 100000, 100000000L);
            int n10 = 0;
            while (n10 < n5) {
                TpcDBDataPopulator.createStorageVolume(n6, n2, n9, "", n2, "device_id", n);
                n2 += n8;
                ++n10;
            }
            n += n3;
            ++n7;
        }
    }

    public static void populateSan1() {
        try {
            String string;
            int n;
            TpcDBDataPopulator.nameGenerator(TOTAL_SERVERS);
            TpcDBDataPopulator.createServerGroup(4, "boulder.ibm.com", 0L, "00000000", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "almaden.ibm.com", 255L, "11111111", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "sanjose.ibm.com", 510L, "22222222", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "santateresa.ibm.com", 765L, "33333333", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "boulder.ibm.com", 255L, "11110000", 0, 0x100000, 1, 2, 8, null, null, 9, 91);
            System.out.println();
            TpcDBDataPopulator.createRealSwitchGroup(2, "55555555", 0, 0x100000, 1020L, 64, 8, 80, "Eric", "My Virtual Switch1", "Almaden", "ffffffff00000000", false, null, null, null);
            TpcDBDataPopulator.createRealSwitchGroup(2, "66666666", 0, 0x100000, 1275L, 64, 8, 80, "Eric", "My Virtual Switch2", "Almaden", "ffffffff00000000", false, null, null, null);
            TpcDBDataPopulator.createRealSwitchGroup(2, "77777777", 0, 0x100000, 1530L, 64, 8, 80, "Eric", "My Virtual Switch3", "Almaden", "ffffffff00000000", false, null, null, null);
            TpcDBDataPopulator.createRealSwitchGroup(2, "88888888", 0, 0x100000, 1785L, 64, 8, 80, "Eric", "My Virtual Switch4", "Almaden", "ffffffff00000000", false, null, null, null);
            System.out.println("\nSwitch2Switch:");
            TpcDBDataPopulator.connectSwitches("55555555", 0L, 0x100000L, 62L, "66666666", 0L, 0x100000L, 63L);
            TpcDBDataPopulator.connectSwitches("77777777", 0L, 0x100000L, 62L, "88888888", 0L, 0x100000L, 63L);
            System.out.println();
            TpcDBDataPopulator.createStorageGroup(2, 40000000, 100000, "44444444", 0, 0x100000, 2040L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0x6400000L, 0xC800000L, 314572800L, 1, 12, "800");
            TpcDBDataPopulator.createStorageGroup(2, 50000000, 100000, "99999999", 0, 0x100000, 2295L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0xA00000L, 0x19000000L, 429916160L, 2, 20, "800");
            TpcDBDataPopulator.populateStorageSubsystem(40000000, 40000000, 100000, 2, 3, 10);
            TpcDBDataPopulator.populateStorageSubsystem(40000000, 40008000, 100000, 1, 5, 2);
            int n2 = 0;
            while (n2 < 5) {
                TpcDBDataPopulator.addDiskToSubsystem(40000000, 10, 100, 0x1000000, 0);
                ++n2;
            }
            TpcDBDataPopulator.populateStorageSubsystem(50000000, 50000000, 100000, 2, 10, 2);
            Debug.info("Switch2SAN:");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "5555555500000000");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "6666666600000000");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "5555555500100000");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "6666666600100000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "7777777700000000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "8888888800000000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "7777777700100000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "8888888800100000");
            n2 = 0;
            int n3 = 0;
            System.out.println();
            Debug.info("Host2Switch:");
            String[] stringArray = new String[]{"00000000", "11111111"};
            int n4 = 0;
            while (n4 < stringArray.length) {
                n = 0;
                while (n < 4) {
                    string = stringArray[n4];
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 0, 8), "55555555" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + n4 * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 256, 8), "66666666" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + 8192 + n4 * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 0 + 65536, 8), "55555555" + TpcDBDataPopulator.zeropadded(n2 + 0x100000 + n * 256 + n4 * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 256 + 65536, 8), "66666666" + TpcDBDataPopulator.zeropadded(n2 + 0x100000 + n * 256 + 8192 + n4 * 4 * 256, 8));
                    ++n;
                }
                ++n4;
            }
            stringArray = new String[]{"22222222", "33333333", "11110000"};
            n4 = 0;
            while (n4 < stringArray.length) {
                n = 0;
                while (n < 4) {
                    string = stringArray[n4];
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 0, 8), "77777777" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + n4 * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 256, 8), "88888888" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + 8192 + n4 * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 0 + 65536, 8), "77777777" + TpcDBDataPopulator.zeropadded(n2 + 0x100000 + n * 256 + n4 * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(string) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 256 + 65536, 8), "88888888" + TpcDBDataPopulator.zeropadded(n2 + 0x100000 + n * 256 + 8192 + n4 * 4 * 256, 8));
                    ++n;
                }
                ++n4;
            }
            System.out.println();
            Debug.info("Switch2Storage:");
            n4 = 0;
            while (n4 < 2) {
                n = 0;
                while (n < 2) {
                    TpcDBDataPopulator.createPort2Port("55555555" + TpcDBDataPopulator.zeropadded(n4 * 0x100000 + n * 256 + 13824, 8), "44444444" + TpcDBDataPopulator.zeropadded(n * 0x100000 + n4 * 64, 8));
                    TpcDBDataPopulator.createPort2Port("66666666" + TpcDBDataPopulator.zeropadded(n4 * 0x100000 + n * 256 + 13824, 8), "44444444" + TpcDBDataPopulator.zeropadded(n * 0x100000 + n4 * 64 + 16, 8));
                    TpcDBDataPopulator.createPort2Port("77777777" + TpcDBDataPopulator.zeropadded(n4 * 0x100000 + n * 256 + 13824, 8), "99999999" + TpcDBDataPopulator.zeropadded(n * 0x100000 + n4 * 64, 8));
                    TpcDBDataPopulator.createPort2Port("88888888" + TpcDBDataPopulator.zeropadded(n4 * 0x100000 + n * 256 + 13824, 8), "99999999" + TpcDBDataPopulator.zeropadded(n * 0x100000 + n4 * 64 + 16, 8));
                    ++n;
                }
                ++n4;
            }
            int[] cfr_ignored_0 = new int[4];
            int[] cfr_ignored_1 = new int[4];
            int[] cfr_ignored_2 = new int[4];
            int[] cfr_ignored_3 = new int[4];
            System.out.println();
            Debug.info("LunMasking:");
            Vector vector = TpcDBDataPopulator.getArrays();
            Iterator iterator = vector.iterator();
            int n5 = 0;
            int n6 = 0;
            int n7 = 1;
            while (iterator.hasNext()) {
                Integer n8 = (Integer)iterator.next();
                Vector vector2 = TpcDBDataPopulator.getVolumeFromArray(n8);
                if (vector2.size() != 0) {
                    Vector vector3 = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(n8));
                    Vector vector4 = TpcDBDataPopulator.getHostFromArray(n8);
                    for (Integer n9 : vector4) {
                        Vector vector5 = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromHost(n9));
                        for (Integer n10 : vector5) {
                            for (Integer n11 : vector3) {
                                TpcDBDataPopulator.createDataPath(n7++, n5++, n6++, n10, n11, (Integer)vector2.elementAt(n5 % vector2.size()));
                            }
                        }
                    }
                    continue;
                }
                Debug.warning("No volumes found on storage subsystem: " + n8);
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void populateSan1a() {
        try {
            Serializable serializable;
            Integer n;
            int n2;
            TpcDBDataPopulator.createRealSwitchGroup(1, "ffffffff", 0, 0x100000, 1785L, 512, 8, 80, "Eric", "Real Cisco switch", "Almaden", null, true, null, null, null);
            TpcDBDataPopulator.createSan2Switch("fefefefe00000000", "ffffffff00000000");
            System.out.println("\nSwitch2Switch:");
            System.out.println();
            Vector vector = TpcDBDataPopulator.getPortsFromSwitch("ffffffff00000000");
            int n3 = 0;
            int n4 = 0;
            while (n4 < 4) {
                n2 = 299;
                while (n2 < computerId) {
                    n = (Integer)vector.elementAt(n3++);
                    serializable = TpcDBDataPopulator.getPortsFromHost(n2);
                    if (((Vector)serializable).size() > n4) {
                        Integer n5 = null;
                        try {
                            n5 = (Integer)((Vector)serializable).elementAt(n4);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN(n5), TpcDBDataPopulator.getPortWWN(n), false);
                    }
                    ++n2;
                }
                ++n4;
            }
            Vector vector2 = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(50000000));
            n2 = 0;
            while (n2 < vector2.size()) {
                n = (Integer)vector.elementAt(n3++);
                serializable = (Integer)vector2.elementAt(n2);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)serializable), TpcDBDataPopulator.getPortWWN(n), false);
                ++n2;
            }
            vector2 = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(40000000));
            n2 = 0;
            while (n2 < vector2.size()) {
                n = (Integer)vector.elementAt(n3++);
                serializable = (Integer)vector2.elementAt(n2);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)serializable), TpcDBDataPopulator.getPortWWN(n), false);
                ++n2;
            }
            vector2 = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(50100000));
            n2 = 0;
            while (n2 < vector2.size()) {
                n = (Integer)vector.elementAt(n3++);
                serializable = (Integer)vector2.elementAt(n2);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)serializable), TpcDBDataPopulator.getPortWWN(n), false);
                ++n2;
            }
            vector2 = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(40100000));
            n2 = 0;
            while (n2 < vector2.size()) {
                n = (Integer)vector.elementAt(n3++);
                serializable = (Integer)vector2.elementAt(n2);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)serializable), TpcDBDataPopulator.getPortWWN(n), false);
                ++n2;
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void populateSan2() {
        try {
            Object object;
            int n;
            TpcDBDataPopulator.nameGenerator(TOTAL_SERVERS);
            TpcDBDataPopulator.createServerGroup(6, "Zurich.ibm.com", 0L, "01010101", 0, 0x100000, 1, 1, 3, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "Poughkeepsie.ibm.com", 255L, "10000000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "Austin.ibm.com", 510L, "20000000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "watson.ibm.com", 765L, "30000000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "boulder.ibm.com", 255L, "10100000", 0, 0x100000, 1, 1, 1, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(1, "local.ibm.com", 255L, "20200000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            System.out.println();
            TpcDBDataPopulator.createRealSwitchGroup(1, "50000000", 0, 0x100000, 1020L, 64, 7, 70, "Danny", null, "Almaden", null, true, "B3-200", null, null);
            TpcDBDataPopulator.createRealSwitchGroup(1, "60000000", 0, 0x100000, 1275L, 64, 7, 70, "Danny", null, "Almaden", null, true, "B2-255", null, null);
            TpcDBDataPopulator.createRealSwitchGroup(1, "70000000", 0, 0x100000, 1530L, 64, 6, 60, "Robert", null, "Almaden", null, true, "B3-200", null, null);
            TpcDBDataPopulator.createRealSwitchGroup(1, "80000000", 0, 0x100000, 1785L, 64, 6, 60, "Robert", null, "Almaden", null, true, "B2-255", null, null);
            System.out.println("\nSwitch2Switch:");
            TpcDBDataPopulator.connectSwitches("50000000", 0L, 0x100000L, 62L, "60000000", 0L, 0x100000L, 63L);
            TpcDBDataPopulator.connectSwitches("70000000", 0L, 0x100000L, 62L, "80000000", 0L, 0x100000L, 63L);
            System.out.println();
            TpcDBDataPopulator.createStorageGroup(1, 60000000, 100000, "40000000", 0, 0x100000, 2040L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0xA00000L, 0x19000000L, 429916160L, 2, 20, "800");
            TpcDBDataPopulator.createStorageGroup(1, 70000000, 100000, "90000000", 0, 0x100000, 2295L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0xA00000L, 0x19000000L, 429916160L, 2, 20, "800");
            TpcDBDataPopulator.populateStorageSubsystem(60000000, 60000000, 100000, 2, 2, 10);
            TpcDBDataPopulator.populateStorageSubsystem(70000000, 70000000, 100000, 2, 4, 5);
            Debug.info("Switch2SAN:");
            TpcDBDataPopulator.createSan2Switch("dddddddd00000000", "5000000000000000");
            TpcDBDataPopulator.createSan2Switch("dddddddd00000000", "6000000000000000");
            TpcDBDataPopulator.createSan2Switch("cccccccc00000000", "7000000000000000");
            TpcDBDataPopulator.createSan2Switch("cccccccc00000000", "8000000000000000");
            int n2 = 0;
            int n3 = 0;
            System.out.println();
            Debug.info("Host2Switch:");
            String[] stringArray = new String[]{"01010101"};
            int n4 = 0;
            while (n4 < stringArray.length) {
                n = 0;
                while (n < 6) {
                    object = stringArray[n4];
                    TpcDBDataPopulator.createPort2Port(String.valueOf(object) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 0, 8), "50000000" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + n4 * 6 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(String.valueOf(object) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000 + 256, 8), "60000000" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + n4 * 6 * 256, 8));
                    ++n;
                }
                ++n4;
            }
            stringArray = new String[]{"10000000"};
            n4 = 0;
            while (n4 < stringArray.length) {
                n = 0;
                while (n < 6) {
                    object = stringArray[n4];
                    TpcDBDataPopulator.createPort2Port(String.valueOf(object) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000, 8), "50000000" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + 8192 + n4 * 6 * 256, 8));
                    ++n;
                }
                ++n4;
            }
            stringArray = new String[]{"10100000"};
            n4 = 0;
            while (n4 < stringArray.length) {
                n = 0;
                while (n < 6) {
                    object = stringArray[n4];
                    TpcDBDataPopulator.createPort2Port(String.valueOf(object) + TpcDBDataPopulator.zeropadded(n3 + n * 0x100000, 8), "60000000" + TpcDBDataPopulator.zeropadded(n2 + 0 + n * 256 + 8192 + n4 * 6 * 256, 8));
                    ++n;
                }
                ++n4;
            }
            TpcDBDataPopulator.createPort("9999999999999999", 0, null, 7, "Port from an unknown switch");
            Vector vector = TpcDBDataPopulator.getDisconnectedPortsFromSwitch("5000000000000000");
            Vector vector2 = TpcDBDataPopulator.getDisconnectedPortsFromSwitch("6000000000000000");
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)vector.elementAt(0)), "9999999999999999");
            object = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(60000000));
            Vector vector3 = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(70000000));
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)vector.elementAt(1)), TpcDBDataPopulator.getPortWWN((Integer)((Vector)object).elementAt(0)), false);
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)vector.elementAt(2)), TpcDBDataPopulator.getPortWWN((Integer)vector3.elementAt(0)), false);
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)vector2.elementAt(0)), TpcDBDataPopulator.getPortWWN((Integer)((Vector)object).elementAt(1)), false);
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)vector2.elementAt(1)), TpcDBDataPopulator.getPortWWN((Integer)vector3.elementAt(1)), false);
            Vector vector4 = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromHost(computerId - 1));
            if (vector4.size() > 0) {
                Integer n5 = (Integer)vector4.elementAt(0);
                Vector vector5 = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(60000000));
                TpcDBDataPopulator.createPort2Port((Integer)vector5.elementAt(0), n5);
            } else {
                Debug.error("Number of free ports is invalid");
            }
        }
        catch (Exception exception) {
            Debug.warning(exception);
        }
    }

    public static void populateZones1(String string, int n, int n2, int n3, int n4) {
        TpcDBDataPopulator.createZoneSet(2, 0, 0x1000000, string, (short)0);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            TpcDBDataPopulator.createZone(n2, n5, 4096, string, (short)n4, (short)0);
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n5 + 4096 * n7;
                TpcDBDataPopulator.createZSet2Zone(n5, n8);
                int n9 = 0;
                while (n9 < n3) {
                    TpcDBDataPopulator.createZSet2Member(n8, "ZoneMember:" + TpcDBDataPopulator.zeropadded(n8, 16) + ":" + n9);
                    ++n9;
                }
                ++n7;
            }
            n5 += 0x1000000;
            ++n6;
        }
    }

    public static void populate() {
        TpcDBDataPopulator.populateConfiguration();
        TpcDBDataPopulator.createSanGroup(1, "fefefefe", 0, 0x100000, null, "Manually Entered Name", true, true, "", "Eric", "B3-255", null);
        TpcDBDataPopulator.createSanGroup(1, "ffffffff", 0, 0x100000, "fefefefe00000000", null, true, true, "0f0f0f0f0f0f0ff0", "Eric", "B3-255", null);
        TpcDBDataPopulator.createSanGroup(1, "eeeeeeee", 0, 0x100000, "fefefefe00000000", null, true, true, "0f0f0f0f0f0f0ff0", "Eric", "B3-255", null);
        TpcDBDataPopulator.createSanGroup(1, "dddddddd", 0, 0x100000, null, null, false, true, "0d0d0d0d0d0d0dfd", "Roberto", "B3-247", null);
        TpcDBDataPopulator.createSanGroup(1, "cccccccc", 0, 0x100000, null, null, true, false, "eeeeeeeeeeeeeeee", "Danny", "B3-255", null);
        TpcDBDataPopulator.populateSan1();
    }

    public static void main(String[] stringArray) {
        try {
            try {
                try {
                    System.out.println("Loading JDBC driver... ");
                    Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDriver");
                    clazz.newInstance();
                    Properties properties = new Properties();
                    properties.setProperty("user", user);
                    properties.setProperty("password", password);
                    con = DriverManager.getConnection(url, properties);
                    con.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException2) {}
                    }
                }
                catch (Exception exception) {
                    Debug.error(exception);
                    System.exit(-1);
                }
                TpcDBDataPopulator.populate();
            }
            catch (Exception exception) {
                Debug.error(exception);
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception2) {
                    Debug.warning(exception2);
                }
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {
                Debug.warning(exception);
            }
        }
    }
}

