/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyHostTable;

public class CimkeyHost
extends TResCimkeyHostTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static CimkeyHostCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new CimkeyHostCursor(dBConnection, hashtable, vector);
    }

    public CimkeyHost() {
        this.clear();
    }

    public CimkeyHost(int n, int n2, String string, short s, short s2, short s3) {
        this.clear();
        this.m_HostId = n;
        this.m_CimNamespaceId = n2;
        this.m_Name = string;
        this.m_NameFormat = s;
        this.m_CreationClassNameId = s2;
        this.m_Active = s3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(CimkeyHost.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            hashtable.put(CimkeyHost.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Active != Short.MIN_VALUE) {
            hashtable.put(CimkeyHost.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htColsAndValues.put(CimkeyHost.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htColsAndValues.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_HOST", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_HOST", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_HOST", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("HOST_ID"), hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")));
        if (hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_HOST", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_HOST", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("HOST_ID"), hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")));
        if (hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_HOST", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_HOST", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static CimkeyHost retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        CimkeyHost cimkeyHost = null;
        if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        hashtable2.put(CimkeyHost.getColumnInfo("HOST_ID"), hashtable.get(CimkeyHost.getColumnInfo("HOST_ID")));
        if (hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        hashtable2.put(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeyHost.getColumnInfo("CIM_NAMESPACE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_HOST", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                cimkeyHost = new CimkeyHost();
                cimkeyHost.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return cimkeyHost;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_HOST", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_HOST", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setHostId(dBResultSet.getInt("HOST_ID"));
        this.setCimNamespaceId(dBResultSet.getInt("CIM_NAMESPACE_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setNameFormat(dBResultSet.getShort("NAME_FORMAT"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setActive(dBResultSet.getShort("ACTIVE"));
    }

    public static class CimkeyHostCursor
    extends DBCursor {
        private CimkeyHost element = new CimkeyHost();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyHost.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public CimkeyHostCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_CIMKEY_HOST", dBConnection, CimkeyHostCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public CimkeyHost getObject() throws SQLException {
            CimkeyHost cimkeyHost = null;
            if (this.DBrs != null) {
                cimkeyHost = new CimkeyHost();
                cimkeyHost.setFields(this.con, this.DBrs);
            }
            return cimkeyHost;
        }

        public CimkeyHost getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

