/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;

public class Cimom2namespace
extends TResCimom2namespaceTable {
    public static Cimom2namespaceCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new Cimom2namespaceCursor(dBConnection, hashtable, vector);
    }

    public Cimom2namespace() {
        this.clear();
    }

    public Cimom2namespace(int n, int n2, String string, Timestamp timestamp) {
        this.clear();
        this.m_CimNamespaceId = n;
        this.m_CimomId = n2;
        this.m_Namespace = string;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_CimNamespaceId != Integer.MIN_VALUE) {
            hashtable.put(Cimom2namespace.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Cimom2namespace.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htColsAndValues.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htColsAndValues.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMOM2NAMESPACE", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        if (hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMOM2NAMESPACE", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMOM2NAMESPACE", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")));
        if (hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMOM2NAMESPACE", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMOM2NAMESPACE", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")));
        if (hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMOM2NAMESPACE", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMOM2NAMESPACE", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Cimom2namespace retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Cimom2namespace cimom2namespace = null;
        if (hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        hashtable2.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), hashtable.get(Cimom2namespace.getColumnInfo("CIMOM_ID")));
        if (hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        hashtable2.put(Cimom2namespace.getColumnInfo("NAMESPACE"), hashtable.get(Cimom2namespace.getColumnInfo("NAMESPACE")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMOM2NAMESPACE", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                cimom2namespace = new Cimom2namespace();
                cimom2namespace.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return cimom2namespace;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMOM2NAMESPACE", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMOM2NAMESPACE", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setCimNamespaceId(dBResultSet.getInt("CIM_NAMESPACE_ID"));
        this.setCimomId(dBResultSet.getInt("CIMOM_ID"));
        this.setNamespace(dBResultSet.getString("NAMESPACE"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class Cimom2namespaceCursor
    extends DBCursor {
        private Cimom2namespace element = new Cimom2namespace();
        private DBConnection con;

        public Cimom2namespaceCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_CIMOM2NAMESPACE", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Cimom2namespace getObject() throws SQLException {
            Cimom2namespace cimom2namespace = null;
            if (this.DBrs != null) {
                cimom2namespace = new Cimom2namespace();
                cimom2namespace.setFields(this.con, this.DBrs);
            }
            return cimom2namespace;
        }

        public Cimom2namespace getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

