/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResPhyPeAttributeSnapshotTable;

public class PhyPeAttributeSnapshot
extends TResPhyPeAttributeSnapshotTable {
    public static PhyPeAttributeSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new PhyPeAttributeSnapshotCursor(dBConnection, hashtable, vector);
    }

    public PhyPeAttributeSnapshot() {
        this.clear();
    }

    public PhyPeAttributeSnapshot(int n, short s, String string) {
        this.clear();
        this.m_PhyPeId = n;
        this.m_Detectable = s;
        this.m_FirmwareRevision = string;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(PhyPeAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_FirmwareRevision != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPeAttributeSnapshot.getColumnInfo("FIRMWARE_REVISION"), this.m_FirmwareRevision);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htColsAndValues.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static PhyPeAttributeSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        PhyPeAttributeSnapshot phyPeAttributeSnapshot = null;
        if (hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        hashtable2.put(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID"), hashtable.get(PhyPeAttributeSnapshot.getColumnInfo("PHY_PE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                phyPeAttributeSnapshot = new PhyPeAttributeSnapshot();
                phyPeAttributeSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return phyPeAttributeSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setPhyPeId(dBResultSet.getInt("PHY_PE_ID"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setFirmwareRevision(dBResultSet.getString("FIRMWARE_REVISION"));
    }

    public static class PhyPeAttributeSnapshotCursor
    extends DBCursor {
        private PhyPeAttributeSnapshot element = new PhyPeAttributeSnapshot();
        private DBConnection con;

        public PhyPeAttributeSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public PhyPeAttributeSnapshot getObject() throws SQLException {
            PhyPeAttributeSnapshot phyPeAttributeSnapshot = null;
            if (this.DBrs != null) {
                phyPeAttributeSnapshot = new PhyPeAttributeSnapshot();
                phyPeAttributeSnapshot.setFields(this.con, this.DBrs);
            }
            return phyPeAttributeSnapshot;
        }

        public PhyPeAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

