/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResSnmpTrapTable;

public class SnmpTrap
extends TResSnmpTrapTable {
    public static SnmpTrapCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SnmpTrapCursor(dBConnection, hashtable, vector);
    }

    public SnmpTrap() {
        this.clear();
    }

    public SnmpTrap(int n, short s, short s2, String string) {
        this.clear();
        this.m_SnmpTrapId = n;
        this.m_SpecificTrap = s;
        this.m_GenericTrap = s2;
        this.m_EnterpriseTrap = string;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SpecificTrap != Short.MIN_VALUE) {
            hashtable.put(SnmpTrap.getColumnInfo("SPECIFIC_TRAP"), String.valueOf(this.m_SpecificTrap));
        }
        if (this.m_GenericTrap != Short.MIN_VALUE) {
            hashtable.put(SnmpTrap.getColumnInfo("GENERIC_TRAP"), String.valueOf(this.m_GenericTrap));
        }
        if (this.m_EnterpriseTrap != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(SnmpTrap.getColumnInfo("ENTERPRISE_TRAP"), this.m_EnterpriseTrap);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SnmpTrapId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNMP_TRAP_ID not found");
        }
        this.htColsAndValues.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), String.valueOf(this.m_SnmpTrapId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SNMP_TRAP", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")) == null) {
            throw new SQLException(" ERROR: key SNMP_TRAP_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SNMP_TRAP", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SnmpTrapId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNMP_TRAP_ID not found");
        }
        this.htWhereClause.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), String.valueOf(this.m_SnmpTrapId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNMP_TRAP", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")) == null) {
            throw new SQLException(" ERROR: key SNMP_TRAP_ID not found");
        }
        this.htWhereClause.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNMP_TRAP", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SnmpTrapId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNMP_TRAP_ID not found");
        }
        this.htWhereClause.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), String.valueOf(this.m_SnmpTrapId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SNMP_TRAP", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")) == null) {
            throw new SQLException(" ERROR: key SNMP_TRAP_ID not found");
        }
        this.htWhereClause.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SNMP_TRAP", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SnmpTrapId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNMP_TRAP_ID not found");
        }
        this.htWhereClause.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), String.valueOf(this.m_SnmpTrapId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SNMP_TRAP", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static SnmpTrap retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        SnmpTrap snmpTrap = null;
        if (hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")) == null) {
            throw new SQLException(" ERROR: key SNMP_TRAP_ID not found");
        }
        hashtable2.put(SnmpTrap.getColumnInfo("SNMP_TRAP_ID"), hashtable.get(SnmpTrap.getColumnInfo("SNMP_TRAP_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SNMP_TRAP", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                snmpTrap = new SnmpTrap();
                snmpTrap.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return snmpTrap;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNMP_TRAP", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SNMP_TRAP", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnmpTrapId(dBResultSet.getInt("SNMP_TRAP_ID"));
        this.setSpecificTrap(dBResultSet.getShort("SPECIFIC_TRAP"));
        this.setGenericTrap(dBResultSet.getShort("GENERIC_TRAP"));
        this.setEnterpriseTrap(dBResultSet.getString("ENTERPRISE_TRAP"));
    }

    public static class SnmpTrapCursor
    extends DBCursor {
        private SnmpTrap element = new SnmpTrap();
        private DBConnection con;

        public SnmpTrapCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SNMP_TRAP", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public SnmpTrap getObject() throws SQLException {
            SnmpTrap snmpTrap = null;
            if (this.DBrs != null) {
                snmpTrap = new SnmpTrap();
                snmpTrap.setFields(this.con, this.DBrs);
            }
            return snmpTrap;
        }

        public SnmpTrap getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

