/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;

public class Switch
extends TResSwitchTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static SwitchCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SwitchCursor(dBConnection, hashtable, vector);
    }

    public Switch() {
        this.clear();
    }

    public Switch(String string, int n, short s, short s2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, short s3, int n2, short s4, short s5, Timestamp timestamp, Timestamp timestamp2, String string16, String string17, String string18) {
        this.clear();
        this.m_SwitchWwn = string;
        this.m_SwitchId = n;
        this.m_VendorId = s;
        this.m_ModelId = s2;
        this.m_ParentSwitchWwn = string2;
        this.m_SerialNumber = string3;
        this.m_Description = string4;
        this.m_Contact = string5;
        this.m_Location = string6;
        this.m_IpAddress = string7;
        this.m_DisplayName = string8;
        this.m_LogicalName = string9;
        this.m_Domain = string10;
        this.m_ManagementId = string11;
        this.m_MgmtTelAddr = string12;
        this.m_MgmtSnmpAddr = string13;
        this.m_MgmtUrlAddr = string14;
        this.m_Version = string15;
        this.m_Detectable = s3;
        this.m_OperationalStatus = n2;
        this.m_ConsolidatedStatus = s4;
        this.m_PropagatedStatus = s5;
        this.m_ChangedTimestamp = timestamp;
        this.m_UpdateTimestamp = timestamp2;
        this.m_UserAttrib1 = string16;
        this.m_UserAttrib2 = string17;
        this.m_UserAttrib3 = string18;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SwitchId != Integer.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("SWITCH_ID"), String.valueOf(this.m_SwitchId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ParentSwitchWwn != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("PARENT_SWITCH_WWN"), this.m_ParentSwitchWwn);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_Contact != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("CONTACT"), this.m_Contact);
        }
        if (this.m_Location != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("LOCATION"), this.m_Location);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_LogicalName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("LOGICAL_NAME"), this.m_LogicalName);
        }
        if (this.m_Domain != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("DOMAIN"), this.m_Domain);
        }
        if (this.m_ManagementId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("MANAGEMENT_ID"), this.m_ManagementId);
        }
        if (this.m_MgmtTelAddr != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("MGMT_TEL_ADDR"), this.m_MgmtTelAddr);
        }
        if (this.m_MgmtSnmpAddr != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("MGMT_SNMP_ADDR"), this.m_MgmtSnmpAddr);
        }
        if (this.m_MgmtUrlAddr != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("MGMT_URL_ADDR"), this.m_MgmtUrlAddr);
        }
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(Switch.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Switch.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Switch.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Switch.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(Switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch.getColumnInfo("SWITCH_WWN"), hashtable.get(Switch.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch.getColumnInfo("SWITCH_WWN"), hashtable.get(Switch.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Switch retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Switch switch_ = null;
        if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        hashtable2.put(Switch.getColumnInfo("SWITCH_WWN"), hashtable.get(Switch.getColumnInfo("SWITCH_WWN")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                switch_ = new Switch();
                switch_.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return switch_;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSwitchWwn(dBResultSet.getString("SWITCH_WWN"));
        this.setSwitchId(dBResultSet.getInt("SWITCH_ID"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setParentSwitchWwn(dBResultSet.getString("PARENT_SWITCH_WWN"));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setDescription(dBResultSet.getString("DESCRIPTION"));
        this.setContact(dBResultSet.getString("CONTACT"));
        this.setLocation(dBResultSet.getString("LOCATION"));
        this.setIpAddress(dBResultSet.getString("IP_ADDRESS"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setLogicalName(dBResultSet.getString("LOGICAL_NAME"));
        this.setDomain(dBResultSet.getString("DOMAIN"));
        this.setManagementId(dBResultSet.getString("MANAGEMENT_ID"));
        this.setMgmtTelAddr(dBResultSet.getString("MGMT_TEL_ADDR"));
        this.setMgmtSnmpAddr(dBResultSet.getString("MGMT_SNMP_ADDR"));
        this.setMgmtUrlAddr(dBResultSet.getString("MGMT_URL_ADDR"));
        this.setVersion(dBResultSet.getString("VERSION"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(dBResultSet.getTimestamp("CHANGED_TIMESTAMP"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserAttrib1(dBResultSet.getString("USER_ATTRIB1"));
        this.setUserAttrib2(dBResultSet.getString("USER_ATTRIB2"));
        this.setUserAttrib3(dBResultSet.getString("USER_ATTRIB3"));
    }

    public static class SwitchCursor
    extends DBCursor {
        private Switch element = new Switch();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(Switch.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(Switch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("VENDOR_ID")))));
            }
            if (hashtable.get(Switch.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(Switch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Switch.getColumnInfo("MODEL_ID")))));
            }
            return hashtable;
        }

        public SwitchCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SWITCH", dBConnection, SwitchCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public Switch getObject() throws SQLException {
            Switch switch_ = null;
            if (this.DBrs != null) {
                switch_ = new Switch();
                switch_.setFields(this.con, this.DBrs);
            }
            return switch_;
        }

        public Switch getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

